/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.arrow.ArrowReader;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.testutils.CustomEqualityMatcher;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;

abstract class ArrowReaderWriterTestBase<T> {
    private final DeeplyEqualsChecker checker;

    ArrowReaderWriterTestBase() {
        this.checker = new DeeplyEqualsChecker();
    }

    ArrowReaderWriterTestBase(DeeplyEqualsChecker checker) {
        this.checker = (DeeplyEqualsChecker)Preconditions.checkNotNull((Object)checker);
    }

    @Test
    void testBasicFunctionality() {
        try {
            T[] testData;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Tuple2<ArrowWriter<T>, ArrowStreamWriter> tuple2 = this.createArrowWriter(baos);
            ArrowWriter arrowWriter = (ArrowWriter)tuple2.f0;
            ArrowStreamWriter arrowStreamWriter = (ArrowStreamWriter)tuple2.f1;
            for (T value : testData = this.getTestData()) {
                arrowWriter.write(value);
            }
            arrowWriter.finish();
            arrowStreamWriter.writeBatch();
            ArrowReader arrowReader = this.createArrowReader(new ByteArrayInputStream(baos.toByteArray()));
            for (int i = 0; i < testData.length; ++i) {
                RowData deserialized = arrowReader.read(i);
                ((ObjectAssert)Assertions.assertThat((Object)deserialized).as("Deserialized value is wrong.", new Object[0])).is((Condition)HamcrestCondition.matching((Matcher)CustomEqualityMatcher.deeplyEquals(testData[i]).withChecker(this.checker)));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    public abstract ArrowReader createArrowReader(InputStream var1) throws IOException;

    public abstract Tuple2<ArrowWriter<T>, ArrowStreamWriter> createArrowWriter(OutputStream var1) throws IOException;

    public abstract T[] getTestData();
}

