/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.runtime.arrow.ArrowReader;
import org.apache.flink.table.runtime.arrow.ArrowUtils;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.table.runtime.arrow.vectors.ArrowArrayColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowBigIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowBooleanColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowDateColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowDecimalColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowDoubleColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowFloatColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowRowColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowSmallIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowTimeColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowTimestampColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowTinyIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowVarBinaryColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowVarCharColumnVector;
import org.apache.flink.table.runtime.arrow.writers.ArrayWriter;
import org.apache.flink.table.runtime.arrow.writers.ArrowFieldWriter;
import org.apache.flink.table.runtime.arrow.writers.BigIntWriter;
import org.apache.flink.table.runtime.arrow.writers.BooleanWriter;
import org.apache.flink.table.runtime.arrow.writers.DateWriter;
import org.apache.flink.table.runtime.arrow.writers.DecimalWriter;
import org.apache.flink.table.runtime.arrow.writers.DoubleWriter;
import org.apache.flink.table.runtime.arrow.writers.FloatWriter;
import org.apache.flink.table.runtime.arrow.writers.IntWriter;
import org.apache.flink.table.runtime.arrow.writers.RowWriter;
import org.apache.flink.table.runtime.arrow.writers.SmallIntWriter;
import org.apache.flink.table.runtime.arrow.writers.TimeWriter;
import org.apache.flink.table.runtime.arrow.writers.TimestampWriter;
import org.apache.flink.table.runtime.arrow.writers.TinyIntWriter;
import org.apache.flink.table.runtime.arrow.writers.VarBinaryWriter;
import org.apache.flink.table.runtime.arrow.writers.VarCharWriter;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class ArrowUtilsTest {
    private static List<Tuple5<String, LogicalType, ArrowType, Class<?>, Class<?>>> testFields;
    private static RowType rowType;
    private static BufferAllocator allocator;

    ArrowUtilsTest() {
    }

    @BeforeAll
    static void init() {
        testFields = new ArrayList();
        testFields.add(Tuple5.of((Object)"f1", (Object)new TinyIntType(), (Object)new ArrowType.Int(8, true), TinyIntWriter.TinyIntWriterForRow.class, ArrowTinyIntColumnVector.class));
        testFields.add(Tuple5.of((Object)"f2", (Object)new SmallIntType(), (Object)new ArrowType.Int(16, true), SmallIntWriter.SmallIntWriterForRow.class, ArrowSmallIntColumnVector.class));
        testFields.add(Tuple5.of((Object)"f3", (Object)new IntType(), (Object)new ArrowType.Int(32, true), IntWriter.IntWriterForRow.class, ArrowIntColumnVector.class));
        testFields.add(Tuple5.of((Object)"f4", (Object)new BigIntType(), (Object)new ArrowType.Int(64, true), BigIntWriter.BigIntWriterForRow.class, ArrowBigIntColumnVector.class));
        testFields.add(Tuple5.of((Object)"f5", (Object)new BooleanType(), (Object)new ArrowType.Bool(), BooleanWriter.BooleanWriterForRow.class, ArrowBooleanColumnVector.class));
        testFields.add(Tuple5.of((Object)"f6", (Object)new FloatType(), (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), FloatWriter.FloatWriterForRow.class, ArrowFloatColumnVector.class));
        testFields.add(Tuple5.of((Object)"f7", (Object)new DoubleType(), (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), DoubleWriter.DoubleWriterForRow.class, ArrowDoubleColumnVector.class));
        testFields.add(Tuple5.of((Object)"f8", (Object)new VarCharType(), (Object)ArrowType.Utf8.INSTANCE, VarCharWriter.VarCharWriterForRow.class, ArrowVarCharColumnVector.class));
        testFields.add(Tuple5.of((Object)"f9", (Object)new VarBinaryType(), (Object)ArrowType.Binary.INSTANCE, VarBinaryWriter.VarBinaryWriterForRow.class, ArrowVarBinaryColumnVector.class));
        testFields.add(Tuple5.of((Object)"f10", (Object)new DecimalType(10, 3), (Object)new ArrowType.Decimal(10, 3), DecimalWriter.DecimalWriterForRow.class, ArrowDecimalColumnVector.class));
        testFields.add(Tuple5.of((Object)"f11", (Object)new DateType(), (Object)new ArrowType.Date(DateUnit.DAY), DateWriter.DateWriterForRow.class, ArrowDateColumnVector.class));
        testFields.add(Tuple5.of((Object)"f13", (Object)new TimeType(0), (Object)new ArrowType.Time(TimeUnit.SECOND, 32), TimeWriter.TimeWriterForRow.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple5.of((Object)"f14", (Object)new TimeType(2), (Object)new ArrowType.Time(TimeUnit.MILLISECOND, 32), TimeWriter.TimeWriterForRow.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple5.of((Object)"f15", (Object)new TimeType(4), (Object)new ArrowType.Time(TimeUnit.MICROSECOND, 64), TimeWriter.TimeWriterForRow.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple5.of((Object)"f16", (Object)new TimeType(8), (Object)new ArrowType.Time(TimeUnit.NANOSECOND, 64), TimeWriter.TimeWriterForRow.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple5.of((Object)"f17", (Object)new LocalZonedTimestampType(0), (Object)new ArrowType.Timestamp(TimeUnit.SECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f18", (Object)new LocalZonedTimestampType(2), (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f19", (Object)new LocalZonedTimestampType(4), (Object)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f20", (Object)new LocalZonedTimestampType(8), (Object)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f21", (Object)new TimestampType(0), (Object)new ArrowType.Timestamp(TimeUnit.SECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f22", (Object)new TimestampType(2), (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f23", (Object)new TimestampType(4), (Object)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f24", (Object)new TimestampType(8), (Object)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null), TimestampWriter.TimestampWriterForRow.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple5.of((Object)"f25", (Object)new ArrayType((LogicalType)new VarCharType()), (Object)ArrowType.List.INSTANCE, ArrayWriter.ArrayWriterForRow.class, ArrowArrayColumnVector.class));
        RowType rowFieldType = new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new IntType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("c", (LogicalType)new ArrayType((LogicalType)new VarCharType())), new RowType.RowField("d", (LogicalType)new TimestampType(2)), new RowType.RowField("e", (LogicalType)new RowType(Arrays.asList(new RowType.RowField("e1", (LogicalType)new IntType()), new RowType.RowField("e2", (LogicalType)new VarCharType()))))));
        testFields.add(Tuple5.of((Object)"f26", (Object)rowFieldType, (Object)ArrowType.Struct.INSTANCE, RowWriter.RowWriterForRow.class, ArrowRowColumnVector.class));
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        for (Tuple5<String, LogicalType, ArrowType, Class<?>, Class<?>> field : testFields) {
            rowFields.add(new RowType.RowField((String)field.f0, (LogicalType)field.f1));
        }
        rowType = new RowType(rowFields);
        allocator = ArrowUtils.getRootAllocator().newChildAllocator("stdout", 0L, Long.MAX_VALUE);
    }

    @Test
    void testConvertBetweenLogicalTypeAndArrowType() {
        Schema schema = ArrowUtils.toArrowSchema((RowType)rowType);
        Assertions.assertThat((List)schema.getFields()).hasSize(testFields.size());
        List fields = schema.getFields();
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Assertions.assertThat((String)((Field)fields.get(i)).getName()).isEqualTo((String)ArrowUtilsTest.testFields.get((int)i).f0);
            Assertions.assertThat((Object)((Field)fields.get(i)).getType()).isEqualTo(ArrowUtilsTest.testFields.get((int)i).f2);
        }
    }

    @Test
    void testCreateArrowReader() {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowReader reader = ArrowUtils.createArrowReader((VectorSchemaRoot)root, (RowType)rowType);
        ColumnVector[] columnVectors = reader.getColumnVectors();
        for (int i = 0; i < columnVectors.length; ++i) {
            Assertions.assertThat(columnVectors[i].getClass()).isEqualTo(ArrowUtilsTest.testFields.get((int)i).f4);
        }
    }

    @Test
    void testCreateArrowWriter() {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter writer = ArrowUtils.createRowDataArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ArrowFieldWriter[] fieldWriters = writer.getFieldWriters();
        for (int i = 0; i < fieldWriters.length; ++i) {
            Assertions.assertThat(fieldWriters[i].getClass()).isEqualTo(ArrowUtilsTest.testFields.get((int)i).f3);
        }
    }

    @Test
    void testReadArrowBatches() throws IOException {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter arrowWriter = ArrowUtils.createRowDataArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrowStreamWriter arrowStreamWriter = new ArrowStreamWriter(root, null, (OutputStream)baos);
        arrowStreamWriter.start();
        List<RowData> testData = Arrays.asList(new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()));
        int batches = 3;
        List subLists = Lists.partition(testData, (int)(testData.size() / batches + 1));
        for (List subList : subLists) {
            for (RowData value : subList) {
                arrowWriter.write((Object)value);
            }
            arrowWriter.finish();
            arrowStreamWriter.writeBatch();
            arrowWriter.reset();
        }
        Assertions.assertThat((int)ArrowUtils.readArrowBatches((ReadableByteChannel)Channels.newChannel(new ByteArrayInputStream(baos.toByteArray()))).length).isEqualTo(batches);
    }
}

