/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.groupwindow.NamedWindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowEnd;
import org.apache.flink.table.runtime.groupwindow.WindowProperty;
import org.apache.flink.table.runtime.groupwindow.WindowStart;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.AbstractArrowPythonAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.AbstractStreamArrowPythonAggregateFunctionOperatorTest;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonGroupWindowAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.window.assigners.SlidingWindowAssigner;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.apache.flink.table.runtime.utils.PassThroughPythonAggregateFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.jupiter.api.Test;

class StreamArrowPythonGroupWindowAggregateFunctionOperatorTest
extends AbstractStreamArrowPythonAggregateFunctionOperatorTest {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");

    StreamArrowPythonGroupWindowAggregateFunctionOperatorTest() {
    }

    @Test
    void testGroupWindowAggregateFunction() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(new Configuration());
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 6000L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10000L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 0L), initialTime + 4L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c3", "c8", 3L, 0L), initialTime + 5L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(false, "c3", "c8", 3L, 0L), initialTime + 6L));
        testHarness.processWatermark(Long.MAX_VALUE);
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 1L, TimestampData.fromEpochMillis((long)5000L), TimestampData.fromEpochMillis((long)15000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 2L, TimestampData.fromEpochMillis((long)10000L), TimestampData.fromEpochMillis((long)20000L))));
        expectedOutput.add(new Watermark(Long.MAX_VALUE));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testFinishBundleTriggeredOnCheckpoint() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 10);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 6000L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10000L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 0L), initialTime + 4L));
        testHarness.processWatermark(new Watermark(10000L));
        testHarness.prepareSnapshotPreBarrier(0L);
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new Watermark(10000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(20000L);
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 1L, TimestampData.fromEpochMillis((long)5000L), TimestampData.fromEpochMillis((long)15000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 2L, TimestampData.fromEpochMillis((long)10000L), TimestampData.fromEpochMillis((long)20000L))));
        expectedOutput.add(new Watermark(20000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testFinishBundleTriggeredByCount() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 4);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 6000L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10000L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 0L), initialTime + 4L));
        testHarness.processWatermark(new Watermark(10000L));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new Watermark(10000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(20000L);
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 1L, TimestampData.fromEpochMillis((long)5000L), TimestampData.fromEpochMillis((long)15000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 2L, TimestampData.fromEpochMillis((long)10000L), TimestampData.fromEpochMillis((long)20000L))));
        expectedOutput.add(new Watermark(20000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Override
    public LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    @Override
    public RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("rowTime", (LogicalType)new BigIntType())));
    }

    @Override
    public RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new BigIntType()), new RowType.RowField("windowStart", (LogicalType)new TimestampType(3)), new RowType.RowField("windowEnd", (LogicalType)new TimestampType(3))));
    }

    @Override
    public AbstractArrowPythonAggregateFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo[] pandasAggregateFunctions, RowType inputType, RowType outputType, int[] groupingSet, int[] udafInputOffsets) {
        long size = 10000L;
        long slide = 5000L;
        SlidingWindowAssigner windowAssigner = SlidingWindowAssigner.of((Duration)Duration.ofMillis(size), (Duration)Duration.ofMillis(slide)).withEventTime();
        EventTimeTriggers.AfterEndOfWindow trigger = EventTimeTriggers.afterEndOfWindow();
        RowType udfInputType = (RowType)Projection.of((int[])udafInputOffsets).project((LogicalType)inputType);
        RowType udfOutputType = (RowType)Projection.range((int)groupingSet.length, (int)(outputType.getFieldCount() - 2)).project((LogicalType)outputType);
        return new PassThroughStreamArrowPythonGroupWindowAggregateFunctionOperator(config, pandasAggregateFunctions, inputType, udfInputType, udfOutputType, 3, (WindowAssigner)windowAssigner, (Trigger)trigger, 0L, new NamedWindowProperty[]{new NamedWindowProperty("start", (WindowProperty)new WindowStart(null)), new NamedWindowProperty("end", (WindowProperty)new WindowEnd(null))}, UTC_ZONE_ID, ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader()), (String)"UdafInputProjection", (RowType)inputType, (RowType)udfInputType, (int[])udafInputOffsets));
    }

    private static class PassThroughStreamArrowPythonGroupWindowAggregateFunctionOperator
    extends StreamArrowPythonGroupWindowAggregateFunctionOperator {
        PassThroughStreamArrowPythonGroupWindowAggregateFunctionOperator(Configuration config, PythonFunctionInfo[] pandasAggFunctions, RowType inputType, RowType udfInputType, RowType udfOutputType, int inputTimeFieldIndex, WindowAssigner windowAssigner, Trigger trigger, long allowedLateness, NamedWindowProperty[] namedProperties, ZoneId shiftTimeZone, GeneratedProjection generatedProjection) {
            super(config, pandasAggFunctions, inputType, udfInputType, udfOutputType, inputTimeFieldIndex, windowAssigner, trigger, allowedLateness, namedProperties, shiftTimeZone, generatedProjection);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonAggregateFunctionRunner(this.getRuntimeContext().getTaskName(), PythonTestUtils.createTestProcessEnvironmentManager(), this.udfInputType, this.udfOutputType, this.getFunctionUrn(), this.createUserDefinedFunctionsProto(), PythonTestUtils.createMockFlinkMetricContainer(), false);
        }
    }
}

