/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.table;

import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.python.table.PythonTableFunctionOperator;
import org.apache.flink.table.runtime.operators.python.table.PythonTableFunctionOperatorTestBase;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.runtime.utils.PassThroughPythonTableFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class PythonTableFunctionOperatorTest
extends PythonTableFunctionOperatorTestBase<RowData, RowData> {
    private final RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()});

    @Override
    public RowData newRow(boolean accumulateMsg, Object ... fields) {
        if (accumulateMsg) {
            return StreamRecordUtils.row((Object[])fields);
        }
        RowData row = StreamRecordUtils.row((Object[])fields);
        row.setRowKind(RowKind.DELETE);
        return row;
    }

    @Override
    public void assertOutputEquals(String message, Collection<Object> expected, Collection<Object> actual) {
        this.assertor.assertOutputEquals(message, expected, actual);
    }

    @Override
    public PythonTableFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo tableFunction, RowType inputType, RowType outputType, int[] udfInputOffsets, FlinkJoinType joinRelType) {
        RowType udfInputType = (RowType)Projection.of((int[])udfInputOffsets).project((LogicalType)inputType);
        RowType udfOutputType = (RowType)Projection.range((int)inputType.getFieldCount(), (int)outputType.getFieldCount()).project((LogicalType)outputType);
        return new PassThroughPythonTableFunctionOperator(config, tableFunction, inputType, udfInputType, udfOutputType, joinRelType, ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader()), (String)"UdtfInputProjection", (RowType)inputType, (RowType)udfInputType, (int[])udfInputOffsets));
    }

    private static class PassThroughPythonTableFunctionOperator
    extends PythonTableFunctionOperator {
        PassThroughPythonTableFunctionOperator(Configuration config, PythonFunctionInfo tableFunction, RowType inputType, RowType udfInputType, RowType udfOutputType, FlinkJoinType joinType, GeneratedProjection udtfInputGeneratedProjection) {
            super(config, tableFunction, inputType, udfInputType, udfOutputType, joinType, udtfInputGeneratedProjection);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonTableFunctionRunner(this.getRuntimeContext().getTaskName(), PythonTestUtils.createTestProcessEnvironmentManager(), this.udfInputType, this.udfOutputType, this.getFunctionUrn(), this.createUserDefinedFunctionsProto(), PythonTestUtils.createMockFlinkMetricContainer());
        }
    }
}

