/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.common;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.mailbox.SyncMailboxExecutor;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterators;
import org.apache.flink.state.common.ChangelogMaterializationMetricGroup;
import org.apache.flink.state.common.PeriodicMaterializationManager;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PeriodicMaterializationManagerTest {
    PeriodicMaterializationManagerTest() {
    }

    @Test
    void testInitialDelay() {
        ManuallyTriggeredScheduledExecutorService scheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        long periodicMaterializeDelay = 10000L;
        try (PeriodicMaterializationManager test = new PeriodicMaterializationManager((MailboxExecutor)new SyncMailboxExecutor(), Executors.newDirectExecutorService(), "test", (message, exception) -> {}, PeriodicMaterializationManager.MaterializationTarget.NO_OP, new ChangelogMaterializationMetricGroup((MetricGroup)UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup()), periodicMaterializeDelay, 0, "subtask-0", (ScheduledExecutorService)scheduledExecutorService);){
            test.start();
            ((AbstractLongAssert)Assertions.assertThat((long)((ScheduledFuture)Iterators.getOnlyElement(scheduledExecutorService.getAllScheduledTasks().iterator())).getDelay(TimeUnit.MILLISECONDS)).as(String.format("task for initial materialization should be scheduled with a 0..%d delay", periodicMaterializeDelay), new Object[0])).isLessThanOrEqualTo(periodicMaterializeDelay);
        }
    }
}

