/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0001\u00051\u0011\u0001#\u0011<s_>+H\u000f];u/JLG/\u001a:\u000b\u0005\r!\u0011\u0001B1we>T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002\u0005\u0002\u000f'5\tqB\u0003\u0002\u0011#\u0005YA-\u0019;bg>,(oY3t\u0015\t\u0011B!A\u0005fq\u0016\u001cW\u000f^5p]&\u0011Ac\u0004\u0002\r\u001fV$\b/\u001e;Xe&$XM\u001d\u0005\t-\u0001\u0011\t\u0011)A\u00051\u0005!\u0001/\u0019;i\u0007\u0001\u0001\"!G\u0010\u000f\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003=mA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\bG>tG/\u001a=u!\t)#&D\u0001'\u0015\t9\u0003&A\u0005nCB\u0014X\rZ;dK*\u0011\u0011\u0006C\u0001\u0007Q\u0006$wn\u001c9\n\u0005-2#A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRD\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0007g\u000eDW-\\1\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011!\u0002;za\u0016\u001c\u0018BA\u001a1\u0005)\u0019FO];diRK\b/\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005Q\u0011M\u001e:p'\u000eDW-\\1\u0011\u0005]JT\"\u0001\u001d\u000b\u0005\rA\u0011B\u0001\u001e9\u0005\u0019\u00196\r[3nC\")A\b\u0001C\u0001{\u00051A(\u001b8jiz\"RA\u0010!B\u0005\u000e\u0003\"a\u0010\u0001\u000e\u0003\tAQAF\u001eA\u0002aAQaI\u001eA\u0002\u0011BQ!L\u001eA\u00029BQ!N\u001eA\u0002YB\u0001\"\u0012\u0001\t\u0006\u0004%IAR\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014X#A$\u0011\u0005}B\u0015BA%\u0003\u00059\teO]8TKJL\u0017\r\\5{KJD\u0001b\u0013\u0001\t\u0002\u0003\u0006KaR\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0004N\u0001\t\u0007I\u0011\u0002(\u0002\u0019I,7m\u001c:e/JLG/\u001a:\u0016\u0003=\u0003B!\n)S=&\u0011\u0011K\n\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\t\u0004'ZCV\"\u0001+\u000b\u0005UC\u0014AB7baJ,G-\u0003\u0002X)\n9\u0011I\u001e:p\u0017\u0016L\bCA-]\u001b\u0005Q&BA.9\u0003\u001d9WM\\3sS\u000eL!!\u0018.\u0003\u001b\u001d+g.\u001a:jGJ+7m\u001c:e!\ty&-D\u0001a\u0015\t\t\u0007&\u0001\u0002j_&\u00111\r\u0019\u0002\r\u001dVdGn\u0016:ji\u0006\u0014G.\u001a\u0005\u0007K\u0002\u0001\u000b\u0011B(\u0002\u001bI,7m\u001c:e/JLG/\u001a:!\u0011\u00159\u0007\u0001\"\u0011i\u0003\u00159(/\u001b;f)\tIG\u000e\u0005\u0002\u001bU&\u00111n\u0007\u0002\u0005+:LG\u000fC\u0003nM\u0002\u0007a.A\u0002s_^\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0003\u0002\u0011\r\fG/\u00197zgRL!a\u001d9\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006k\u0002!\tE^\u0001\u0006G2|7/\u001a\u000b\u0002S\u0002")
public class AvroOutputWriter
extends OutputWriter {
    public final String org$apache$spark$sql$avro$AvroOutputWriter$$path;
    public final TaskAttemptContext org$apache$spark$sql$avro$AvroOutputWriter$$context;
    private final StructType schema;
    private final Schema avroSchema;
    private AvroSerializer serializer;
    private final RecordWriter<AvroKey<GenericRecord>, NullWritable> recordWriter;
    private volatile boolean bitmap$0;

    private AvroSerializer serializer$lzycompute() {
        AvroOutputWriter avroOutputWriter = this;
        synchronized (avroOutputWriter) {
            if (!this.bitmap$0) {
                this.serializer = new AvroSerializer((DataType)this.schema, this.avroSchema, false);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.schema = null;
            this.avroSchema = null;
            return this.serializer;
        }
    }

    private AvroSerializer serializer() {
        return this.bitmap$0 ? this.serializer : this.serializer$lzycompute();
    }

    private RecordWriter<AvroKey<GenericRecord>, NullWritable> recordWriter() {
        return this.recordWriter;
    }

    public void write(InternalRow row) {
        AvroKey key = new AvroKey((Object)((GenericRecord)this.serializer().serialize(row)));
        this.recordWriter().write((Object)key, (Object)NullWritable.get());
    }

    public void close() {
        this.recordWriter().close(this.org$apache$spark$sql$avro$AvroOutputWriter$$context);
    }

    public AvroOutputWriter(String path, TaskAttemptContext context, StructType schema, Schema avroSchema) {
        this.org$apache$spark$sql$avro$AvroOutputWriter$$path = path;
        this.org$apache$spark$sql$avro$AvroOutputWriter$$context = context;
        this.schema = schema;
        this.avroSchema = avroSchema;
        this.recordWriter = new AvroKeyOutputFormat<GenericRecord>(this){
            private final /* synthetic */ AvroOutputWriter $outer;

            public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
                return new Path(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$path);
            }

            public OutputStream getAvroFileOutputStream(TaskAttemptContext c) throws IOException {
                Path path = this.getDefaultWorkFile(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$context, ".avro");
                return path.getFileSystem(this.$outer.org$apache$spark$sql$avro$AvroOutputWriter$$context.getConfiguration()).create(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.getRecordWriter(context);
    }
}

