/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class AvroReadBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static AvroReadBenchmark$ MODULE$;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new AvroReadBenchmark$();
    }

    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$((SqlBasedBenchmark)this);
    }

    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$((SqlBasedBenchmark)this, (String)name, (long)cardinality, f);
    }

    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$((SqlBasedBenchmark)this, ds);
    }

    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$((SqlBasedBenchmark)this, (Benchmark)benchmark);
    }

    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$((SqlBasedBenchmark)this, (String)path, (int)rowsNum, (int)numCols);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        AvroReadBenchmark$ avroReadBenchmark$ = this;
        synchronized (avroReadBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)AvroReadBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        String dirAvro = dir.getCanonicalPath();
        if (partition.isDefined()) {
            df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})).format("avro").save(dirAvro);
        } else {
            df.write().format("avro").save(dirAvro);
        }
        this.spark().read().format("avro").load(dirAvro).createOrReplaceTempView("avroTable");
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        String x$1 = new StringBuilder(23).append("SQL Single ").append(dataType.sql()).append(" Column Scan").toString();
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$1).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT CAST(value as ").append(dataType$1.sql()).append(") id FROM t1").toString()), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$1.addCase("Sum", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM avroTable")).noop());
                benchmark$1.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        String x$1 = "Int and String Scan";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$2.addCase("Sum of columns", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM avroTable")).noop());
                benchmark$2.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        String x$1 = "Partitioned Table";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                benchmark$3.addCase("Data column", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM avroTable")).noop());
                benchmark$3.addCase("Partition column", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM avroTable")).noop());
                benchmark$3.addCase("Both columns", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM avroTable")).noop());
                benchmark$3.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        String x$1 = "Repeated String";
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$4).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT CAST((id % 200) + 10000 as STRING) AS c1 FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$4.addCase("Sum of string length", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT sum(length(c1)) FROM avroTable")).noop());
                benchmark$4.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AvroReadBenchmark$.MODULE$.spark().range((long)values$5).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql(new StringBuilder(109).append("SELECT IF(RAND(1) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c1, ").append("IF(RAND(2) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c2 FROM t1").toString()), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                double percentageOfNulls = fractionOfNulls$1 * (double)100;
                String x$1 = new StringBuilder(26).append("String with Nulls Scan (").append(percentageOfNulls).append("%)").toString();
                long x$2 = values$5;
                Option x$3 = AvroReadBenchmark$.MODULE$.output();
                int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
                benchmark.addCase("Sum of string length", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM avroTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL")).noop());
                benchmark.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        String x$1 = new StringBuilder(32).append("Single Column Scan from ").append(width).append(" columns").toString();
        long x$2 = values;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            AvroReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "avroTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable & scala.Serializable)i -> AvroReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                AvroReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), AvroReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                AvroReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)AvroReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), AvroReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$5.addCase("Sum of single column", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> AvroReadBenchmark$.MODULE$.DatasetToBenchmark(AvroReadBenchmark$.MODULE$.spark().sql(new StringBuilder(28).append("SELECT sum(c").append(middle).append(") FROM avroTable").toString())).noop());
                benchmark$5.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    private void filtersPushdownBenchmark(int rowsNum, int numIters) {
        String x$1 = "Filters pushdown";
        long x$2 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        int colsNum = 100;
        Seq fields = (Seq)Seq$.MODULE$.tabulate(colsNum, (Function1 & Serializable & scala.Serializable)i -> AvroReadBenchmark$.$anonfun$filtersPushdownBenchmark$1(BoxesRunTime.unboxToInt((Object)i)));
        StructField structField = new StructField("key", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)fields.$plus$colon((Object)structField, Seq$.MODULE$.canBuildFrom()));
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            AvroReadBenchmark$.$anonfun$filtersPushdownBenchmark$3(this, rowsNum, schema, benchmark, numIters, colsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("SQL Single Numeric Column Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            AvroReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        }));
        this.runBenchmark("Int and String Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.intStringScanBenchmark(0xA00000));
        this.runBenchmark("Partitioned Table Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.partitionTableScanBenchmark(0xF00000));
        this.runBenchmark("Repeated String Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.repeatedStringScanBenchmark(0xA00000));
        this.runBenchmark("String with Nulls Scan", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls)));
        this.runBenchmark("Single Column Scan From Wide Columns", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.columnsBenchmark(0x100000, 100);
            MODULE$.columnsBenchmark(0x100000, 200);
            MODULE$.columnsBenchmark(0x100000, 300);
        });
        this.filtersPushdownBenchmark(1000000, 3);
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return new StringBuilder(10).append("value as c").append(i).toString();
    }

    public static final /* synthetic */ StructField $anonfun$filtersPushdownBenchmark$1(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$filtersPushdownBenchmark$2(int i) {
        return functions$.MODULE$.lit((Object)Instant.ofEpochSecond(-30610224000L + (long)(i * 123456))).as(new StringBuilder(3).append("col").append(i).toString());
    }

    private final Seq columns$1(int colsNum$1) {
        Seq ts = (Seq)Seq$.MODULE$.tabulate(colsNum$1, (Function1 & Serializable & scala.Serializable)i -> AvroReadBenchmark$.$anonfun$filtersPushdownBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        Column column = this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToInteger((int)1000)).as("key");
        return (Seq)ts.$plus$colon((Object)column, Seq$.MODULE$.canBuildFrom());
    }

    private static final Dataset readback$1(StructType schema$1, File path$1) {
        return MODULE$.spark().read().schema(schema$1).format("avro").load(path$1.getAbsolutePath());
    }

    private static final void withFilter$1(boolean configEnabled, StructType schema$1, File path$1) {
        MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_READ().key()), (Object)"LEGACY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.AVRO_FILTER_PUSHDOWN_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)configEnabled)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(AvroReadBenchmark$.readback$1(schema$1, path$1).filter(MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)))).noop());
    }

    public static final /* synthetic */ void $anonfun$filtersPushdownBenchmark$3(AvroReadBenchmark$ $this, int rowsNum$1, StructType schema$1, Benchmark benchmark$6, int numIters$1, int colsNum$1, File path) {
        MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_WRITE().key()), (Object)"LEGACY")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.spark().range((long)rowsNum$1).select($this.columns$1(colsNum$1)).write().format("avro").save(path.getAbsolutePath()));
        benchmark$6.addCase("w/o filters", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$15 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_READ().key()), (Object)"LEGACY")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(AvroReadBenchmark$.readback$1(schema$1, path)).noop()));
        benchmark$6.addCase("pushdown disabled", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$16 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_AVRO_REBASE_MODE_IN_READ().key()), (Object)"LEGACY")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AvroReadBenchmark$.withFilter$1(false, schema$1, path)));
        benchmark$6.addCase("w/ filters", numIters$1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$17 -> AvroReadBenchmark$.withFilter$1(true, schema$1, path));
        benchmark$6.run();
    }

    private AvroReadBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$((SqlBasedBenchmark)this);
    }
}

