/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.package$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001f\t1B+\u00192mKN\u001b\u0007.Z7b!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\u0004\t\u00051\u0001/\u0019:tKJT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!)!\u0004\u0001C\u00017\u0005)\u0001/\u0019:tKR\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0019\tQ\u0001^=qKNL!!\t\u0010\u0003\u0015M#(/^2u)f\u0004X\rC\u0003\b3\u0001\u00071\u0005\u0005\u0002%U9\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIc\u0005C\u0003/\u0001\u0011\u0005q&\u0001\tdQ\u0016\u001c7\u000eV1cY\u0016\u001c6\r[3nCR\u0019\u0001gM\u001b\u0011\u0005\u0015\n\u0014B\u0001\u001a'\u0005\u0011)f.\u001b;\t\u000bQj\u0003\u0019A\u0012\u0002#Q\f'\r\\3TG\",W.Y*ue&tw\rC\u00037[\u0001\u0007q'\u0001\tfqB,7\r^3e\t\u0006$\u0018\rV=qKB\u0011Q\u0004O\u0005\u0003sy\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\u0006w\u0001!\t\u0001P\u0001\fCN\u001cXM\u001d;FeJ|'\u000f\u0006\u00021{!)qA\u000fa\u0001G\u0001")
public class TableSchemaParserSuite
extends SparkFunSuite {
    public StructType parse(String sql) {
        return CatalystSqlParser$.MODULE$.parseTableSchema(sql);
    }

    public void checkTableSchema(String tableSchemaString, DataType expectedDataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parse ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableSchemaString})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, tableSchemaString, expectedDataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableSchemaParserSuite $outer;
            private final String tableSchemaString$1;
            private final DataType expectedDataType$1;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.parse(this.tableSchemaString$1));
                DataType $org_scalatest_assert_macro_right = this.expectedDataType$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableSchemaString$1 = tableSchemaString$1;
                this.expectedDataType$1 = expectedDataType$1;
            }
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
    }

    public void assertError(String sql) {
        this.intercept((Function0)new Serializable(this, sql){
            public static final long serialVersionUID = 0L;
            private final String sql$1;

            public final StructType apply() {
                return CatalystSqlParser$.MODULE$.parseTableSchema(this.sql$1);
            }
            {
                this.sql$1 = sql$1;
            }
        }, ClassTag$.MODULE$.apply(ParseException.class), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }

    public TableSchemaParserSuite() {
        this.checkTableSchema("a int", (DataType)new StructType().add("a", "int"));
        this.checkTableSchema("A int", (DataType)new StructType().add("A", "int"));
        this.checkTableSchema("a INT", (DataType)new StructType().add("a", "int"));
        this.checkTableSchema("`!@#$%.^&*()` string", (DataType)new StructType().add("!@#$%.^&*()", "string"));
        this.checkTableSchema("a int, b long", (DataType)new StructType().add("a", "int").add("b", "long"));
        StructField structField = new StructField("intType", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("a", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkTableSchema("a STRUCT<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)));
        this.checkTableSchema("a int comment 'test'", (DataType)new StructType().add("a", "int", true, "test"));
        this.test("complex hive type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableSchemaParserSuite $outer;

            public final Assertion apply() {
                String tableSchemaString = new StringOps(Predef$.MODULE$.augmentString("\n        |complexStructCol struct<\n        |struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n        |MAP:Map<timestamp, varchar(10)>,\n        |arrAy:Array<double>,\n        |anotherArray:Array<char(9)>>\n      ")).stripMargin().replace("\n", "");
                MetadataBuilder builder = new MetadataBuilder();
                builder.putString(package$.MODULE$.HIVE_TYPE_STRING(), "struct<struct:struct<deciMal:decimal(10,0),anotherDecimal:decimal(5,2)>,MAP:map<timestamp,varchar(10)>,arrAy:array<double>,anotherArray:array<char(9)>>");
                StructField structField = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField3 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField4 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField5 = new StructField("arrAy", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField6 = new StructField("anotherArray", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField7 = new StructField("complexStructCol", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3)), true, builder.build());
                StructType expectedDataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.parse(tableSchemaString));
                StructType $org_scalatest_assert_macro_right = expectedDataType;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Negative cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableSchemaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError("");
                this.$outer.assertError("a");
                this.$outer.assertError("a INT b long");
                this.$outer.assertError("a INT,, b long");
                this.$outer.assertError("a INT, b long,,");
                this.$outer.assertError("a INT, b long, c int,");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
    }
}

