/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.unsafe.Platform;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00112A!\u0001\u0002\u0001\u001f\tqQK\\:bM\u0016l\u0015\r]*vSR,'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\b5\u0001\u0011\r\u0011\"\u0001\u001c\u00035)hn]1gK6\u000b\u0007\u000fR1uCV\tA\u0004\u0005\u0002\u001eA5\taD\u0003\u0002 \t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\tcDA\u0007V]N\fg-Z'ba\u0012\u000bG/\u0019\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u001dUt7/\u00194f\u001b\u0006\u0004H)\u0019;bA\u0001")
public class UnsafeMapSuite
extends SparkFunSuite {
    private final UnsafeMapData unsafeMapData;

    public UnsafeMapData unsafeMapData() {
        return this.unsafeMapData;
    }

    public UnsafeMapSuite() {
        int offset = 32;
        int keyArraySize = 256;
        byte[] baseObject = new byte[1024];
        Platform.putLong((Object)baseObject, (long)offset, (long)keyArraySize);
        UnsafeMapData unsafeMap = new UnsafeMapData();
        Platform.putLong((Object)baseObject, (long)(offset + 8), (long)1L);
        UnsafeArrayData keyArray = new UnsafeArrayData();
        keyArray.pointTo((Object)baseObject, (long)(offset + 8), keyArraySize);
        keyArray.setLong(0, 19285L);
        UnsafeArrayData valueArray = new UnsafeArrayData();
        Platform.putLong((Object)baseObject, (long)(offset + 8 + keyArray.getSizeInBytes()), (long)1L);
        valueArray.pointTo((Object)baseObject, (long)(offset + 8 + keyArray.getSizeInBytes()), keyArraySize);
        valueArray.setLong(0, 19286L);
        unsafeMap.pointTo((Object)baseObject, (long)offset, baseObject.length);
        this.unsafeMapData = unsafeMap;
        this.test("unsafe java serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeMapSuite $outer;

            public final Assertion apply() {
                SerializerInstance ser = new JavaSerializer(new SparkConf()).newInstance();
                UnsafeMapData mapDataSer = (UnsafeMapData)ser.deserialize(ser.serialize((Object)this.$outer.unsafeMapData(), ClassTag$.MODULE$.apply(UnsafeMapData.class)), ClassTag$.MODULE$.apply(UnsafeMapData.class));
                int $org_scalatest_assert_macro_left = mapDataSer.numElements();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
                int $org_scalatest_assert_macro_left2 = mapDataSer.keyArray().getInt(0);
                int $org_scalatest_assert_macro_right2 = 19285;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
                int $org_scalatest_assert_macro_left3 = mapDataSer.valueArray().getInt(0);
                int $org_scalatest_assert_macro_right3 = 19286;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
                byte[] $org_scalatest_assert_macro_left4 = (byte[])mapDataSer.getBaseObject();
                int $org_scalatest_assert_macro_right4 = 1024;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("unsafe Kryo serialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsafeMapSuite $outer;

            public final Assertion apply() {
                SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
                UnsafeMapData mapDataSer = (UnsafeMapData)ser.deserialize(ser.serialize((Object)this.$outer.unsafeMapData(), ClassTag$.MODULE$.apply(UnsafeMapData.class)), ClassTag$.MODULE$.apply(UnsafeMapData.class));
                int $org_scalatest_assert_macro_left = mapDataSer.numElements();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                int $org_scalatest_assert_macro_left2 = mapDataSer.keyArray().getInt(0);
                int $org_scalatest_assert_macro_right2 = 19285;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                int $org_scalatest_assert_macro_left3 = mapDataSer.valueArray().getInt(0);
                int $org_scalatest_assert_macro_right3 = 19286;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
                byte[] $org_scalatest_assert_macro_left4 = (byte[])mapDataSer.getBaseObject();
                int $org_scalatest_assert_macro_right4 = 1024;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("UnsafeMapSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }
}

