/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.First$;
import org.apache.spark.sql.catalyst.expressions.aggregate.FirstLast$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr[, isIgnoreNull]) - Returns the first value of `expr` for a group of rows.\n      If `isIgnoreNull` is true, returns only non-null values.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (10), (5), (20) AS tab(col);\n       10\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (5), (20) AS tab(col);\n       NULL\n      > SELECT _FUNC_(col, true) FROM VALUES (NULL), (5), (20) AS tab(col);\n       5\n  ", note="\n    The function is non-deterministic because its results depends on the order of the rows\n    which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001\u0002\u0014(\u0001ZB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003Q\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015!\u0006\u0001\"\u0001Z\u0011\u0015!\u0006\u0001\"\u0001\\\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015i\u0007\u0001\"\u0011P\u0011!q\u0007\u0001#b\u0001\n\u0003z\u0005\"B8\u0001\t\u0003\u0002\b\"B<\u0001\t\u0003B\b\"B?\u0001\t\u0003r\bBCA\u0006\u0001!\u0015\r\u0011\"\u0003\u0002\u000e!Q\u0011Q\u0003\u0001\t\u0006\u0004%I!!\u0004\t\u0015\u0005]\u0001\u0001#b\u0001\n\u0003\nI\u0002\u0003\u0006\u0002\u001e\u0001A)\u0019!C!\u0003?A\u0011\"!\u000b\u0001\u0011\u000b\u0007I\u0011\t1\t\u0013\u0005-\u0002\u0001#b\u0001\n\u0003\u0002\u0007BCA\u0017\u0001!\u0015\r\u0011\"\u0011\u0002\u000e!9\u0011q\u0006\u0001\u0005B\u0005E\u0002\"CA\"\u0001\u0005\u0005I\u0011AA#\u0011%\tY\u0005AI\u0001\n\u0003\ti\u0005C\u0005\u0002d\u0001\t\n\u0011\"\u0001\u0002f!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00131\u000e\u0005\n\u0003w\u0002\u0011\u0011!C\u0001\u0003{B\u0011\"!\"\u0001\u0003\u0003%\t!a\"\t\u0013\u0005M\u0005!!A\u0005B\u0005U\u0005\"CAR\u0001\u0005\u0005I\u0011AAS\u0011%\tI\u000bAA\u0001\n\u0003\nYkB\u0005\u0002V\u001e\n\t\u0011#\u0001\u0002X\u001aAaeJA\u0001\u0012\u0003\tI\u000e\u0003\u0004UA\u0011\u0005\u0011q\u001d\u0005\n\u0003_\u0001\u0013\u0011!C#\u0003SD\u0011\"a;!\u0003\u0003%\t)!<\t\u0013\u0005M\b%!A\u0005\u0002\u0006U\b\"\u0003B\u0004A\u0005\u0005I\u0011\u0002B\u0005\u0005\u00151\u0015N]:u\u0015\tA\u0013&A\u0005bO\u001e\u0014XmZ1uK*\u0011!fK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002-[\u0005A1-\u0019;bYf\u001cHO\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001omzT\t\u0005\u00029s5\tq%\u0003\u0002;O\t!B)Z2mCJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"\u0001P\u001f\u000e\u0003%J!AP\u0015\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015IA\u0004Qe>$Wo\u0019;\u0011\u0005\u00013\u0015BA$B\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005Q\u0005C\u0001\u001fL\u0013\ta\u0015F\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013aC5h]>\u0014XMT;mYN,\u0012\u0001\u0015\t\u0003\u0001FK!AU!\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011n\u001a8pe\u0016tU\u000f\u001c7tA\u00051A(\u001b8jiz\"2AV,Y!\tA\u0004\u0001C\u0003I\u000b\u0001\u0007!\nC\u0003O\u000b\u0001\u0007\u0001\u000b\u0006\u0002W5\")\u0001J\u0002a\u0001\u0015R\u0019a\u000bX/\t\u000b!;\u0001\u0019\u0001&\t\u000by;\u0001\u0019\u0001&\u0002\u001f%<gn\u001c:f\u001dVdGn]#yaJ\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002CB\u0019!M\u001b&\u000f\u0005\rDgB\u00013h\u001b\u0005)'B\u000146\u0003\u0019a$o\\8u}%\t!)\u0003\u0002j\u0003\u00069\u0001/Y2lC\u001e,\u0017BA6m\u0005\r\u0019V-\u001d\u0006\u0003S\u0006\u000b\u0001B\\;mY\u0006\u0014G.Z\u0001\u000eI\u0016$XM]7j]&\u001cH/[2\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i6\nQ\u0001^=qKNL!A^:\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005I\bc\u00012kuB\u0011!o_\u0005\u0003yN\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bY\u0013\u0001C1oC2L8/[:\n\t\u0005%\u00111\u0001\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006)a-\u001b:tiV\u0011\u0011q\u0002\t\u0004y\u0005E\u0011bAA\nS\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003!1\u0018\r\\;f'\u0016$\u0018aE1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001cXCAA\u000e!\u0011\u0011'.a\u0004\u0002\u001b%t\u0017\u000e^5bYZ\u000bG.^3t+\t\t\t\u0003\u0005\u0003cU\u0006\r\u0002c\u0001\u001f\u0002&%\u0019\u0011qE\u0015\u0003\u000f1KG/\u001a:bY\u0006\tR\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002!5,'oZ3FqB\u0014Xm]:j_:\u001c\u0018AE3wC2,\u0018\r^3FqB\u0014Xm]:j_:\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003g\u0001B!!\u000e\u0002>9!\u0011qGA\u001d!\t!\u0017)C\u0002\u0002<\u0005\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001e\u0003\u0006!1m\u001c9z)\u00151\u0016qIA%\u0011\u001dAe\u0003%AA\u0002)CqA\u0014\f\u0011\u0002\u0003\u0007\u0001+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=#f\u0001&\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002^\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d$f\u0001)\u0002R\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!A.\u00198h\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA \u0003c\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a \u0011\u0007\u0001\u000b\t)C\u0002\u0002\u0004\u0006\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!#\u0002\u0010B\u0019\u0001)a#\n\u0007\u00055\u0015IA\u0002B]fD\u0011\"!%\u001c\u0003\u0003\u0005\r!a \u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\n\u0005\u0004\u0002\u001a\u0006}\u0015\u0011R\u0007\u0003\u00037S1!!(B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\u000bYJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001)\u0002(\"I\u0011\u0011S\u000f\u0002\u0002\u0003\u0007\u0011\u0011R\u0001\u0007KF,\u0018\r\\:\u0015\u0007A\u000bi\u000bC\u0005\u0002\u0012z\t\t\u00111\u0001\u0002\n\":\u0002!!-\u00028\u0006e\u0016QXA`\u0003\u0007\f)-!3\u0002L\u0006=\u0017\u0011\u001b\t\u0004y\u0005M\u0016bAA[S\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA^\u0003\u0005M\"\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO].-A%\u001c\u0018j\u001a8pe\u0016tU\u000f\u001c7^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u00022\u0017N]:uAY\fG.^3!_\u001a\u0004\u0003-\u001a=qe\u0002\u0004cm\u001c:!C\u0002:'o\\;qA=4\u0007E]8xg:R\u0001\u0005\t\u0011!A\u0001Je\r\t1jg&;gn\u001c:f\u001dVdG\u000e\u0019\u0011jg\u0002\"(/^3-AI,G/\u001e:og\u0002zg\u000e\\=!]>tWF\\;mY\u00022\u0018\r\\;fg:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0003\f!Q\u0002\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>d\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u0019*Y\u0001BS'\u000b\u0017!QI\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b(V\u00192KC\u0006\t\u00156S1\u0002\u0003F\r\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003\u0005\u001e:vK&\u0002cIU(NAY\u000bE*V#TA!rU\u000b\u0014'*Y\u0001BS'\u000b\u0017!QI\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0005!an\u001c;fC\t\t9-AA\u0013\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001c\u0007EY3dCV\u001cX\rI5ug\u0002\u0012Xm];miN\u0004C-\u001a9f]\u0012\u001c\be\u001c8!i\",\u0007e\u001c:eKJ\u0004sN\u001a\u0011uQ\u0016\u0004#o\\<t\u0015\u0001\u0002\u0003\u0005I<iS\u000eD\u0007%\\1zA\t,\u0007E\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA\u00054G/\u001a:!C\u0002\u001a\b.\u001e4gY\u0016t#\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u00055\u0017!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019.A\u00033]Ar\u0003'A\u0003GSJ\u001cH\u000f\u0005\u00029AM!\u0001%a7F!\u001d\ti.a9K!Zk!!a8\u000b\u0007\u0005\u0005\u0018)A\u0004sk:$\u0018.\\3\n\t\u0005\u0015\u0018q\u001c\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAl)\t\ti'A\u0003baBd\u0017\u0010F\u0003W\u0003_\f\t\u0010C\u0003IG\u0001\u0007!\nC\u0003OG\u0001\u0007\u0001+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005](1\u0001\t\u0006\u0001\u0006e\u0018Q`\u0005\u0004\u0003w\f%AB(qi&|g\u000eE\u0003A\u0003\u007fT\u0005+C\u0002\u0003\u0002\u0005\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u0003I\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0006!\u0011\tyG!\u0004\n\t\t=\u0011\u0011\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class First
extends DeclarativeAggregate
implements ExpectsInputTypes {
    private boolean deterministic;
    private AttributeReference first;
    private AttributeReference valueSet;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private AttributeReference evaluateExpression;
    private final Expression child;
    private final boolean ignoreNulls;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Object>> unapply(First first) {
        return First$.MODULE$.unapply(first);
    }

    public static Function1<Tuple2<Expression, Object>, First> tupled() {
        return First$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, First>> curried() {
        return First$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private boolean deterministic$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deterministic = false;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.deterministic;
    }

    @Override
    public boolean deterministic() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private AttributeReference first$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$1 = "first";
                DataType x$2 = this.child().dataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.first = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.first;
    }

    private AttributeReference first() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.first$lzycompute() : this.first;
    }

    private AttributeReference valueSet$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String x$1 = "valueSet";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.valueSet = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.valueSet;
    }

    private AttributeReference valueSet() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.valueSet$lzycompute() : this.valueSet;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                AttributeReference attributeReference = this.first();
                AttributeReference attributeReference2 = this.valueSet();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, this.child().dataType()), Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.updateExpressions = this.ignoreNulls() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.valueSet()).$bar$bar((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))), this.first(), this.child()), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.valueSet()).$bar$bar((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNotNull())))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If(this.valueSet(), this.first(), this.child()), Literal$.MODULE$.create(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$)}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new If(this.RichAttribute(this.valueSet()).left(), this.RichAttribute(this.first()).left(), this.RichAttribute(this.first()).right()), (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.valueSet()).left()).$bar$bar(this.RichAttribute(this.valueSet()).right()))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private AttributeReference evaluateExpression$lzycompute() {
        First first = this;
        synchronized (first) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.evaluateExpression = this.first();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public String toString() {
        return new StringBuilder(2).append(this.prettyName()).append("(").append(this.child()).append(")").append((Object)(this.ignoreNulls() ? " ignore nulls" : BoxedUnit.UNIT)).toString();
    }

    public First copy(Expression child, boolean ignoreNulls) {
        return new First(child, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "First";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof First;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof First)) return false;
        boolean bl = true;
        if (!bl) return false;
        First first = (First)x$1;
        Expression expression = this.child();
        Expression expression2 = first.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.ignoreNulls() != first.ignoreNulls()) return false;
        if (!first.canEqual(this)) return false;
        return true;
    }

    public First(Expression child, boolean ignoreNulls) {
        this.child = child;
        this.ignoreNulls = ignoreNulls;
        ExpectsInputTypes.$init$(this);
    }

    public First(Expression child) {
        this(child, false);
    }

    public First(Expression child, Expression ignoreNullsExpr) {
        this(child, FirstLast$.MODULE$.validateIgnoreNullExpr(ignoreNullsExpr, "first"));
    }
}

