/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AnsiCastSuiteBase$;
import org.apache.spark.sql.catalyst.expressions.CastBase;
import org.apache.spark.sql.catalyst.expressions.CastSuiteBase;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.parallel.immutable.ParVector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U3Qa\u0002\u0005\u0002\u0002UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\nyAQ!\f\u0001\u0005\n9BQ\u0001\r\u0001\u0007\u0012EBQ!\u0010\u0001\u0005\nyBq!\u0013\u0001\u0012\u0002\u0013%!JA\tB]NL7)Y:u'VLG/\u001a\"bg\u0016T!!\u0003\u0006\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u00171\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u0003!I!!\u0007\u0005\u0003\u001b\r\u000b7\u000f^*vSR,')Y:f\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0018\u0001\u0005\u0001B/Z:u\u0013:$X*\u0019=B]\u0012l\u0015N\u001c\u000b\u0003?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012A!\u00168ji\")aE\u0001a\u0001O\u0005\u0011A\r\u001e\t\u0003Q-j\u0011!\u000b\u0006\u0003U1\tQ\u0001^=qKNL!\u0001L\u0015\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0011\u0003^3ti2{gnZ'bq\u0006sG-T5o)\tyr\u0006C\u0003'\u0007\u0001\u0007q%\u0001\u000btKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"Kg\u000e^\u000b\u0002eA\u00111G\u000f\b\u0003ia\u0002\"!N\u0011\u000e\u0003YR!a\u000e\u000b\u0002\rq\u0012xn\u001c;?\u0013\tI\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d\"\u0003E1XM]5gs\u000e\u000b7\u000f\u001e$bS2,(/\u001a\u000b\u0004?}\"\u0005\"\u0002!\u0006\u0001\u0004\t\u0015!A2\u0011\u0005]\u0011\u0015BA\"\t\u0005!\u0019\u0015m\u001d;CCN,\u0007bB#\u0006!\u0003\u0005\rAR\u0001\u0014_B$\u0018n\u001c8bY\u0016C\b/Z2uK\u0012l5o\u001a\t\u0004A\u001d\u0013\u0014B\u0001%\"\u0005\u0019y\u0005\u000f^5p]\u0006Yb/\u001a:jMf\u001c\u0015m\u001d;GC&dWO]3%I\u00164\u0017-\u001e7uII*\u0012a\u0013\u0016\u0003\r2[\u0013!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005I\u000b\u0013AC1o]>$\u0018\r^5p]&\u0011Ak\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class AnsiCastSuiteBase
extends CastSuiteBase {
    private void testIntMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegralType[]{IntegerType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$}));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0x80000000L, -2147483649L}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(((Object)BoxesRunTime.boxToLong((long)value)).toString()), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)((float)((double)value * 1.5))), (DataType)FloatType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        });
    }

    private void testLongMaxAndMin(DataType dt) {
        Seq $org_scalatest_assert_macro_left = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegralType[]{LongType$.MODULE$, IntegerType$.MODULE$}));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 748));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Decimal[]{Decimal$.MODULE$.apply(Long.MAX_VALUE).$plus(Decimal$.MODULE$.apply(1)), Decimal$.MODULE$.apply(Long.MIN_VALUE).$minus(Decimal$.MODULE$.apply(1))}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            AnsiCastSuiteBase.$anonfun$testLongMaxAndMin$1(this, dt, value);
            return BoxedUnit.UNIT;
        });
    }

    public abstract String setConfigurationHint();

    private void verifyCastFailure(CastBase c, Option<String> optionalExpectedMsg) {
        TypeCheckResult typeCheckResult = c.checkInputDataTypes();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(typeCheckResult.isFailure(), "typeCheckResult.isFailure", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        TypeCheckResult $org_scalatest_assert_macro_left = typeCheckResult;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.analysis.TypeCheckResult.TypeCheckFailure", $org_scalatest_assert_macro_left instanceof TypeCheckResult.TypeCheckFailure, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
        String message = ((TypeCheckResult.TypeCheckFailure)typeCheckResult).message();
        if (optionalExpectedMsg.isDefined()) {
            String $org_scalatest_assert_macro_left2 = message;
            String $org_scalatest_assert_macro_right = (String)optionalExpectedMsg.get();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
        } else {
            String $org_scalatest_assert_macro_left3 = message;
            String $org_scalatest_assert_macro_right = "with ANSI mode on";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            String $org_scalatest_assert_macro_left4 = message;
            String $org_scalatest_assert_macro_right2 = this.setConfigurationHint();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
        }
    }

    private Option<String> verifyCastFailure$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$testLongMaxAndMin$1(AnsiCastSuiteBase $this, DataType dt$2, Decimal value) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(value, dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToFloat((float)value.$times(Decimal$.MODULE$.apply(1.1)).toFloat()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToDouble((double)value.$times(Decimal$.MODULE$.apply(1.1)).toDouble()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    public static final /* synthetic */ void $anonfun$new$142(AnsiCastSuiteBase $this, byte value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToByte((byte)value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(((Object)BoxesRunTime.boxToByte((byte)value)).toString(), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Decimal$.MODULE$.apply(((Object)BoxesRunTime.boxToByte((byte)value)).toString()), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$153(AnsiCastSuiteBase $this, short value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(BoxesRunTime.boxToShort((short)value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(((Object)BoxesRunTime.boxToShort((short)value)).toString(), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(Decimal$.MODULE$.apply(((Object)BoxesRunTime.boxToShort((short)value)).toString()), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$189(AnsiCastSuiteBase $this, IntegralType dataType) {
        Literal array = Literal$.MODULE$.create((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"123", "true", "f", null})), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast(array, (DataType)new ArrayType((DataType)dataType, true), $this.cast$default$3()), "invalid input syntax for type numeric: true", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("string", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: string", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("123-string", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 123-string", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("2020-07-19", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 2020-07-19", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("1.23", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 1.23", ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public static final /* synthetic */ void $anonfun$new$195(AnsiCastSuiteBase $this, FractionalType dataType) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("string", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: string", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("123.000.00", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: 123.000.00", ClassTag$.MODULE$.apply(NumberFormatException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> $this.cast("abc.com", (DataType)dataType, $this.cast$default$3()), "invalid input syntax for type numeric: abc.com", ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    private final void checkCastWithParseError$1(String str, ZoneId zid$2) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$2.getId())), new StringBuilder(30).append("Cannot cast ").append(str).append(" to TimestampType.").toString(), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public AnsiCastSuiteBase() {
        this.test("ANSI mode: Throw exception on casting out-of-range value to byte type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)ByteType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{128, -129}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{127, (byte)0, -128}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                AnsiCastSuiteBase.$anonfun$new$142(this, BoxesRunTime.unboxToByte((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
        this.test("ANSI mode: Throw exception on casting out-of-range value to short type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)ShortType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{32768, -32769}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapShortArray(new short[]{Short.MAX_VALUE, (short)0, Short.MIN_VALUE}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
                AnsiCastSuiteBase.$anonfun$new$153(this, BoxesRunTime.unboxToShort((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        this.test("ANSI mode: Throw exception on casting out-of-range value to int type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testIntMaxAndMin((DataType)IntegerType$.MODULE$);
            this.testLongMaxAndMin((DataType)IntegerType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Integer.MAX_VALUE, 0, Integer.MIN_VALUE}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(((Object)BoxesRunTime.boxToInteger((int)value)).toString(), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(((Object)BoxesRunTime.boxToInteger((int)value)).toString()), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)2.1474836479E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-2.1474836489E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
        this.test("ANSI mode: Throw exception on casting out-of-range value to long type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testLongMaxAndMin((DataType)LongType$.MODULE$);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{Long.MAX_VALUE, 0L, Long.MIN_VALUE}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(((Object)BoxesRunTime.boxToLong((long)value)).toString(), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Decimal$.MODULE$.apply(((Object)BoxesRunTime.boxToLong((long)value)).toString()), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)-9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("ANSI mode: Throw exception on casting out-of-range value to decimal type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)"134.12"), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
        this.test("ANSI mode: disallow type conversions between Numeric types and Timestamp type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)TimestampType$.MODULE$);
            ObjectRef errorMsg = ObjectRef.create((Object)"you can use functions TIMESTAMP_SECONDS/TIMESTAMP_MILLIS/TIMESTAMP_MICROS instead");
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            errorMsg.elem = "you can use functions UNIX_SECONDS/UNIX_MILLIS/UNIX_MICROS instead.";
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                this.verifyCastFailure(this.cast(timestampLiteral, (DataType)numericType, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
        this.test("ANSI mode: disallow type conversions between Numeric types and Date type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)DateType$.MODULE$);
            ObjectRef errorMsg = ObjectRef.create((Object)"you can use function DATE_FROM_UNIX_DATE instead");
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)DateType$.MODULE$, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            errorMsg.elem = "you can use function UNIX_DATE instead";
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                this.verifyCastFailure(this.cast(dateLiteral, (DataType)numericType, this.cast$default$3()), (Option<String>)new Some((Object)((String)errorMsg.elem)));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
        this.test("ANSI mode: disallow type conversions between Numeric types and Binary type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkInvalidCastFromNumericType((DataType)BinaryType$.MODULE$);
            Literal binaryLiteral = new Literal((Object)new byte[(byte)1], (DataType)BinaryType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable & scala.Serializable)numericType -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(binaryLiteral, (DataType)numericType, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(binaryLiteral, numericType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
        this.test("ANSI mode: disallow type conversions between Datatime types and Boolean types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.cast(timestampLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(timestampLiteral, org.apache.spark.sql.types.BooleanType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.cast(dateLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(dateLiteral, org.apache.spark.sql.types.BooleanType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
            Literal booleanLiteral = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.cast(booleanLiteral, (DataType)TimestampType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(booleanLiteral, org.apache.spark.sql.types.TimestampType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.cast(booleanLiteral, (DataType)DateType$.MODULE$, this.cast$default$3()).checkInputDataTypes().isFailure(), "AnsiCastSuiteBase.this.cast(booleanLiteral, org.apache.spark.sql.types.DateType, AnsiCastSuiteBase.this.cast$default$3).checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
        this.test("ANSI mode: disallow casting complex types as String type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AnsiCastSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator1$1(AnsiCastSuiteBase $outer) {
                }
            }
            this.verifyCastFailure(this.cast(Literal$.MODULE$.create((Object)new int[]{1, 2, 3, 4, 5}, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator1$1(null))), (DataType)StringType$.MODULE$, this.cast$default$3()), this.verifyCastFailure$default$2());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AnsiCastSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator2$1(AnsiCastSuiteBase $outer) {
                }
            }
            this.verifyCastFailure(this.cast(Literal$.MODULE$.create((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator2$1(null))), (DataType)StringType$.MODULE$, this.cast$default$3()), this.verifyCastFailure$default$2());
            JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AnsiCastSuiteBase.class.getClassLoader());
            public final class Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator3$1(AnsiCastSuiteBase $outer) {
                }
            }
            this.verifyCastFailure(this.cast(Literal$.MODULE$.create((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToDouble((double)0.1)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_catalyst_expressions_AnsiCastSuiteBase$$typecreator3$1(null))), (DataType)StringType$.MODULE$, this.cast$default$3()), this.verifyCastFailure$default$2());
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        this.test("cast from invalid string to numeric should throw NumberFormatException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegralType[]{IntegerType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$, LongType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                AnsiCastSuiteBase.$anonfun$new$189(this, dataType);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{DoubleType$.MODULE$, FloatType$.MODULE$, DecimalType$.MODULE$.USER_DEFAULT()}))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
                AnsiCastSuiteBase.$anonfun$new$195(this, dataType);
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
        this.test("Fast fail for cast string type to decimal type in ansi mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("12345678901234567890123456789012345678"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("123456789012345678901234567890123456789", (DataType)new DecimalType(38, 0), this.cast$default$3()), "out of decimal type range", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 18), this.cast$default$3()), Decimal$.MODULE$.apply("0E-18"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E-120", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("60000000000000000000000000000000000000"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+38", (DataType)new DecimalType(38, 0), this.cast$default$3()), "out of decimal type range", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast("abcd", (DataType)new DecimalType(38, 1), this.cast$default$3()), "invalid input syntax for type numeric", ClassTag$.MODULE$.apply(NumberFormatException.class));
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930));
        this.test("ANSI mode: cast string to timestamp with parse error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLConf activeConf = this.conf();
            new ParVector(DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().toVector()).foreach((Function1 & Serializable & scala.Serializable)zid -> {
                SQLConf$.MODULE$.withExistingConf(activeConf, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.checkCastWithParseError$1("123", zid);
                    $this.checkCastWithParseError$1("2015-03-18 123142", zid);
                    $this.checkCastWithParseError$1("2015-03-18T123123", zid);
                    $this.checkCastWithParseError$1("2015-03-18X", zid);
                    $this.checkCastWithParseError$1("2015/03/18", zid);
                    $this.checkCastWithParseError$1("2015.03.18", zid);
                    $this.checkCastWithParseError$1("20150318", zid);
                    $this.checkCastWithParseError$1("2015-031-8", zid);
                    $this.checkCastWithParseError$1("2015-03-18T12:03:17-0:70", zid);
                    $this.checkCastWithParseError$1("abdef", zid);
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
        this.test("SPARK-26218: Fix the corner case of codegen when casting float to Integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> this.cast(this.cast(Literal$.MODULE$.apply((Object)"2147483648"), (DataType)FloatType$.MODULE$, this.cast$default$3()), (DataType)IntegerType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class)), new Position("CastSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
    }
}

