/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.AddMonths;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.DateAdd$;
import org.apache.spark.sql.catalyst.expressions.DateAddInterval;
import org.apache.spark.sql.catalyst.expressions.DateAddInterval$;
import org.apache.spark.sql.catalyst.expressions.DateDiff;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.DateFromUnixDate;
import org.apache.spark.sql.catalyst.expressions.DateSub;
import org.apache.spark.sql.catalyst.expressions.DateSub$;
import org.apache.spark.sql.catalyst.expressions.DayOfMonth;
import org.apache.spark.sql.catalyst.expressions.DayOfMonth$;
import org.apache.spark.sql.catalyst.expressions.DayOfWeek;
import org.apache.spark.sql.catalyst.expressions.DayOfWeek$;
import org.apache.spark.sql.catalyst.expressions.DayOfYear;
import org.apache.spark.sql.catalyst.expressions.DayOfYear$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.FromUTCTimestamp;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.Hour;
import org.apache.spark.sql.catalyst.expressions.IntegralLiteralTestUtils$;
import org.apache.spark.sql.catalyst.expressions.LastDay;
import org.apache.spark.sql.catalyst.expressions.LastDay$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.LiteralGenerator$;
import org.apache.spark.sql.catalyst.expressions.MakeDate;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.MicrosToTimestamp;
import org.apache.spark.sql.catalyst.expressions.MillisToTimestamp;
import org.apache.spark.sql.catalyst.expressions.Minute;
import org.apache.spark.sql.catalyst.expressions.Month;
import org.apache.spark.sql.catalyst.expressions.Month$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NextDay;
import org.apache.spark.sql.catalyst.expressions.NonFoldableLiteral$;
import org.apache.spark.sql.catalyst.expressions.ParseToDate;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Quarter;
import org.apache.spark.sql.catalyst.expressions.Quarter$;
import org.apache.spark.sql.catalyst.expressions.Second;
import org.apache.spark.sql.catalyst.expressions.SecondWithFraction;
import org.apache.spark.sql.catalyst.expressions.SecondsToTimestamp;
import org.apache.spark.sql.catalyst.expressions.SubtractDates;
import org.apache.spark.sql.catalyst.expressions.SubtractTimestamps;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.ToUTCTimestamp;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.TruncDate;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.UnixDate;
import org.apache.spark.sql.catalyst.expressions.UnixMicros;
import org.apache.spark.sql.catalyst.expressions.UnixMillis;
import org.apache.spark.sql.catalyst.expressions.UnixSeconds;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.WeekDay;
import org.apache.spark.sql.catalyst.expressions.WeekDay$;
import org.apache.spark.sql.catalyst.expressions.WeekOfYear;
import org.apache.spark.sql.catalyst.expressions.WeekOfYear$;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.expressions.Year$;
import org.apache.spark.sql.catalyst.expressions.YearOfWeek;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Shrink$;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u4AAE\n\u0001A!)\u0011\u0006\u0001C\u0001U!9A\u0006\u0001b\u0001\n\u0013i\u0003B\u0002\u001f\u0001A\u0003%a\u0006C\u0004>\u0001\t\u0007I\u0011B\u0017\t\ry\u0002\u0001\u0015!\u0003/\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u001d\u0001\u0006A1A\u0005\u0002ECaA\u0015\u0001!\u0002\u0013!\u0004bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u00075\u0002\u0001\u000b\u0011B+\t\u000fm\u0003!\u0019!C\u0001#\"1A\f\u0001Q\u0001\nQBq!\u0018\u0001C\u0002\u0013\u0005a\f\u0003\u0004c\u0001\u0001\u0006Ia\u0018\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006]\u0002!Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0002\u0015\t\u0006$X-\u0012=qe\u0016\u001c8/[8ogN+\u0018\u000e^3\u000b\u0005Q)\u0012aC3yaJ,7o]5p]NT!AF\f\u0002\u0011\r\fG/\u00197zgRT!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011&!\t\u00113%D\u0001\u001a\u0013\t!\u0013DA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003M\u001dj\u0011aE\u0005\u0003QM\u0011A#\u0012=qe\u0016\u001c8/[8o\u000bZ\fG\u000eS3ma\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001,!\t1\u0003!A\u0004Q'R{v\n\u0015+\u0016\u00039\u00022a\f\u001a5\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB(qi&|g\u000e\u0005\u00026u5\taG\u0003\u00028q\u0005!A.\u00198h\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\rM#(/\u001b8h\u0003!\u00016\u000bV0P!R\u0003\u0013a\u0002&T)~{\u0005\u000bV\u0001\t\u0015N#vl\u0014)UA\u0005AAo\\'jY2L7\u000f\u0006\u0002B\tB\u0011qFQ\u0005\u0003\u0007B\u0012A\u0001T8oO\")QI\u0002a\u0001\r\u0006IA/[7fgR\fW\u000e\u001d\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%\u0003T\"\u0001&\u000b\u0005-{\u0012A\u0002\u001fs_>$h(\u0003\u0002Na\u00051\u0001K]3eK\u001aL!aO(\u000b\u00055\u0003\u0014\u0001\u00023bi\u0016,\u0012\u0001N\u0001\u0006I\u0006$X\rI\u0001\u0002IV\tQ\u000b\u0005\u0002W16\tqK\u0003\u0002\u0019q%\u0011\u0011l\u0016\u0002\u0005\t\u0006$X-\u0001\u0002eA\u0005!A/[7f\u0003\u0015!\u0018.\\3!\u0003\t!8/F\u0001`!\t1\u0006-\u0003\u0002b/\nIA+[7fgR\fW\u000e]\u0001\u0004iN\u0004\u0013!\u0004;fgR$&/\u001e8d\t\u0006$X\r\u0006\u0003fQ*d\u0007CA\u0018g\u0013\t9\u0007G\u0001\u0003V]&$\b\"B5\u0010\u0001\u0004)\u0016!B5oaV$\b\"B6\u0010\u0001\u00041\u0015a\u00014ni\")Qn\u0004a\u0001+\u0006AQ\r\u001f9fGR,G-\u0001\nuKN$HK];oGRKW.Z:uC6\u0004H\u0003B3qcJDQ!\u001b\tA\u0002}CQa\u001b\tA\u0002\u0019CQ!\u001c\tA\u0002}\u000b\u0011\u0003^3ti&sG/Z4sC2Le\u000e];u)\t)W\u000fC\u0003w#\u0001\u0007q/\u0001\u0005uKN$h)\u001e8d!\u0011y\u0003P_3\n\u0005e\u0004$!\u0003$v]\u000e$\u0018n\u001c82!\t)40\u0003\u0002}m\t1a*^7cKJ\u0004")
public class DateExpressionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private final Option<String> PST_OPT;
    private final Option<String> JST_OPT;
    private final String date;
    private final Date d;
    private final String time;
    private final Timestamp ts;
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<?> keys, Seq<?> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$1);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$2);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    private String sparkHome$lzycompute() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    private Option<String> PST_OPT() {
        return this.PST_OPT;
    }

    private Option<String> JST_OPT() {
        return this.JST_OPT;
    }

    public long toMillis(String timestamp) {
        TimestampFormatter tf = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd HH:mm:ss", DateTimeTestUtils$.MODULE$.UTC(), true);
        return DateTimeUtils$.MODULE$.microsToMillis(tf.parse(timestamp));
    }

    public String date() {
        return this.date;
    }

    public Date d() {
        return this.d;
    }

    public String time() {
        return this.time;
    }

    public Timestamp ts() {
        return this.ts;
    }

    private void testTruncDate(Date input, String fmt, Date expected) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TruncDate((Expression)Literal$.MODULE$.create((Object)input, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create((Object)fmt, (DataType)StringType$.MODULE$)), expected, this.checkEvaluation$default$3());
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TruncDate((Expression)Literal$.MODULE$.create((Object)input, (DataType)DateType$.MODULE$), (Expression)NonFoldableLiteral$.MODULE$.create(fmt, (DataType)StringType$.MODULE$)), expected, this.checkEvaluation$default$3());
    }

    private void testTruncTimestamp(Timestamp input, String fmt, Timestamp expected) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TruncTimestamp((Expression)Literal$.MODULE$.create((Object)fmt, (DataType)StringType$.MODULE$), (Expression)Literal$.MODULE$.create((Object)input, (DataType)TimestampType$.MODULE$), TruncTimestamp$.MODULE$.apply$default$3()), expected, this.checkEvaluation$default$3());
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TruncTimestamp((Expression)NonFoldableLiteral$.MODULE$.create(fmt, (DataType)StringType$.MODULE$), (Expression)Literal$.MODULE$.create((Object)input, (DataType)TimestampType$.MODULE$), TruncTimestamp$.MODULE$.apply$default$3()), expected, this.checkEvaluation$default$3());
    }

    public void testIntegralInput(Function1<Number, BoxedUnit> testFunc) {
        DateExpressionsSuite.checkResult$1(0L, testFunc);
        DateExpressionsSuite.checkResult$1(127L, testFunc);
        DateExpressionsSuite.checkResult$1(-128L, testFunc);
        DateExpressionsSuite.checkResult$1(32767L, testFunc);
        DateExpressionsSuite.checkResult$1(-32768L, testFunc);
        DateExpressionsSuite.checkResult$1(Integer.MAX_VALUE, testFunc);
        DateExpressionsSuite.checkResult$1(Integer.MIN_VALUE, testFunc);
        DateExpressionsSuite.checkResult$1((long)Integer.MAX_VALUE + 100L, testFunc);
        DateExpressionsSuite.checkResult$1((long)Integer.MIN_VALUE - 100L, testFunc);
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        DateExpressionsSuite dateExpressionsSuite = this;
        synchronized (dateExpressionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$63(DateExpressionsSuite $this, Calendar c$6, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        c$6.setTimeZone(TimeZone.getTimeZone(zid));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 60).by(5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)s -> {
            c$6.set(2015, 18, 3, 3, 5, s);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Second((Expression)Literal$.MODULE$.apply((Object)new Timestamp(c$6.getTimeInMillis())), timeZoneId), BoxesRunTime.boxToInteger((int)c$6.get(13)), $this.checkEvaluation$default$3());
        });
        $this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)child -> new Second(child, timeZoneId), (DataType)TimestampType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$113(DateExpressionsSuite $this, Calendar c$7, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        c$7.setTimeZone(TimeZone.getTimeZone(zid));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 24).by(6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)h -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 60).by(30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 60).by(30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)s -> {
            c$7.set(2015, 18, 3, h, m, s);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Hour((Expression)Literal$.MODULE$.apply((Object)new Timestamp(c$7.getTimeInMillis())), timeZoneId), BoxesRunTime.boxToInteger((int)c$7.get(11)), $this.checkEvaluation$default$3());
        })));
        $this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)child -> new Hour(child, timeZoneId), (DataType)TimestampType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$123(DateExpressionsSuite $this, Calendar c$8, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        c$8.setTimeZone(TimeZone.getTimeZone(zid));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 60).by(5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 60).by(15).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)s -> {
            c$8.set(2015, 18, 3, 3, m, s);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Minute((Expression)Literal$.MODULE$.apply((Object)new Timestamp(c$8.getTimeInMillis())), timeZoneId), BoxesRunTime.boxToInteger((int)c$8.get(12)), $this.checkEvaluation$default$3());
        }));
        $this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)child -> new Minute(child, timeZoneId), (DataType)TimestampType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$161(DateExpressionsSuite $this, SimpleDateFormat sdf$1, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        sdf$1.setTimeZone(TimeZone.getTimeZone(zid));
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$1.parse("2016-01-29 10:00:00.000").getTime())), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 2, 123000L)), timeZoneId), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(sdf$1.parse("2016-03-02 10:00:00.123").getTime()))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.create(null, (DataType)TimestampType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 2, 123000L)), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$1.parse("2016-01-29 10:00:00.000").getTime())), (Expression)Literal$.MODULE$.create(null, (DataType)CalendarIntervalType$.MODULE$), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.create(null, (DataType)TimestampType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)CalendarIntervalType$.MODULE$), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(start, interval) -> new TimeAdd(start, interval, timeZoneId), (DataType)TimestampType$.MODULE$, (DataType)CalendarIntervalType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$168(DateExpressionsSuite $this, SimpleDateFormat sdf$2, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        sdf$2.setTimeZone(TimeZone.getTimeZone(zid));
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$2.parse("2016-03-31 10:00:00.000").getTime())), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 0, 0L)), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(sdf$2.parse("2016-02-29 10:00:00.000").getTime()))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$2.parse("2016-03-31 10:00:00.000").getTime())), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, 0L)), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(sdf$2.parse("2016-02-28 10:00:00.000").getTime()))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$2.parse("2016-03-30 00:00:01.000").getTime())), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 0, (long)2000000)), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(sdf$2.parse("2016-02-28 23:59:59.000").getTime()))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$2.parse("2016-03-30 00:00:01.000").getTime())), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, (long)2000000)), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(sdf$2.parse("2016-02-27 23:59:59.000").getTime()))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.create(null, (DataType)TimestampType$.MODULE$), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 2, 123000L)), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$2.parse("2016-01-29 10:00:00.000").getTime())), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.create(null, (DataType)CalendarIntervalType$.MODULE$), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new TimeAdd((Expression)Literal$.MODULE$.create(null, (DataType)TimestampType$.MODULE$), (Expression)new UnaryMinus((Expression)Literal$.MODULE$.create(null, (DataType)CalendarIntervalType$.MODULE$), UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)(Function2 & Serializable & scala.Serializable)(start, interval) -> new TimeAdd(start, (Expression)new UnaryMinus(interval, UnaryMinus$.MODULE$.apply$default$2()), timeZoneId), (DataType)TimestampType$.MODULE$, (DataType)CalendarIntervalType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$190(DateExpressionsSuite $this, SimpleDateFormat sdf$3, Option timeZoneId$6, Literal roundOff) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("2015-01-30 11:52:00").getTime())), (Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("2015-01-30 11:50:00").getTime())), (Expression)roundOff, timeZoneId$6), BoxesRunTime.boxToDouble((double)0.0), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("2015-01-31 00:00:00").getTime())), (Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("2015-03-31 22:00:00").getTime())), (Expression)roundOff, timeZoneId$6), BoxesRunTime.boxToDouble((double)-2.0), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("2015-03-31 22:00:00").getTime())), (Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("2015-02-28 00:00:00").getTime())), (Expression)roundOff, timeZoneId$6), BoxesRunTime.boxToDouble((double)1.0), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$187(DateExpressionsSuite $this, SimpleDateFormat sdf$3, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        sdf$3.setTimeZone(TimeZone.getTimeZone(zid));
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("1997-02-28 10:30:00").getTime())), (Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("1996-10-30 00:00:00").getTime())), (Expression)Literal$.MODULE$.TrueLiteral(), timeZoneId), BoxesRunTime.boxToDouble((double)3.94959677), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("1997-02-28 10:30:00").getTime())), (Expression)Literal$.MODULE$.apply((Object)new Timestamp(sdf$3.parse("1996-10-30 00:00:00").getTime())), (Expression)Literal$.MODULE$.FalseLiteral(), timeZoneId), BoxesRunTime.boxToDouble((double)3.9495967741935485), $this.checkEvaluation$default$3());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.FalseLiteral(), Literal$.MODULE$.TrueLiteral()}))).foreach((Function1 & Serializable & scala.Serializable)roundOff -> {
            DateExpressionsSuite.$anonfun$new$190($this, sdf$3, timeZoneId, roundOff);
            return BoxedUnit.UNIT;
        });
        Literal t = Literal$.MODULE$.apply((Object)Timestamp.valueOf("2015-03-31 22:00:00"));
        Literal tnull = Literal$.MODULE$.create(null, (DataType)TimestampType$.MODULE$);
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)t, (Expression)tnull, (Expression)Literal$.MODULE$.TrueLiteral(), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)tnull, (Expression)t, (Expression)Literal$.MODULE$.TrueLiteral(), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)tnull, (Expression)tnull, (Expression)Literal$.MODULE$.TrueLiteral(), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MonthsBetween((Expression)t, (Expression)t, (Expression)Literal$.MODULE$.create(null, (DataType)BooleanType$.MODULE$), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkConsistencyBetweenInterpretedAndCodegen((Function3<Expression, Expression, Expression, Expression>)(Function3 & Serializable & scala.Serializable)(time1, time2, roundOff) -> new MonthsBetween(time1, time2, roundOff, timeZoneId), (DataType)TimestampType$.MODULE$, (DataType)TimestampType$.MODULE$, (DataType)BooleanType$.MODULE$);
    }

    private final void testNextDay$1(String input, String dayOfWeek, String output) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new NextDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf(input)), (Expression)NonFoldableLiteral$.MODULE$.apply(dayOfWeek)), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf(output))), this.checkEvaluation$default$3());
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new NextDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf(input)), (Expression)Literal$.MODULE$.apply((Object)dayOfWeek)), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf(output))), this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$234(DateExpressionsSuite $this, String field) {
        $this.testTruncDate(Date.valueOf("2000-03-08"), field, null);
        $this.testTruncDate(null, field, null);
        $this.testTruncTimestamp(Timestamp.valueOf("2000-03-08 11:12:13"), field, null);
        $this.testTruncTimestamp(null, field, null);
    }

    public static final /* synthetic */ void $anonfun$new$238(DateExpressionsSuite $this, SimpleDateFormat sdf1$1, SimpleDateFormat sdf2$1, String fmt1$1, String fmt2$1, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        TimeZone tz = TimeZone.getTimeZone(zid);
        sdf1$1.setTimeZone(tz);
        sdf2$1.setTimeZone(tz);
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (Expression)Literal$.MODULE$.apply((Object)fmt1$1), timeZoneId), sdf1$1.format(new Timestamp(0L)), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L)), (Expression)Literal$.MODULE$.apply((Object)fmt1$1), timeZoneId), sdf1$1.format(new Timestamp(1000000L)), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)-1000L)), (Expression)Literal$.MODULE$.apply((Object)fmt2$1), timeZoneId), sdf2$1.format(new Timestamp(-1000000L)), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.create(null, (DataType)LongType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.create(null, (DataType)LongType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)fmt1$1), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L)), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), timeZoneId), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)new BoundReference(0, (DataType)LongType$.MODULE$, true), (Expression)new BoundReference(1, (DataType)StringType$.MODULE$, true), timeZoneId), UTF8String.fromString((String)sdf1$1.format(new Timestamp(0L))), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), UTF8String.fromString((String)fmt1$1)})));
    }

    public static final /* synthetic */ void $anonfun$new$250(DateExpressionsSuite $this, SimpleDateFormat sdf1$2, SimpleDateFormat sdf2$2, String fmt2$2, SimpleDateFormat sdf3$1, String fmt3$1, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        TimeZone tz = TimeZone.getTimeZone(zid);
        sdf1$2.setTimeZone(tz);
        sdf2$2.setTimeZone(tz);
        Date date1 = Date.valueOf("2015-07-24");
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf1$2.format(new Timestamp(0L))), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)0L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf1$2.format(new Timestamp(1000000L))), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)1000L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)new Timestamp(1000000L)), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)1000L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)date1), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toSeconds(DateTimeUtils$.MODULE$.daysToMicros(DateTimeUtils$.MODULE$.fromJavaDate(date1), tz.toZoneId()))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf2$2.format(new Timestamp(-1000000L))), (Expression)Literal$.MODULE$.apply((Object)fmt2$2), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)-1000L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf3$1.format(Date.valueOf("2015-07-24"))), (Expression)Literal$.MODULE$.apply((Object)fmt3$1), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toSeconds(DateTimeUtils$.MODULE$.daysToMicros(DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-07-24")), tz.toZoneId()))), $this.checkEvaluation$default$3());
        UnixTimestamp qual$1 = new UnixTimestamp((Expression)new CurrentTimestamp(), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), UnixTimestamp$.MODULE$.apply$default$3(), UnixTimestamp$.MODULE$.apply$default$4());
        InternalRow x$1 = qual$1.eval$default$1();
        long t1 = BoxesRunTime.unboxToLong((Object)qual$1.eval(x$1));
        UnixTimestamp qual$2 = new UnixTimestamp((Expression)new CurrentTimestamp(), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), UnixTimestamp$.MODULE$.apply$default$3(), UnixTimestamp$.MODULE$.apply$default$4());
        InternalRow x$2 = qual$2.eval$default$1();
        long t2 = BoxesRunTime.unboxToLong((Object)qual$2.eval(x$2));
        long $org_scalatest_assert_macro_left = t2 - t1;
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)date1), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), timeZoneId, UnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toSeconds(DateTimeUtils$.MODULE$.daysToMicros(DateTimeUtils$.MODULE$.fromJavaDate(date1), tz.toZoneId()))), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$264(DateExpressionsSuite $this, SimpleDateFormat sdf1$3, SimpleDateFormat sdf2$3, String fmt1$2, String fmt2$3, SimpleDateFormat sdf3$2, String fmt3$2, ZoneId zid) {
        Option timeZoneId = Option$.MODULE$.apply((Object)zid.getId());
        TimeZone tz = TimeZone.getTimeZone(zid);
        sdf1$3.setTimeZone(tz);
        sdf2$3.setTimeZone(tz);
        Date date1 = Date.valueOf("2015-07-24");
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf1$3.format(new Timestamp(0L))), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)0L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf1$3.format(new Timestamp(1000000L))), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)1000L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)new Timestamp(1000000L)), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)1000L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)date1), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toSeconds(DateTimeUtils$.MODULE$.daysToMicros(DateTimeUtils$.MODULE$.fromJavaDate(date1), zid))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf2$3.format(new Timestamp(-1000000L))), (Expression)Literal$.MODULE$.apply((Object)fmt2$3), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)-1000L), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)sdf3$2.format(Date.valueOf("2015-07-24"))), (Expression)Literal$.MODULE$.apply((Object)fmt3$2), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toSeconds(DateTimeUtils$.MODULE$.daysToMicros(DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-07-24")), zid))), $this.checkEvaluation$default$3());
        ToUnixTimestamp qual$3 = new ToUnixTimestamp((Expression)new CurrentTimestamp(), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4());
        InternalRow x$3 = qual$3.eval$default$1();
        long t1 = BoxesRunTime.unboxToLong((Object)qual$3.eval(x$3));
        ToUnixTimestamp qual$4 = new ToUnixTimestamp((Expression)new CurrentTimestamp(), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4());
        InternalRow x$4 = qual$4.eval$default$1();
        long t2 = BoxesRunTime.unboxToLong((Object)qual$4.eval(x$4));
        long $org_scalatest_assert_macro_left = t2 - t1;
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)fmt1$2), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)date1), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)TimeUnit.MICROSECONDS.toSeconds(DateTimeUtils$.MODULE$.daysToMicros(DateTimeUtils$.MODULE$.fromJavaDate(date1), zid))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)new BoundReference(0, (DataType)StringType$.MODULE$, true), (Expression)new BoundReference(1, (DataType)StringType$.MODULE$, true), timeZoneId, ToUnixTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)0L), InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)sdf1$3.format(new Timestamp(0L))), UTF8String.fromString((String)fmt1$2)})));
    }

    private final void test$1(String t, String tz, String expected) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUTCTimestamp((Expression)Literal$.MODULE$.create((Object)(t != null ? Timestamp.valueOf(t) : null), (DataType)TimestampType$.MODULE$), (Expression)Literal$.MODULE$.create((Object)tz, (DataType)StringType$.MODULE$)), expected != null ? Timestamp.valueOf(expected) : null, this.checkEvaluation$default$3());
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUTCTimestamp((Expression)Literal$.MODULE$.create((Object)(t != null ? Timestamp.valueOf(t) : null), (DataType)TimestampType$.MODULE$), (Expression)NonFoldableLiteral$.MODULE$.create(tz, (DataType)StringType$.MODULE$)), expected != null ? Timestamp.valueOf(expected) : null, this.checkEvaluation$default$3());
    }

    private final void test$2(String t, String tz, String expected) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUTCTimestamp((Expression)Literal$.MODULE$.create((Object)(t != null ? Timestamp.valueOf(t) : null), (DataType)TimestampType$.MODULE$), (Expression)Literal$.MODULE$.create((Object)tz, (DataType)StringType$.MODULE$)), expected != null ? Timestamp.valueOf(expected) : null, this.checkEvaluation$default$3());
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUTCTimestamp((Expression)Literal$.MODULE$.create((Object)(t != null ? Timestamp.valueOf(t) : null), (DataType)TimestampType$.MODULE$), (Expression)NonFoldableLiteral$.MODULE$.create(tz, (DataType)StringType$.MODULE$)), expected != null ? Timestamp.valueOf(expected) : null, this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$319(DateExpressionsSuite $this, boolean ansi$1, Tuple2 entry) {
        if (ansi$1) {
            $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (MakeTimestamp)entry._1(), package$.MODULE$.EmptyRow(), (String)entry._2(), ClassTag$.MODULE$.apply(DateTimeException.class));
        } else {
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (MakeTimestamp)entry._1(), null, $this.checkEvaluation$default$3());
        }
    }

    private static final SecondWithFraction secFrac$1(MakeTimestamp ts, String timezone$1) {
        return new SecondWithFraction((Expression)ts, (Option)new Some((Object)timezone$1));
    }

    public static final /* synthetic */ void $anonfun$new$334(DateExpressionsSuite $this, String timezone) {
        MakeTimestamp timestamp = new MakeTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)8)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(10.123456), 8, 6)), (Option)new Some((Object)Literal$.MODULE$.apply((Object)timezone)), (Option)new Some((Object)timezone), MakeTimestamp$.MODULE$.apply$default$9());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> DateExpressionsSuite.secFrac$1(timestamp, timezone), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(10.123456), 8, 6), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
            Literal x$140 = Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(59000001L, 8, 6));
            Expression x$141 = timestamp.copy$default$1();
            Expression x$142 = timestamp.copy$default$2();
            Expression x$143 = timestamp.copy$default$3();
            Expression x$144 = timestamp.copy$default$4();
            Expression x$145 = timestamp.copy$default$5();
            Option x$146 = timestamp.copy$default$7();
            Option x$147 = timestamp.copy$default$8();
            boolean x$148 = timestamp.copy$default$9();
            return DateExpressionsSuite.secFrac$1(timestamp.copy(x$141, x$142, x$143, x$144, x$145, (Expression)x$140, x$146, x$147, x$148), timezone);
        }, Decimal$.MODULE$.apply(59000001L, 8, 6), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
            Literal x$149 = Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(1L, 8, 6));
            Expression x$150 = timestamp.copy$default$1();
            Expression x$151 = timestamp.copy$default$2();
            Expression x$152 = timestamp.copy$default$3();
            Expression x$153 = timestamp.copy$default$4();
            Expression x$154 = timestamp.copy$default$5();
            Option x$155 = timestamp.copy$default$7();
            Option x$156 = timestamp.copy$default$8();
            boolean x$157 = timestamp.copy$default$9();
            return DateExpressionsSuite.secFrac$1(timestamp.copy(x$150, x$151, x$152, x$153, x$154, (Expression)x$149, x$155, x$156, x$157), timezone);
        }, Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(1.0E-6), 8, 6), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> DateExpressionsSuite.secFrac$1(timestamp.copy((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), timestamp.copy$default$2(), timestamp.copy$default$3(), timestamp.copy$default$4(), timestamp.copy$default$5(), timestamp.copy$default$6(), timestamp.copy$default$7(), timestamp.copy$default$8(), timestamp.copy$default$9()), timezone), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(10.123456), 8, 6), $this.checkEvaluation$default$3());
    }

    private final void checkException$1(String c, ClassTag evidence$1) {
        block0: {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ParseToTimestamp((Expression)Literal$.MODULE$.apply((Object)"1"), (Expression)Literal$.MODULE$.apply((Object)c)).child(), c, evidence$1);
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ParseToDate((Expression)Literal$.MODULE$.apply((Object)"1"), (Expression)Literal$.MODULE$.apply((Object)c)).child(), c, evidence$1);
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"1"), (Expression)Literal$.MODULE$.apply((Object)c), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4()), c, evidence$1);
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"1"), (Expression)Literal$.MODULE$.apply((Object)c), UnixTimestamp$.MODULE$.apply$default$3(), UnixTimestamp$.MODULE$.apply$default$4()), c, evidence$1);
            if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"E", "F", "q", "Q"}))).contains((Object)c)) break block0;
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new CurrentTimestamp(), (Expression)Literal$.MODULE$.apply((Object)c), DateFormatClass$.MODULE$.apply$default$3()), c, evidence$1);
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new FromUnixTime((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (Expression)Literal$.MODULE$.apply((Object)c), FromUnixTime$.MODULE$.apply$default$3()), c, evidence$1);
        }
    }

    private static final void checkResult$1(long input, Function1 testFunc$1) {
        if ((long)((byte)input) == input) {
            testFunc$1.apply((Object)Predef$.MODULE$.byte2Byte((byte)input));
        } else if ((long)((short)input) == input) {
            testFunc$1.apply((Object)Predef$.MODULE$.short2Short((short)input));
        } else if ((long)((int)input) == input) {
            testFunc$1.apply((Object)Predef$.MODULE$.int2Integer((int)input));
        } else {
            testFunc$1.apply((Object)Predef$.MODULE$.long2Long(input));
        }
    }

    private final void testIntegralFunc$1(Number value) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFromUnixDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)value.intValue()))), LocalDate.ofEpochDay(value.intValue()), this.checkEvaluation$default$3());
    }

    private final void testIntegralFunc$2(Number value) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixDate((Expression)Literal$.MODULE$.apply((Object)LocalDate.ofEpochDay(value.intValue()))), BoxesRunTime.boxToInteger((int)value.intValue()), this.checkEvaluation$default$3());
    }

    private final void testIntegralFunc$3(Number value) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply((Object)value)), Instant.ofEpochSecond(value.longValue()), this.checkEvaluation$default$3());
    }

    private final void testFractionalInput$1(String input) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(input)).toFloat()), BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(input)).toDouble()), Decimal$.MODULE$.apply(input)}))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply(value)), BoxesRunTime.boxToLong((long)((long)(new StringOps(Predef$.MODULE$.augmentString(input)).toDouble() * (double)1000000L))), this.checkEvaluation$default$3());
            return BoxedUnit.UNIT;
        });
    }

    private final void testIntegralFunc$4(Number value) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MillisToTimestamp((Expression)Literal$.MODULE$.apply((Object)value)), Instant.ofEpochMilli(value.longValue()), this.checkEvaluation$default$3());
    }

    private final void testIntegralFunc$5(Number value) {
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MicrosToTimestamp((Expression)Literal$.MODULE$.apply((Object)value)), BoxesRunTime.boxToLong((long)value.longValue()), this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$420(DateExpressionsSuite $this, boolean ansiEnabled) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LEGACY", "CORRECTED", "EXCEPTION"}))).foreach((Function1 & Serializable & scala.Serializable)policy -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)policy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)ansiEnabled)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq exprSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new GetTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss.SSS"), GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), new GetTimestamp((Expression)Literal$.MODULE$.apply((Object)"Unparseable"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss.SSS"), GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss.SSS"), UnixTimestamp$.MODULE$.apply$default$3(), UnixTimestamp$.MODULE$.apply$default$4()), new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"Unparseable"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss.SSS"), UnixTimestamp$.MODULE$.apply$default$3(), UnixTimestamp$.MODULE$.apply$default$4()), new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss.SSS"), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4()), new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"Unparseable"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss.SSS"), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4())}));
                if (!ansiEnabled$1) {
                    exprSeq.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> x$9, null, $this.checkEvaluation$default$3());
                        return BoxedUnit.UNIT;
                    });
                } else {
                    String string = policy;
                    String string2 = "LEGACY";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        exprSeq.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                            $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> x$10, "Unparseable", ClassTag$.MODULE$.apply(ParseException.class));
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        exprSeq.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                            $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> x$11, "could not be parsed", ClassTag$.MODULE$.apply(DateTimeParseException.class));
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                Seq exprSeq2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new GetTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847!!!"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd'T'HH:mm:ss.SSS"), GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), (Object)BoxesRunTime.boxToLong((long)1580184371847000L)), new Tuple2((Object)new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847!!!"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd'T'HH:mm:ss.SSS"), UnixTimestamp$.MODULE$.apply$default$3(), UnixTimestamp$.MODULE$.apply$default$4()), (Object)BoxesRunTime.boxToLong((long)1580184371L)), new Tuple2((Object)new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847!!!"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd'T'HH:mm:ss.SSS"), ToUnixTimestamp$.MODULE$.apply$default$3(), ToUnixTimestamp$.MODULE$.apply$default$4()), (Object)BoxesRunTime.boxToLong((long)1580184371L))}));
                String string = policy;
                String string3 = "LEGACY";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    exprSeq2.foreach((Function1 & Serializable & scala.Serializable)pair -> {
                        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (Expression)pair._1(), BoxesRunTime.boxToLong((long)pair._2$mcJ$sp()), $this.checkEvaluation$default$3());
                        return BoxedUnit.UNIT;
                    });
                } else {
                    String string4 = policy;
                    String string5 = "EXCEPTION";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        exprSeq2.foreach((Function1 & Serializable & scala.Serializable)pair -> {
                            $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (Expression)pair._1(), "You may get a different result due to the upgrading of Spark 3.0", ClassTag$.MODULE$.apply(SparkUpgradeException.class));
                            return BoxedUnit.UNIT;
                        });
                    } else if (ansiEnabled$1) {
                        exprSeq2.foreach((Function1 & Serializable & scala.Serializable)pair -> {
                            $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (Expression)pair._1(), "could not be parsed", ClassTag$.MODULE$.apply(DateTimeParseException.class));
                            return BoxedUnit.UNIT;
                        });
                    } else {
                        exprSeq2.foreach((Function1 & Serializable & scala.Serializable)pair -> {
                            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (Expression)pair._1(), null, $this.checkEvaluation$default$3());
                            return BoxedUnit.UNIT;
                        });
                    }
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public DateExpressionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.PST_OPT = Option$.MODULE$.apply((Object)DateTimeTestUtils$.MODULE$.PST().getId());
        this.JST_OPT = Option$.MODULE$.apply((Object)DateTimeTestUtils$.MODULE$.JST().getId());
        this.date = "2015-04-08 13:10:15";
        this.d = new Date(this.toMillis(this.date()));
        this.time = "2013-11-08 13:10:15";
        this.ts = new Timestamp(this.toMillis(this.time()));
        this.test("datetime function current_date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            int cdpst;
            Bool bool2;
            Bool bool3;
            int d0 = DateTimeUtils$.MODULE$.currentDate(DateTimeTestUtils$.MODULE$.UTC());
            int cd = BoxesRunTime.unboxToInt((Object)new CurrentDate(DateTimeTestUtils$.MODULE$.UTC_OPT()).eval(package$.MODULE$.EmptyRow()));
            int d1 = DateTimeUtils$.MODULE$.currentDate(DateTimeTestUtils$.MODULE$.UTC());
            int $org_scalatest_assert_macro_left = d0;
            int $org_scalatest_assert_macro_right = cd;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                int $org_scalatest_assert_macro_left3 = cd;
                int $org_scalatest_assert_macro_right2 = d1;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool3;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                int $org_scalatest_assert_macro_left5 = d1 - d0;
                int $org_scalatest_assert_macro_right4 = 1;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            int cdjst = BoxesRunTime.unboxToInt((Object)new CurrentDate(this.JST_OPT()).eval(package$.MODULE$.EmptyRow()));
            int $org_scalatest_assert_macro_left6 = cdpst = BoxesRunTime.unboxToInt((Object)new CurrentDate(this.PST_OPT()).eval(package$.MODULE$.EmptyRow()));
            int $org_scalatest_assert_macro_right6 = cd;
            Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 <= $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left7.value()) {
                int $org_scalatest_assert_macro_left8 = cd;
                int $org_scalatest_assert_macro_right7 = cdjst;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 <= $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right8 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("datetime function current_timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Timestamp ct = DateTimeUtils$.MODULE$.toJavaTimestamp(BoxesRunTime.unboxToLong((Object)new CurrentTimestamp().eval(package$.MODULE$.EmptyRow())));
            long t1 = System.currentTimeMillis();
            long $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(t1 - ct.getTime());
            int $org_scalatest_assert_macro_right = 5000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("DayOfYear", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SimpleDateFormat sdfDay = new SimpleDateFormat("D", Locale.US);
            Calendar c = Calendar.getInstance();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                c.set(2000, m, 28, 0, 0, 0);
                c.add(5, i);
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfYear((Expression)Literal$.MODULE$.apply((Object)new Date(c.getTimeInMillis()))), BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(sdfDay.format(c.getTime()))).toInt()), this.checkEvaluation$default$3());
            }));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfYear((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-15 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)288), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-04 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)277), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)DayOfYear$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Year", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)2015), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)2015), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)2013), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2000), 2002).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).by(11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> {
                c.set(y, m, 28);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 120).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    c.add(11, 1);
                    this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)Literal$.MODULE$.apply((Object)new Date(c.getTimeInMillis()))), BoxesRunTime.boxToInteger((int)c.get(1)), this.checkEvaluation$default$3());
                });
            }));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-01-01 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)1582), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Year((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1581-12-31 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)1581), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)Year$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("Quarter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)2), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)2), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2003), 2004).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 11).by(3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> {
                c.set(y, m, 28, 0, 0, 0);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 120).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    c.add(11, 1);
                    this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)Literal$.MODULE$.apply((Object)new Date(c.getTimeInMillis()))), BoxesRunTime.boxToInteger((int)(c.get(2) / 3 + 1)), this.checkEvaluation$default$3());
                });
            }));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-01 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Quarter((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-09-30 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)3), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)Quarter$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("Month", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)11), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-04-28 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-04 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-15 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2003), 2004).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 48).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                c.set(y, m, 28, 0, 0, 0);
                c.add(11, i);
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Month((Expression)Literal$.MODULE$.apply((Object)new Date(c.getTimeInMillis()))), BoxesRunTime.boxToInteger((int)(c.get(2) + 1)), this.checkEvaluation$default$3());
            })));
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)Month$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("Day / DayOfMonth", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"2000-02-29"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)29), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)8), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)8), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)8), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-04-28 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)28), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-15 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-04 13:10:15"), (DataType)DateType$.MODULE$, Cast$.MODULE$.apply$default$3())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1999), 2000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                c.set(y, 0, 1, 0, 0, 0);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 365).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)d -> {
                    c.add(5, 1);
                    this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfMonth((Expression)Literal$.MODULE$.apply((Object)new Date(c.getTimeInMillis()))), BoxesRunTime.boxToInteger((int)c.get(5)), this.checkEvaluation$default$3());
                });
            });
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)DayOfMonth$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("Seconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)new Second((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), DateTimeTestUtils$.MODULE$.UTC_OPT()).resolved()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new Second((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()).resolved(), "Second.apply(Cast.apply(Literal.apply(DateExpressionsSuite.this.d), org.apache.spark.sql.types.TimestampType, org.apache.spark.sql.catalyst.util.DateTimeTestUtils.UTC_OPT), org.apache.spark.sql.catalyst.util.DateTimeTestUtils.UTC_OPT).resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Second((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Second((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Second((Expression)Literal$.MODULE$.apply((Object)this.ts()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                DateExpressionsSuite.$anonfun$new$63(this, c, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("DayOfWeek", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"2011-05-06"), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)Literal$.MODULE$.apply((Object)new Date(this.toMillis("2017-05-27 13:10:15")))), BoxesRunTime.boxToInteger((int)7), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DayOfWeek((Expression)Literal$.MODULE$.apply((Object)new Date(this.toMillis("1582-10-15 13:10:15")))), BoxesRunTime.boxToInteger((int)6), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)DayOfWeek$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("WeekDay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)2), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)2), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"2011-05-06"), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)Literal$.MODULE$.apply((Object)new Date(this.toMillis("2017-05-27 13:10:15")))), BoxesRunTime.boxToInteger((int)5), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekDay((Expression)Literal$.MODULE$.apply((Object)new Date(this.toMillis("1582-10-15 13:10:15")))), BoxesRunTime.boxToInteger((int)4), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)WeekDay$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("WeekOfYear", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)Literal$.MODULE$.apply((Object)this.d())), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)15), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.ts()), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)45), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"2011-05-06"), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)18), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-15 13:10:15"), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)41), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new WeekOfYear((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)"1582-10-04 13:10:15"), (DataType)DateType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT())), BoxesRunTime.boxToInteger((int)40), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)WeekOfYear$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("DateFormat", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"}))).foreach((Function1 & Serializable & scala.Serializable)legacyParserPolicy -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.create(null, (DataType)TimestampType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)"y"), DateTimeTestUtils$.MODULE$.UTC_OPT()), null, $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), DateTimeTestUtils$.MODULE$.UTC_OPT()), null, $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), (Expression)Literal$.MODULE$.apply((Object)"y"), DateTimeTestUtils$.MODULE$.UTC_OPT()), "2015", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"y"), DateTimeTestUtils$.MODULE$.UTC_OPT()), "2013", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), (Expression)Literal$.MODULE$.apply((Object)"H"), DateTimeTestUtils$.MODULE$.UTC_OPT()), "0", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"H"), DateTimeTestUtils$.MODULE$.UTC_OPT()), "13", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, $this.PST_OPT()), (Expression)Literal$.MODULE$.apply((Object)"y"), $this.PST_OPT()), "2015", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"y"), $this.PST_OPT()), "2013", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, $this.PST_OPT()), (Expression)Literal$.MODULE$.apply((Object)"H"), $this.PST_OPT()), "0", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"H"), $this.PST_OPT()), "5", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, $this.JST_OPT()), (Expression)Literal$.MODULE$.apply((Object)"y"), $this.JST_OPT()), "2015", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"y"), $this.JST_OPT()), "2013", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)$this.d()), (DataType)TimestampType$.MODULE$, $this.JST_OPT()), (Expression)Literal$.MODULE$.apply((Object)"H"), $this.JST_OPT()), "0", $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"H"), $this.JST_OPT()), "22", $this.checkEvaluation$default$3());
                DateFormatClass dateFormatClass = new DateFormatClass((Expression)Literal$.MODULE$.apply((Object)$this.ts()), (Expression)Literal$.MODULE$.apply((Object)"\""), $this.JST_OPT());
                GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)dateFormatClass));
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFormatClass((Expression)new BoundReference(0, (DataType)TimestampType$.MODULE$, true), (Expression)new BoundReference(1, (DataType)StringType$.MODULE$, true), $this.JST_OPT()), "22", InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp($this.ts())), UTF8String.fromString((String)"H")})));
            });
            return BoxedUnit.UNIT;
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("Hour", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)new Hour((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), DateTimeTestUtils$.MODULE$.UTC_OPT()).resolved()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new Hour((Expression)Literal$.MODULE$.apply((Object)this.ts()), DateTimeTestUtils$.MODULE$.UTC_OPT()).resolved(), "Hour.apply(Literal.apply(DateExpressionsSuite.this.ts), org.apache.spark.sql.catalyst.util.DateTimeTestUtils.UTC_OPT).resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Hour((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Hour((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)13), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Hour((Expression)Literal$.MODULE$.apply((Object)this.ts()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)13), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                DateExpressionsSuite.$anonfun$new$113(this, c, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("Minute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)new Minute((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), DateTimeTestUtils$.MODULE$.UTC_OPT()).resolved()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new Minute((Expression)Literal$.MODULE$.apply((Object)this.ts()), DateTimeTestUtils$.MODULE$.UTC_OPT()).resolved(), "Minute.apply(Literal.apply(DateExpressionsSuite.this.ts), org.apache.spark.sql.catalyst.util.DateTimeTestUtils.UTC_OPT).resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Minute((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.d()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Minute((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)this.date()), (DataType)TimestampType$.MODULE$, DateTimeTestUtils$.MODULE$.UTC_OPT()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new Minute((Expression)Literal$.MODULE$.apply((Object)this.ts()), DateTimeTestUtils$.MODULE$.UTC_OPT()), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            Calendar c = Calendar.getInstance();
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                DateExpressionsSuite.$anonfun$new$123(this, c, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("date_add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)1)))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-02-29"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)1)))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-02-29"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-02-29"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-365))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-02-28"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)IntegralLiteralTestUtils$.MODULE$.positiveIntLit()), BoxesRunTime.boxToInteger((int)49627), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAdd((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeIntLit()), BoxesRunTime.boxToInteger((int)-15910), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)DateAdd$.MODULE$, (DataType)DateType$.MODULE$, (DataType)ByteType$.MODULE$);
            this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)DateAdd$.MODULE$, (DataType)DateType$.MODULE$, (DataType)ShortType$.MODULE$);
            this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)DateAdd$.MODULE$, (DataType)DateType$.MODULE$, (DataType)IntegerType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("date add interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Date d = Date.valueOf("2016-02-28");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"}))).foreach((Function1 & Serializable & scala.Serializable)flag -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.ANSI_ENABLED().key(), (Object)flag)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.apply((Object)d$1), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(0, 1, 0L)), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-02-29"))), $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.apply((Object)d$1), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, 0L)), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-03-29"))), $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.apply((Object)d$1), (Expression)Literal$.MODULE$.create(null, (DataType)CalendarIntervalType$.MODULE$), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, 0L)), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
                });
                return BoxedUnit.UNIT;
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.ANSI_ENABLED().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.apply((Object)d), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, 90000000000L)), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), "Cannot add hours, minutes or seconds, milliseconds, microseconds to a date", ClassTag$.MODULE$.apply(IllegalArgumentException.class)));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.ANSI_ENABLED().key(), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.apply((Object)d), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, 25L)), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-03-29"))), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateAddInterval((Expression)Literal$.MODULE$.apply((Object)d), (Expression)Literal$.MODULE$.apply((Object)new CalendarInterval(1, 1, 90000000000L)), DateAddInterval$.MODULE$.apply$default$3(), DateAddInterval$.MODULE$.apply$default$4()), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-03-30"))), this.checkEvaluation$default$3());
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("date_sub", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-01-01")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)1)))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2014-12-31"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-01-01")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)1)))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2014-12-31"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-01-01")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2014-12-31"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-01-01")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-01-02"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)IntegralLiteralTestUtils$.MODULE$.positiveIntLit()), BoxesRunTime.boxToInteger((int)-15909), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateSub((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-28")), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeIntLit()), BoxesRunTime.boxToInteger((int)49628), this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)DateSub$.MODULE$, (DataType)DateType$.MODULE$, (DataType)ByteType$.MODULE$);
            this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)DateSub$.MODULE$, (DataType)DateType$.MODULE$, (DataType)ShortType$.MODULE$);
            this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)DateSub$.MODULE$, (DataType)DateType$.MODULE$, (DataType)IntegerType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("time_add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                DateExpressionsSuite.$anonfun$new$161(this, sdf, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
        this.test("time_sub", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                DateExpressionsSuite.$anonfun$new$168(this, sdf, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        this.test("add_months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-01-30")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2015-02-28"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-03-30")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1))), BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-02-29"))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-01-30")), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            int maxMonthInterval = 120000;
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.apply((Object)LocalDate.parse("0001-01-01")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)maxMonthInterval))), BoxesRunTime.boxToInteger((int)((int)LocalDate.of(10001, 1, 1).toEpochDay())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new AddMonths((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("9999-12-31")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(-1 * maxMonthInterval)))), BoxesRunTime.boxToInteger((int)-719529), this.checkEvaluation$default$3());
            this.forAll(LiteralGenerator$.MODULE$.randomGen((DataType)DateType$.MODULE$), LiteralGenerator$.MODULE$.monthIntervalLiterGen(), (Seq<Configuration.PropertyCheckConfigParam>)Predef$.MODULE$.wrapRefArray((Object[])new Configuration.PropertyCheckConfigParam[0]), (Function2 & Serializable & scala.Serializable)(l1, l2) -> {
                this.cmpInterpretWithCodegen(package$.MODULE$.EmptyRow(), (Expression)new AddMonths((Expression)l1, (Expression)l2), this.cmpInterpretWithCodegen$default$3());
                return BoxedUnit.UNIT;
            }, this.generatorDrivenConfig(), Shrink$.MODULE$.shrinkAny(), Shrink$.MODULE$.shrinkAny(), CheckerAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
        this.test("months_between", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                DateExpressionsSuite.$anonfun$new$187(this, sdf, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        this.test("last_day", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-02-28"))), Date.valueOf("2015-02-28"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-03-27"))), Date.valueOf("2015-03-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-04-26"))), Date.valueOf("2015-04-30"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-05-25"))), Date.valueOf("2015-05-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-06-24"))), Date.valueOf("2015-06-30"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-23"))), Date.valueOf("2015-07-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-08-01"))), Date.valueOf("2015-08-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-09-02"))), Date.valueOf("2015-09-30"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-10-03"))), Date.valueOf("2015-10-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-11-04"))), Date.valueOf("2015-11-30"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-12-05"))), Date.valueOf("2015-12-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-01-06"))), Date.valueOf("2016-01-31"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2016-02-07"))), Date.valueOf("2016-02-29"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new LastDay((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)LastDay$.MODULE$, (DataType)DateType$.MODULE$);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        this.test("next_day", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.testNextDay$1("2015-07-23", "Mon", "2015-07-27");
            this.testNextDay$1("2015-07-23", "mo", "2015-07-27");
            this.testNextDay$1("2015-07-23", "Tue", "2015-07-28");
            this.testNextDay$1("2015-07-23", "tu", "2015-07-28");
            this.testNextDay$1("2015-07-23", "we", "2015-07-29");
            this.testNextDay$1("2015-07-23", "wed", "2015-07-29");
            this.testNextDay$1("2015-07-23", "Thu", "2015-07-30");
            this.testNextDay$1("2015-07-23", "TH", "2015-07-30");
            this.testNextDay$1("2015-07-23", "Fri", "2015-07-24");
            this.testNextDay$1("2015-07-23", "fr", "2015-07-24");
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new NextDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-23")), (Expression)Literal$.MODULE$.apply((Object)"xx")), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new NextDay((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)"xx")), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new NextDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-23")), (Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$)), null, this.checkEvaluation$default$3());
            NextDay nextDay = new NextDay((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-23")), (Expression)Literal$.MODULE$.apply((Object)"\"quote"));
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)nextDay));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
        this.test("TruncDate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Date date = Date.valueOf("2015-07-22");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy", "YYYY", "year", "YEAR", "yy", "YY"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncDate(date, fmt, Date.valueOf("2015-01-01"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"month", "MONTH", "mon", "MON", "mm", "MM"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncDate(date, fmt, Date.valueOf("2015-07-01"));
                return BoxedUnit.UNIT;
            });
            this.testTruncDate(date, "DD", null);
            this.testTruncDate(date, "SECOND", null);
            this.testTruncDate(date, "HOUR", null);
            this.testTruncDate(null, "MON", null);
            TruncDate truncDate = new TruncDate((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0), (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)"\"quote"));
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)truncDate));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
        this.test("TruncTimestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Timestamp inputDate = Timestamp.valueOf("2015-07-22 05:30:06");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy", "YYYY", "year", "YEAR", "yy", "YY"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-01-01 00:00:00"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"month", "MONTH", "mon", "MON", "mm", "MM"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-01 00:00:00"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DAY", "day", "DD", "dd"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-22 00:00:00"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HOUR", "hour"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-22 05:00:00"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MINUTE", "minute"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-22 05:30:00"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SECOND", "second"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-22 05:30:06"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WEEK", "week"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-20 00:00:00"));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"QUARTER", "quarter"}))).foreach((Function1 & Serializable & scala.Serializable)fmt -> {
                this.testTruncTimestamp(inputDate, fmt, Timestamp.valueOf("2015-07-01 00:00:00"));
                return BoxedUnit.UNIT;
            });
            this.testTruncTimestamp(null, "MON", null);
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
        this.test("unsupported fmt fields for trunc/date_trunc results null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INVALID", "decade", "century", "millennium", "whatever", null}))).foreach((Function1 & Serializable & scala.Serializable)field -> {
            DateExpressionsSuite.$anonfun$new$234(this, field);
            return BoxedUnit.UNIT;
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
        this.test("from_unixtime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"}))).foreach((Function1 & Serializable & scala.Serializable)legacyParserPolicy -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String fmt1 = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat sdf1 = new SimpleDateFormat(fmt1, Locale.US);
                    String fmt2 = "yyyy-MM-dd HH:mm:ss.SSS";
                    SimpleDateFormat sdf2 = new SimpleDateFormat(fmt2, Locale.US);
                    DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                        DateExpressionsSuite.$anonfun$new$238($this, sdf1, sdf2, fmt1, fmt2, zid);
                        return BoxedUnit.UNIT;
                    });
                });
                return BoxedUnit.UNIT;
            });
            FromUnixTime fromUnixTime = new FromUnixTime((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (Expression)Literal$.MODULE$.apply((Object)"\""), DateTimeTestUtils$.MODULE$.UTC_OPT());
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)fromUnixTime));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        this.test("unix_timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"}))).foreach((Function1 & Serializable & scala.Serializable)legacyParserPolicy -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                    String fmt2 = "yyyy-MM-dd HH:mm:ss.SSS";
                    SimpleDateFormat sdf2 = new SimpleDateFormat(fmt2, Locale.US);
                    String fmt3 = "yy-MM-dd";
                    SimpleDateFormat sdf3 = new SimpleDateFormat(fmt3, Locale.US);
                    sdf3.setTimeZone(DateTimeUtils$.MODULE$.TimeZoneUTC());
                    DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                        DateExpressionsSuite.$anonfun$new$250($this, sdf1, sdf2, fmt2, sdf3, fmt3, zid);
                        return BoxedUnit.UNIT;
                    }));
                });
                return BoxedUnit.UNIT;
            });
            UnixTimestamp unixTimestamp = new UnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"2015-07-24"), (Expression)Literal$.MODULE$.apply((Object)"\""), DateTimeTestUtils$.MODULE$.UTC_OPT(), UnixTimestamp$.MODULE$.apply$default$4());
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)unixTimestamp));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
        this.test("to_unix_timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"legacy", "corrected"}))).foreach((Function1 & Serializable & scala.Serializable)legacyParserPolicy -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)legacyParserPolicy)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String fmt1 = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat sdf1 = new SimpleDateFormat(fmt1, Locale.US);
                    String fmt2 = "yyyy-MM-dd HH:mm:ss.SSS";
                    SimpleDateFormat sdf2 = new SimpleDateFormat(fmt2, Locale.US);
                    String fmt3 = "yy-MM-dd";
                    SimpleDateFormat sdf3 = new SimpleDateFormat(fmt3, Locale.US);
                    sdf3.setTimeZone(DateTimeUtils$.MODULE$.TimeZoneUTC());
                    DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable & scala.Serializable)zid -> {
                        DateExpressionsSuite.$anonfun$new$264($this, sdf1, sdf2, fmt1, fmt2, sdf3, fmt3, zid);
                        return BoxedUnit.UNIT;
                    }));
                });
                return BoxedUnit.UNIT;
            });
            ToUnixTimestamp toUnixTimestamp = new ToUnixTimestamp((Expression)Literal$.MODULE$.apply((Object)"2015-07-24"), (Expression)Literal$.MODULE$.apply((Object)"\""), DateTimeTestUtils$.MODULE$.UTC_OPT(), ToUnixTimestamp$.MODULE$.apply$default$4());
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)toUnixTimestamp));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
        this.test("datediff", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateDiff((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-24")), (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-21"))), BoxesRunTime.boxToInteger((int)3), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateDiff((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-21")), (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-24"))), BoxesRunTime.boxToInteger((int)-3), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateDiff((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-24"))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateDiff((Expression)Literal$.MODULE$.apply((Object)Date.valueOf("2015-07-24")), (Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateDiff((Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$), (Expression)Literal$.MODULE$.create(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
        this.test("to_utc_timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.test$1("2015-07-24 00:00:00", DateTimeTestUtils$.MODULE$.LA().getId(), "2015-07-24 07:00:00");
            this.test$1("2015-01-24 00:00:00", DateTimeTestUtils$.MODULE$.LA().getId(), "2015-01-24 08:00:00");
            this.test$1(null, "UTC", null);
            this.test$1("2015-07-24 00:00:00", null, null);
            this.test$1(null, null, null);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956));
        this.test("to_utc_timestamp - invalid time zone id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid time zone", "\"quote", "UTC*42"}))).foreach((Function1 & Serializable & scala.Serializable)invalidTz -> {
            String msg;
            String $org_scalatest_assert_macro_left = msg = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                ToUTCTimestamp toUTCTimestamp = new ToUTCTimestamp((Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2015-07-24 00:00:00")), (Expression)Literal$.MODULE$.apply(invalidTz));
                return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)toUTCTimestamp));
            }, ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978))).getMessage();
            String $org_scalatest_assert_macro_right = invalidTz;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 976));
        this.test("from_utc_timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.test$2("2015-07-24 00:00:00", DateTimeTestUtils$.MODULE$.LA().getId(), "2015-07-23 17:00:00");
            this.test$2("2015-01-24 00:00:00", DateTimeTestUtils$.MODULE$.LA().getId(), "2015-01-23 16:00:00");
            this.test$2(null, "UTC", null);
            this.test$2("2015-07-24 00:00:00", null, null);
            this.test$2(null, null, null);
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
        this.test("from_utc_timestamp - invalid time zone id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid time zone", "\"quote", "UTC*42"}))).foreach((Function1 & Serializable & scala.Serializable)invalidTz -> {
            String msg;
            String $org_scalatest_assert_macro_left = msg = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                FromUTCTimestamp fromUTCTimestamp = new FromUTCTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply(invalidTz));
                return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)Nil$.MODULE$.$colon$colon((Object)fromUTCTimestamp));
            }, ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009))).getMessage();
            String $org_scalatest_assert_macro_right = invalidTz;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012));
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1007));
        this.test("creating values of DateType via make_date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ansi -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)ansi))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2013)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)15)), MakeDate$.MODULE$.apply$default$4()), Date.valueOf("2013-7-15"), $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)15)), MakeDate$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)19)), MakeDate$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$), MakeDate$.MODULE$.apply$default$4()), null, $this.checkEvaluation$default$3());
                });
                return BoxedUnit.UNIT;
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)13)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)19)), MakeDate$.MODULE$.apply$default$4()), package$.MODULE$.EmptyRow(), "Invalid value for Year", ClassTag$.MODULE$.apply(DateTimeException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)13)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)19)), MakeDate$.MODULE$.apply$default$4()), package$.MODULE$.EmptyRow(), "Invalid value for Month", ClassTag$.MODULE$.apply(DateTimeException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)32)), MakeDate$.MODULE$.apply$default$4()), package$.MODULE$.EmptyRow(), "Invalid value for Day", ClassTag$.MODULE$.apply(DateTimeException.class));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)13)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)19)), MakeDate$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)13)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)19)), MakeDate$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)32)), MakeDate$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3());
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1016));
        this.test("creating values of TimestampType via make_timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Timestamp expected = Timestamp.valueOf("2013-7-15 8:15:23.5");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ansi -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)ansi))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    ObjectRef makeTimestampExpr = ObjectRef.create((Object)new MakeTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2013)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)15)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)8)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)15)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(23.5), 8, 6)), (Option)new Some((Object)Literal$.MODULE$.apply((Object)ZoneId.systemDefault().getId())), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9()));
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (MakeTimestamp)makeTimestampExpr$1.elem, expected$1, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$5 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        Literal x$5 = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
                        Expression x$6 = qual$5.copy$default$2();
                        Expression x$7 = qual$5.copy$default$3();
                        Expression x$8 = qual$5.copy$default$4();
                        Expression x$9 = qual$5.copy$default$5();
                        Expression x$10 = qual$5.copy$default$6();
                        Option x$11 = qual$5.copy$default$7();
                        Option x$12 = qual$5.copy$default$8();
                        boolean x$13 = qual$5.copy$default$9();
                        return qual$5.copy((Expression)x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
                    }, null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$6 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        Literal x$14 = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
                        Expression x$15 = qual$6.copy$default$1();
                        Expression x$16 = qual$6.copy$default$3();
                        Expression x$17 = qual$6.copy$default$4();
                        Expression x$18 = qual$6.copy$default$5();
                        Expression x$19 = qual$6.copy$default$6();
                        Option x$20 = qual$6.copy$default$7();
                        Option x$21 = qual$6.copy$default$8();
                        boolean x$22 = qual$6.copy$default$9();
                        return qual$6.copy(x$15, (Expression)x$14, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
                    }, null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$7 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        Literal x$23 = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
                        Expression x$24 = qual$7.copy$default$1();
                        Expression x$25 = qual$7.copy$default$2();
                        Expression x$26 = qual$7.copy$default$4();
                        Expression x$27 = qual$7.copy$default$5();
                        Expression x$28 = qual$7.copy$default$6();
                        Option x$29 = qual$7.copy$default$7();
                        Option x$30 = qual$7.copy$default$8();
                        boolean x$31 = qual$7.copy$default$9();
                        return qual$7.copy(x$24, x$25, (Expression)x$23, x$26, x$27, x$28, x$29, x$30, x$31);
                    }, null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$8 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        Literal x$32 = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
                        Expression x$33 = qual$8.copy$default$1();
                        Expression x$34 = qual$8.copy$default$2();
                        Expression x$35 = qual$8.copy$default$3();
                        Expression x$36 = qual$8.copy$default$5();
                        Expression x$37 = qual$8.copy$default$6();
                        Option x$38 = qual$8.copy$default$7();
                        Option x$39 = qual$8.copy$default$8();
                        boolean x$40 = qual$8.copy$default$9();
                        return qual$8.copy(x$33, x$34, x$35, (Expression)x$32, x$36, x$37, x$38, x$39, x$40);
                    }, null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$9 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        Literal x$41 = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
                        Expression x$42 = qual$9.copy$default$1();
                        Expression x$43 = qual$9.copy$default$2();
                        Expression x$44 = qual$9.copy$default$3();
                        Expression x$45 = qual$9.copy$default$4();
                        Expression x$46 = qual$9.copy$default$6();
                        Option x$47 = qual$9.copy$default$7();
                        Option x$48 = qual$9.copy$default$8();
                        boolean x$49 = qual$9.copy$default$9();
                        return qual$9.copy(x$42, x$43, x$44, x$45, (Expression)x$41, x$46, x$47, x$48, x$49);
                    }, null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$10 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        Literal x$50 = Literal$.MODULE$.create(null, (DataType)new DecimalType(8, 6));
                        Expression x$51 = qual$10.copy$default$1();
                        Expression x$52 = qual$10.copy$default$2();
                        Expression x$53 = qual$10.copy$default$3();
                        Expression x$54 = qual$10.copy$default$4();
                        Expression x$55 = qual$10.copy$default$5();
                        Option x$56 = qual$10.copy$default$7();
                        Option x$57 = qual$10.copy$default$8();
                        boolean x$58 = qual$10.copy$default$9();
                        return qual$10.copy(x$51, x$52, x$53, x$54, x$55, (Expression)x$50, x$56, x$57, x$58);
                    }, null, $this.checkEvaluation$default$3());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                        MakeTimestamp qual$11 = (MakeTimestamp)makeTimestampExpr$1.elem;
                        None$ x$59 = None$.MODULE$;
                        Expression x$60 = qual$11.copy$default$1();
                        Expression x$61 = qual$11.copy$default$2();
                        Expression x$62 = qual$11.copy$default$3();
                        Expression x$63 = qual$11.copy$default$4();
                        Expression x$64 = qual$11.copy$default$5();
                        Expression x$65 = qual$11.copy$default$6();
                        Option x$66 = qual$11.copy$default$8();
                        boolean x$67 = qual$11.copy$default$9();
                        return qual$11.copy(x$60, x$61, x$62, x$63, x$64, x$65, (Option)x$59, x$66, x$67);
                    }, expected$1, $this.checkEvaluation$default$3());
                    Tuple2[] tuple2Array = new Tuple2[6];
                    MakeTimestamp qual$12 = (MakeTimestamp)makeTimestampExpr.elem;
                    Literal x$68 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
                    Expression x$69 = qual$12.copy$default$2();
                    Expression x$70 = qual$12.copy$default$3();
                    Expression x$71 = qual$12.copy$default$4();
                    Expression x$72 = qual$12.copy$default$5();
                    Expression x$73 = qual$12.copy$default$6();
                    Option x$74 = qual$12.copy$default$7();
                    Option x$75 = qual$12.copy$default$8();
                    boolean x$76 = qual$12.copy$default$9();
                    tuple2Array[0] = new Tuple2((Object)qual$12.copy((Expression)x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76), (Object)"Invalid value for Year");
                    MakeTimestamp qual$13 = (MakeTimestamp)makeTimestampExpr.elem;
                    Literal x$77 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)13));
                    Expression x$78 = qual$13.copy$default$1();
                    Expression x$79 = qual$13.copy$default$3();
                    Expression x$80 = qual$13.copy$default$4();
                    Expression x$81 = qual$13.copy$default$5();
                    Expression x$82 = qual$13.copy$default$6();
                    Option x$83 = qual$13.copy$default$7();
                    Option x$84 = qual$13.copy$default$8();
                    boolean x$85 = qual$13.copy$default$9();
                    tuple2Array[1] = new Tuple2((Object)qual$13.copy(x$78, (Expression)x$77, x$79, x$80, x$81, x$82, x$83, x$84, x$85), (Object)"Invalid value for Month");
                    MakeTimestamp qual$14 = (MakeTimestamp)makeTimestampExpr.elem;
                    Literal x$86 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)32));
                    Expression x$87 = qual$14.copy$default$1();
                    Expression x$88 = qual$14.copy$default$2();
                    Expression x$89 = qual$14.copy$default$4();
                    Expression x$90 = qual$14.copy$default$5();
                    Expression x$91 = qual$14.copy$default$6();
                    Option x$92 = qual$14.copy$default$7();
                    Option x$93 = qual$14.copy$default$8();
                    boolean x$94 = qual$14.copy$default$9();
                    tuple2Array[2] = new Tuple2((Object)qual$14.copy(x$87, x$88, (Expression)x$86, x$89, x$90, x$91, x$92, x$93, x$94), (Object)"Invalid value for Day");
                    MakeTimestamp qual$15 = (MakeTimestamp)makeTimestampExpr.elem;
                    Literal x$95 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)25));
                    Expression x$96 = qual$15.copy$default$1();
                    Expression x$97 = qual$15.copy$default$2();
                    Expression x$98 = qual$15.copy$default$3();
                    Expression x$99 = qual$15.copy$default$5();
                    Expression x$100 = qual$15.copy$default$6();
                    Option x$101 = qual$15.copy$default$7();
                    Option x$102 = qual$15.copy$default$8();
                    boolean x$103 = qual$15.copy$default$9();
                    tuple2Array[3] = new Tuple2((Object)qual$15.copy(x$96, x$97, x$98, (Expression)x$95, x$99, x$100, x$101, x$102, x$103), (Object)"Invalid value for Hour");
                    MakeTimestamp qual$16 = (MakeTimestamp)makeTimestampExpr.elem;
                    Literal x$104 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)65));
                    Expression x$105 = qual$16.copy$default$1();
                    Expression x$106 = qual$16.copy$default$2();
                    Expression x$107 = qual$16.copy$default$3();
                    Expression x$108 = qual$16.copy$default$4();
                    Expression x$109 = qual$16.copy$default$6();
                    Option x$110 = qual$16.copy$default$7();
                    Option x$111 = qual$16.copy$default$8();
                    boolean x$112 = qual$16.copy$default$9();
                    tuple2Array[4] = new Tuple2((Object)qual$16.copy(x$105, x$106, x$107, x$108, (Expression)x$104, x$109, x$110, x$111, x$112), (Object)"Invalid value for Min");
                    MakeTimestamp qual$17 = (MakeTimestamp)makeTimestampExpr.elem;
                    Literal x$113 = Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(70.0), 8, 6));
                    Expression x$114 = qual$17.copy$default$1();
                    Expression x$115 = qual$17.copy$default$2();
                    Expression x$116 = qual$17.copy$default$3();
                    Expression x$117 = qual$17.copy$default$4();
                    Expression x$118 = qual$17.copy$default$5();
                    Option x$119 = qual$17.copy$default$7();
                    Option x$120 = qual$17.copy$default$8();
                    boolean x$121 = qual$17.copy$default$9();
                    tuple2Array[5] = new Tuple2((Object)qual$17.copy(x$114, x$115, x$116, x$117, x$118, (Expression)x$113, x$119, x$120, x$121), (Object)"Invalid value for Second");
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                        DateExpressionsSuite.$anonfun$new$319($this, ansi, entry);
                        return BoxedUnit.UNIT;
                    });
                    makeTimestampExpr.elem = new MakeTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)30)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)23)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)59)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(60.0), 8, 6)), MakeTimestamp$.MODULE$.apply$default$7(), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9());
                    if (ansi) {
                        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                            MakeTimestamp qual$18 = (MakeTimestamp)makeTimestampExpr$1.elem;
                            Literal x$122 = Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(60.5), 8, 6));
                            Expression x$123 = qual$18.copy$default$1();
                            Expression x$124 = qual$18.copy$default$2();
                            Expression x$125 = qual$18.copy$default$3();
                            Expression x$126 = qual$18.copy$default$4();
                            Expression x$127 = qual$18.copy$default$5();
                            Option x$128 = qual$18.copy$default$7();
                            Option x$129 = qual$18.copy$default$8();
                            boolean x$130 = qual$18.copy$default$9();
                            return qual$18.copy(x$123, x$124, x$125, x$126, x$127, (Expression)x$122, x$128, x$129, x$130);
                        }, package$.MODULE$.EmptyRow(), "The fraction of sec must be zero", ClassTag$.MODULE$.apply(DateTimeException.class));
                    } else {
                        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (MakeTimestamp)makeTimestampExpr$1.elem, Timestamp.valueOf("2019-07-01 00:00:00"), $this.checkEvaluation$default$3());
                    }
                    makeTimestampExpr.elem = new MakeTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)8)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)12)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(58.000001), 8, 6)), MakeTimestamp$.MODULE$.apply$default$7(), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> (MakeTimestamp)makeTimestampExpr$1.elem, Timestamp.valueOf("2019-08-12 00:00:58.000001"), $this.checkEvaluation$default$3());
                });
                return BoxedUnit.UNIT;
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MakeTimestamp makeTimestampExpr = new MakeTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)30)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)23)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)59)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(60.0), 8, 6)), MakeTimestamp$.MODULE$.apply$default$7(), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> {
                    Literal x$131 = Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(60.5), 8, 6));
                    Expression x$132 = makeTimestampExpr.copy$default$1();
                    Expression x$133 = makeTimestampExpr.copy$default$2();
                    Expression x$134 = makeTimestampExpr.copy$default$3();
                    Expression x$135 = makeTimestampExpr.copy$default$4();
                    Expression x$136 = makeTimestampExpr.copy$default$5();
                    Option x$137 = makeTimestampExpr.copy$default$7();
                    Option x$138 = makeTimestampExpr.copy$default$8();
                    boolean x$139 = makeTimestampExpr.copy$default$9();
                    return makeTimestampExpr.copy(x$132, x$133, x$134, x$135, x$136, (Expression)x$131, x$137, x$138, x$139);
                }, null, this.checkEvaluation$default$3());
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ansi -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)ansi))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    MakeTimestamp makeTimestampExpr = new MakeTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2019)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)8)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)12)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(58.000001), 8, 6)), MakeTimestamp$.MODULE$.apply$default$7(), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9());
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> makeTimestampExpr, Timestamp.valueOf("2019-08-12 00:00:58.000001"), $this.checkEvaluation$default$3());
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1046));
        this.test("ISO 8601 week-numbering year", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new YearOfWeek((Expression)new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2006)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), MakeDate$.MODULE$.apply$default$4())), BoxesRunTime.boxToInteger((int)2005), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new YearOfWeek((Expression)new MakeDate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2006)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), MakeDate$.MODULE$.apply$default$4())), BoxesRunTime.boxToInteger((int)2006), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1110));
        this.test("extract the seconds part with fraction from timestamps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1 & Serializable & scala.Serializable)timezone -> {
            DateExpressionsSuite.$anonfun$new$334(this, timezone);
            return BoxedUnit.UNIT;
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1115));
        this.test("timestamps difference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instant end = Instant.parse("2019-10-04T11:04:01.123456Z");
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractTimestamps((Expression)Literal$.MODULE$.apply((Object)end), (Expression)Literal$.MODULE$.apply((Object)end)), new CalendarInterval(0, 0, 0L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractTimestamps((Expression)Literal$.MODULE$.apply((Object)end), (Expression)Literal$.MODULE$.apply((Object)Instant.EPOCH)), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval 436163 hours 4 minutes 1 seconds 123 milliseconds 456 microseconds")), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractTimestamps((Expression)Literal$.MODULE$.apply((Object)Instant.EPOCH), (Expression)Literal$.MODULE$.apply((Object)end)), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval -436163 hours -4 minutes -1 seconds -123 milliseconds -456 microseconds")), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractTimestamps((Expression)Literal$.MODULE$.apply((Object)Instant.parse("9999-12-31T23:59:59.999999Z")), (Expression)Literal$.MODULE$.apply((Object)Instant.parse("0001-01-01T00:00:00Z"))), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval 87649415 hours 59 minutes 59 seconds 999 milliseconds 999 microseconds")), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1135));
        this.test("subtract dates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalDate end = LocalDate.of(2019, 10, 5);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractDates((Expression)Literal$.MODULE$.apply((Object)end), (Expression)Literal$.MODULE$.apply((Object)end)), new CalendarInterval(0, 0, 0L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractDates((Expression)Literal$.MODULE$.apply((Object)end.plusDays(1L)), (Expression)Literal$.MODULE$.apply((Object)end)), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval 1 days")), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractDates((Expression)Literal$.MODULE$.apply((Object)end.minusDays(1L)), (Expression)Literal$.MODULE$.apply((Object)end)), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval -1 days")), this.checkEvaluation$default$3());
            Literal epochDate = Literal$.MODULE$.apply((Object)LocalDate.ofEpochDay(0L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractDates((Expression)Literal$.MODULE$.apply((Object)end), (Expression)epochDate), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval 49 years 9 months 4 days")), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractDates((Expression)epochDate, (Expression)Literal$.MODULE$.apply((Object)end)), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval -49 years -9 months -4 days")), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SubtractDates((Expression)Literal$.MODULE$.apply((Object)LocalDate.of(10000, 1, 1)), (Expression)Literal$.MODULE$.apply((Object)LocalDate.of(1, 1, 1))), IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)"interval 9999 years")), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1153));
        this.test("to_timestamp exception mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)"legacy")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new GetTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847-0800"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSz"), GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), BoxesRunTime.boxToLong((long)1580184371847000L), this.checkEvaluation$default$3()));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)"corrected")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new GetTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847-0800"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSz"), GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), null, this.checkEvaluation$default$3()));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()), (Object)"exception")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new GetTimestamp((Expression)Literal$.MODULE$.apply((Object)"2020-01-27T20:06:11.847-0800"), (Expression)Literal$.MODULE$.apply((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSz"), GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()), "Fail to parse", ClassTag$.MODULE$.apply(SparkUpgradeException.class)));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
        this.test("Consistent error handling for datetime formatting and parsing functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'Y', 'W', 'w', 'E', 'u', 'F'}))).foreach((Function1 & Serializable & scala.Serializable)l -> {
                this.checkException$1(((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)l))).toString(), ClassTag$.MODULE$.apply(SparkUpgradeException.class));
                return BoxedUnit.UNIT;
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'q', 'Q', 'e', 'c', 'A', 'n', 'N', 'p'}))).foreach((Function1 & Serializable & scala.Serializable)l -> {
                this.checkException$1(((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)l))).toString(), ClassTag$.MODULE$.apply(IllegalArgumentException.class));
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1194));
        this.test("SPARK-31896: Handle am-pm timestamp parsing when hour is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ParseToTimestamp((Expression)Literal$.MODULE$.apply((Object)"PM"), (Expression)Literal$.MODULE$.apply((Object)"a")).child(), Timestamp.valueOf("1970-01-01 12:00:00.0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ParseToTimestamp((Expression)Literal$.MODULE$.apply((Object)"11:11 PM"), (Expression)Literal$.MODULE$.apply((Object)"mm:ss a")).child(), Timestamp.valueOf("1970-01-01 12:11:11.0"), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1216));
        this.test("DATE_FROM_UNIX_DATE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new DateFromUnixDate((Expression)new Literal(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.testIntegralInput((Function1<Number, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                this.testIntegralFunc$1(value);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1248));
        this.test("UNIX_DATE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixDate((Expression)new Literal(null, (DataType)DateType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.testIntegralInput((Function1<Number, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                this.testIntegralFunc$2(value);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
        this.test("UNIX_SECONDS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)new Literal(null, (DataType)TimestampType$.MODULE$)), null, this.checkEvaluation$default$3());
            ObjectRef timestamp = ObjectRef.create((Object)Literal$.MODULE$.apply((Object)new Timestamp(0L)));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)((Literal)timestamp$2.elem)), BoxesRunTime.boxToLong((long)0L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)((Literal)timestamp$2.elem)), BoxesRunTime.boxToLong((long)1L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(-1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)((Literal)timestamp$2.elem)), BoxesRunTime.boxToLong((long)-1L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(-1L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)((Literal)timestamp$2.elem)), BoxesRunTime.boxToLong((long)-1L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(-1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)((Literal)timestamp$2.elem)), BoxesRunTime.boxToLong((long)-1L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(1999L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixSeconds((Expression)((Literal)timestamp$2.elem)), BoxesRunTime.boxToLong((long)1L), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1272));
        this.test("UNIX_MILLIS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMillis((Expression)new Literal(null, (DataType)TimestampType$.MODULE$)), null, this.checkEvaluation$default$3());
            ObjectRef timestamp = ObjectRef.create((Object)Literal$.MODULE$.apply((Object)new Timestamp(0L)));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMillis((Expression)((Literal)timestamp$3.elem)), BoxesRunTime.boxToLong((long)0L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMillis((Expression)((Literal)timestamp$3.elem)), BoxesRunTime.boxToLong((long)1000L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(-1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMillis((Expression)((Literal)timestamp$3.elem)), BoxesRunTime.boxToLong((long)-1000L), this.checkEvaluation$default$3());
            Timestamp timestampWithNanos = new Timestamp(1000L);
            timestampWithNanos.setNanos(999999);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMillis((Expression)Literal$.MODULE$.apply((Object)timestampWithNanos)), BoxesRunTime.boxToLong((long)1000L), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1290));
        this.test("UNIX_MICROS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMicros((Expression)new Literal(null, (DataType)TimestampType$.MODULE$)), null, this.checkEvaluation$default$3());
            ObjectRef timestamp = ObjectRef.create((Object)Literal$.MODULE$.apply((Object)new Timestamp(0L)));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMicros((Expression)((Literal)timestamp$4.elem)), BoxesRunTime.boxToLong((long)0L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMicros((Expression)((Literal)timestamp$4.elem)), BoxesRunTime.boxToLong((long)1000000L), this.checkEvaluation$default$3());
            timestamp.elem = Literal$.MODULE$.apply((Object)new Timestamp(-1000L));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMicros((Expression)((Literal)timestamp$4.elem)), BoxesRunTime.boxToLong((long)-1000000L), this.checkEvaluation$default$3());
            Timestamp timestampWithNanos = new Timestamp(1000L);
            timestampWithNanos.setNanos(1000);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new UnixMicros((Expression)Literal$.MODULE$.apply((Object)timestampWithNanos)), BoxesRunTime.boxToLong((long)1000001L), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
        this.test("TIMESTAMP_SECONDS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)new Literal(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.testIntegralInput((Function1<Number, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                this.testIntegralFunc$3(value);
                return BoxedUnit.UNIT;
            });
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (DataType)LongType$.MODULE$)), package$.MODULE$.EmptyRow(), "long overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.testFractionalInput$1("1.0");
            this.testFractionalInput$1("-1.0");
            this.testFractionalInput$1("1.234567");
            this.testFractionalInput$1("-1.234567");
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("9")).$times(38)))), "Overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply("0.1234567"))), "Rounding necessary", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new SecondsToTimestamp((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)123.456789123))), Instant.ofEpochSecond(123L, 456789000L), this.checkEvaluation$default$3());
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1317));
        this.test("TIMESTAMP_MILLIS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MillisToTimestamp((Expression)new Literal(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.testIntegralInput((Function1<Number, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                this.testIntegralFunc$4(value);
                return BoxedUnit.UNIT;
            });
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MillisToTimestamp((Expression)new Literal((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (DataType)LongType$.MODULE$)), package$.MODULE$.EmptyRow(), "long overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
        this.test("TIMESTAMP_MICROS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new MicrosToTimestamp((Expression)new Literal(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.testIntegralInput((Function1<Number, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                this.testIntegralFunc$5(value);
                return BoxedUnit.UNIT;
            });
            this.testIntegralFunc$5(Predef$.MODULE$.long2Long(Long.MAX_VALUE));
            this.testIntegralFunc$5(Predef$.MODULE$.long2Long(Long.MIN_VALUE));
        }, new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1389));
        this.test("SPARK-33498: GetTimestamp,UnixTimestamp,ToUnixTimestamp with parseError", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ansiEnabled -> {
            DateExpressionsSuite.$anonfun$new$420(this, BoxesRunTime.unboxToBoolean((Object)ansiEnabled));
            return BoxedUnit.UNIT;
        }), new Position("DateExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1408));
    }
}

