/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.DivideInterval;
import org.apache.spark.sql.catalyst.expressions.DivideInterval$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalDays;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalHours;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalMinutes;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalMonths;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalSeconds;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalYears;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.MultiplyInterval;
import org.apache.spark.sql.catalyst.expressions.MultiplyInterval$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Prettifier;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r3AAB\u0004\u0001)!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C\u0002C!)\u0011\b\u0001C\u0002u!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002\"\u0001A\u0003%AF\u0001\rJ]R,'O^1m\u000bb\u0004(/Z:tS>t7oU;ji\u0016T!\u0001C\u0005\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005i\u0011B\u0001\r\u000e\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\u0015\u000bb\u0004(/Z:tS>tWI^1m\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003=\u0019HO]5oOR{W\u000b\u0016$9'R\u0014HC\u0001\u0012+!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003usB,7O\u0003\u0002(\u001b\u00051QO\\:bM\u0016L!!\u000b\u0013\u0003\u0015U#f\tO*ue&tw\rC\u0003,\u0005\u0001\u0007A&A\u0002tiJ\u0004\"!\f\u001c\u000f\u00059\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019\u0014\u0003\u0019a$o\\8u})\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$'\u0001\u0005j]R,'O^1m)\tYd\b\u0005\u0002\u001by%\u0011Qh\u0002\u0002\b\u0019&$XM]1m\u0011\u0015y4\u00011\u0001-\u0003\u0005\u0019\u0018!\u00047be\u001e,\u0017J\u001c;feZ\fG.F\u0001-\u00039a\u0017M]4f\u0013:$XM\u001d<bY\u0002\u0002")
public class IntervalExpressionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private final String largeInterval;
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<?> keys, Seq<?> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$1);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$2);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    private String sparkHome$lzycompute() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    public UTF8String stringToUTF8Str(String str) {
        return UTF8String.fromString((String)str);
    }

    public Literal interval(String s) {
        return Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str(new StringBuilder(9).append("interval ").append(s).toString())));
    }

    private String largeInterval() {
        return this.largeInterval;
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    public static final /* synthetic */ String $anonfun$new$54(boolean x$1) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)x$1)).toString();
    }

    private final void check$1(String interval, double num, String expected, Option isAnsi) {
        CalendarInterval expectedRes = IntervalUtils$.MODULE$.safeStringToInterval(this.stringToUTF8Str(expected));
        Seq configs = isAnsi.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"})) : Option$.MODULE$.option2Iterable(isAnsi.map((Function1 & Serializable & scala.Serializable)x$1 -> IntervalExpressionsSuite.$anonfun$new$54(BoxesRunTime.unboxToBoolean((Object)x$1)))).toSeq();
        configs.foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)v)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MultiplyInterval expr = new MultiplyInterval((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval($this.stringToUTF8Str(interval$1))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)num$1)), MultiplyInterval$.MODULE$.apply$default$3());
                if (expectedRes$1 == null) {
                    $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expected$1, ClassTag$.MODULE$.apply(ArithmeticException.class));
                } else {
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expectedRes$1, $this.checkEvaluation$default$3());
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Option check$default$4$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$new$60(boolean x$2) {
        return ((Object)BoxesRunTime.boxToBoolean((boolean)x$2)).toString();
    }

    private final void check$2(String interval, double num, String expected, Option isAnsi) {
        CalendarInterval expectedRes = IntervalUtils$.MODULE$.safeStringToInterval(this.stringToUTF8Str(expected));
        Seq configs = isAnsi.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "false"})) : Option$.MODULE$.option2Iterable(isAnsi.map((Function1 & Serializable & scala.Serializable)x$2 -> IntervalExpressionsSuite.$anonfun$new$60(BoxesRunTime.unboxToBoolean((Object)x$2)))).toSeq();
        configs.foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)v)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DivideInterval expr = new DivideInterval((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval($this.stringToUTF8Str(interval$2))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)num$2)), DivideInterval$.MODULE$.apply$default$3());
                if (expected$2 != null && expectedRes$2 == null) {
                    $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expected$2, ClassTag$.MODULE$.apply(ArithmeticException.class));
                } else {
                    $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expectedRes$2, $this.checkEvaluation$default$3());
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Option check$default$4$2() {
        return None$.MODULE$;
    }

    private final void check$3(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeInterval intervalExpr = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)years)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)months)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)weeks)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), MakeInterval$.MODULE$.apply$default$8());
        int totalMonths = years * 12 + months;
        int totalDays = weeks * 7 + days;
        long totalMicros = secFrac + (long)minutes * 60000000L + (long)hours * 3600000000L;
        CalendarInterval expected = new CalendarInterval(totalMonths, totalDays, totalMicros);
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> intervalExpr, expected, this.checkEvaluation$default$3());
    }

    private static final int check$default$1$1() {
        return 0;
    }

    private static final int check$default$2$1() {
        return 0;
    }

    private static final int check$default$3$1() {
        return 0;
    }

    private static final int check$default$4$3() {
        return 0;
    }

    private static final int check$default$5$1() {
        return 0;
    }

    private static final int check$default$6$1() {
        return 0;
    }

    private static final int check$default$7$1() {
        return 0;
    }

    private static final int check$default$8$1() {
        return 0;
    }

    private static final int check$default$9$1() {
        return 0;
    }

    private final void check$4(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeInterval intervalExpr = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)years)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)months)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)weeks)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), MakeInterval$.MODULE$.apply$default$8());
        int totalMonths = years * 12 + months;
        int totalDays = weeks * 7 + days;
        long totalMicros = secFrac + (long)minutes * 60000000L + (long)hours * 3600000000L;
        CalendarInterval expected = new CalendarInterval(totalMonths, totalDays, totalMicros);
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> intervalExpr, expected, this.checkEvaluation$default$3());
    }

    private static final int check$default$1$2() {
        return 0;
    }

    private static final int check$default$2$2() {
        return 0;
    }

    private static final int check$default$3$2() {
        return 0;
    }

    private static final int check$default$4$4() {
        return 0;
    }

    private static final int check$default$5$2() {
        return 0;
    }

    private static final int check$default$6$2() {
        return 0;
    }

    private static final int check$default$7$2() {
        return 0;
    }

    private static final int check$default$8$2() {
        return 0;
    }

    private static final int check$default$9$2() {
        return 0;
    }

    private final void checkException$1(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeInterval intervalExpr = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)years)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)months)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)weeks)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), MakeInterval$.MODULE$.apply$default$8());
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> intervalExpr, package$.MODULE$.EmptyRow(), "", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    private static final int checkException$default$1$1() {
        return 0;
    }

    private static final int checkException$default$2$1() {
        return 0;
    }

    private static final int checkException$default$3$1() {
        return 0;
    }

    private static final int checkException$default$4$1() {
        return 0;
    }

    private static final int checkException$default$5$1() {
        return 0;
    }

    private static final int checkException$default$6$1() {
        return 0;
    }

    private static final int checkException$default$7$1() {
        return 0;
    }

    private static final int checkException$default$8$1() {
        return 0;
    }

    private static final int checkException$default$9$1() {
        return 0;
    }

    public IntervalExpressionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.test("years", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("0 years")), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("9999 years")), BoxesRunTime.boxToInteger((int)9999), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("1000 years")), BoxesRunTime.boxToInteger((int)1000), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("-2000 years")), BoxesRunTime.boxToInteger((int)-2000), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("9 years 400 days")), BoxesRunTime.boxToInteger((int)9), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("9 years 12 months")), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalYears((Expression)this.interval("10 years -1 months")), BoxesRunTime.boxToInteger((int)9), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("0 year")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-24), 24).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)m -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMonths((Expression)this.interval(new StringBuilder(7).append(m).append(" months").toString())), BoxesRunTime.boxToByte((byte)((byte)(m % 12))), this.checkEvaluation$default$3()));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("1 year 10 months")), BoxesRunTime.boxToByte((byte)((byte)10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("-2 year -10 months")), BoxesRunTime.boxToByte((byte)((byte)-10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("9999 years")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.largeInterval = "9999 years 11 months 31 days 11 hours 59 minutes 59 seconds 999 milliseconds 999 microseconds";
        this.test("days", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("0 days")), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("1 days 100 seconds")), BoxesRunTime.boxToInteger((int)1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("-1 days -100 seconds")), BoxesRunTime.boxToInteger((int)-1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("-365 days")), BoxesRunTime.boxToInteger((int)-365), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("365 days")), BoxesRunTime.boxToInteger((int)365), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("100 year 10 months 5 days")), BoxesRunTime.boxToInteger((int)5), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval(this.largeInterval())), BoxesRunTime.boxToInteger((int)31), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalDays((Expression)this.interval("25 hours")), BoxesRunTime.boxToInteger((int)1), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("hours", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("0 hours")), BoxesRunTime.boxToLong((long)0L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("1 hour")), BoxesRunTime.boxToLong((long)1L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("-1 hour")), BoxesRunTime.boxToLong((long)-1L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("23 hours")), BoxesRunTime.boxToLong((long)23L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("-23 hours")), BoxesRunTime.boxToLong((long)-23L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("100 year 10 months 10 days 10 hours")), BoxesRunTime.boxToLong((long)10L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("10 hours 100 minutes")), BoxesRunTime.boxToLong((long)11L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval(this.largeInterval())), BoxesRunTime.boxToLong((long)11L), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalHours((Expression)this.interval("25 hours")), BoxesRunTime.boxToLong((long)1L), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("minutes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("0 minute")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("1 minute")), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("-1 minute")), BoxesRunTime.boxToByte((byte)((byte)-1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("59 minute")), BoxesRunTime.boxToByte((byte)((byte)59)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("-59 minute")), BoxesRunTime.boxToByte((byte)((byte)-59)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("100 year 10 months 10 minutes")), BoxesRunTime.boxToByte((byte)((byte)10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval(this.largeInterval())), BoxesRunTime.boxToByte((byte)((byte)59)), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("seconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("0 second")), Decimal$.MODULE$.apply(0L, 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("1 second")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(1.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("-1 second")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(-1.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("1 minute 59 second")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(59.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("-59 minutes -59 seconds")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(-59.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("100 year 10 months 10 seconds")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(10.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval(this.largeInterval())), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(59.999999), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("10 seconds 1 milliseconds 1 microseconds")), Decimal$.MODULE$.apply(10001001L, 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("61 seconds 1 microseconds")), Decimal$.MODULE$.apply(1000001L, 8, 6), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("multiply", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1("0 seconds", 10.0, "0 seconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("10 hours", 0.0, "0 hours", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("12 months 1 microseconds", 2.0, "2 years 2 microseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("-5 year 3 seconds", 3.0, "-15 years 9 seconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("1 year 1 second", 0.5, "6 months 500 milliseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("-100 years -1 millisecond", 0.5, "-50 years -500 microseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("2 months 4 seconds", -0.5, "-1 months -2 seconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("1 month 2 microseconds", 1.5, "1 months 3 microseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("2 months", 2.147483647E9, "integer overflow", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.check$1("2 months", 2.147483647E9, new StringBuilder(27).append(Integer.MAX_VALUE).append(" months").toString(), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("divide", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$2("0 seconds", 10.0, "0 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("12 months 3 milliseconds", 2.0, "6 months 0.0015 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("-5 year 3 seconds", 3.0, "-1 years -8 months 1 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("6 years -7 seconds", 3.0, "2 years -2.333333 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("2 years -8 seconds", 0.5, "4 years -16 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("-1 month 2 microseconds", -0.25, "4 months -8 microseconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("1 month 3 microsecond", 1.5, "2 microseconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("1 second", 0.0, "divide by zero", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.check$2("1 second", 0.0, null, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            this.check$2(new StringBuilder(7).append(Integer.MAX_VALUE).append(" months").toString(), 0.9, "integer overflow", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.check$2(new StringBuilder(7).append(Integer.MAX_VALUE).append(" months").toString(), 0.9, new StringBuilder(27).append(Integer.MAX_VALUE).append(" months").toString(), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("make interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$1 = 0;
            int x$2 = 0;
            int x$3 = 0;
            int x$4 = IntervalExpressionsSuite.check$default$1$1();
            int x$5 = IntervalExpressionsSuite.check$default$3$1();
            int x$6 = IntervalExpressionsSuite.check$default$5$1();
            int x$7 = IntervalExpressionsSuite.check$default$6$1();
            int x$8 = IntervalExpressionsSuite.check$default$7$1();
            int x$9 = IntervalExpressionsSuite.check$default$8$1();
            this.check$3(x$4, x$1, x$5, x$2, x$6, x$7, x$8, x$9, x$3);
            this.check$3(-123, IntervalExpressionsSuite.check$default$2$1(), IntervalExpressionsSuite.check$default$3$1(), IntervalExpressionsSuite.check$default$4$3(), IntervalExpressionsSuite.check$default$5$1(), IntervalExpressionsSuite.check$default$6$1(), IntervalExpressionsSuite.check$default$7$1(), IntervalExpressionsSuite.check$default$8$1(), IntervalExpressionsSuite.check$default$9$1());
            int x$10 = 123;
            int x$11 = IntervalExpressionsSuite.check$default$1$1();
            int x$12 = IntervalExpressionsSuite.check$default$2$1();
            int x$13 = IntervalExpressionsSuite.check$default$4$3();
            int x$14 = IntervalExpressionsSuite.check$default$5$1();
            int x$15 = IntervalExpressionsSuite.check$default$6$1();
            int x$16 = IntervalExpressionsSuite.check$default$7$1();
            int x$17 = IntervalExpressionsSuite.check$default$8$1();
            int x$18 = IntervalExpressionsSuite.check$default$9$1();
            this.check$3(x$11, x$12, x$10, x$13, x$14, x$15, x$16, x$17, x$18);
            int x$19 = -123;
            int x$20 = IntervalExpressionsSuite.check$default$1$1();
            int x$21 = IntervalExpressionsSuite.check$default$2$1();
            int x$22 = IntervalExpressionsSuite.check$default$3$1();
            int x$23 = IntervalExpressionsSuite.check$default$4$3();
            int x$24 = IntervalExpressionsSuite.check$default$5$1();
            int x$25 = IntervalExpressionsSuite.check$default$6$1();
            int x$26 = IntervalExpressionsSuite.check$default$7$1();
            int x$27 = IntervalExpressionsSuite.check$default$9$1();
            this.check$3(x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$19, x$27);
            this.check$3(9999, 11, 0, 31, 23, 59, 59, 999, 999);
            int x$28 = 10000;
            int x$29 = -1;
            int x$30 = IntervalExpressionsSuite.check$default$2$1();
            int x$31 = IntervalExpressionsSuite.check$default$3$1();
            int x$32 = IntervalExpressionsSuite.check$default$4$3();
            int x$33 = IntervalExpressionsSuite.check$default$5$1();
            int x$34 = IntervalExpressionsSuite.check$default$6$1();
            int x$35 = IntervalExpressionsSuite.check$default$7$1();
            int x$36 = IntervalExpressionsSuite.check$default$8$1();
            this.check$3(x$28, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$29);
            this.check$3(-9999, -11, 0, -31, -23, -59, -59, -999, -999);
            int x$37 = -10000;
            int x$38 = 1;
            int x$39 = IntervalExpressionsSuite.check$default$2$1();
            int x$40 = IntervalExpressionsSuite.check$default$3$1();
            int x$41 = IntervalExpressionsSuite.check$default$4$3();
            int x$42 = IntervalExpressionsSuite.check$default$5$1();
            int x$43 = IntervalExpressionsSuite.check$default$6$1();
            int x$44 = IntervalExpressionsSuite.check$default$7$1();
            int x$45 = IntervalExpressionsSuite.check$default$8$1();
            this.check$3(x$37, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$38);
            int x$46 = Integer.MAX_VALUE;
            int x$47 = Integer.MAX_VALUE;
            int x$48 = Integer.MAX_VALUE;
            int x$49 = Integer.MAX_VALUE;
            int x$50 = Integer.MAX_VALUE;
            int x$51 = IntervalExpressionsSuite.check$default$1$1();
            int x$52 = IntervalExpressionsSuite.check$default$2$1();
            int x$53 = IntervalExpressionsSuite.check$default$3$1();
            int x$54 = IntervalExpressionsSuite.check$default$4$3();
            this.check$3(x$51, x$52, x$53, x$54, x$46, x$47, x$48, x$49, x$50);
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("ANSI mode: make interval", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$55 = 0;
            int x$56 = 0;
            int x$57 = 0;
            int x$58 = IntervalExpressionsSuite.check$default$1$2();
            int x$59 = IntervalExpressionsSuite.check$default$3$2();
            int x$60 = IntervalExpressionsSuite.check$default$5$2();
            int x$61 = IntervalExpressionsSuite.check$default$6$2();
            int x$62 = IntervalExpressionsSuite.check$default$7$2();
            int x$63 = IntervalExpressionsSuite.check$default$8$2();
            this.check$4(x$58, x$55, x$59, x$56, x$60, x$61, x$62, x$63, x$57);
            this.check$4(-123, IntervalExpressionsSuite.check$default$2$2(), IntervalExpressionsSuite.check$default$3$2(), IntervalExpressionsSuite.check$default$4$4(), IntervalExpressionsSuite.check$default$5$2(), IntervalExpressionsSuite.check$default$6$2(), IntervalExpressionsSuite.check$default$7$2(), IntervalExpressionsSuite.check$default$8$2(), IntervalExpressionsSuite.check$default$9$2());
            int x$64 = 123;
            int x$65 = IntervalExpressionsSuite.check$default$1$2();
            int x$66 = IntervalExpressionsSuite.check$default$2$2();
            int x$67 = IntervalExpressionsSuite.check$default$4$4();
            int x$68 = IntervalExpressionsSuite.check$default$5$2();
            int x$69 = IntervalExpressionsSuite.check$default$6$2();
            int x$70 = IntervalExpressionsSuite.check$default$7$2();
            int x$71 = IntervalExpressionsSuite.check$default$8$2();
            int x$72 = IntervalExpressionsSuite.check$default$9$2();
            this.check$4(x$65, x$66, x$64, x$67, x$68, x$69, x$70, x$71, x$72);
            int x$73 = -123;
            int x$74 = IntervalExpressionsSuite.check$default$1$2();
            int x$75 = IntervalExpressionsSuite.check$default$2$2();
            int x$76 = IntervalExpressionsSuite.check$default$3$2();
            int x$77 = IntervalExpressionsSuite.check$default$4$4();
            int x$78 = IntervalExpressionsSuite.check$default$5$2();
            int x$79 = IntervalExpressionsSuite.check$default$6$2();
            int x$80 = IntervalExpressionsSuite.check$default$7$2();
            int x$81 = IntervalExpressionsSuite.check$default$9$2();
            this.check$4(x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$73, x$81);
            this.check$4(9999, 11, 0, 31, 23, 59, 59, 999, 999);
            int x$82 = 10000;
            int x$83 = -1;
            int x$84 = IntervalExpressionsSuite.check$default$2$2();
            int x$85 = IntervalExpressionsSuite.check$default$3$2();
            int x$86 = IntervalExpressionsSuite.check$default$4$4();
            int x$87 = IntervalExpressionsSuite.check$default$5$2();
            int x$88 = IntervalExpressionsSuite.check$default$6$2();
            int x$89 = IntervalExpressionsSuite.check$default$7$2();
            int x$90 = IntervalExpressionsSuite.check$default$8$2();
            this.check$4(x$82, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$83);
            this.check$4(-9999, -11, 0, -31, -23, -59, -59, -999, -999);
            int x$91 = -10000;
            int x$92 = 1;
            int x$93 = IntervalExpressionsSuite.check$default$2$2();
            int x$94 = IntervalExpressionsSuite.check$default$3$2();
            int x$95 = IntervalExpressionsSuite.check$default$4$4();
            int x$96 = IntervalExpressionsSuite.check$default$5$2();
            int x$97 = IntervalExpressionsSuite.check$default$6$2();
            int x$98 = IntervalExpressionsSuite.check$default$7$2();
            int x$99 = IntervalExpressionsSuite.check$default$8$2();
            this.check$4(x$91, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$92);
            int x$100 = Integer.MAX_VALUE;
            int x$101 = Integer.MAX_VALUE;
            int x$102 = Integer.MAX_VALUE;
            int x$103 = Integer.MAX_VALUE;
            int x$104 = Integer.MAX_VALUE;
            int x$105 = IntervalExpressionsSuite.check$default$1$2();
            int x$106 = IntervalExpressionsSuite.check$default$2$2();
            int x$107 = IntervalExpressionsSuite.check$default$3$2();
            int x$108 = IntervalExpressionsSuite.check$default$4$4();
            this.check$4(x$105, x$106, x$107, x$108, x$100, x$101, x$102, x$103, x$104);
            this.checkException$1(Integer.MAX_VALUE, IntervalExpressionsSuite.checkException$default$2$1(), IntervalExpressionsSuite.checkException$default$3$1(), IntervalExpressionsSuite.checkException$default$4$1(), IntervalExpressionsSuite.checkException$default$5$1(), IntervalExpressionsSuite.checkException$default$6$1(), IntervalExpressionsSuite.checkException$default$7$1(), IntervalExpressionsSuite.checkException$default$8$1(), IntervalExpressionsSuite.checkException$default$9$1());
            int x$109 = Integer.MAX_VALUE;
            int x$110 = IntervalExpressionsSuite.checkException$default$1$1();
            int x$111 = IntervalExpressionsSuite.checkException$default$2$1();
            int x$112 = IntervalExpressionsSuite.checkException$default$4$1();
            int x$113 = IntervalExpressionsSuite.checkException$default$5$1();
            int x$114 = IntervalExpressionsSuite.checkException$default$6$1();
            int x$115 = IntervalExpressionsSuite.checkException$default$7$1();
            int x$116 = IntervalExpressionsSuite.checkException$default$8$1();
            int x$117 = IntervalExpressionsSuite.checkException$default$9$1();
            this.checkException$1(x$110, x$111, x$109, x$112, x$113, x$114, x$115, x$116, x$117);
        }), new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
    }
}

