/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.CheckCartesianProductsSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.ExistenceJoin;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.matchers.must.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\t\u0013\u0001}AQA\u000b\u0001\u0005\u0002-:QA\f\u0001\t\u0002=2Q!\r\u0001\t\u0002IBQAK\u0002\u0005\u0002}Bq\u0001Q\u0002C\u0002\u0013\u0005\u0011\t\u0003\u0004Q\u0007\u0001\u0006IA\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u00191\u0006\u0001)A\u0005'\"9q\u000b\u0001b\u0001\n\u0003\u0011\u0006B\u0002-\u0001A\u0003%1\u000bC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\r1\u0004\u0001\u0015!\u0003\\\u0011\u001di\u0007A1A\u0005\u00029DaA\u001d\u0001!\u0002\u0013y\u0007\"B:\u0001\t\u0013!\b\"CA\u0006\u0001E\u0005I\u0011BA\u0007\u0005m\u0019\u0005.Z2l\u0007\u0006\u0014H/Z:jC:\u0004&o\u001c3vGR\u001c8+^5uK*\u00111\u0003F\u0001\n_B$\u0018.\\5{KJT!!\u0006\f\u0002\u0011\r\fG/\u00197zgRT!a\u0006\r\u0002\u0007M\fHN\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0011%!\t\t#%D\u0001\u0019\u0013\t\u0019\u0003DA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003K!j\u0011A\n\u0006\u0003OQ\tQ\u0001\u001d7b]NL!!\u000b\u0014\u0003\u0011Ac\u0017M\u001c+fgR\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\n\u0002\u0011=\u0003H/[7ju\u0016\u0004\"\u0001M\u0002\u000e\u0003\u0001\u0011\u0001b\u00149uS6L'0Z\n\u0003\u0007M\u00022\u0001N\u001c:\u001b\u0005)$B\u0001\u001c\u0015\u0003\u0015\u0011X\u000f\\3t\u0013\tATG\u0001\u0007Sk2,W\t_3dkR|'\u000f\u0005\u0002;{5\t1H\u0003\u0002=M\u00059An\\4jG\u0006d\u0017B\u0001 <\u0005-aunZ5dC2\u0004F.\u00198\u0015\u0003=\nqAY1uG\",7/F\u0001C!\r\u0019%\nT\u0007\u0002\t*\u0011QIR\u0001\nS6lW\u000f^1cY\u0016T!a\u0012%\u0002\u0015\r|G\u000e\\3di&|gNC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tYEI\u0001\u0003MSN$\bCA'O\u001b\u0005\u0019\u0011BA(8\u0005\u0015\u0011\u0015\r^2i\u0003!\u0011\u0017\r^2iKN\u0004\u0013!\u0004;fgR\u0014V\r\\1uS>t\u0017'F\u0001T!\tQD+\u0003\u0002Vw\tiAj\\2bYJ+G.\u0019;j_:\fa\u0002^3tiJ+G.\u0019;j_:\f\u0004%A\u0007uKN$(+\u001a7bi&|gNM\u0001\u000fi\u0016\u001cHOU3mCRLwN\u001c\u001a!\u0003yQw.\u001b8UsB,7oV5uQJ+\u0017/^5sK\u0012\u001cuN\u001c3ji&|g.F\u0001\\!\raVlX\u0007\u0002\r&\u0011aL\u0012\u0002\u0004'\u0016\f(\u0003\u00021cM&4A!\u0019\u0001\u0001?\naAH]3gS:,W.\u001a8u}A\u00111\rZ\u0007\u0002\u0011&\u0011Q\r\u0013\u0002\b!J|G-^2u!\t\u0019w-\u0003\u0002i\u0011\na1+\u001a:jC2L'0\u00192mKB\u0011QE[\u0005\u0003W\u001a\u0012\u0001BS8j]RK\b/Z\u0001 U>Lg\u000eV=qKN<\u0016\u000e\u001e5SKF,\u0018N]3e\u0007>tG-\u001b;j_:\u0004\u0013!\t6pS:$\u0016\u0010]3t/&$\bn\\;u%\u0016\fX/\u001b:fI\u000e{g\u000eZ5uS>tW#A8\u0011\u0007qk\u0006O\u0005\u0003rE\u001aLg\u0001B1\u0001\u0001A\f!E[8j]RK\b/Z:XSRDw.\u001e;SKF,\u0018N]3e\u0007>tG-\u001b;j_:\u0004\u0013\u0001\b9fe\u001a|'/\\\"beR,7/[1o!J|G-^2u\u0007\",7m\u001b\u000b\u0004kbT\bCA2w\u0013\t9\bJ\u0001\u0003V]&$\b\"B=\u0010\u0001\u0004I\u0017\u0001\u00036pS:$\u0016\u0010]3\t\u000fm|\u0001\u0013!a\u0001y\u0006I1m\u001c8eSRLwN\u001c\t\u0004Gv|\u0018B\u0001@I\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006Q\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011BA\u0002\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001'a\u0016\u0014hm\u001c:n\u0007\u0006\u0014H/Z:jC:\u0004&o\u001c3vGR\u001c\u0005.Z2lI\u0011,g-Y;mi\u0012\u0012TCAA\bU\ra\u0018\u0011C\u0016\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0004%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class CheckCartesianProductsSuite
extends SparkFunSuite
implements PlanTest {
    private volatile CheckCartesianProductsSuite$Optimize$ Optimize$module;
    private final LocalRelation testRelation1;
    private final LocalRelation testRelation2;
    private final Seq<JoinType> joinTypesWithRequiredCondition;
    private final Seq<JoinType> joinTypesWithoutRequiredCondition;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public CheckCartesianProductsSuite$Optimize$ Optimize() {
        if (this.Optimize$module == null) {
            this.Optimize$lzycompute$1();
        }
        return this.Optimize$module;
    }

    private String sparkHome$lzycompute() {
        CheckCartesianProductsSuite checkCartesianProductsSuite = this;
        synchronized (checkCartesianProductsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public LocalRelation testRelation1() {
        return this.testRelation1;
    }

    public LocalRelation testRelation2() {
        return this.testRelation2;
    }

    public Seq<JoinType> joinTypesWithRequiredCondition() {
        return this.joinTypesWithRequiredCondition;
    }

    public Seq<JoinType> joinTypesWithoutRequiredCondition() {
        return this.joinTypesWithoutRequiredCondition;
    }

    private void performCartesianProductCheck(JoinType joinType, Option<Expression> condition) {
        LogicalPlan analyzedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation1()).join((LogicalPlan)this.testRelation2(), joinType, condition)).analyze();
        LogicalPlan optimizedPlan = (LogicalPlan)this.Optimize().execute((TreeNode)analyzedPlan);
        this.comparePlans(analyzedPlan, optimizedPlan, this.comparePlans$default$3());
    }

    private Option<Expression> performCartesianProductCheck$default$2() {
        return None$.MODULE$;
    }

    private final void Optimize$lzycompute$1() {
        CheckCartesianProductsSuite checkCartesianProductsSuite = this;
        synchronized (checkCartesianProductsSuite) {
            if (this.Optimize$module == null) {
                this.Optimize$module = new CheckCartesianProductsSuite$Optimize$(this);
            }
        }
    }

    public CheckCartesianProductsSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        this.testRelation1 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()}));
        this.testRelation2 = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).int()}));
        this.joinTypesWithRequiredCondition = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinType[]{Inner$.MODULE$, LeftOuter$.MODULE$, RightOuter$.MODULE$, FullOuter$.MODULE$}));
        this.joinTypesWithoutRequiredCondition = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinType[]{LeftSemi$.MODULE$, LeftAnti$.MODULE$, new ExistenceJoin((Attribute)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "exists")))}));
        this.test("CheckCartesianProducts doesn't throw an exception if cross joins are enabled)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CROSS_JOINS_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Matchers$.MODULE$.noException(new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45)).should(Matchers$.MODULE$.be()).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.joinTypesWithRequiredCondition().$plus$plus(this.joinTypesWithoutRequiredCondition(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)joinType -> {
            this.performCartesianProductCheck(joinType, this.performCartesianProductCheck$default$2());
            return BoxedUnit.UNIT;
        }))), new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("CheckCartesianProducts throws an exception for join types that require a join condition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CROSS_JOINS_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.joinTypesWithRequiredCondition().foreach((Function1 & Serializable & scala.Serializable)joinType -> {
            AnalysisException thrownException = (AnalysisException)Matchers$.MODULE$.the(ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.performCartesianProductCheck((JoinType)joinType, this.performCartesianProductCheck$default$2()));
            String $org_scalatest_assert_macro_left = thrownException.message();
            String $org_scalatest_assert_macro_right = "Detected implicit cartesian product";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        })), new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("CheckCartesianProducts doesn't throw an exception if a join condition is present", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CROSS_JOINS_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.joinTypesWithRequiredCondition().foreach((Function1 & Serializable & scala.Serializable)joinType -> Matchers$.MODULE$.noException(new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67)).should(Matchers$.MODULE$.be()).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.performCartesianProductCheck((JoinType)joinType, (Option<Expression>)new Some((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).$eq$eq$eq((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "d")))))))), new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("CheckCartesianProducts doesn't throw an exception if join types don't require conditions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CROSS_JOINS_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.joinTypesWithoutRequiredCondition().foreach((Function1 & Serializable & scala.Serializable)joinType -> Matchers$.MODULE$.noException(new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77)).should(Matchers$.MODULE$.be()).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.performCartesianProductCheck((JoinType)joinType, this.performCartesianProductCheck$default$2())))), new Position("CheckCartesianProductsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }
}

