/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.statsEstimation;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.ResolvedNamespace;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.CommentOnNamespace;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.statsEstimation.DummyLogicalPlan;
import org.apache.spark.sql.catalyst.statsEstimation.StatsEstimationTestBase;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3AAC\u0006\u00011!)q\u0005\u0001C\u0001Q!9!\u0006\u0001b\u0001\n\u0003Y\u0003B\u0002\u001a\u0001A\u0003%A\u0006C\u00044\u0001\t\u0007I\u0011\u0001\u001b\t\rm\u0002\u0001\u0015!\u00036\u0011\u001da\u0004A1A\u0005\u0002uBa!\u0011\u0001!\u0002\u0013q\u0004\"\u0002\"\u0001\t\u0013\u0019\u0005\"\u0002\"\u0001\t\u0013)&!\u0007\"bg&\u001c7\u000b^1ug\u0016\u001bH/[7bi&|gnU;ji\u0016T!\u0001D\u0007\u0002\u001fM$\u0018\r^:FgRLW.\u0019;j_:T!AD\b\u0002\u0011\r\fG/\u00197zgRT!\u0001E\t\u0002\u0007M\fHN\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\r\u001eGA\u0011!dG\u0007\u0002#%\u0011A$\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001j\u0011!\u00029mC:\u001c\u0018B\u0001\u0012 \u0005!\u0001F.\u00198UKN$\bC\u0001\u0013&\u001b\u0005Y\u0011B\u0001\u0014\f\u0005]\u0019F/\u0019;t\u000bN$\u0018.\\1uS>tG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011A\u0005A\u0001\nCR$(/\u001b2vi\u0016,\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0003_5\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0011G\f\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-\u0001\u0006biR\u0014\u0018NY;uK\u0002\nqaY8m'R\fG/F\u00016!\t1\u0014(D\u00018\u0015\tAt$A\u0004m_\u001eL7-\u00197\n\u0005i:$AC\"pYVlgn\u0015;bi\u0006A1m\u001c7Ti\u0006$\b%\u0001\u0003qY\u0006tW#\u0001 \u0011\u0005\u0011z\u0014B\u0001!\f\u00055\u0019F/\u0019;t)\u0016\u001cH\u000f\u00157b]\u0006)\u0001\u000f\\1oA\u0005Q1\r[3dWN#\u0018\r^:\u0015\t\u0011Sej\u0015\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0005+:LG\u000fC\u0003=\u0011\u0001\u00071\n\u0005\u00027\u0019&\u0011Qj\u000e\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0003P\u0011\u0001\u0007\u0001+\u0001\nfqB,7\r^3e'R\fGo]\"c_>s\u0007C\u0001\u001cR\u0013\t\u0011vG\u0001\u0006Ti\u0006$\u0018n\u001d;jGNDQ\u0001\u0016\u0005A\u0002A\u000b1#\u001a=qK\u000e$X\rZ*uCR\u001c8IY8PM\u001a$2\u0001\u0012,X\u0011\u0015a\u0014\u00021\u0001L\u0011\u0015A\u0016\u00021\u0001Q\u00035)\u0007\u0010]3di\u0016$7\u000b^1ug\u0002")
public class BasicStatsEstimationSuite
extends SparkFunSuite
implements PlanTest,
StatsEstimationTestBase {
    private final AttributeReference attribute;
    private final ColumnStat colStat;
    private final StatsTestPlan plan;
    private boolean originalCBOValue;
    private boolean originalPlanStatsValue;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        StatsEstimationTestBase.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        StatsEstimationTestBase.afterAll$(this);
    }

    @Override
    public long getColSize(Attribute attribute, ColumnStat colStat) {
        return StatsEstimationTestBase.getColSize$(this, attribute, colStat);
    }

    @Override
    public AttributeReference attr(String colName) {
        return StatsEstimationTestBase.attr$(this, colName);
    }

    @Override
    public AttributeMap<ColumnStat> toAttributeMap(Seq<Tuple2<String, ColumnStat>> colStats, LogicalPlan plan) {
        return StatsEstimationTestBase.toAttributeMap$(this, colStats, plan);
    }

    @Override
    public ColumnStat rangeColumnStat(int distinctCount, int nullCount) {
        return StatsEstimationTestBase.rangeColumnStat$(this, distinctCount, nullCount);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    @Override
    public boolean originalCBOValue() {
        return this.originalCBOValue;
    }

    @Override
    public void originalCBOValue_$eq(boolean x$1) {
        this.originalCBOValue = x$1;
    }

    @Override
    public boolean originalPlanStatsValue() {
        return this.originalPlanStatsValue;
    }

    @Override
    public void originalPlanStatsValue_$eq(boolean x$1) {
        this.originalPlanStatsValue = x$1;
    }

    private String sparkHome$lzycompute() {
        BasicStatsEstimationSuite basicStatsEstimationSuite = this;
        synchronized (basicStatsEstimationSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public AttributeReference attribute() {
        return this.attribute;
    }

    public ColumnStat colStat() {
        return this.colStat;
    }

    public StatsTestPlan plan() {
        return this.plan;
    }

    private void checkStats(LogicalPlan plan, Statistics expectedStatsCboOn, Statistics expectedStatsCboOff) {
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            plan.invalidateStatsCache();
            Statistics $org_scalatest_assert_macro_left = plan.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStatsCboOn;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        });
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CBO_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            plan.invalidateStatsCache();
            Statistics $org_scalatest_assert_macro_left = plan.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStatsCboOff;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        });
    }

    private void checkStats(LogicalPlan plan, Statistics expectedStats) {
        this.checkStats(plan, expectedStats, expectedStats);
    }

    public BasicStatsEstimationSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        StatsEstimationTestBase.$init$(this);
        this.attribute = this.attr("key");
        this.colStat = new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.attribute()}));
        AttributeMap x$2 = AttributeMap$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attribute()), (Object)this.colStat())})));
        BigInt x$3 = BigInt$.MODULE$.int2bigInt(10);
        Some x$4 = new Some((Object)BigInt$.MODULE$.int2bigInt(120));
        this.plan = new StatsTestPlan((Seq<Attribute>)x$1, x$3, (AttributeMap<ColumnStat>)x$2, (Option<BigInt>)x$4);
        this.test("range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Range range = Range$.MODULE$.apply(1L, 5L, 1L, (Option)None$.MODULE$, Range$.MODULE$.apply$default$5());
            Statistics rangeStats = new Statistics(BigInt$.MODULE$.int2bigInt(32), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3());
            this.checkStats((LogicalPlan)range, rangeStats, rangeStats);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("windows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan windows = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.plan()).window((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.min((Expression)this.attribute(), package.expressions$.MODULE$.min$default$2())).as((Symbol)SymbolLiteral.bootstrap("apply", "sum_attr"))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.attribute()})), (Seq)Nil$.MODULE$);
            Statistics windowsStats = new Statistics(((BigInt)this.plan().size().get()).$times(BigInt$.MODULE$.int2bigInt(16)).$div(BigInt$.MODULE$.int2bigInt(12)), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3());
            this.checkStats(windows, windowsStats, windowsStats);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("limit estimation: limit < child's rowCount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLimit localLimit = new LocalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (LogicalPlan)this.plan());
            GlobalLimit globalLimit = new GlobalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (LogicalPlan)this.plan());
            Statistics qual$1 = this.plan().stats();
            AttributeMap x$5 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$6 = qual$1.copy$default$1();
            Option x$7 = qual$1.copy$default$2();
            this.checkStats((LogicalPlan)localLimit, qual$1.copy(x$6, x$7, x$5));
            this.checkStats((LogicalPlan)globalLimit, new Statistics(BigInt$.MODULE$.int2bigInt(24), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), Statistics$.MODULE$.apply$default$3()));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("limit estimation: limit > child's rowCount", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLimit localLimit = new LocalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20)), (LogicalPlan)this.plan());
            GlobalLimit globalLimit = new GlobalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)20)), (LogicalPlan)this.plan());
            Statistics qual$2 = this.plan().stats();
            AttributeMap x$8 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$9 = qual$2.copy$default$1();
            Option x$10 = qual$2.copy$default$2();
            this.checkStats((LogicalPlan)localLimit, qual$2.copy(x$9, x$10, x$8));
            Statistics qual$3 = this.plan().stats();
            AttributeMap x$11 = AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            BigInt x$12 = qual$3.copy$default$1();
            Option x$13 = qual$3.copy$default$2();
            this.checkStats((LogicalPlan)globalLimit, qual$3.copy(x$12, x$13, x$11));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("limit estimation: limit = 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LocalLimit localLimit = new LocalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (LogicalPlan)this.plan());
            GlobalLimit globalLimit = new GlobalLimit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (LogicalPlan)this.plan());
            Statistics stats = new Statistics(BigInt$.MODULE$.int2bigInt(1), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), Statistics$.MODULE$.apply$default$3());
            this.checkStats((LogicalPlan)localLimit, stats);
            this.checkStats((LogicalPlan)globalLimit, stats);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("sample estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Sample sample = new Sample(0.0, 0.5, false, (long)(package$.MODULE$.random() * (double)1000), (LogicalPlan)this.plan());
            this.checkStats((LogicalPlan)sample, new Statistics(BigInt$.MODULE$.int2bigInt(60), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(5)), Statistics$.MODULE$.apply$default$3()));
            Statistics childStats = new Statistics(BigInt$.MODULE$.int2bigInt(120), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3());
            DummyLogicalPlan childPlan = new DummyLogicalPlan(childStats, childStats);
            Sample sample2 = new Sample(0.0, 0.11, false, (long)(package$.MODULE$.random() * (double)1000), (LogicalPlan)childPlan);
            this.checkStats((LogicalPlan)sample2, new Statistics(BigInt$.MODULE$.int2bigInt(14), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3()));
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("estimate statistics when the conf changes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2[] tuple2Array = new Tuple2[1];
            String x$14 = "c1";
            IntegerType$ x$15 = IntegerType$.MODULE$;
            boolean x$16 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$17 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$18 = AttributeReference$.MODULE$.apply$default$5(x$14, (DataType)x$15, x$16, x$17);
            Seq x$19 = AttributeReference$.MODULE$.apply$default$6(x$14, (DataType)x$15, x$16, x$17);
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$14, (DataType)x$15, x$16, x$17, x$18, x$19)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            Statistics expectedDefaultStats = new Statistics(BigInt$.MODULE$.int2bigInt(40), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), AttributeMap$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
            Tuple2[] tuple2Array2 = new Tuple2[1];
            String x$20 = "c1";
            IntegerType$ x$21 = IntegerType$.MODULE$;
            boolean x$22 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$23 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$24 = AttributeReference$.MODULE$.apply$default$5(x$20, (DataType)x$21, x$22, x$23);
            Seq x$25 = AttributeReference$.MODULE$.apply$default$6(x$20, (DataType)x$21, x$22, x$23);
            tuple2Array2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$20, (DataType)x$21, x$22, x$23, x$24, x$25)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            Statistics expectedCboStats = new Statistics(BigInt$.MODULE$.int2bigInt(4), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), AttributeMap$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))));
            DummyLogicalPlan plan = new DummyLogicalPlan(expectedDefaultStats, expectedCboStats);
            this.checkStats((LogicalPlan)plan, expectedCboStats, expectedDefaultStats);
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("command should report a dummy stats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CommentOnNamespace plan = new CommentOnNamespace((LogicalPlan)new ResolvedNamespace((CatalogPlugin)Mockito.mock(SupportsNamespaces.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ns"})), "comment");
            this.checkStats((LogicalPlan)plan, Statistics$.MODULE$.DUMMY(), Statistics$.MODULE$.DUMMY());
        }, new Position("BasicStatsEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

