/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001}4Aa\u0004\t\u0001;!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u0018\u0001A\u0003%\u0001\u0006C\u00041\u0001\t\u0007I\u0011B\u0019\t\rY\u0002\u0001\u0015!\u00033\u0011\u001d9\u0004A1A\u0005\naBaa\u0014\u0001!\u0002\u0013I\u0004b\u0002)\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007#\u0002\u0001\u000b\u0011B\u001d\t\u000fI\u0003!\u0019!C\u0005'\"1\u0011\f\u0001Q\u0001\nQCQA\u0017\u0001\u0005\nmCQ\u0001\u001d\u0001\u0005\nEDQ!\u001e\u0001\u0005\nY\u0014a#U;b]RLG.Z*v[6\f'/[3t'VLG/\u001a\u0006\u0003#I\tA!\u001e;jY*\u00111\u0003F\u0001\tG\u0006$\u0018\r\\=ti*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\b\t\u0003?\u0001j\u0011AF\u0005\u0003CY\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0011\u0003\u0005\u0011X#\u0001\u0015\u0011\u0005%jS\"\u0001\u0016\u000b\u0005EY#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059R#A\u0002*b]\u0012|W.\u0001\u0002sA\u0005\ta.F\u00013!\t\u0019D'D\u0001,\u0013\t)4FA\u0002J]R\f!A\u001c\u0011\u0002\u0015%t7M]3bg&tw-F\u0001:!\u0011\u0019$\b\u0010#\n\u0005mZ#A\u0002+va2,'\u0007\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\rM#(/\u001b8h!\r)%\nT\u0007\u0002\r*\u0011q\tS\u0001\nS6lW\u000f^1cY\u0016T!!S\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002L\r\nQ\u0011J\u001c3fq\u0016$7+Z9\u0011\u0005Mj\u0015B\u0001(,\u0005\u0019!u.\u001e2mK\u0006Y\u0011N\\2sK\u0006\u001c\u0018N\\4!\u0003)!Wm\u0019:fCNLgnZ\u0001\fI\u0016\u001c'/Z1tS:<\u0007%\u0001\u0004sC:$w.\\\u000b\u0002)B!1G\u000f\u001fV!\r1v\u000bT\u0007\u0002\u0011&\u0011\u0001\f\u0013\u0002\u0004'\u0016\f\u0018a\u0002:b]\u0012|W\u000eI\u0001\rEVLG\u000eZ*v[6\f'/\u001f\u000b\u00059~cg\u000e\u0005\u0002&;&\u0011a\f\u0005\u0002\u0012#V\fg\u000e^5mKN+X.\\1sS\u0016\u001c\b\"\u00021\r\u0001\u0004\t\u0017\u0001\u00023bi\u0006\u00042A\u00196M\u001d\t\u0019\u0007N\u0004\u0002eO6\tQM\u0003\u0002g9\u00051AH]8pizJ\u0011\u0001L\u0005\u0003S.\nq\u0001]1dW\u0006<W-\u0003\u0002YW*\u0011\u0011n\u000b\u0005\u0006[2\u0001\r\u0001T\u0001\u0005KB\u001c\u0018\u000eC\u0003p\u0019\u0001\u0007!'A\u0005uQJ,7\u000f[8mI\u0006!\"-^5mI\u000e{W\u000e\u001d:fgN\u001cV/\\7bef$B\u0001\u0018:ti\")\u0001-\u0004a\u0001C\")Q.\u0004a\u0001\u0019\")q.\u0004a\u0001e\u0005i1\r[3dWF+\u0018M\u001c;jY\u0016$Ba\u001e>}{B\u00111\u0007_\u0005\u0003s.\u0012A!\u00168ji\")1P\u0004a\u0001\u0019\u0006)\u0011/^1oi\")\u0001M\u0004a\u0001C\")aP\u0004a\u00019\u000691/^7nCJL\b")
public class QuantileSummariesSuite
extends SparkFunSuite {
    private final Random r = new Random(1);
    private final int n;
    private final Tuple2<String, IndexedSeq<Object>> increasing = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"increasing"), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$1 -> x$1, IndexedSeq$.MODULE$.canBuildFrom()));
    private final Tuple2<String, IndexedSeq<Object>> decreasing = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"decreasing"), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.n()), 0).by(-1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> x$2, IndexedSeq$.MODULE$.canBuildFrom()));
    private final Tuple2<String, Seq<Object>> random = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"random"), (Object)Seq$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> package$.MODULE$.ceil(this.r().nextDouble() * (double)1000)));

    private Random r() {
        return this.r;
    }

    private int n() {
        return this.n;
    }

    private Tuple2<String, IndexedSeq<Object>> increasing() {
        return this.increasing;
    }

    private Tuple2<String, IndexedSeq<Object>> decreasing() {
        return this.decreasing;
    }

    private Tuple2<String, Seq<Object>> random() {
        return this.random;
    }

    private QuantileSummaries buildSummary(Seq<Object> data, double epsi, int threshold) {
        ObjectRef summary = ObjectRef.create((Object)new QuantileSummaries(threshold, epsi, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4(), QuantileSummaries$.MODULE$.$lessinit$greater$default$5()));
        data.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x -> {
            summary$1.elem = ((QuantileSummaries)summary$1.elem).insert(x);
        });
        return ((QuantileSummaries)summary.elem).compress();
    }

    private QuantileSummaries buildCompressSummary(Seq<Object> data, double epsi, int threshold) {
        ObjectRef summary = ObjectRef.create((Object)new QuantileSummaries(threshold, epsi, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4(), QuantileSummaries$.MODULE$.$lessinit$greater$default$5()));
        data.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x -> {
            summary$2.elem = ((QuantileSummaries)summary$2.elem).insert(x).compress();
        });
        return (QuantileSummaries)summary.elem;
    }

    private void checkQuantile(double quant, Seq<Object> data, QuantileSummaries summary) {
        if (data.nonEmpty()) {
            double approx = BoxesRunTime.unboxToDouble((Object)summary.query(quant).get());
            int rankOfValue = data.count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 <= approx);
            int rankOfPreValue = data.count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 < approx);
            double rank = package$.MODULE$.ceil((double)(rankOfValue + rankOfPreValue) / 2.0);
            double lower = package$.MODULE$.floor((quant - summary.relativeError()) * (double)data.size());
            double upper = package$.MODULE$.ceil((quant + summary.relativeError()) * (double)data.size());
            String msg = new StringBuilder(52).append(rank).append(" not in [").append(lower).append(" ").append(upper).append("], requested quantile: ").append(quant).append(", approx returned: ").append(approx).toString();
            double $org_scalatest_assert_macro_left = rank;
            double $org_scalatest_assert_macro_right = lower;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)msg, Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            double $org_scalatest_assert_macro_left2 = rank;
            double $org_scalatest_assert_macro_right2 = upper;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)msg, Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        } else {
            Option $org_scalatest_assert_macro_left = summary.query(quant);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$2(QuantileSummariesSuite $this, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String seq_name = (String)tuple2._1();
        Seq data = (Seq)tuple2._2();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 1.0E-4}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)epsi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1000, 10}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)compression -> {
            $this.test(new StringBuilder(42).append("Extremas with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                double max_approx;
                double min_approx;
                QuantileSummaries s = $this.buildSummary((Seq<Object>)data, epsi, compression);
                double $org_scalatest_assert_macro_left = min_approx = BoxesRunTime.unboxToDouble((Object)s.query(0.0).get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)data.min((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Did not return the min: min=").append(data.min((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(min_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                double $org_scalatest_assert_macro_left2 = max_approx = BoxesRunTime.unboxToDouble((Object)s.query(1.0).get());
                double $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToDouble((Object)data.max((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(34).append("Did not return the max: max=").append(data.max((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(max_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            $this.test(new StringBuilder(54).append("Some quantile values with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QuantileSummaries s = $this.buildSummary((Seq<Object>)data, epsi, compression);
                long $org_scalatest_assert_macro_left = s.count();
                int $org_scalatest_assert_macro_right = data.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(27).append("Found count=").append(s.count()).append(" but data size=").append(data.size()).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            $this.test(new StringBuilder(68).append("Some quantile values with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).append(" ").append("(interleaved)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QuantileSummaries s = $this.buildCompressSummary((Seq<Object>)data, epsi, compression);
                long $org_scalatest_assert_macro_left = s.count();
                int $org_scalatest_assert_macro_right = data.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(27).append("Found count=").append(s.count()).append(" but data size=").append(data.size()).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            $this.test(new StringBuilder(53).append("Tests on empty data with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq emptyData = (Seq)Seq$.MODULE$.empty();
                QuantileSummaries s = $this.buildSummary((Seq<Object>)emptyData, epsi, compression);
                long $org_scalatest_assert_macro_left = s.count();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(28).append("Found count=").append(s.count()).append(" but data size=0").toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])s.sampled());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"if QuantileSummaries is empty, sampled should be empty", Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                $this.checkQuantile(0.9999, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.9, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.5, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.1, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.001, (Seq<Object>)emptyData, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$new$14(Seq x$7) {
        return BoxesRunTime.unboxToDouble((Object)x$7.head());
    }

    public static final /* synthetic */ double $anonfun$new$15(Seq x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8.last());
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Tuple2 x$10) {
        return x$10._2$mcI$sp() % 5 != 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(Tuple2 x$12) {
        return x$12._2$mcI$sp() % 5 == 0;
    }

    public static final /* synthetic */ void $anonfun$new$10(QuantileSummariesSuite $this, Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String seq_name = (String)tuple2._1();
        Seq data = (Seq)tuple2._2();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 1.0E-4}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)epsi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1000, 10}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)compression -> {
            int l = data.size();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(data.take(l / 2)), data.drop(l / 2));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq data1 = (Seq)tuple2._1();
            Seq data2 = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)data1, (Object)data2);
            Tuple2 tuple23 = tuple22;
            Seq data12 = (Seq)tuple23._1();
            Seq data22 = (Seq)tuple23._2();
            $this.test(new StringBuilder(55).append("Merging ordered lists with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                double max_approx;
                double min_approx;
                QuantileSummaries s1 = $this.buildSummary((Seq<Object>)data12, epsi, compression);
                QuantileSummaries s2 = $this.buildSummary((Seq<Object>)data22, epsi, compression);
                QuantileSummaries s = s1.merge(s2);
                double $org_scalatest_assert_macro_left = min_approx = BoxesRunTime.unboxToDouble((Object)s.query(0.0).get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)data.min((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Did not return the min: min=").append(data.min((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(min_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                double $org_scalatest_assert_macro_left2 = max_approx = BoxesRunTime.unboxToDouble((Object)s.query(1.0).get());
                double $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToDouble((Object)data.max((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(34).append("Did not return the max: max=").append(data.max((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(max_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Tuple2 tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data.sliding(2).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble((double)QuantileSummariesSuite.$anonfun$new$14(x$7))).toSeq()), (Object)data.sliding(2).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)QuantileSummariesSuite.$anonfun$new$15(x$8))).toSeq());
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Seq data11 = (Seq)tuple24._1();
            Seq data122 = (Seq)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)data11, (Object)data122);
            Tuple2 tuple26 = tuple25;
            Seq data112 = (Seq)tuple26._1();
            Seq data123 = (Seq)tuple26._2();
            $this.test(new StringBuilder(59).append("Merging interleaved lists with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                double max_approx;
                double min_approx;
                QuantileSummaries s1 = $this.buildSummary((Seq<Object>)data112, epsi, compression);
                QuantileSummaries s2 = $this.buildSummary((Seq<Object>)data123, epsi, compression);
                QuantileSummaries s = s1.merge(s2);
                double $org_scalatest_assert_macro_left = min_approx = BoxesRunTime.unboxToDouble((Object)s.query(0.0).get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)data.min((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Did not return the min: min=").append(data.min((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(min_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                double $org_scalatest_assert_macro_left2 = max_approx = BoxesRunTime.unboxToDouble((Object)s.query(1.0).get());
                double $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToDouble((Object)data.max((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(34).append("Did not return the max: max=").append(data.max((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(max_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            Seq data21 = ((SeqLike)((TraversableLike)((TraversableLike)data.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$17(x$10)))).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11._1$mcD$sp()), Seq$.MODULE$.canBuildFrom())).toSeq();
            Seq data222 = ((SeqLike)((TraversableLike)((TraversableLike)data.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$19(x$12)))).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13._1$mcD$sp()), Seq$.MODULE$.canBuildFrom())).toSeq();
            $this.test(new StringBuilder(70).append("Merging unbalanced interleaved lists with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", ").append("compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QuantileSummaries s1 = $this.buildSummary((Seq<Object>)data21, epsi, compression);
                QuantileSummaries s2 = $this.buildSummary((Seq<Object>)data222, epsi, compression);
                QuantileSummaries s = s1.merge(s2);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.n()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)queryRank -> {
                    double queryQuantile = (double)queryRank / (double)$this.n();
                    $this.checkQuantile(queryQuantile, (Seq<Object>)data, s);
                });
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        }));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuantileSummariesSuite() {
        this.n = 100;
        ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.increasing(), this.decreasing(), this.random()}))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            QuantileSummariesSuite.$anonfun$new$2(this, x$5);
            return BoxedUnit.UNIT;
        });
        ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.increasing(), this.decreasing(), this.random()}))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$9(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            QuantileSummariesSuite.$anonfun$new$10(this, x$14);
            return BoxedUnit.UNIT;
        });
    }
}

