/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.InMemoryTable;
import org.apache.spark.sql.connector.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0002\f\u0018\u0001\tBQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013Ea\u0007\u0003\u0004V\u0001\u0001\u0006Ia\u000e\u0005\b-\u0002\u0011\r\u0011\"\u0005X\u0011\u0019y\u0006\u0001)A\u00051\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007BB3\u0001A\u0003%!\rC\u0004g\u0001\u0001\u0007I\u0011B4\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n!DQ\u0001\u001e\u0001\u0005BUDQa\u001e\u0001\u0005B}Dq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\ty\u0007\u0001C!\u0003cBq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\u0002\u0002!\t!a!\u00033\t\u000b7/[2J]6+Wn\u001c:z)\u0006\u0014G.Z\"bi\u0006dwn\u001a\u0006\u00031e\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u00193\u0006\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\r=\u0013'.Z2u!\tas&D\u0001.\u0015\tqs#A\u0004dCR\fGn\\4\n\u0005Aj#\u0001\u0004+bE2,7)\u0019;bY><\u0017A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\u0018\u0003)q\u0017-\\3ta\u0006\u001cWm]\u000b\u0002oA!\u0001hO\u001fT\u001b\u0005I$B\u0001\u001e(\u0003\u0011)H/\u001b7\n\u0005qJ$aA'baB\u0019a\bS&\u000f\u0005}*eB\u0001!D\u001b\u0005\t%B\u0001\"\"\u0003\u0019a$o\\8u}%\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u000f\u00069\u0001/Y2lC\u001e,'\"\u0001#\n\u0005%S%\u0001\u0002'jgRT!AR$\u0011\u00051\u0003fBA'O!\t\u0001u)\u0003\u0002P\u000f\u00061\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyu\t\u0005\u0003M).[\u0015B\u0001\u001fS\u0003-q\u0017-\\3ta\u0006\u001cWm\u001d\u0011\u0002\rQ\f'\r\\3t+\u0005A\u0006\u0003\u0002\u001d<3r\u0003\"\u0001\f.\n\u0005mk#AC%eK:$\u0018NZ5feB\u0011A&X\u0005\u0003=6\u0012Q\u0001V1cY\u0016\fq\u0001^1cY\u0016\u001c\b%A\tj]Z\fG.\u001b3bi\u0016$G+\u00192mKN,\u0012A\u0019\t\u0004q\rL\u0016B\u00013:\u0005\r\u0019V\r^\u0001\u0013S:4\u0018\r\\5eCR,G\rV1cY\u0016\u001c\b%A\u0003`]\u0006lW-F\u0001i!\rI'nS\u0007\u0002\u000f&\u00111n\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013}s\u0017-\\3`I\u0015\fHC\u00018r!\tIw.\u0003\u0002q\u000f\n!QK\\5u\u0011\u001d\u0011\u0018\"!AA\u0002!\f1\u0001\u001f\u00132\u0003\u0019yf.Y7fA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000794\b\u0010C\u0003x\u0017\u0001\u00071*\u0001\u0003oC6,\u0007\"B=\f\u0001\u0004Q\u0018aB8qi&|gn\u001d\t\u0003wvl\u0011\u0001 \u0006\u0003ueI!A ?\u00031\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016\u001cFO]5oO6\u000b\u0007\u000fF\u0001L\u0003)a\u0017n\u001d;UC\ndWm\u001d\u000b\u0005\u0003\u000b\tY\u0001\u0005\u0003j\u0003\u000fI\u0016bAA\u0005\u000f\n)\u0011I\u001d:bs\"9\u0011QB\u0007A\u0002\u0005=\u0011!\u00038b[\u0016\u001c\b/Y2f!\u0011I\u0017qA&\u0002\u00131|\u0017\r\u001a+bE2,Gc\u0001/\u0002\u0016!1\u0011q\u0003\bA\u0002e\u000bQ!\u001b3f]R\fq\"\u001b8wC2LG-\u0019;f)\u0006\u0014G.\u001a\u000b\u0004]\u0006u\u0001BBA\f\u001f\u0001\u0007\u0011,A\u0006de\u0016\fG/\u001a+bE2,G#\u0003/\u0002$\u0005\u0015\u0012QGA$\u0011\u0019\t9\u0002\u0005a\u00013\"9\u0011q\u0005\tA\u0002\u0005%\u0012AB:dQ\u0016l\u0017\r\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#G\u0001\u0006if\u0004Xm]\u0005\u0005\u0003g\tiC\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a\u000e\u0011\u0001\u0004\tI$\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R![A\u0004\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003:\u0012aC3yaJ,7o]5p]NLA!!\u0012\u0002@\tIAK]1og\u001a|'/\u001c\u0005\b\u0003\u0013\u0002\u0002\u0019AA&\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005qmZ5*\u0001\u0006bYR,'\u000fV1cY\u0016$R\u0001XA)\u0003'Ba!a\u0006\u0012\u0001\u0004I\u0006bBA+#\u0001\u0007\u0011qK\u0001\bG\"\fgnZ3t!\u0015I\u0017\u0011LA/\u0013\r\tYf\u0012\u0002\u000byI,\u0007/Z1uK\u0012t\u0004c\u0001\u0017\u0002`%\u0019\u0011\u0011M\u0017\u0003\u0017Q\u000b'\r\\3DQ\u0006tw-Z\u0001\nIJ|\u0007\u000fV1cY\u0016$B!a\u001a\u0002nA\u0019\u0011.!\u001b\n\u0007\u0005-tIA\u0004C_>dW-\u00198\t\r\u0005]!\u00031\u0001Z\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000b9\f\u0019(a\u001e\t\r\u0005U4\u00031\u0001Z\u0003!yG\u000eZ%eK:$\bBBA='\u0001\u0007\u0011,\u0001\u0005oK^LE-\u001a8u\u0003II7\u000fV1cY\u0016LeN^1mS\u0012\fG/\u001a3\u0015\t\u0005\u001d\u0014q\u0010\u0005\u0007\u0003/!\u0002\u0019A-\u0002\u0017\rdW-\u0019:UC\ndWm\u001d\u000b\u0002]\u0002")
public class BasicInMemoryTableCatalog
implements TableCatalog {
    private final java.util.Map<List<String>, Map<String, String>> namespaces = new ConcurrentHashMap<List<String>, Map<String, String>>();
    private final java.util.Map<Identifier, Table> tables = new ConcurrentHashMap<Identifier, Table>();
    private final Set<Identifier> invalidatedTables = ConcurrentHashMap.newKeySet();
    private Option<String> _name = None$.MODULE$;

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public java.util.Map<List<String>, Map<String, String>> namespaces() {
        return this.namespaces;
    }

    public java.util.Map<Identifier, Table> tables() {
        return this.tables;
    }

    private Set<Identifier> invalidatedTables() {
        return this.invalidatedTables;
    }

    private Option<String> _name() {
        return this._name;
    }

    private void _name_$eq(Option<String> x$1) {
        this._name = x$1;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this._name_$eq((Option<String>)new Some((Object)name));
    }

    public String name() {
        return (String)this._name().get();
    }

    public Identifier[] listTables(String[] namespace) {
        return (Identifier[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.tables().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BasicInMemoryTableCatalog.$anonfun$listTables$1(namespace, x$1)))).toArray(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public Table loadTable(Identifier ident) {
        Table table;
        Option option = Option$.MODULE$.apply((Object)this.tables().get(ident));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(ident);
        }
        Some some = (Some)option;
        Table table2 = table = (Table)some.value();
        return table2;
    }

    public void invalidateTable(Identifier ident) {
        this.invalidatedTables().add(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        if (this.tables().containsKey(ident)) {
            throw new TableAlreadyExistsException(ident);
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(properties);
        InMemoryTable table = new InMemoryTable(new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString(), schema, partitions, properties);
        this.tables().put(ident, (Table)table);
        this.namespaces().putIfAbsent((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).toList(), (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return table;
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        InMemoryTable table = (InMemoryTable)this.loadTable(ident);
        java.util.Map properties = CatalogV2Util$.MODULE$.applyPropertiesChanges(table.properties(), changes);
        StructType schema = CatalogV2Util$.MODULE$.applySchemaChanges(table.schema(), changes);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).isEmpty()) {
            throw new IllegalArgumentException("Cannot drop all fields");
        }
        InMemoryTable newTable = new InMemoryTable(table.name(), schema, table.partitioning(), properties).withData(table.data());
        this.tables().put(ident, (Table)newTable);
        return newTable;
    }

    public boolean dropTable(Identifier ident) {
        return Option$.MODULE$.apply((Object)this.tables().remove(ident)).isDefined();
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        if (this.tables().containsKey(newIdent)) {
            throw new TableAlreadyExistsException(newIdent);
        }
        Option option = Option$.MODULE$.apply((Object)this.tables().remove(oldIdent));
        if (!(option instanceof Some)) {
            throw new NoSuchTableException(oldIdent);
        }
        Some some = (Some)option;
        Table table = (Table)some.value();
        this.tables().put(newIdent, table);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean isTableInvalidated(Identifier ident) {
        return this.invalidatedTables().contains(ident);
    }

    public void clearTables() {
        this.tables().clear();
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$listTables$1(String[] namespace$1, Identifier x$1) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.namespace())).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])namespace$1));
    }
}

