/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException$;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException$;
import org.apache.spark.sql.connector.InMemoryTable;
import org.apache.spark.sql.connector.InMemoryTableCatalog;
import org.apache.spark.sql.connector.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u0011\"\u00011BQa\u000e\u0001\u0005\u0002aBQA\u000f\u0001\u0005BmBQa\u001c\u0001\u0005BADQ!\u001e\u0001\u0005BYDQa\u001f\u0001\u0005\nq4q!!\u0002\u0001\u0003\u0013\t9\u0001\u0003\u0005A\r\t\u0005\t\u0015!\u0003B\u0011)\t\tC\u0002B\u0001B\u0003%\u00111\u0005\u0005\u0007o\u0019!\t!!\u000b\t\u000f\u0005Mb\u0001\"\u0011\u00026!9\u0011q\u0007\u0004\u0005B\u0005e\u0002BB#\u0007\t\u0003\nY\u0004C\u0004\u0002>\u0019!\t%a\u0010\t\u000f\u00055c\u0001\"\u0011\u0002P!9\u0011q\r\u0004\u0005B\u0005%dABAC\u0001\u0011\t9\t\u0003\u0005A!\t\u0005\t\u0015!\u0003B\u0011)\t\t\u0003\u0005B\u0001B\u0003%\u00111\u0005\u0005\u0007oA!\t!!#\t\u000f\u0005E\u0005\u0003\"\u0011\u00026\u00191\u00111\u0013\u0001\u0005\u0003+C\u0001\u0002Q\u000b\u0003\u0002\u0003\u0006I!\u0011\u0005\u000b\u0003C)\"\u0011!Q\u0001\n\u0005\r\u0002BB\u001c\u0016\t\u0003\t9\nC\u0004\u0002\u0012V!\t%!\u000e\t\u000f\u0005}U\u0003\"\u0003\u00026\u00191\u0011\u0011\u0015\u0001\u0005\u0003GC\u0001\u0002Q\u000e\u0003\u0002\u0003\u0006I!\u0011\u0005\u000b\u0003CY\"\u0011!Q\u0001\n\u0005\r\u0002BB\u001c\u001c\t\u0003\t)\u000bC\u0004\u0002\u0012n!\t%!\u000e\u00037M#\u0018mZ5oO&sW*Z7pef$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0015\t\u00113%A\u0005d_:tWm\u0019;pe*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!L\u0019\u0011\u00059zS\"A\u0011\n\u0005A\n#\u0001F%o\u001b\u0016lwN]=UC\ndWmQ1uC2|w\r\u0005\u00023k5\t1G\u0003\u00025C\u000591-\u0019;bY><\u0017B\u0001\u001c4\u0005M\u0019F/Y4j]\u001e$\u0016M\u00197f\u0007\u0006$\u0018\r\\8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0005\u0002/\u0001\u0005Y1\u000f^1hK\u000e\u0013X-\u0019;f)\u0015at\b\u0012'[!\t\u0011T(\u0003\u0002?g\tY1\u000b^1hK\u0012$\u0016M\u00197f\u0011\u0015\u0001%\u00011\u0001B\u0003\u0015IG-\u001a8u!\t\u0011$)\u0003\u0002Dg\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000b\u0015\u0013\u0001\u0019\u0001$\u0002\rM\u001c\u0007.Z7b!\t9%*D\u0001I\u0015\tI5%A\u0003usB,7/\u0003\u0002L\u0011\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b5\u0013\u0001\u0019\u0001(\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002P%Rk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\n1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0011L\u0016\u0002\n)J\fgn\u001d4pe6DQa\u0017\u0002A\u0002q\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011i&\r\u001a3\u000e\u0003yS!a\u00181\u0002\tU$\u0018\u000e\u001c\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gLA\u0002NCB\u0004\"!\u001a7\u000f\u0005\u0019T\u0007CA4Q\u001b\u0005A'BA5,\u0003\u0019a$o\\8u}%\u00111\u000eU\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002l!\u0006a1\u000f^1hKJ+\u0007\u000f\\1dKR)A(\u001d:ti\")\u0001i\u0001a\u0001\u0003\")Qi\u0001a\u0001\r\")Qj\u0001a\u0001\u001d\")1l\u0001a\u00019\u0006!2\u000f^1hK\u000e\u0013X-\u0019;f\u001fJ\u0014V\r\u001d7bG\u0016$R\u0001P<ysjDQ\u0001\u0011\u0003A\u0002\u0005CQ!\u0012\u0003A\u0002\u0019CQ!\u0014\u0003A\u00029CQa\u0017\u0003A\u0002q\u000b1C^1mS\u0012\fG/Z*uC\u001e,G\rV1cY\u0016$R!`A\u0001\u0003\u0007\u0001\"a\u0014@\n\u0005}\u0004&\u0001B+oSRDQ!T\u0003A\u00029CQaW\u0003A\u0002q\u0013q\u0002V3tiN#\u0018mZ3e)\u0006\u0014G.Z\n\t\r\u0005%A(!\u0006\u0002\u001cA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010\u0001\fA\u0001\\1oO&!\u00111CA\u0007\u0005\u0019y%M[3diB\u0019!'a\u0006\n\u0007\u0005e1GA\u0007TkB\u0004xN\u001d;t/JLG/\u001a\t\u0004e\u0005u\u0011bAA\u0010g\ta1+\u001e9q_J$8OU3bI\u0006iA-\u001a7fO\u0006$X\rV1cY\u0016\u00042ALA\u0013\u0013\r\t9#\t\u0002\u000e\u0013:lU-\\8ssR\u000b'\r\\3\u0015\r\u0005-\u0012qFA\u0019!\r\tiCB\u0007\u0002\u0001!)\u0001)\u0003a\u0001\u0003\"9\u0011\u0011E\u0005A\u0002\u0005\r\u0012AE1c_J$8\u000b^1hK\u0012\u001c\u0005.\u00198hKN$\u0012!`\u0001\u0005]\u0006lW\rF\u0001e)\u00051\u0015\u0001D2ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCAA!!\u0015i\u00161IA$\u0013\r\t)E\u0018\u0002\u0004'\u0016$\bc\u0001\u001a\u0002J%\u0019\u00111J\u001a\u0003\u001fQ\u000b'\r\\3DCB\f'-\u001b7jif\fqB\\3x/JLG/\u001a\"vS2$WM\u001d\u000b\u0005\u0003#\ni\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9&I\u0001\u0006oJLG/Z\u0005\u0005\u00037\n)F\u0001\u0007Xe&$XMQ;jY\u0012,'\u000fC\u0004\u0002`9\u0001\r!!\u0019\u0002\t%tgm\u001c\t\u0005\u0003'\n\u0019'\u0003\u0003\u0002f\u0005U#\u0001\u0005'pO&\u001c\u0017\r\\,sSR,\u0017J\u001c4p\u00039qWm^*dC:\u0014U/\u001b7eKJ$B!a\u001b\u0002xA!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\u0005\nAA]3bI&!\u0011QOA8\u0005-\u00196-\u00198Ck&dG-\u001a:\t\u000f\u0005et\u00021\u0001\u0002|\u00059q\u000e\u001d;j_:\u001c\b\u0003BA?\u0003\u0003k!!a \u000b\u0005}\u001b\u0013\u0002BAB\u0003\u007f\u0012\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u0005U!Vm\u001d;Ti\u0006<W\rZ\"sK\u0006$X\rV1cY\u0016\u001c2\u0001EA\u0016)\u0019\tY)!$\u0002\u0010B\u0019\u0011Q\u0006\t\t\u000b\u0001\u001b\u0002\u0019A!\t\u000f\u0005\u00052\u00031\u0001\u0002$\u0005\u00192m\\7nSR\u001cF/Y4fI\u000eC\u0017M\\4fg\n1B+Z:u'R\fw-\u001a3SKBd\u0017mY3UC\ndWmE\u0002\u0016\u0003W!b!!'\u0002\u001c\u0006u\u0005cAA\u0017+!)\u0001\t\u0007a\u0001\u0003\"9\u0011\u0011\u0005\rA\u0002\u0005\r\u0012!H7bs\n,7+[7vY\u0006$X\r\u0012:pa\n+gm\u001c:f\u0007>lW.\u001b;\u0003=Q+7\u000f^*uC\u001e,Gm\u0011:fCR,wJ\u001d*fa2\f7-\u001a+bE2,7cA\u000e\u0002,Q1\u0011qUAU\u0003W\u00032!!\f\u001c\u0011\u0015\u0001e\u00041\u0001B\u0011\u001d\t\tC\ba\u0001\u0003G\u0001")
public class StagingInMemoryTableCatalog
extends InMemoryTableCatalog
implements StagingTableCatalog {
    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.validateStagedTable(partitions, properties);
        return new TestStagedCreateTable(this, ident, new InMemoryTable(new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString(), schema, partitions, properties));
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.validateStagedTable(partitions, properties);
        return new TestStagedReplaceTable(this, ident, new InMemoryTable(new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString(), schema, partitions, properties));
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.validateStagedTable(partitions, properties);
        return new TestStagedCreateOrReplaceTable(this, ident, new InMemoryTable(new StringBuilder(1).append(this.name()).append(".").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString(), schema, partitions, properties));
    }

    private void validateStagedTable(Transform[] partitions, Map<String, String> properties) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).nonEmpty()) {
            throw new UnsupportedOperationException(new StringBuilder(46).append("Catalog ").append(this.name()).append(": Partitioned tables are not supported").toString());
        }
        InMemoryTableCatalog$.MODULE$.maybeSimulateFailedTableCreation(properties);
    }

    public class TestStagedCreateOrReplaceTable
    extends TestStagedTable {
        private final Identifier ident;
        private final InMemoryTable delegateTable;

        public void commitStagedChanges() {
            this.org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedCreateOrReplaceTable$$$outer().tables().put(this.ident, (Table)this.delegateTable);
        }

        public /* synthetic */ StagingInMemoryTableCatalog org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedCreateOrReplaceTable$$$outer() {
            return this.$outer;
        }

        public TestStagedCreateOrReplaceTable(StagingInMemoryTableCatalog $outer, Identifier ident, InMemoryTable delegateTable) {
            this.ident = ident;
            this.delegateTable = delegateTable;
            super($outer, ident, delegateTable);
        }
    }

    public class TestStagedCreateTable
    extends TestStagedTable {
        private final Identifier ident;
        private final InMemoryTable delegateTable;

        public void commitStagedChanges() {
            Table maybePreCommittedTable = this.org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedCreateTable$$$outer().tables().putIfAbsent(this.ident, (Table)this.delegateTable);
            if (maybePreCommittedTable != null) {
                throw new TableAlreadyExistsException(new StringBuilder(53).append("Table with identifier ").append(this.ident).append(" and name ").append(this.name()).append(" was already created.").toString(), TableAlreadyExistsException$.MODULE$.$lessinit$greater$default$2());
            }
        }

        public /* synthetic */ StagingInMemoryTableCatalog org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedCreateTable$$$outer() {
            return this.$outer;
        }

        public TestStagedCreateTable(StagingInMemoryTableCatalog $outer, Identifier ident, InMemoryTable delegateTable) {
            this.ident = ident;
            this.delegateTable = delegateTable;
            super($outer, ident, delegateTable);
        }
    }

    public class TestStagedReplaceTable
    extends TestStagedTable {
        private final Identifier ident;
        private final InMemoryTable delegateTable;

        public void commitStagedChanges() {
            this.maybeSimulateDropBeforeCommit();
            Table maybePreCommittedTable = this.org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedReplaceTable$$$outer().tables().replace(this.ident, (Table)this.delegateTable);
            if (maybePreCommittedTable == null) {
                throw new CannotReplaceMissingTableException(this.ident, CannotReplaceMissingTableException$.MODULE$.$lessinit$greater$default$2());
            }
        }

        private void maybeSimulateDropBeforeCommit() {
            block0: {
                if (!"true".equalsIgnoreCase(this.delegateTable.properties().get(InMemoryTableCatalog$.MODULE$.SIMULATE_DROP_BEFORE_REPLACE_PROPERTY()))) break block0;
                this.org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedReplaceTable$$$outer().tables().remove(this.ident);
            }
        }

        public /* synthetic */ StagingInMemoryTableCatalog org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedReplaceTable$$$outer() {
            return this.$outer;
        }

        public TestStagedReplaceTable(StagingInMemoryTableCatalog $outer, Identifier ident, InMemoryTable delegateTable) {
            this.ident = ident;
            this.delegateTable = delegateTable;
            super($outer, ident, delegateTable);
        }
    }

    public abstract class TestStagedTable
    implements StagedTable,
    SupportsWrite,
    SupportsRead {
        private final InMemoryTable delegateTable;
        public final /* synthetic */ StagingInMemoryTableCatalog $outer;

        public void abortStagedChanges() {
        }

        public String name() {
            return this.delegateTable.name();
        }

        public StructType schema() {
            return this.delegateTable.schema();
        }

        public Set<TableCapability> capabilities() {
            return this.delegateTable.capabilities();
        }

        public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
            return this.delegateTable.newWriteBuilder(info);
        }

        public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
            return this.delegateTable.newScanBuilder(options);
        }

        public /* synthetic */ StagingInMemoryTableCatalog org$apache$spark$sql$connector$StagingInMemoryTableCatalog$TestStagedTable$$$outer() {
            return this.$outer;
        }

        public TestStagedTable(StagingInMemoryTableCatalog $outer, Identifier ident, InMemoryTable delegateTable) {
            this.delegateTable = delegateTable;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

