/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000154AAD\b\u00015!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)\u0001\u0007\u0001C\u0001c!91\u0007\u0001b\u0001\n\u0003!\u0004B\u0002\u001d\u0001A\u0003%Q\u0007C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\t\ry\u0002\u0001\u0015!\u0003<\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d\t\u0007!%A\u0005\u0002\t\u0014Q\u0002R1uCRK\b/Z*vSR,'B\u0001\t\u0012\u0003\u0015!\u0018\u0010]3t\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d;5\t1#\u0003\u0002\u001f'\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\b\u0002+\rDWmY6ECR\fG+\u001f9f\rJ|WNS:p]R\u0011Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0005+:LG\u000fC\u0003-\u0005\u0001\u0007Q&\u0001\u0005eCR\fG+\u001f9f!\t\u0011c&\u0003\u00020\u001f\tAA)\u0019;b)f\u0004X-\u0001\u000bdQ\u0016\u001c7\u000eR1uCRK\b/\u001a$s_6$E\t\u0014\u000b\u0003KIBQ\u0001L\u0002A\u00025\n\u0001\"\\3uC\u0012\fG/Y\u000b\u0002kA\u0011!EN\u0005\u0003o=\u0011\u0001\"T3uC\u0012\fG/Y\u0001\n[\u0016$\u0018\rZ1uC\u0002\n!b\u001d;sk\u000e$H+\u001f9f+\u0005Y\u0004C\u0001\u0012=\u0013\titB\u0001\u0006TiJ,8\r\u001e+za\u0016\f1b\u001d;sk\u000e$H+\u001f9fA\u0005\u00012\r[3dW\u0012+g-Y;miNK'0\u001a\u000b\u0004K\u0005\u0013\u0005\"\u0002\u0017\t\u0001\u0004i\u0003\"B\"\t\u0001\u0004!\u0015aE3ya\u0016\u001cG/\u001a3EK\u001a\fW\u000f\u001c;TSj,\u0007C\u0001\u0014F\u0013\t1uEA\u0002J]R\fae\u00195fG.,\u0015/^1mg&;gn\u001c:f\u0007>l\u0007/\u0019;jE2,g*\u001e7mC\nLG.\u001b;z)\u0011)\u0013jS'\t\u000b)K\u0001\u0019A\u0017\u0002\t\u0019\u0014x.\u001c\u0005\u0006\u0019&\u0001\r!L\u0001\u0003i>DQAT\u0005A\u0002=\u000b\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0003MAK!!U\u0014\u0003\u000f\t{w\u000e\\3b]\u0006\u00112\r[3dW\u000e\u000bG/\u00197pON#(/\u001b8h)\t)C\u000bC\u0003V\u0015\u0001\u0007Q&\u0001\u0002ei\u0006a1M]3bi\u0016\u001cFO];diR\u00111\b\u0017\u0005\u00063.\u0001\r\u0001R\u0001\u0002]\u000692\r[3dW\u0016\u000bX/\u00197t'R\u0014Xo\u0019;ve\u0006dG.\u001f\u000b\u0006Kqkfl\u0018\u0005\u0006\u00152\u0001\r!\f\u0005\u0006\u00192\u0001\r!\f\u0005\u0006\u001d2\u0001\ra\u0014\u0005\bA2\u0001\n\u00111\u0001P\u0003EIwM\\8sK:+H\u000e\\1cS2LG/_\u0001\"G\",7m[#rk\u0006d7o\u0015;sk\u000e$XO]1mYf$C-\u001a4bk2$H\u0005N\u000b\u0002G*\u0012q\nZ\u0016\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\nk:\u001c\u0007.Z2lK\u0012T!A[\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002mO\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DataTypeSuite
extends SparkFunSuite {
    private final Metadata metadata;
    private final StructType structType;

    public void checkDataTypeFromJson(DataType dataType) {
        this.test(new StringBuilder(12).append("from Json - ").append(dataType).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DataType$.MODULE$.fromJson(dataType.json()));
            DataType $org_scalatest_assert_macro_right = dataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
    }

    public void checkDataTypeFromDDL(DataType dataType) {
        this.test(new StringBuilder(11).append("from DDL - ").append(dataType).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType parsed = StructType$.MODULE$.fromDDL(new StringBuilder(2).append("a ").append(dataType.sql()).toString());
            StructType expected = new StructType().add("a", dataType);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(parsed.sameType((DataType)expected), "parsed.sameType(expected)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public StructType structType() {
        return this.structType;
    }

    public void checkDefaultSize(DataType dataType, int expectedDefaultSize) {
        this.test(new StringBuilder(26).append("Check the default size of ").append(dataType).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dataType.defaultSize()));
            int $org_scalatest_assert_macro_right = expectedDefaultSize;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
    }

    public void checkEqualsIgnoreCompatibleNullability(DataType from, DataType to, boolean expected) {
        String testName = new StringBuilder(49).append("equalsIgnoreCompatibleNullability: (from: ").append(from).append(", to: ").append(to).append(")").toString();
        this.test(testName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsIgnoreCompatibleNullability(from, to)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
    }

    public void checkCatalogString(DataType dt) {
        this.test(new StringBuilder(15).append("catalogString: ").append(dt).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DataType dt2 = CatalystSqlParser$.MODULE$.parseDataType(dt.catalogString());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dt);
            DataType $org_scalatest_assert_macro_right = dt2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
    }

    public StructType createStruct(int n) {
        return new StructType((StructField[])Array$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)i -> DataTypeSuite.$anonfun$createStruct$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(StructField.class)));
    }

    public void checkEqualsStructurally(DataType from, DataType to, boolean expected, boolean ignoreNullability) {
        String testName = new StringBuilder(55).append("equalsStructurally: (from: ").append(from).append(", to: ").append(to).append(", ").append("ignoreNullability: ").append(ignoreNullability).append(")").toString();
        this.test(testName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsStructurally(from, to, ignoreNullability)));
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
    }

    public boolean checkEqualsStructurally$default$4() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$new$17(DataType x$18) {
        return x$18 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$18(DataType x$19) {
        return x$19 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(DataType x$20) {
        return x$20 instanceof IntegerType;
    }

    public static final /* synthetic */ boolean $anonfun$new$20(DataType x$21) {
        return x$21 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$21(DataType x$22) {
        return x$22 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$22(DataType x$23) {
        return x$23 instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$new$23(DataType x$24) {
        return x$24 instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$new$24(DataType x$25) {
        return x$25 instanceof IntegerType;
    }

    public static final /* synthetic */ boolean $anonfun$new$25(DataType x$26) {
        return x$26 instanceof LongType;
    }

    public static final /* synthetic */ boolean $anonfun$new$26(DataType x$27) {
        return x$27 instanceof StructType;
    }

    public static final /* synthetic */ boolean $anonfun$new$27(DataType x$28) {
        return x$28 instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(DataType x$29) {
        return x$29 instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$new$29(DataType x$30) {
        return x$30 instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$new$30(DataType x$31) {
        return x$31 instanceof IntegerType;
    }

    public static final /* synthetic */ StructField $anonfun$createStruct$1(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
    }

    public DataTypeSuite() {
        this.test("construct an ArrayType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ArrayType array = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayType((DataType)StringType$.MODULE$, true));
            ArrayType $org_scalatest_assert_macro_right = array;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("construct an MapType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MapType map = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true));
            MapType $org_scalatest_assert_macro_right = map;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("construct with add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$, true).add("b", (DataType)LongType$.MODULE$, false).add("c", (DataType)StringType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        this.test("construct with add from StructField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())).add(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("construct with add from StructField with comments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("a", "int", true, "test1").add("b", (DataType)StringType$.MODULE$, true, "test3").add(new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4")).add(new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_left = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test1");
            StructField $org_scalatest_assert_macro_right = struct.apply("a");
            StructField structField = $org_scalatest_assert_macro_left;
            StructField structField2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structField != null ? !structField.equals(structField2) : structField2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            StructField $org_scalatest_assert_macro_left2 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()).withComment("test3");
            StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
            StructField structField3 = $org_scalatest_assert_macro_left2;
            StructField structField4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structField3 != null ? !structField3.equals(structField4) : structField4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            StructField $org_scalatest_assert_macro_left3 = new StructField("c", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("test4");
            StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
            StructField structField5 = $org_scalatest_assert_macro_left3;
            StructField structField6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structField5 != null ? !structField5.equals(structField6) : structField6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            StructField $org_scalatest_assert_macro_left4 = new StructField("d", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField $org_scalatest_assert_macro_right4 = struct.apply("d");
            StructField structField7 = $org_scalatest_assert_macro_left4;
            StructField structField8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(structField7 != null ? !structField7.equals(structField8) : structField8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            Option $org_scalatest_assert_macro_left5 = struct.apply("c").getComment();
            Option $org_scalatest_assert_macro_right5 = Option$.MODULE$.apply((Object)"test4");
            Option option = $org_scalatest_assert_macro_left5;
            Option option2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Option $org_scalatest_assert_macro_left6 = struct.apply("d").getComment();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("construct with String DataType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType struct = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("a");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("extract fields from a StructType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
            StructField $org_scalatest_assert_macro_right = struct.apply("b");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> struct.apply("e"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            StructField structField5 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            StructType expectedStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(expectedStruct);
            StructType $org_scalatest_assert_macro_right2 = struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d"})));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d", "e", "f"}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("extract field index from a StructType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("a")));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("b")));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> struct.fieldIndex("non_existent"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("fieldsMap returns map of name to StructField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Map mapped = StructType$.MODULE$.fieldsMap(struct.fields());
            scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mapped);
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("fieldNames and names returns field names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(struct.fieldNames());
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(struct.names());
            Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("merge where right contains type conflict", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            StructField structField3 = new StructField("b", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3));
            String message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> left.merge(right), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154))).getMessage();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(message.equals("Failed to merge fields 'b' and 'b'. Failed to merge incompatible data types float and bigint"), "message.equals(\"Failed to merge fields \\'b\\' and \\'b\\'. Failed to merge incompatible data types float and bigint\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("existsRecursively", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$17(x$18))), "struct.existsRecursively(((x$18: org.apache.spark.sql.types.DataType) => x$18.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$18(x$19))), "struct.existsRecursively(((x$19: org.apache.spark.sql.types.DataType) => x$19.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$19(x$20))), "struct.existsRecursively(((x$20: org.apache.spark.sql.types.DataType) => x$20.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            MapType mapType = MapType$.MODULE$.apply((DataType)struct, (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$20(x$21))), "mapType.existsRecursively(((x$21: org.apache.spark.sql.types.DataType) => x$21.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$21(x$22))), "mapType.existsRecursively(((x$22: org.apache.spark.sql.types.DataType) => x$22.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$22(x$23))), "mapType.existsRecursively(((x$23: org.apache.spark.sql.types.DataType) => x$23.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$23(x$24))), "mapType.existsRecursively(((x$24: org.apache.spark.sql.types.DataType) => x$24.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$24(x$25))), "mapType.existsRecursively(((x$25: org.apache.spark.sql.types.DataType) => x$25.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)mapType);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$25(x$26))), "arrayType.existsRecursively(((x$26: org.apache.spark.sql.types.DataType) => x$26.isInstanceOf[org.apache.spark.sql.types.LongType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$26(x$27))), "arrayType.existsRecursively(((x$27: org.apache.spark.sql.types.DataType) => x$27.isInstanceOf[org.apache.spark.sql.types.StructType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$27(x$28))), "arrayType.existsRecursively(((x$28: org.apache.spark.sql.types.DataType) => x$28.isInstanceOf[org.apache.spark.sql.types.StringType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$28(x$29))), "arrayType.existsRecursively(((x$29: org.apache.spark.sql.types.DataType) => x$29.isInstanceOf[org.apache.spark.sql.types.MapType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$29(x$30))), "arrayType.existsRecursively(((x$30: org.apache.spark.sql.types.DataType) => x$30.isInstanceOf[org.apache.spark.sql.types.ArrayType]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)DataTypeSuite.$anonfun$new$30(x$31))), "arrayType.existsRecursively(((x$31: org.apache.spark.sql.types.DataType) => x$31.isInstanceOf[org.apache.spark.sql.types.IntegerType]))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.checkDataTypeFromJson((DataType)NullType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BooleanType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ByteType$.MODULE$);
        this.checkDataTypeFromJson((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)ShortType$.MODULE$);
        this.checkDataTypeFromJson((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)IntegerType$.MODULE$);
        this.checkDataTypeFromJson((DataType)LongType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)LongType$.MODULE$);
        this.checkDataTypeFromJson((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)FloatType$.MODULE$);
        this.checkDataTypeFromJson((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DoubleType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromDDL((DataType)new DecimalType(10, 5));
        this.checkDataTypeFromJson((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromDDL((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeFromJson((DataType)DateType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)DateType$.MODULE$);
        this.checkDataTypeFromJson((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)TimestampType$.MODULE$);
        this.checkDataTypeFromJson((DataType)StringType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)StringType$.MODULE$);
        this.checkDataTypeFromJson((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromDDL((DataType)BinaryType$.MODULE$);
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromDDL((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeFromJson((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromDDL((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.checkDataTypeFromJson((DataType)new CharType(1));
        this.checkDataTypeFromDDL((DataType)new CharType(1));
        this.checkDataTypeFromJson((DataType)new VarcharType(10));
        this.checkDataTypeFromDDL((DataType)new VarcharType(11));
        this.metadata = new MetadataBuilder().putString("name", "age").build();
        this.structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)DoubleType$.MODULE$, false, this.metadata())})));
        this.checkDataTypeFromJson((DataType)this.structType());
        this.checkDataTypeFromDDL((DataType)this.structType());
        this.test("fromJson throws an exception when given type string is invalid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String message;
            String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> DataType$.MODULE$.fromJson("\"abcd\""), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269))).getMessage();
            String $org_scalatest_assert_macro_right = "Failed to convert the JSON string 'abcd' to a data type.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            String $org_scalatest_assert_macro_left2 = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> DataType$.MODULE$.fromJson("{\"abcd\":\"a\"}"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275))).getMessage();
            String $org_scalatest_assert_macro_right2 = "Failed to convert the JSON string '{\"abcd\":\"a\"}' to a data type";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            String $org_scalatest_assert_macro_left3 = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> DataType$.MODULE$.fromJson("{\"fields\": [{\"a\":123}], \"type\": \"struct\"}"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281))).getMessage();
            String $org_scalatest_assert_macro_right3 = "Failed to convert the JSON string '{\"a\":123}' to a field.";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            String $org_scalatest_assert_macro_left4 = message = ((JsonParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> DataType$.MODULE$.fromJson("abcd"), ClassTag$.MODULE$.apply(JsonParseException.class), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288))).getMessage();
            String $org_scalatest_assert_macro_right4 = "Unrecognized token 'abcd'";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.checkDefaultSize((DataType)NullType$.MODULE$, 1);
        this.checkDefaultSize((DataType)BooleanType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ByteType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ShortType$.MODULE$, 2);
        this.checkDefaultSize((DataType)IntegerType$.MODULE$, 4);
        this.checkDefaultSize((DataType)LongType$.MODULE$, 8);
        this.checkDefaultSize((DataType)FloatType$.MODULE$, 4);
        this.checkDefaultSize((DataType)DoubleType$.MODULE$, 8);
        this.checkDefaultSize((DataType)new DecimalType(10, 5), 8);
        this.checkDefaultSize((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), 16);
        this.checkDefaultSize((DataType)DateType$.MODULE$, 4);
        this.checkDefaultSize((DataType)TimestampType$.MODULE$, 8);
        this.checkDefaultSize((DataType)StringType$.MODULE$, 20);
        this.checkDefaultSize((DataType)BinaryType$.MODULE$, 100);
        this.checkDefaultSize((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), 8);
        this.checkDefaultSize((DataType)new ArrayType((DataType)StringType$.MODULE$, false), 20);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), 24);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false), 12);
        this.checkDefaultSize((DataType)this.structType(), 20);
        this.checkDefaultSize((DataType)new CharType(5), 5);
        this.checkDefaultSize((DataType)new CharType(100), 100);
        this.checkDefaultSize((DataType)new VarcharType(5), 5);
        this.checkDefaultSize((DataType)new VarcharType(10), 10);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true);
        StructField structField3 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4)), true);
        StructField structField5 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6)), true);
        StructField structField7 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8)), false);
        StructField structField9 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField10).$colon$colon((Object)structField9)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11)), false);
        this.checkCatalogString((DataType)BooleanType$.MODULE$);
        this.checkCatalogString((DataType)ByteType$.MODULE$);
        this.checkCatalogString((DataType)ShortType$.MODULE$);
        this.checkCatalogString((DataType)IntegerType$.MODULE$);
        this.checkCatalogString((DataType)LongType$.MODULE$);
        this.checkCatalogString((DataType)FloatType$.MODULE$);
        this.checkCatalogString((DataType)DoubleType$.MODULE$);
        this.checkCatalogString((DataType)new DecimalType(10, 5));
        this.checkCatalogString((DataType)BinaryType$.MODULE$);
        this.checkCatalogString((DataType)StringType$.MODULE$);
        this.checkCatalogString((DataType)DateType$.MODULE$);
        this.checkCatalogString((DataType)TimestampType$.MODULE$);
        this.checkCatalogString((DataType)this.createStruct(4));
        this.checkCatalogString((DataType)this.createStruct(40));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        this.checkCatalogString((DataType)ArrayType$.MODULE$.apply((DataType)this.createStruct(40)));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        this.checkCatalogString((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)this.createStruct(40)));
        this.checkEqualsStructurally((DataType)BooleanType$.MODULE$, (DataType)BooleanType$.MODULE$, true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)IntegerType$.MODULE$, (DataType)LongType$.MODULE$, false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), false, this.checkEqualsStructurally$default$4());
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$, false)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, true);
        this.checkEqualsStructurally((DataType)new StructType().add("f1", (DataType)IntegerType$.MODULE$).add("f", (DataType)new StructType().add("f2", (DataType)StringType$.MODULE$)), (DataType)new StructType().add("f2", (DataType)IntegerType$.MODULE$, false).add("g", (DataType)new StructType().add("f1", (DataType)StringType$.MODULE$)), true, true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false, false);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, true);
        this.checkEqualsStructurally((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), (DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false, false);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), true, true);
        this.checkEqualsStructurally((DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true, true);
        this.test("SPARK-25031: MapType should produce current formatted string for complex types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType keyType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            StructType valueType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("c", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("d", DataTypes.IntegerType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            StringUtils.StringConcat stringConcat = new StringUtils.StringConcat(StringUtils.StringConcat$.MODULE$.$lessinit$greater$default$1());
            MapType qual$1 = MapType$.MODULE$.apply((DataType)keyType, (DataType)valueType);
            String x$1 = "";
            StringUtils.StringConcat x$2 = stringConcat;
            int x$3 = qual$1.buildFormattedString$default$3();
            qual$1.buildFormattedString(x$1, x$2, x$3);
            String result = stringConcat.toString();
            String expected = new StringOps(Predef$.MODULE$.augmentString("-- key: struct\n        |    |-- a: integer (nullable = true)\n        |    |-- b: integer (nullable = true)\n        |-- value: struct (valueContainsNull = true)\n        |    |-- c: integer (nullable = true)\n        |    |-- d: integer (nullable = true)\n        |")).stripMargin();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        }, new Position("DataTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
    }
}

