/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.spark.util.kvstore.ArrayKeyIndexType;
import org.apache.spark.util.kvstore.CustomType1;
import org.apache.spark.util.kvstore.KVIndex;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.LevelDB;
import org.apache.spark.util.kvstore.LevelDBIterator;
import org.apache.spark.util.kvstore.UnsupportedStoreVersionException;
import org.iq80.leveldb.DBIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelDBSuite {
    private LevelDB db;
    private File dbpath;

    @After
    public void cleanup() throws Exception {
        if (this.db != null) {
            this.db.close();
        }
        if (this.dbpath != null) {
            FileUtils.deleteQuietly((File)this.dbpath);
        }
    }

    @Before
    public void setup() throws Exception {
        this.dbpath = File.createTempFile("test.", ".ldb");
        this.dbpath.delete();
        this.db = new LevelDB(this.dbpath);
    }

    @Test
    public void testReopenAndVersionCheckDb() throws Exception {
        this.db.close();
        this.db = null;
        Assert.assertTrue((boolean)this.dbpath.exists());
        this.db = new LevelDB(this.dbpath);
        Assert.assertEquals((long)1L, (long)this.db.serializer.deserializeLong(this.db.db().get(LevelDB.STORE_VERSION_KEY)));
        this.db.db().put(LevelDB.STORE_VERSION_KEY, this.db.serializer.serialize(2L));
        this.db.close();
        this.db = null;
        try {
            this.db = new LevelDB(this.dbpath);
            Assert.fail((String)"Should have failed version check.");
        }
        catch (UnsupportedStoreVersionException unsupportedStoreVersionException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectWriteReadDelete() throws Exception {
        CustomType1 t = this.createCustomType1(1);
        try {
            this.db.read(CustomType1.class, (Object)t.key);
            Assert.fail((String)"Expected exception for non-existent object.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.db.write((Object)t);
        Assert.assertEquals((Object)t, (Object)this.db.read(t.getClass(), (Object)t.key));
        Assert.assertEquals((long)1L, (long)this.db.count(t.getClass()));
        this.db.delete(t.getClass(), (Object)t.key);
        try {
            this.db.read(t.getClass(), (Object)t.key);
            Assert.fail((String)"Expected exception for deleted object.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.countKeys(t.getClass()));
    }

    @Test
    public void testMultipleObjectWriteReadDelete() throws Exception {
        CustomType1 t1 = this.createCustomType1(1);
        CustomType1 t2 = this.createCustomType1(2);
        t2.id = t1.id;
        this.db.write((Object)t1);
        this.db.write((Object)t2);
        Assert.assertEquals((Object)t1, (Object)this.db.read(t1.getClass(), (Object)t1.key));
        Assert.assertEquals((Object)t2, (Object)this.db.read(t2.getClass(), (Object)t2.key));
        Assert.assertEquals((long)2L, (long)this.db.count(t1.getClass()));
        Assert.assertEquals((long)2L, (long)this.db.count(t1.getClass(), "id", (Object)t1.id));
        this.db.delete(t1.getClass(), (Object)t1.key);
        Assert.assertEquals((long)1L, (long)this.db.count(t2.getClass(), "id", (Object)t2.id));
        this.db.delete(t2.getClass(), (Object)t2.key);
        Assert.assertEquals((long)0L, (long)this.countKeys(t2.getClass()));
    }

    @Test
    public void testMultipleTypesWriteReadDelete() throws Exception {
        CustomType1 t1 = this.createCustomType1(1);
        IntKeyType t2 = new IntKeyType();
        t2.key = 2;
        t2.id = "2";
        t2.values = Arrays.asList("value1", "value2");
        ArrayKeyIndexType t3 = new ArrayKeyIndexType();
        t3.key = new int[]{42, 84};
        t3.id = new String[]{"id1", "id2"};
        this.db.write((Object)t1);
        this.db.write((Object)t2);
        this.db.write((Object)t3);
        Assert.assertEquals((Object)t1, (Object)this.db.read(t1.getClass(), (Object)t1.key));
        Assert.assertEquals((Object)t2, (Object)this.db.read(t2.getClass(), (Object)t2.key));
        Assert.assertEquals((Object)t3, (Object)this.db.read(t3.getClass(), (Object)t3.key));
        Assert.assertEquals((long)1L, (long)this.db.count(t1.getClass(), "id", (Object)t1.id));
        Assert.assertEquals((long)1L, (long)this.db.count(t2.getClass(), "id", (Object)t2.id));
        Assert.assertEquals((long)1L, (long)this.db.count(t3.getClass(), "id", (Object)t3.id));
        this.db.delete(t1.getClass(), (Object)t1.key);
        Assert.assertEquals((long)0L, (long)this.countKeys(t1.getClass()));
        Assert.assertEquals((long)1L, (long)this.db.count(t2.getClass(), "id", (Object)t2.id));
        Assert.assertEquals((long)1L, (long)this.db.count(t3.getClass(), "id", (Object)t3.id));
        this.db.delete(t2.getClass(), (Object)t2.key);
        Assert.assertEquals((long)0L, (long)this.countKeys(t2.getClass()));
        this.db.delete(t3.getClass(), (Object)t3.key);
        Assert.assertEquals((long)0L, (long)this.countKeys(t3.getClass()));
    }

    @Test
    public void testMetadata() throws Exception {
        Assert.assertNull((Object)this.db.getMetadata(CustomType1.class));
        CustomType1 t = this.createCustomType1(1);
        this.db.setMetadata((Object)t);
        Assert.assertEquals((Object)t, (Object)this.db.getMetadata(CustomType1.class));
        this.db.setMetadata(null);
        Assert.assertNull((Object)this.db.getMetadata(CustomType1.class));
    }

    @Test
    public void testUpdate() throws Exception {
        CustomType1 t = this.createCustomType1(1);
        this.db.write((Object)t);
        t.name = "anotherName";
        this.db.write((Object)t);
        Assert.assertEquals((long)1L, (long)this.db.count(t.getClass()));
        Assert.assertEquals((long)1L, (long)this.db.count(t.getClass(), "name", (Object)"anotherName"));
        Assert.assertEquals((long)0L, (long)this.db.count(t.getClass(), "name", (Object)"name"));
    }

    @Test
    public void testSkip() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.db.write((Object)this.createCustomType1(i));
        }
        KVStoreIterator it = this.db.view(CustomType1.class).closeableIterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.skip(5L));
        Assert.assertEquals((Object)"key5", (Object)((CustomType1)it.next()).key);
        Assert.assertTrue((boolean)it.skip(3L));
        Assert.assertEquals((Object)"key9", (Object)((CustomType1)it.next()).key);
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testNegativeIndexValues() throws Exception {
        List<Integer> expected = Arrays.asList(-100, -50, 0, 50, 100);
        expected.stream().forEach(i -> {
            try {
                this.db.write((Object)this.createCustomType1((int)i));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        List results = StreamSupport.stream(this.db.view(CustomType1.class).index("int").spliterator(), false).map(e -> e.num).collect(Collectors.toList());
        Assert.assertEquals(expected, results);
    }

    private CustomType1 createCustomType1(int i) {
        CustomType1 t = new CustomType1();
        t.key = "key" + i;
        t.id = "id" + i;
        t.name = "name" + i;
        t.num = i;
        t.child = "child" + i;
        return t;
    }

    private int countKeys(Class<?> type) throws Exception {
        byte[] prefix = this.db.getTypeInfo(type).keyPrefix();
        int count = 0;
        DBIterator it = this.db.db().iterator();
        it.seek(prefix);
        while (it.hasNext()) {
            byte[] key = (byte[])((Map.Entry)it.next()).getKey();
            if (!LevelDBIterator.startsWith((byte[])key, (byte[])prefix)) continue;
            ++count;
        }
        return count;
    }

    public static class IntKeyType {
        @KVIndex
        public int key;
        @KVIndex(value="id")
        public String id;
        public List<String> values;

        public boolean equals(Object o) {
            if (o instanceof IntKeyType) {
                IntKeyType other = (IntKeyType)o;
                return this.key == other.key && this.id.equals(other.id) && this.values.equals(other.values);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

