/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.spark.util.kvstore.ArrayKeyIndexType;
import org.apache.spark.util.kvstore.CustomType1;
import org.apache.spark.util.kvstore.CustomType2;
import org.apache.spark.util.kvstore.InMemoryStore;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryStoreSuite {
    @Test
    public void testObjectWriteReadDelete() throws Exception {
        InMemoryStore store = new InMemoryStore();
        CustomType1 t = new CustomType1();
        t.key = "key";
        t.id = "id";
        t.name = "name";
        try {
            store.read(CustomType1.class, (Object)t.key);
            Assert.fail((String)"Expected exception for non-existent object.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        store.write((Object)t);
        Assert.assertEquals((Object)t, (Object)store.read(t.getClass(), (Object)t.key));
        Assert.assertEquals((long)1L, (long)store.count(t.getClass()));
        store.delete(t.getClass(), (Object)t.key);
        try {
            store.read(t.getClass(), (Object)t.key);
            Assert.fail((String)"Expected exception for deleted object.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleObjectWriteReadDelete() throws Exception {
        InMemoryStore store = new InMemoryStore();
        CustomType1 t1 = new CustomType1();
        t1.key = "key1";
        t1.id = "id";
        t1.name = "name1";
        CustomType1 t2 = new CustomType1();
        t2.key = "key2";
        t2.id = "id";
        t2.name = "name2";
        store.write((Object)t1);
        store.write((Object)t2);
        Assert.assertEquals((Object)t1, (Object)store.read(t1.getClass(), (Object)t1.key));
        Assert.assertEquals((Object)t2, (Object)store.read(t2.getClass(), (Object)t2.key));
        Assert.assertEquals((long)2L, (long)store.count(t1.getClass()));
        store.delete(t1.getClass(), (Object)t1.key);
        Assert.assertEquals((Object)t2, (Object)store.read(t2.getClass(), (Object)t2.key));
        store.delete(t2.getClass(), (Object)t2.key);
        try {
            store.read(t2.getClass(), (Object)t2.key);
            Assert.fail((String)"Expected exception for deleted object.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testMetadata() throws Exception {
        InMemoryStore store = new InMemoryStore();
        Assert.assertNull((Object)store.getMetadata(CustomType1.class));
        CustomType1 t = new CustomType1();
        t.id = "id";
        t.name = "name";
        store.setMetadata((Object)t);
        Assert.assertEquals((Object)t, (Object)store.getMetadata(CustomType1.class));
        store.setMetadata(null);
        Assert.assertNull((Object)store.getMetadata(CustomType1.class));
    }

    @Test
    public void testUpdate() throws Exception {
        InMemoryStore store = new InMemoryStore();
        CustomType1 t = new CustomType1();
        t.key = "key";
        t.id = "id";
        t.name = "name";
        store.write((Object)t);
        t.name = "anotherName";
        store.write((Object)t);
        Assert.assertEquals((long)1L, (long)store.count(t.getClass()));
        Assert.assertSame((Object)t, (Object)store.read(t.getClass(), (Object)t.key));
    }

    @Test
    public void testArrayIndices() throws Exception {
        InMemoryStore store = new InMemoryStore();
        ArrayKeyIndexType o = new ArrayKeyIndexType();
        o.key = new int[]{1, 2};
        o.id = new String[]{"3", "4"};
        store.write((Object)o);
        Assert.assertEquals((Object)o, (Object)store.read(ArrayKeyIndexType.class, (Object)o.key));
        Assert.assertEquals((Object)o, store.view(ArrayKeyIndexType.class).index("id").first((Object)o.id).iterator().next());
    }

    @Test
    public void testRemoveAll() throws Exception {
        InMemoryStore store = new InMemoryStore();
        for (int i = 0; i < 2; ++i) {
            int j = 0;
            while (j < 2) {
                ArrayKeyIndexType o = new ArrayKeyIndexType();
                o.key = new int[]{i, j, 0};
                o.id = new String[]{"things"};
                store.write((Object)o);
                o = new ArrayKeyIndexType();
                o.key = new int[]{i, j++, 1};
                o.id = new String[]{"more things"};
                store.write((Object)o);
            }
        }
        ArrayKeyIndexType o = new ArrayKeyIndexType();
        o.key = new int[]{2, 2, 2};
        o.id = new String[]{"things"};
        store.write((Object)o);
        Assert.assertEquals((long)9L, (long)store.count(ArrayKeyIndexType.class));
        assert (!store.removeAllByIndexValues(ArrayKeyIndexType.class, "__main__", (Collection)ImmutableSet.of((Object)new int[]{10, 10, 10}, (Object)new int[]{3, 3, 3})));
        Assert.assertEquals((long)9L, (long)store.count(ArrayKeyIndexType.class));
        assert (store.removeAllByIndexValues(ArrayKeyIndexType.class, "__main__", (Collection)ImmutableSet.of((Object)new int[]{0, 0, 0}, (Object)new int[]{2, 2, 2})));
        Assert.assertEquals((long)7L, (long)store.count(ArrayKeyIndexType.class));
        assert (store.removeAllByIndexValues(ArrayKeyIndexType.class, "id", (Collection)ImmutableSet.of((Object)new String[]{"things"})));
        Assert.assertEquals((long)4L, (long)store.count(ArrayKeyIndexType.class));
        assert (store.removeAllByIndexValues(ArrayKeyIndexType.class, "id", (Collection)ImmutableSet.of((Object)new String[]{"more things"})));
        Assert.assertEquals((long)0L, (long)store.count(ArrayKeyIndexType.class));
    }

    @Test
    public void testBasicIteration() throws Exception {
        InMemoryStore store = new InMemoryStore();
        CustomType1 t1 = new CustomType1();
        t1.key = "1";
        t1.id = "id1";
        t1.name = "name1";
        store.write((Object)t1);
        CustomType1 t2 = new CustomType1();
        t2.key = "2";
        t2.id = "id2";
        t2.name = "name2";
        store.write((Object)t2);
        Assert.assertEquals((Object)t1.id, (Object)((CustomType1)store.view(t1.getClass()).iterator().next()).id);
        Assert.assertEquals((Object)t2.id, (Object)((CustomType1)store.view(t1.getClass()).skip((long)1L).iterator().next()).id);
        Assert.assertEquals((Object)t2.id, (Object)((CustomType1)store.view(t1.getClass()).skip((long)1L).max((long)1L).iterator().next()).id);
        Assert.assertEquals((Object)t1.id, (Object)((CustomType1)store.view(t1.getClass()).first((Object)t1.key).max((long)1L).iterator().next()).id);
        Assert.assertEquals((Object)t2.id, (Object)((CustomType1)store.view(t1.getClass()).first((Object)t2.key).max((long)1L).iterator().next()).id);
        Assert.assertFalse((boolean)store.view(t1.getClass()).first((Object)t2.id).skip(1L).iterator().hasNext());
    }

    @Test
    public void testDeleteParentIndex() throws Exception {
        InMemoryStore store = new InMemoryStore();
        CustomType2 t1 = new CustomType2();
        t1.key = "key1";
        t1.id = "id1";
        t1.parentId = "parentId1";
        store.write((Object)t1);
        CustomType2 t2 = new CustomType2();
        t2.key = "key2";
        t2.id = "id2";
        t2.parentId = "parentId1";
        store.write((Object)t2);
        CustomType2 t3 = new CustomType2();
        t3.key = "key3";
        t3.id = "id1";
        t3.parentId = "parentId2";
        store.write((Object)t3);
        CustomType2 t4 = new CustomType2();
        t4.key = "key4";
        t4.id = "id2";
        t4.parentId = "parentId2";
        store.write((Object)t4);
        Assert.assertEquals((long)4L, (long)store.count(CustomType2.class));
        store.delete(t1.getClass(), (Object)t1.key);
        Assert.assertEquals((long)3L, (long)store.count(CustomType2.class));
        store.delete(t2.getClass(), (Object)t2.key);
        Assert.assertEquals((long)2L, (long)store.count(CustomType2.class));
        store.delete(t3.getClass(), (Object)t3.key);
        Assert.assertEquals((long)1L, (long)store.count(CustomType2.class));
        store.delete(t4.getClass(), (Object)t4.key);
        Assert.assertEquals((long)0L, (long)store.count(CustomType2.class));
    }
}

