/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.ml.feature.PCA;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.Assert;
import org.junit.Test;

public class JavaPCASuite
extends SharedSparkSession {
    @Test
    public void testPCA() {
        List<Vector> points = Arrays.asList(org.apache.spark.ml.linalg.Vectors.sparse((int)5, (int[])new int[]{1, 3}, (double[])new double[]{1.0, 7.0}), org.apache.spark.ml.linalg.Vectors.dense((double)2.0, (double[])new double[]{0.0, 3.0, 4.0, 5.0}), org.apache.spark.ml.linalg.Vectors.dense((double)4.0, (double[])new double[]{0.0, 0.0, 6.0, 7.0}));
        JavaRDD dataRDD = this.jsc.parallelize(points, 2);
        RowMatrix mat = new RowMatrix(dataRDD.map((Function & Serializable)vector -> Vectors.fromML((Vector)vector)).rdd());
        Matrix pc = mat.computePrincipalComponents(3);
        mat.multiply(pc).rows().toJavaRDD();
        JavaRDD expected = mat.multiply(pc).rows().toJavaRDD().map(org.apache.spark.mllib.linalg.Vector::asML);
        JavaRDD featuresExpected = dataRDD.zip((JavaRDDLike)expected).map((Function & Serializable)pair -> {
            VectorPair featuresExpected1 = new VectorPair();
            featuresExpected1.setFeatures((Vector)pair._1());
            featuresExpected1.setExpected((Vector)pair._2());
            return featuresExpected1;
        });
        Dataset df = this.spark.createDataFrame(featuresExpected, VectorPair.class);
        PCAModel pca = new PCA().setInputCol("features").setOutputCol("pca_features").setK(3).fit(df);
        List result = pca.transform(df).select("pca_features", new String[]{"expected"}).toJavaRDD().collect();
        for (Row r : result) {
            Vector calculatedVector = (Vector)r.get(0);
            Vector expectedVector = (Vector)r.get(1);
            for (int i = 0; i < calculatedVector.size(); ++i) {
                Assert.assertEquals((double)calculatedVector.apply(i), (double)expectedVector.apply(i), (double)1.0E-8);
            }
        }
    }

    public static class VectorPair
    implements Serializable {
        private Vector features = org.apache.spark.ml.linalg.Vectors.dense((double)0.0, (double[])new double[0]);
        private Vector expected = org.apache.spark.ml.linalg.Vectors.dense((double)0.0, (double[])new double[0]);

        public void setFeatures(Vector features) {
            this.features = features;
        }

        public Vector getFeatures() {
            return this.features;
        }

        public void setExpected(Vector expected) {
            this.expected = expected;
        }

        public Vector getExpected() {
            return this.expected;
        }
    }
}

