/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\n\u0014\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00048\u0001\u0001\u0006Ia\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0001\u0005\u0001)A\u0005u!)\u0011\t\u0001C\u0005\u0005\u001e)Ql\u0005E\u0001=\u001a)!c\u0005E\u0001?\")Q\u0005\u0003C\u0001M\u001a!q\r\u0003\u0001i\u0011!a'B!A!\u0002\u0013i\u0007\u0002\u00039\u000b\u0005\u0003\u0005\u000b\u0011B9\t\u000b\u0015RA\u0011A<\t\u000fmT!\u0019!C)y\"1QP\u0003Q\u0001\n5DQA \u0006\u0005B}D\u0011\"!\u0002\t\u0003\u0003%I!a\u0002\u0003C\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peN+\u0018\u000e^3\u000b\u0005Q)\u0012AC1hOJ,w-\u0019;pe*\u0011acF\u0001\u0006_B$\u0018.\u001c\u0006\u00031e\t!!\u001c7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001CA\u0011!eI\u0007\u00023%\u0011A%\u0007\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005\u0019\u0012AC5ogR\fgnY3tcU\t1\u0006E\u0002-_Ej\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003eUj\u0011a\r\u0006\u0003i]\tqAZ3biV\u0014X-\u0003\u00027g\tA\u0011J\\:uC:\u001cW-A\u0006j]N$\u0018M\\2fgF\u0002\u0013AC5ogR\fgnY3teU\t!\bE\u0002<}Ej\u0011\u0001\u0010\u0006\u0003{5\n!bY8mY\u0016\u001cG/[8o\u0013\tyDHA\u0002TKF\f1\"\u001b8ti\u0006t7-Z:3A\u0005Y\u0011m]:feR,\u0015/^1m+\r\u0019e\n\u0017\u000b\u0004\t\u001e[\u0006C\u0001\u0017F\u0013\t1UF\u0001\u0003V]&$\b\"\u0002%\u0007\u0001\u0004I\u0015\u0001B1hOF\u0002B\u0001\u000b&M/&\u00111j\u0005\u0002\u001d\t&4g-\u001a:f]RL\u0017M\u00197f\u0019>\u001c8/Q4he\u0016<\u0017\r^8s!\tie\n\u0004\u0001\u0005\u000b=3!\u0019\u0001)\u0003\u0003Q\u000b\"!\u0015+\u0011\u00051\u0012\u0016BA*.\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001L+\n\u0005Yk#aA!osB\u0011Q\n\u0017\u0003\u00063\u001a\u0011\rA\u0017\u0002\u0004\u0003\u001e<\u0017CA)J\u0011\u0015af\u00011\u0001J\u0003\u0011\twm\u001a\u001a\u0002C\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peN+\u0018\u000e^3\u0011\u0005!B1c\u0001\u0005aGB\u0011A&Y\u0005\u0003E6\u0012a!\u00118z%\u00164\u0007C\u0001\u0017e\u0013\t)WF\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001_\u00059!Vm\u001d;BO\u001e\u0014XmZ1u_J\u001c2A\u00031j!\u0011A#*\r6\u0011\u0005-TQ\"\u0001\u0005\u0002\u00179,XNR3biV\u0014Xm\u001d\t\u0003Y9L!a\\\u0017\u0003\u0007%sG/\u0001\u0007d_\u00164g-[2jK:$8\u000f\u0005\u0002sk6\t1O\u0003\u0002u/\u00051A.\u001b8bY\u001eL!A^:\u0003\rY+7\r^8s)\tA(\u0010\u0006\u0002ks\")\u0001/\u0004a\u0001c\")A.\u0004a\u0001[\u0006\u0019A-[7\u0016\u00035\fA\u0001Z5nA\u0005\u0019\u0011\r\u001a3\u0015\u0007)\f\t\u0001\u0003\u0004\u0002\u0004A\u0001\r!M\u0001\tS:\u001cH/\u00198dK\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003'\tAA[1wC&!\u0011qCA\u0007\u0005\u0019y%M[3di\u0002")
public class DifferentiableLossAggregatorSuite
extends SparkFunSuite {
    private final Instance[] instances1 = (Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))});
    private final Seq<Instance> instances2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(0.2, 0.4, Vectors$.MODULE$.dense(0.8, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.5}))), new Instance(0.8, 0.9, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.3}))), new Instance(1.5, 0.2, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2})))}));

    private Instance[] instances1() {
        return this.instances1;
    }

    private Seq<Instance> instances2() {
        return this.instances2;
    }

    private <T, Agg extends DifferentiableLossAggregator<T, Agg>> void assertEqual(DifferentiableLossAggregator<T, Agg> agg1, DifferentiableLossAggregator<T, Agg> agg2) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)agg1.weight()));
        double $org_scalatest_assert_macro_right = agg2.weight();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)agg1.loss()));
        double $org_scalatest_assert_macro_right2 = agg2.loss();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(agg1.gradient());
        Vector $org_scalatest_assert_macro_right3 = agg2.gradient();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
    }

    public static final /* synthetic */ double $anonfun$new$17(Vector coefficients$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double label = instance.label();
        Vector features = instance.features();
        double d = label - BLAS$.MODULE$.dot(features, coefficients$1);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$18(Tuple2 x0$2) {
        double d;
        Instance instance;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                double error = tuple2._1$mcD$sp();
                instance = (Instance)tuple2._2();
                d = error;
                if (instance != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Instance instance2 = instance;
        double d2 = instance2.weight() * d * d / 2.0;
        return d2;
    }

    public static final /* synthetic */ void $anonfun$new$19(Vector expectedGradient$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        BLAS$.MODULE$.axpy(instance.weight() * error, instance.features(), expectedGradient$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public DifferentiableLossAggregatorSuite() {
        this.test("empty aggregator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numFeatures = 5;
            Vector coef = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
            TestAggregator agg = new TestAggregator(numFeatures, coef);
            this.withClue("cannot get loss for empty aggregator", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> agg.loss(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52)));
            return (IllegalArgumentException)this.withClue("cannot get gradient for empty aggregator", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.gradient(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57)));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("aggregator initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numFeatures = 3;
            Vector coef = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
            TestAggregator agg = new TestAggregator(numFeatures, coef);
            agg.add(new Instance(1.0, 0.3, Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)agg.gradient().size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)agg.weight()));
            double $org_scalatest_assert_macro_right2 = 0.3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("merge aggregators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.1}));
            TestAggregator agg1 = new TestAggregator(2, coefficients);
            TestAggregator agg2 = new TestAggregator(2, coefficients);
            TestAggregator aggBadDim = new TestAggregator(1, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
            aggBadDim.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg1.add((Instance)instance));
            this.withClue("cannot merge aggregators with different dimensions", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TestAggregator)agg1.merge(aggBadDim), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82)));
            TestAggregator mergedEmptyOther = (TestAggregator)agg1.merge(agg2);
            this.assertEqual(mergedEmptyOther, agg1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mergedEmptyOther);
            TestAggregator $org_scalatest_assert_macro_right = agg1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            TestAggregator agg3 = new TestAggregator(2, coefficients);
            TestAggregator mergedEmptyThis = (TestAggregator)agg3.merge(agg1);
            this.assertEqual(mergedEmptyThis, agg1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(mergedEmptyThis);
            TestAggregator $org_scalatest_assert_macro_right2 = agg1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.instances2().foreach((Function1 & Serializable & scala.Serializable)instance -> agg2.add((Instance)instance));
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)agg1.loss()), (Object)BoxesRunTime.boxToDouble((double)agg1.weight()), (Object)agg1.gradient());
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double loss1 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double weight1 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            Vector grad1 = (Vector)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)loss1), (Object)BoxesRunTime.boxToDouble((double)weight1), (Object)grad1);
            Tuple3 tuple33 = tuple32;
            double loss12 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double weight12 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            Vector grad12 = (Vector)tuple33._3();
            Tuple3 tuple34 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)agg2.loss()), (Object)BoxesRunTime.boxToDouble((double)agg2.weight()), (Object)agg2.gradient());
            if (tuple34 == null) {
                throw new MatchError((Object)tuple34);
            }
            double loss2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
            double weight2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
            Vector grad2 = (Vector)tuple34._3();
            Tuple3 tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)loss2), (Object)BoxesRunTime.boxToDouble((double)weight2), (Object)grad2);
            Tuple3 tuple36 = tuple35;
            double loss22 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
            double weight22 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
            Vector grad22 = (Vector)tuple36._3();
            TestAggregator merged = (TestAggregator)agg1.merge(agg2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(merged);
            TestAggregator $org_scalatest_assert_macro_right3 = agg1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)merged.loss()));
            double $org_scalatest_assert_macro_right4 = (loss12 * weight12 + loss22 * weight22) / (weight12 + weight22);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)merged.weight()));
            double $org_scalatest_assert_macro_right5 = weight12 + weight22;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            Vector addedGradients = Vectors$.MODULE$.dense((double[])grad12.toArray().clone());
            BLAS$.MODULE$.scal(weight12, addedGradients);
            BLAS$.MODULE$.axpy(weight22, grad22, addedGradients);
            BLAS$.MODULE$.scal(1.0 / (weight12 + weight22), addedGradients);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(merged.gradient());
            Vector $org_scalatest_assert_macro_right6 = addedGradients;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("loss, gradient, weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.1}));
            TestAggregator agg = new TestAggregator(2, coefficients);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add((Instance)instance));
            double[] errors = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)DifferentiableLossAggregatorSuite.$anonfun$new$17(coefficients, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] expectedLoss = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)DifferentiableLossAggregatorSuite.$anonfun$new$18(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Vector expectedGradient = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                DifferentiableLossAggregatorSuite.$anonfun$new$19(expectedGradient, x0$3);
                return BoxedUnit.UNIT;
            });
            BLAS$.MODULE$.scal(1.0 / agg.weight(), expectedGradient);
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.weight()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightSum).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.weight).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weightSum).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expectedLoss)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / weightSum).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(expectedLoss).sum[Double](math.this.Numeric.DoubleIsFractional)./(weightSum)).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    public static class TestAggregator
    implements DifferentiableLossAggregator<Instance, TestAggregator> {
        private final Vector coefficients;
        private final int dim;
        private double weightSum;
        private double lossSum;
        private double[] gradientSumArray;
        private volatile boolean bitmap$0;

        public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
            return DifferentiableLossAggregator.merge$((DifferentiableLossAggregator)this, (DifferentiableLossAggregator)other);
        }

        public Vector gradient() {
            return DifferentiableLossAggregator.gradient$((DifferentiableLossAggregator)this);
        }

        public double weight() {
            return DifferentiableLossAggregator.weight$((DifferentiableLossAggregator)this);
        }

        public double loss() {
            return DifferentiableLossAggregator.loss$((DifferentiableLossAggregator)this);
        }

        public double weightSum() {
            return this.weightSum;
        }

        public void weightSum_$eq(double x$1) {
            this.weightSum = x$1;
        }

        public double lossSum() {
            return this.lossSum;
        }

        public void lossSum_$eq(double x$1) {
            this.lossSum = x$1;
        }

        private double[] gradientSumArray$lzycompute() {
            TestAggregator testAggregator = this;
            synchronized (testAggregator) {
                if (!this.bitmap$0) {
                    this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$((DifferentiableLossAggregator)this);
                    this.bitmap$0 = true;
                }
            }
            return this.gradientSumArray;
        }

        public double[] gradientSumArray() {
            return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
        }

        public int dim() {
            return this.dim;
        }

        public TestAggregator add(Instance instance) {
            double error = instance.label() - BLAS$.MODULE$.dot(this.coefficients, instance.features());
            this.weightSum_$eq(this.weightSum() + instance.weight());
            this.lossSum_$eq(this.lossSum() + instance.weight() * error * error / 2.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.dim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                $this.gradientSumArray()[j] = this.gradientSumArray()[j] + instance.weight() * error * instance.features().apply(j);
            });
            return this;
        }

        public TestAggregator(int numFeatures, Vector coefficients) {
            this.coefficients = coefficients;
            DifferentiableLossAggregator.$init$((DifferentiableLossAggregator)this);
            this.dim = numFeatures;
        }
    }
}

