/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BlockHuberAggregator;
import org.apache.spark.ml.optim.aggregator.HuberAggregator;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0005\n\u0001?!)A\u0006\u0001C\u0001[!I\u0001\u0007\u0001a\u0001\u0002\u0004%\t!\r\u0005\n}\u0001\u0001\r\u00111A\u0005\u0002}B\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001a\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0003\t\u0004\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u0011%q\u0005\u00011A\u0001B\u0003&!\u0007C\u0005Q\u0001\u0001\u0007\t\u0019!C\u0001c!I\u0011\u000b\u0001a\u0001\u0002\u0004%\tA\u0015\u0005\n)\u0002\u0001\r\u0011!Q!\nIB\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0006\"\u0003.\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u00151\b\u0001\"\u0003x\u0005QAUOY3s\u0003\u001e<'/Z4bi>\u00148+^5uK*\u00111\u0003F\u0001\u000bC\u001e<'/Z4bi>\u0014(BA\u000b\u0017\u0003\u0015y\u0007\u000f^5n\u0015\t9\u0002$\u0001\u0002nY*\u0011\u0011DG\u0001\u0006gB\f'o\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001C\u0005\u0005\u0002\"E5\t\u0001$\u0003\u0002$1\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0003Sa\tQ!\u001c7mS\nL!a\u000b\u0014\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012A\f\t\u0003_\u0001i\u0011AE\u0001\nS:\u001cH/\u00198dKN,\u0012A\r\t\u0004gYBT\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0012a\u00024fCR,(/Z\u0005\u0003{i\u0012\u0001\"\u00138ti\u0006t7-Z\u0001\u000eS:\u001cH/\u00198dKN|F%Z9\u0015\u0005\u0001\u001b\u0005CA\u001aB\u0013\t\u0011EG\u0001\u0003V]&$\bb\u0002#\u0004\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0014AC5ogR\fgnY3tA!\u0012Aa\u0012\t\u0003g!K!!\u0013\u001b\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001G5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u0006a\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3`I\u0015\fHC\u0001!N\u0011\u001d!e!!AA\u0002I\n\u0011$\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:fA!\u0012qaR\u0001!S:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,g)\u001b7uKJ,G-\u0001\u0013j]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u00164\u0015\u000e\u001c;fe\u0016$w\fJ3r)\t\u00015\u000bC\u0004E\u0013\u0005\u0005\t\u0019\u0001\u001a\u0002C%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014XMR5mi\u0016\u0014X\r\u001a\u0011)\u0005)9\u0015!F:uC:$\u0017M\u001d3ju\u0016$\u0017J\\:uC:\u001cWm]\u0001\u001agR\fg\u000eZ1sI&TX\rZ%ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002A3\"9A\tDA\u0001\u0002\u0004\u0011\u0014AF:uC:$\u0017M\u001d3ju\u0016$\u0017J\\:uC:\u001cWm\u001d\u0011)\u000559\u0015!\u00032fM>\u0014X-\u00117m)\u0005\u0001\u0015\u0001E4fi:+w/Q4he\u0016<\u0017\r^8s)\u0015\u00017\r\u001a7r!\ty\u0013-\u0003\u0002c%\ty\u0001*\u001e2fe\u0006;wM]3hCR|'\u000fC\u00031\u001f\u0001\u0007!\u0007C\u0003f\u001f\u0001\u0007a-\u0001\u0006qCJ\fW.\u001a;feN\u0004\"a\u001a6\u000e\u0003!T!!\u001b\f\u0002\r1Lg.\u00197h\u0013\tY\u0007N\u0001\u0004WK\u000e$xN\u001d\u0005\u0006[>\u0001\rA\\\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003g=L!\u0001\u001d\u001b\u0003\u000f\t{w\u000e\\3b]\")!o\u0004a\u0001g\u00069Q\r]:jY>t\u0007CA\u001au\u0013\t)HG\u0001\u0004E_V\u0014G.Z\u0001\u0016O\u0016$h*Z<CY>\u001c7.Q4he\u0016<\u0017\r^8s)\u0011A8\u0010`?\u0011\u0005=J\u0018B\u0001>\u0013\u0005Q\u0011En\\2l\u0011V\u0014WM]!hOJ,w-\u0019;pe\")Q\r\u0005a\u0001M\")Q\u000e\u0005a\u0001]\")!\u000f\u0005a\u0001g\u0002")
public class HuberAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] standardizedInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] standardizedInstances() {
        return this.standardizedInstances;
    }

    public void standardizedInstances_$eq(Instance[] x$1) {
        this.standardizedInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.standardizedInstances_$eq(this.standardize(this.instances()));
    }

    private HuberAggregator getNewAggregator(Instance[] instances, Vector parameters, boolean fitIntercept, double epsilon) {
        SummarizerBuffer featuresSummarizer;
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
        double[] featuresStd = featuresSummarizer2.std().toArray();
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcParameters = this.spark().sparkContext().broadcast((Object)parameters, ClassTag$.MODULE$.apply(Vector.class));
        return new HuberAggregator(fitIntercept, epsilon, bcFeaturesStd, bcParameters);
    }

    private BlockHuberAggregator getNewBlockAggregator(Vector parameters, boolean fitIntercept, double epsilon) {
        Broadcast bcParameters = this.spark().sparkContext().broadcast((Object)parameters, ClassTag$.MODULE$.apply(Vector.class));
        return new BlockHuberAggregator(fitIntercept, epsilon, bcParameters);
    }

    private final void testImplicits$lzycompute$1() {
        HuberAggregatorSuite huberAggregatorSuite = this;
        synchronized (huberAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$14(double[] stdCoef$1, double intercept$1, double sigma$1, double epsilon$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double label = instance.label();
        double weight = instance.weight();
        Vector features = instance.features();
        double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$1), features) + intercept$1;
        double linearLoss = label - margin;
        double d = package$.MODULE$.abs(linearLoss) <= sigma$1 * epsilon$1 ? 0.5 * weight * (sigma$1 + package$.MODULE$.pow(linearLoss, 2.0) / sigma$1) : 0.5 * weight * (sigma$1 + 2.0 * epsilon$1 * package$.MODULE$.abs(linearLoss) - sigma$1 * epsilon$1 * epsilon$1);
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$15(double[] stdCoef$1, double intercept$1, double sigma$1, double epsilon$1, double[] gradientCoef$1, double[] featuresStd$1, Instance x0$2) {
        BoxedUnit boxedUnit;
        Instance instance = x0$2;
        if (instance != null) {
            double label = instance.label();
            double weight = instance.weight();
            Vector features = instance.features();
            double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$1), features) + intercept$1;
            double linearLoss = label - margin;
            if (package$.MODULE$.abs(linearLoss) <= sigma$1 * epsilon$1) {
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + -1.0 * weight * (linearLoss / sigma$1) * (features.apply(i) / featuresStd$1[i]);
                });
                gradientCoef$1[2] = gradientCoef$1[2] + -1.0 * weight * (linearLoss / sigma$1);
                gradientCoef$1[3] = gradientCoef$1[3] + 0.5 * weight * (1.0 - package$.MODULE$.pow(linearLoss / sigma$1, 2.0));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                double sign = linearLoss >= 0.0 ? -1.0 : 1.0;
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + weight * sign * epsilon$1 * (features.apply(i) / featuresStd$1[i]);
                });
                gradientCoef$1[2] = gradientCoef$1[2] + weight * sign * epsilon$1;
                gradientCoef$1[3] = gradientCoef$1[3] + 0.5 * weight * (1.0 - epsilon$1 * epsilon$1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final void validateGradient$1(Vector grad, Vector gradFiltered) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)grad.apply(0)));
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(grad.apply(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gradFiltered.apply(0)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(grad.apply(1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(gradFiltered.apply(0)).relTol(0.01))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    public HuberAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method should check input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            HuberAggregator agg = this.getNewAggregator(this.instances(), parameters, true, 1.35);
            return (IllegalArgumentException)this.withClue("HuberAggregator features dimension must match parameters dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79)));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            HuberAggregator agg = this.getNewAggregator(this.instances(), parameters, true, 1.35);
            return (IllegalArgumentException)this.withClue("HuberAggregator does not support negative instance weights.", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89)));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector paramWithIntercept = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            Vector paramWithoutIntercept = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 4.0}));
            HuberAggregator aggIntercept = this.getNewAggregator(this.instances(), paramWithIntercept, true, 1.35);
            HuberAggregator aggNoIntercept = this.getNewAggregator(this.instances(), paramWithoutIntercept, false, 1.35);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("check correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SummarizerBuffer featuresSummarizer;
            int x$22;
            WrappedArray x$12;
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            int numFeatures = 2;
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$22 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
            double[] featuresStd = featuresSummarizer2.std().toArray();
            double epsilon = 1.35;
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            HuberAggregator agg = this.getNewAggregator(this.instances(), parameters, true, epsilon);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] coefficients = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(parameters.toArray())).slice(0, 2);
            double intercept = parameters.apply(2);
            double sigma = parameters.apply(3);
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefficients)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefficients[i] / featuresStd[i], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            double lossSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)HuberAggregatorSuite.$anonfun$new$14(stdCoef, intercept, sigma, epsilon, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = lossSum / weightSum;
            double[] gradientCoef = new double[numFeatures + 2];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HuberAggregatorSuite.$anonfun$new$15(stdCoef, intercept, sigma, epsilon, gradientCoef, featuresStd, x0$2);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.standardizedInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceBlock[][]{blocks1, blocks2}))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BlockHuberAggregator blockAgg = this.getNewBlockAggregator(parameters, true, epsilon);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> blockAgg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(blockAgg.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(blockAgg.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(blockAgg.gradient()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(blockAgg.gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                });
            });
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Vector parameters = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
            Vector parametersFiltered = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
            HuberAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), parameters, true, 1.35);
            HuberAggregator aggConstantFeatureFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), parametersFiltered, true, 1.35);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeature.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureFiltered.add(instance));
            this.validateGradient$1(aggConstantFeature.gradient(), aggConstantFeatureFiltered.gradient());
        }, new Position("HuberAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
    }
}

