/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BlockLeastSquaresAggregator;
import org.apache.spark.ml.optim.aggregator.LeastSquaresAggregator;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0005\n\u0001?!)A\u0006\u0001C\u0001[!I\u0001\u0007\u0001a\u0001\u0002\u0004%\t!\r\u0005\n}\u0001\u0001\r\u00111A\u0005\u0002}B\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001a\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0003\t\u0004\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u0011%q\u0005\u00011A\u0001B\u0003&!\u0007C\u0005Q\u0001\u0001\u0007\t\u0019!C\u0001c!I\u0011\u000b\u0001a\u0001\u0002\u0004%\tA\u0015\u0005\n)\u0002\u0001\r\u0011!Q!\nIB\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0006\"\u0003.\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u0015\t\b\u0001\"\u0003s\u0005maU-Y:u'F,\u0018M]3t\u0003\u001e<'/Z4bi>\u00148+^5uK*\u00111\u0003F\u0001\u000bC\u001e<'/Z4bi>\u0014(BA\u000b\u0017\u0003\u0015y\u0007\u000f^5n\u0015\t9\u0002$\u0001\u0002nY*\u0011\u0011DG\u0001\u0006gB\f'o\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001C\u0005\u0005\u0002\"E5\t\u0001$\u0003\u0002$1\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0003Sa\tQ!\u001c7mS\nL!a\u000b\u0014\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012A\f\t\u0003_\u0001i\u0011AE\u0001\nS:\u001cH/\u00198dKN,\u0012A\r\t\u0004gYBT\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0012a\u00024fCR,(/Z\u0005\u0003{i\u0012\u0001\"\u00138ti\u0006t7-Z\u0001\u000eS:\u001cH/\u00198dKN|F%Z9\u0015\u0005\u0001\u001b\u0005CA\u001aB\u0013\t\u0011EG\u0001\u0003V]&$\bb\u0002#\u0004\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0014AC5ogR\fgnY3tA!\u0012Aa\u0012\t\u0003g!K!!\u0013\u001b\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001G5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u0006a\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3`I\u0015\fHC\u0001!N\u0011\u001d!e!!AA\u0002I\n\u0011$\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:fA!\u0012qaR\u0001\u0017S:\u001cH/\u00198dKN\u001cuN\\:uC:$H*\u00192fY\u0006Q\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;MC\n,Gn\u0018\u0013fcR\u0011\u0001i\u0015\u0005\b\t&\t\t\u00111\u00013\u0003]Ign\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e'bE\u0016d\u0007\u0005\u000b\u0002\u000b\u000f\u0006)2\u000f^1oI\u0006\u0014H-\u001b>fI&s7\u000f^1oG\u0016\u001c\u0018!G:uC:$\u0017M\u001d3ju\u0016$\u0017J\\:uC:\u001cWm]0%KF$\"\u0001Q-\t\u000f\u0011c\u0011\u0011!a\u0001e\u000512\u000f^1oI\u0006\u0014H-\u001b>fI&s7\u000f^1oG\u0016\u001c\b\u0005\u000b\u0002\u000e\u000f\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u0001\u0006\u0001r-\u001a;OK^\fum\u001a:fO\u0006$xN\u001d\u000b\u0005A\u000e$G\u000e\u0005\u00020C&\u0011!M\u0005\u0002\u0017\u0019\u0016\f7\u000f^*rk\u0006\u0014Xm]!hOJ,w-\u0019;pe\")\u0001g\u0004a\u0001e!)Qm\u0004a\u0001M\u0006a1m\\3gM&\u001c\u0017.\u001a8ugB\u0011qM[\u0007\u0002Q*\u0011\u0011NF\u0001\u0007Y&t\u0017\r\\4\n\u0005-D'A\u0002,fGR|'\u000fC\u0003n\u001f\u0001\u0007a.\u0001\u0007gSRLe\u000e^3sG\u0016\u0004H\u000f\u0005\u00024_&\u0011\u0001\u000f\u000e\u0002\b\u0005>|G.Z1o\u0003U9W\r\u001e(fo\ncwnY6BO\u001e\u0014XmZ1u_J$Ba\u001d<xqB\u0011q\u0006^\u0005\u0003kJ\u00111D\u00117pG.dU-Y:u'F,\u0018M]3t\u0003\u001e<'/Z4bi>\u0014\b\"\u0002\u0019\u0011\u0001\u0004\u0011\u0004\"B3\u0011\u0001\u00041\u0007\"B7\u0011\u0001\u0004q\u0007")
public class LeastSquaresAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantLabel;
    private transient Instance[] standardizedInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantLabel() {
        return this.instancesConstantLabel;
    }

    public void instancesConstantLabel_$eq(Instance[] x$1) {
        this.instancesConstantLabel = x$1;
    }

    public Instance[] standardizedInstances() {
        return this.standardizedInstances;
    }

    public void standardizedInstances_$eq(Instance[] x$1) {
        this.standardizedInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantLabel_$eq((Instance[])((Object[])new Instance[]{new Instance(1.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.standardizedInstances_$eq(this.standardize(this.instances()));
    }

    private LeastSquaresAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer ySummarizer = (SummarizerBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
        SummarizerBuffer ySummarizer2 = (SummarizerBuffer)tuple23._2();
        double yStd = ySummarizer2.std().apply(0);
        double yMean = ySummarizer2.mean().apply(0);
        double[] featuresStd = featuresSummarizer2.std().toArray();
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Vector featuresMean = featuresSummarizer2.mean();
        Broadcast bcFeaturesMean = this.spark().sparkContext().broadcast((Object)featuresMean.toArray(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new LeastSquaresAggregator(yStd, yMean, fitIntercept, bcFeaturesStd, bcFeaturesMean, bcCoefficients);
    }

    private BlockLeastSquaresAggregator getNewBlockAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer ySummarizer = (SummarizerBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
        SummarizerBuffer ySummarizer2 = (SummarizerBuffer)tuple23._2();
        double yStd = ySummarizer2.std().apply(0);
        double yMean = ySummarizer2.mean().apply(0);
        double[] featuresStd = featuresSummarizer2.std().toArray();
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Vector featuresMean = featuresSummarizer2.mean();
        Broadcast bcFeaturesMean = this.spark().sparkContext().broadcast((Object)featuresMean.toArray(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new BlockLeastSquaresAggregator(yStd, yMean, fitIntercept, bcFeaturesStd, bcFeaturesMean, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        LeastSquaresAggregatorSuite leastSquaresAggregatorSuite = this;
        synchronized (leastSquaresAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$12(int numFeatures$1, double[] featuresMean$1, double[] featuresStd$1, double yMean$1, double yStd$1, Vector coefficients$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        Vector f = instance.features();
        double[] scaledFeatures = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> (f.toArray()[j] - featuresMean$1[j]) / featuresStd$1[j], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double scaledLabel = (l - yMean$1) / yStd$1;
        double d = BLAS$.MODULE$.dot(coefficients$1, Vectors$.MODULE$.dense(scaledFeatures)) - scaledLabel;
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$14(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        double d = instance.weight() * error * error / 2.0;
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$15(int numFeatures$1, double[] featuresStd$1, Vector expectedGradient$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        double[] scaledFeatures = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> instance.weight() * instance.features().toArray()[j] / featuresStd$1[j], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        BLAS$.MODULE$.axpy(error, Vectors$.MODULE$.dense(scaledFeatures), expectedGradient$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LeastSquaresAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
            return (IllegalArgumentException)this.withClue("LeastSquaresAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
            return (IllegalArgumentException)this.withClue("LeastSquaresAggregator does not support negative instance weights.", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103)));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator aggIntercept = this.getNewAggregator(this.instances(), coefficients, true);
            LeastSquaresAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefficients, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("check correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$2;
            WrappedArray x$1;
            Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            int numFeatures = coefficients.size();
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer ySummarizer = (SummarizerBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            Tuple2 tuple23 = tuple22;
            SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
            SummarizerBuffer ySummarizer2 = (SummarizerBuffer)tuple23._2();
            double[] featuresStd = featuresSummarizer2.std().toArray();
            double[] featuresMean = featuresSummarizer2.mean().toArray();
            double yStd = ySummarizer2.std().apply(0);
            double yMean = ySummarizer2.mean().apply(0);
            LeastSquaresAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] errors = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LeastSquaresAggregatorSuite.$anonfun$new$12(numFeatures, featuresMean, featuresStd, yMean, yStd, coefficients, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] expectedLoss = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)LeastSquaresAggregatorSuite.$anonfun$new$14(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Vector expectedGradient = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                LeastSquaresAggregatorSuite.$anonfun$new$15(numFeatures, featuresStd, expectedGradient, x0$3);
                return BoxedUnit.UNIT;
            });
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            BLAS$.MODULE$.scal(1.0 / weightSum, expectedGradient);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expectedLoss)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / weightSum).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(expectedLoss).sum[Double](math.this.Numeric.DoubleIsFractional)./(weightSum)).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.standardizedInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceBlock[][]{blocks1, blocks2}))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BlockLeastSquaresAggregator blockAgg = this.getNewBlockAggregator(this.instances(), coefficients, true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> blockAgg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(blockAgg.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(blockAgg.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(blockAgg.gradient()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(blockAgg.gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
                });
            });
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), coefficients, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeature.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)aggConstantFeature.gradient().apply(0)));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            return (IllegalArgumentException)this.withClue("LeastSquaresAggregator does not support zero standard deviation of the label", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getNewAggregator(this.instancesConstantLabel(), coefficients, true), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193)));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
    }
}

