/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BlockLogisticAggregator;
import org.apache.spark.ml.optim.aggregator.LogisticAggregator;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0005\n\u0001?!)A\u0006\u0001C\u0001[!I\u0001\u0007\u0001a\u0001\u0002\u0004%\t!\r\u0005\n}\u0001\u0001\r\u00111A\u0005\u0002}B\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001a\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0003\t\u0004\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u0011%q\u0005\u00011A\u0001B\u0003&!\u0007C\u0005Q\u0001\u0001\u0007\t\u0019!C\u0001c!I\u0011\u000b\u0001a\u0001\u0002\u0004%\tA\u0015\u0005\n)\u0002\u0001\r\u0011!Q!\nIB\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0006\"\u0003.\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u0015\u0019\b\u0001\"\u0003u\u0005]aunZ5ti&\u001c\u0017iZ4sK\u001e\fGo\u001c:Tk&$XM\u0003\u0002\u0014)\u0005Q\u0011mZ4sK\u001e\fGo\u001c:\u000b\u0005U1\u0012!B8qi&l'BA\f\u0019\u0003\tiGN\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0011%!\t\t#%D\u0001\u0019\u0013\t\u0019\u0003DA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003K)j\u0011A\n\u0006\u0003O!\nA!\u001e;jY*\u0011\u0011\u0006G\u0001\u0006[2d\u0017NY\u0005\u0003W\u0019\u0012Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002%\u0005I\u0011N\\:uC:\u001cWm]\u000b\u0002eA\u00191G\u000e\u001d\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012Q!\u0011:sCf\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\f\u0002\u000f\u0019,\u0017\r^;sK&\u0011QH\u000f\u0002\t\u0013:\u001cH/\u00198dK\u0006i\u0011N\\:uC:\u001cWm]0%KF$\"\u0001Q\"\u0011\u0005M\n\u0015B\u0001\"5\u0005\u0011)f.\u001b;\t\u000f\u0011\u001b\u0011\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\u0002\u0015%t7\u000f^1oG\u0016\u001c\b\u0005\u000b\u0002\u0005\u000fB\u00111\u0007S\u0005\u0003\u0013R\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u00021%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014X-\u0001\u000fj]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u0016|F%Z9\u0015\u0005\u0001k\u0005b\u0002#\u0007\u0003\u0003\u0005\rAM\u0001\u001aS:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,\u0007\u0005\u000b\u0002\b\u000f\u0006\u0001\u0013N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3GS2$XM]3e\u0003\u0011Jgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e$fCR,(/\u001a$jYR,'/\u001a3`I\u0015\fHC\u0001!T\u0011\u001d!\u0015\"!AA\u0002I\n\u0011%\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:f\r&dG/\u001a:fI\u0002B#AC$\u0002+M$\u0018M\u001c3be\u0012L'0\u001a3J]N$\u0018M\\2fg\u0006I2\u000f^1oI\u0006\u0014H-\u001b>fI&s7\u000f^1oG\u0016\u001cx\fJ3r)\t\u0001\u0015\fC\u0004E\u0019\u0005\u0005\t\u0019\u0001\u001a\u0002-M$\u0018M\u001c3be\u0012L'0\u001a3J]N$\u0018M\\2fg\u0002B#!D$\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001!\u0002!\u001d,GOT3x\u0003\u001e<'/Z4bi>\u0014H#\u00021dI2\f\bCA\u0018b\u0013\t\u0011'C\u0001\nM_\u001eL7\u000f^5d\u0003\u001e<'/Z4bi>\u0014\b\"\u0002\u0019\u0010\u0001\u0004\u0011\u0004\"B3\u0010\u0001\u00041\u0017\u0001D2pK\u001a4\u0017nY5f]R\u001c\bCA4k\u001b\u0005A'BA5\u0017\u0003\u0019a\u0017N\\1mO&\u00111\u000e\u001b\u0002\u0007-\u0016\u001cGo\u001c:\t\u000b5|\u0001\u0019\u00018\u0002\u0019\u0019LG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005Mz\u0017B\u000195\u0005\u001d\u0011un\u001c7fC:DQA]\bA\u00029\fQ\"[:Nk2$\u0018N\\8nS\u0006d\u0017!F4fi:+wO\u00117pG.\fum\u001a:fO\u0006$xN\u001d\u000b\u0006kbL(p\u001f\t\u0003_YL!a\u001e\n\u0003/\tcwnY6M_\u001eL7\u000f^5d\u0003\u001e<'/Z4bi>\u0014\b\"\u0002\u0019\u0011\u0001\u0004\u0011\u0004\"B3\u0011\u0001\u00041\u0007\"B7\u0011\u0001\u0004q\u0007\"\u0002?\u0011\u0001\u0004q\u0017aC7vYRLgn\\7jC2\u0004")
public class LogisticAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] standardizedInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] standardizedInstances() {
        return this.standardizedInstances;
    }

    public void standardizedInstances_$eq(Instance[] x$1) {
        this.standardizedInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.standardizedInstances_$eq(this.standardize(this.instances()));
    }

    private LogisticAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept, boolean isMultinomial) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        MultiClassSummarizer ySummarizer = (MultiClassSummarizer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
        MultiClassSummarizer ySummarizer2 = (MultiClassSummarizer)tuple23._2();
        int numClasses = ySummarizer2.histogram().length;
        double[] featuresStd = featuresSummarizer2.std().toArray();
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new LogisticAggregator(bcFeaturesStd, numClasses, fitIntercept, isMultinomial, bcCoefficients);
    }

    private BlockLogisticAggregator getNewBlockAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept, boolean multinomial) {
        MultiClassSummarizer ySummarizer;
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MultiClassSummarizer multiClassSummarizer = ySummarizer = (MultiClassSummarizer)tuple2._2();
        MultiClassSummarizer ySummarizer2 = multiClassSummarizer;
        int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances)).head()).features().size();
        int numClasses = ySummarizer2.histogram().length;
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new BlockLogisticAggregator(numFeatures, numClasses, fitIntercept, multinomial, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        LogisticAggregatorSuite logisticAggregatorSuite = this;
        synchronized (logisticAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$14(Instance x$3) {
        return x$3.label() < 2.0;
    }

    public static final /* synthetic */ double $anonfun$new$25(Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double l = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        DenseVector p = (DenseVector)tuple3._3();
        double d = w * p.apply((int)l);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$26(Tuple3 x0$3) {
        Tuple3 tuple3 = x0$3;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        DenseVector p = (DenseVector)tuple3._3();
        double d = w * package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$28(Vector intercepts$1, int numClasses$1, int numFeatures$1, double[] stdCoef$1, double[] gradientCoef$1, double[] featuresStd$1, double[] gradientIntercept$1, Instance x0$4) {
        Instance instance = x0$4;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        double w = instance.weight();
        Vector f = instance.features();
        DenseVector margin = intercepts$1.copy().toDense();
        BLAS$.MODULE$.gemv(1.0, Matrices$.MODULE$.dense(numClasses$1, numFeatures$1, stdCoef$1), f, 1.0, margin);
        double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margin.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double fStd = f.apply(i / numClasses$1) / featuresStd$1[i / numClasses$1];
            int cidx = i % numClasses$1;
            if (cidx == (int)l) {
                gradientCoef$1[i] = gradientCoef$1[i] - w * fStd;
            }
            gradientCoef$1[i] = gradientCoef$1[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum * fStd;
        });
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int cidx = i % numClasses$1;
            if (cidx == (int)l) {
                gradientIntercept$1[i] = gradientIntercept$1[i] - w;
            }
            gradientIntercept$1[i] = gradientIntercept$1[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$new$43(double[] stdCoef$2, double intercept$1, Instance x0$5) {
        Instance instance = x0$5;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        double w = instance.weight();
        Vector f = instance.features();
        double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$2), f) + intercept$1;
        double prob = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
        double d = -w * l * package$.MODULE$.log(prob) - w * (1.0 - l) * package$.MODULE$.log1p(-prob);
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$44(double[] coefArray$2, double intercept$1, double[] gradientCoef$2, double[] featuresStd$2, DoubleRef gradientIntercept$2, Instance x0$6) {
        Instance instance = x0$6;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double margin = BLAS$.MODULE$.dot(f, Vectors$.MODULE$.dense(coefArray$2)) + intercept$1;
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                gradientCoef$2[i] = gradientCoef$2[i] + w * (1.0 / (1.0 + package$.MODULE$.exp(-margin)) - l) * f.apply(i) / featuresStd$2[i];
            });
            gradientIntercept$2.elem += w * (1.0 / (1.0 + package$.MODULE$.exp(-margin)) - l);
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Assertion $anonfun$new$57(LogisticAggregatorSuite $this, Vector grad$1, int numCoefficientSets$1, Vector gradFiltered$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)grad$1.apply(i)));
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        double $org_scalatest_assert_macro_left2 = grad$1.apply(numCoefficientSets$1 + i);
        double $org_scalatest_assert_macro_right2 = gradFiltered$1.apply(i);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
    }

    private final void validateGradient$1(Vector grad, Vector gradFiltered, int numCoefficientSets) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numCoefficientSets).foreach((Function1 & Serializable & scala.Serializable)i -> LogisticAggregatorSuite.$anonfun$new$57(this, grad, numCoefficientSets, gradFiltered, BoxesRunTime.unboxToInt((Object)i)));
    }

    public LogisticAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            LogisticAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            return (IllegalArgumentException)this.withClue("LogisticAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88)));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            LogisticAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            return (IllegalArgumentException)this.withClue("LogisticAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100)));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("check sizes multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numClasses * (numFeatures + 1), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numClasses * numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            LogisticAggregator aggIntercept = this.getNewAggregator(this.instances(), coefWithIntercept, true, true);
            LogisticAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefWithoutIntercept, false, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = (numFeatures + 1) * numClasses;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures * numClasses;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("check sizes binomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            Instance[] binaryInstances = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogisticAggregatorSuite.$anonfun$new$14(x$3)));
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).head()).features().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures + 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            LogisticAggregator aggIntercept = this.getNewAggregator(binaryInstances, coefWithIntercept, true, false);
            LogisticAggregator aggNoIntercept = this.getNewAggregator(binaryInstances, coefWithoutIntercept, false, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = numFeatures + 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("check correctness multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$2;
            WrappedArray x$1;
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            Vector intercepts = Vectors$.MODULE$.dense(interceptArray);
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            MultiClassSummarizer ySummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            Tuple2 tuple23 = tuple22;
            SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
            MultiClassSummarizer ySummarizer2 = (MultiClassSummarizer)tuple23._2();
            double[] featuresStd = featuresSummarizer2.std().toArray();
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            LogisticAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd[i / numClasses], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            Tuple3[] linearPredictors = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double l = instance.label();
                double w = instance.weight();
                Vector f = instance.features();
                DenseVector result = intercepts.copy().toDense();
                BLAS$.MODULE$.gemv(1.0, Matrices$.MODULE$.dense(numClasses, numFeatures, stdCoef), f, 1.0, result);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)result);
                return tuple3;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            double sumLinear = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)LogisticAggregatorSuite.$anonfun$new$25(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sumLogs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)LogisticAggregatorSuite.$anonfun$new$26(x0$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = (sumLogs - sumLinear) / weightSum;
            double[] gradientCoef = new double[numFeatures * numClasses];
            double[] gradientIntercept = new double[numClasses];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                LogisticAggregatorSuite.$anonfun$new$28(intercepts, numClasses, numFeatures, stdCoef, gradientCoef, featuresStd, gradientIntercept, x0$4);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$7 -> x$7 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.standardizedInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceBlock[][]{blocks1, blocks2}))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BlockLogisticAggregator blockAgg = this.getNewBlockAggregator(this.standardizedInstances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> blockAgg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(blockAgg.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(blockAgg.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(blockAgg.gradient()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(blockAgg.gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
                });
            });
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("check correctness binomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SummarizerBuffer featuresSummarizer;
            int x$4;
            WrappedArray x$3;
            Instance[] binaryInstances = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)instance -> instance.label() <= 1.0 ? instance : new Instance(0.0, instance.weight(), instance.features()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            double[] coefArray = new double[]{1.0, 2.0};
            double intercept = 1.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).head()).features().size();
            SparkContext qual$2 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$2.parallelize((Seq)(x$3 = Predef$.MODULE$.wrapRefArray((Object[])binaryInstances)), x$4 = qual$2.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
            double[] featuresStd = featuresSummarizer2.std().toArray();
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            LogisticAggregator agg = this.getNewAggregator(binaryInstances, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd[i], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            double lossSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)LogisticAggregatorSuite.$anonfun$new$43(stdCoef, intercept, x0$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = lossSum / weightSum;
            double[] gradientCoef = new double[numFeatures];
            DoubleRef gradientIntercept = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                LogisticAggregatorSuite.$anonfun$new$44(coefArray, intercept, gradientCoef, featuresStd, gradientIntercept, x0$6);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{gradientIntercept.elem})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$9 -> x$9 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(0.01))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.standardize(binaryInstances))).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceBlock[][]{blocks1, blocks2}))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BlockLogisticAggregator blockAgg = this.getNewBlockAggregator(binaryInstances, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> blockAgg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(blockAgg.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(blockAgg.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(blockAgg.gradient()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(blockAgg.gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
                });
            });
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instance[] binaryInstances = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeature())).map((Function1 & Serializable & scala.Serializable)instance -> instance.label() <= 1.0 ? instance : new Instance(0.0, instance.weight(), instance.features()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            Instance[] binaryInstancesFiltered = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).map((Function1 & Serializable & scala.Serializable)instance -> instance.label() <= 1.0 ? instance : new Instance(0.0, instance.weight(), instance.features()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] coefArrayFiltered = new double[]{3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            LogisticAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            LogisticAggregator aggConstantFeatureFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArrayFiltered)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeature())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeature.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureFiltered.add(instance));
            this.validateGradient$1(aggConstantFeature.gradient(), aggConstantFeatureFiltered.gradient(), 3);
            double[] binaryCoefArray = new double[]{1.0, 2.0};
            double[] binaryCoefArrayFiltered = new double[]{2.0};
            double intercept = 1.0;
            LogisticAggregator aggConstantFeatureBinary = this.getNewAggregator(binaryInstances, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(binaryCoefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
            LogisticAggregator aggConstantFeatureBinaryFiltered = this.getNewAggregator(binaryInstancesFiltered, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(binaryCoefArrayFiltered)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureBinary.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstancesFiltered)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureBinaryFiltered.add(instance));
            this.validateGradient$1(aggConstantFeatureBinary.gradient(), aggConstantFeatureBinaryFiltered.gradient(), 1);
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
    }
}

