/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0003\u0006\u0001+!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003B\u0002\u001a\u0001A\u0003%a\u0005C\u00044\u0001\t\u0007I\u0011A\u0013\t\rQ\u0002\u0001\u0015!\u0003'\u0011\u001d)\u0004A1A\u0005\u0002\u0015BaA\u000e\u0001!\u0002\u00131\u0003\"B\u001c\u0001\t\u0013A$aE*uC:$\u0017M\u001d3TG\u0006dWM]*vSR,'BA\u0006\r\u0003\u001d1W-\u0019;ve\u0016T!!\u0004\b\u0002\u000b5dG.\u001b2\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-i\u0001\"a\u0006\r\u000e\u00039I!!\u0007\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tYb$D\u0001\u001d\u0015\tiB\"\u0001\u0003vi&d\u0017BA\u0010\u001d\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0006\u0002\u0019\r|gn\u001d;b]R$\u0015\r^1\u0016\u0003\u0019\u00022a\n\u0016-\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#!B!se\u0006L\bCA\u00171\u001b\u0005q#BA\u0018\r\u0003\u0019a\u0017N\\1mO&\u0011\u0011G\f\u0002\u0007-\u0016\u001cGo\u001c:\u0002\u001b\r|gn\u001d;b]R$\u0015\r^1!\u0003)\u0019\b/\u0019:tK\u0012\u000bG/Y\u0001\fgB\f'o]3ECR\f\u0007%A\u0005eK:\u001cX\rR1uC\u0006QA-\u001a8tK\u0012\u000bG/\u0019\u0011\u0002\u001d\r|W\u000e];uKN+X.\\1ssR\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003y1\tAa\u001d;bi&\u0011ah\u000f\u0002\u001f\u001bVdG/\u001b<be&\fG/Z*uCRL7\u000f^5dC2\u001cV/\\7befDQ\u0001\u0011\u0005A\u0002\u0005\u000bA\u0001Z1uCB\u0019!)\u0012\u0017\u000e\u0003\rS!\u0001\u0012\b\u0002\u0007I$G-\u0003\u0002G\u0007\n\u0019!\u000b\u0012#")
public class StandardScalerSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final Vector[] constantData;
    private final Vector[] sparseData;
    private final Vector[] denseData;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Vector[] constantData() {
        return this.constantData;
    }

    public Vector[] sparseData() {
        return this.sparseData;
    }

    public Vector[] denseData() {
        return this.denseData;
    }

    private MultivariateStatisticalSummary computeSummary(RDD<Vector> data2) {
        MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(aggregator, data) -> aggregator.add(data);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(aggregator1, aggregator2) -> aggregator1.merge(aggregator2);
        int x$4 = data2.treeAggregate$default$4((Object)x$1);
        return (MultivariateStatisticalSummary)data2.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
    }

    private final void testImplicits$lzycompute$1() {
        StandardScalerSuite standardScalerSuite = this;
        synchronized (standardScalerSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$8(Vector x0$1, Vector x1$1, Vector x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)x0$1, (Object)x1$1, (Object)x2$1);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$12(Vector x0$2, Vector x1$2, Vector x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)x0$2, (Object)x1$2, (Object)x2$2);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$16(Vector x0$3, Vector x1$3, Vector x2$3) {
        Tuple3 tuple3 = new Tuple3((Object)x0$3, (Object)x1$3, (Object)x2$3);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$22(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$33(Vector x0$4, Vector x1$4, Vector x2$4) {
        Tuple3 tuple3 = new Tuple3((Object)x0$4, (Object)x1$4, (Object)x2$4);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$37(Vector x0$5, Vector x1$5, Vector x2$5) {
        Tuple3 tuple3 = new Tuple3((Object)x0$5, (Object)x1$5, (Object)x2$5);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$41(Vector x0$6, Vector x1$6, Vector x2$6) {
        Tuple3 tuple3 = new Tuple3((Object)x0$6, (Object)x1$6, (Object)x2$6);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$44(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$47(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$50(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$58(Vector x0$7, Vector x1$7, Vector x2$7) {
        Tuple3 tuple3 = new Tuple3((Object)x0$7, (Object)x1$7, (Object)x2$7);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$61(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$64(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$67(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$new$75(Vector x0$8, Vector x1$8, Vector x2$8) {
        Tuple3 tuple3 = new Tuple3((Object)x0$8, (Object)x1$8, (Object)x2$8);
        if (tuple3 != null) {
            Vector v1 = (Vector)tuple3._1();
            Vector v2 = (Vector)tuple3._2();
            Vector v3 = (Vector)tuple3._3();
            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                return true;
            }
        }
        if (tuple3 == null) return false;
        Vector v1 = (Vector)tuple3._1();
        Vector v2 = (Vector)tuple3._2();
        Vector v3 = (Vector)tuple3._3();
        if (!(v1 instanceof SparseVector)) return false;
        if (!(v2 instanceof SparseVector)) return false;
        if (!(v3 instanceof SparseVector)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$78(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$81(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$84(Vector v1, Vector v2) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$89(Vector x$1) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$1.toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 == 0.0);
    }

    public static final /* synthetic */ boolean $anonfun$new$91(Vector x$3) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$3.toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 == 0.0);
    }

    public static final /* synthetic */ boolean $anonfun$new$93(Vector x$5) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$5.toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 == 0.0);
    }

    public static final /* synthetic */ boolean $anonfun$new$99(Vector x$7) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$7.toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$8 -> x$8 == 0.0);
    }

    public static final /* synthetic */ boolean $anonfun$new$101(Vector x$9) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$9.toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$10 -> x$10 == 0.0);
    }

    public static final /* synthetic */ boolean $anonfun$new$103(Vector x$11) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$11.toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$12 -> x$12 == 0.0);
    }

    public StandardScalerSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.constantData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))});
        this.sparseData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, -2.0), new Tuple2.mcID.sp(1, 2.3)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -1.0), new Tuple2.mcID.sp(2, -3.0)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -5.1)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 3.8), new Tuple2.mcID.sp(2, 1.9)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.7), new Tuple2.mcID.sp(1, -0.6)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.9)})))});
        this.denseData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.3, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.0, -3.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-5.1, 0.0})), Vectors$.MODULE$.dense(3.8, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.9})), Vectors$.MODULE$.dense(1.7, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.6, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.9, 0.0}))});
        this.test("Standardization with dense input when means and stds are provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.denseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
            StandardScaler standardizer1 = new StandardScaler(true, true);
            StandardScaler standardizer2 = new StandardScaler();
            StandardScaler standardizer3 = new StandardScaler(true, false);
            StandardScalerModel model1 = standardizer1.fit(dataRDD);
            StandardScalerModel model2 = standardizer2.fit(dataRDD);
            StandardScalerModel model3 = standardizer3.fit(dataRDD);
            StandardScalerModel equivalentModel1 = new StandardScalerModel(model1.std(), model1.mean());
            StandardScalerModel equivalentModel2 = new StandardScalerModel(model2.std(), model2.mean(), true, false);
            StandardScalerModel equivalentModel3 = new StandardScalerModel(model3.std(), model3.mean(), false, true);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.denseData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel1.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.denseData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel2.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data3 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.denseData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel3.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data1RDD = equivalentModel1.transform(dataRDD);
            RDD data2RDD = equivalentModel2.transform(dataRDD);
            RDD data3RDD = equivalentModel3.transform(dataRDD);
            MultivariateStatisticalSummary summary = this.computeSummary((RDD<Vector>)dataRDD);
            MultivariateStatisticalSummary summary1 = this.computeSummary((RDD<Vector>)data1RDD);
            MultivariateStatisticalSummary summary2 = this.computeSummary((RDD<Vector>)data2RDD);
            MultivariateStatisticalSummary summary3 = this.computeSummary((RDD<Vector>)data3RDD);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.denseData(), (Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$8(x0$1, x1$1, x2$1))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$1: org.apache.spark.mllib.linalg.Vector, x1$1: org.apache.spark.mllib.linalg.Vector, x2$1: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$1, x1$1, x2$1) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.denseData(), (Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$2, x1$2, x2$2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$12(x0$2, x1$2, x2$2))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$2: org.apache.spark.mllib.linalg.Vector, x1$2: org.apache.spark.mllib.linalg.Vector, x2$2: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$2, x1$2, x2$2) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.denseData(), (Object)data3, data3RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$3, x1$3, x2$3) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$16(x0$3, x1$3, x2$3))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$3: org.apache.spark.mllib.linalg.Vector, x1$3: org.apache.spark.mllib.linalg.Vector, x2$3: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$3, x1$3, x2$3) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$19(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$22(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data3, data3RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$25(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.variance()).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.variance).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-1.31527964, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.023470449, 0.11637768424}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-1.31527964, 1.023470449, 0.11637768424)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.637735298, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.156973995, 1.32247368462}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.637735298, 0.156973995, 1.32247368462)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.865538862, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.22604255, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.865538862, -0.22604255, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.71580142, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.71580142, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.58333333, -2.8166666666}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, -0.58333333, -2.8166666666)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.316666666, 0.18333333333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, 2.316666666, 0.18333333333)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("Standardization with dense input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.denseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
            StandardScaler standardizer1 = new StandardScaler(true, true);
            StandardScaler standardizer2 = new StandardScaler();
            StandardScaler standardizer3 = new StandardScaler(true, false);
            StandardScalerModel model1 = standardizer1.fit(dataRDD);
            StandardScalerModel model2 = standardizer2.fit(dataRDD);
            StandardScalerModel model3 = standardizer3.fit(dataRDD);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.denseData())).map((Function1 & Serializable & scala.Serializable)vector -> model1.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.denseData())).map((Function1 & Serializable & scala.Serializable)vector -> model2.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data3 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.denseData())).map((Function1 & Serializable & scala.Serializable)vector -> model3.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data1RDD = model1.transform(dataRDD);
            RDD data2RDD = model2.transform(dataRDD);
            RDD data3RDD = model3.transform(dataRDD);
            MultivariateStatisticalSummary summary = this.computeSummary((RDD<Vector>)dataRDD);
            MultivariateStatisticalSummary summary1 = this.computeSummary((RDD<Vector>)data1RDD);
            MultivariateStatisticalSummary summary2 = this.computeSummary((RDD<Vector>)data2RDD);
            MultivariateStatisticalSummary summary3 = this.computeSummary((RDD<Vector>)data3RDD);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.denseData(), (Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$4, x1$4, x2$4) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$33(x0$4, x1$4, x2$4))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$4: org.apache.spark.mllib.linalg.Vector, x1$4: org.apache.spark.mllib.linalg.Vector, x2$4: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$4, x1$4, x2$4) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.denseData(), (Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$5, x1$5, x2$5) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$37(x0$5, x1$5, x2$5))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$5: org.apache.spark.mllib.linalg.Vector, x1$5: org.apache.spark.mllib.linalg.Vector, x2$5: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$5, x1$5, x2$5) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.denseData(), (Object)data3, data3RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$6, x1$6, x2$6) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$41(x0$6, x1$6, x2$6))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.denseData, data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$6: org.apache.spark.mllib.linalg.Vector, x1$6: org.apache.spark.mllib.linalg.Vector, x2$6: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$6, x1$6, x2$6) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$44(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$47(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data3, data3RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$50(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary.variance()).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary.variance).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-1.31527964, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.023470449, 0.11637768424}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-1.31527964, 1.023470449, 0.11637768424)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.637735298, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.156973995, 1.32247368462}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.637735298, 0.156973995, 1.32247368462)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.865538862, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.22604255, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.865538862, -0.22604255, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.71580142, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.71580142, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.58333333, -2.8166666666}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, -0.58333333, -2.8166666666)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.58333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.316666666, 0.18333333333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.58333333, 2.316666666, 0.18333333333)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("Standardization with sparse input when means and stds are provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.sparseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
            StandardScaler standardizer1 = new StandardScaler(true, true);
            StandardScaler standardizer2 = new StandardScaler();
            StandardScaler standardizer3 = new StandardScaler(true, false);
            StandardScalerModel model1 = standardizer1.fit(dataRDD);
            StandardScalerModel model2 = standardizer2.fit(dataRDD);
            StandardScalerModel model3 = standardizer3.fit(dataRDD);
            StandardScalerModel equivalentModel1 = new StandardScalerModel(model1.std(), model1.mean());
            StandardScalerModel equivalentModel2 = new StandardScalerModel(model2.std(), model2.mean(), true, false);
            StandardScalerModel equivalentModel3 = new StandardScalerModel(model3.std(), model3.mean(), false, true);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparseData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel1.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparseData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel2.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data3 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparseData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel3.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data1RDD = equivalentModel1.transform(dataRDD);
            RDD data2RDD = equivalentModel2.transform(dataRDD);
            RDD data3RDD = equivalentModel3.transform(dataRDD);
            MultivariateStatisticalSummary summary1 = this.computeSummary((RDD<Vector>)data1RDD);
            MultivariateStatisticalSummary summary2 = this.computeSummary((RDD<Vector>)data2RDD);
            MultivariateStatisticalSummary summary3 = this.computeSummary((RDD<Vector>)data3RDD);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.sparseData(), (Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$7, x1$7, x2$7) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$58(x0$7, x1$7, x2$7))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.sparseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$7: org.apache.spark.mllib.linalg.Vector, x1$7: org.apache.spark.mllib.linalg.Vector, x2$7: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$7, x1$7, x2$7) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$61(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$64(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data3, data3RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$67(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.variance()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.variance).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.56854, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.069068, 0.116377}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.56854, -0.069068, 0.116377)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.296998, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.872775, 0.116377}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.296998, 0.872775, 0.116377)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.865538862), new Tuple2.mcID.sp(1, -0.22604255)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, 0.865538862), scala.Tuple2.apply[Int, Double](1, -0.22604255)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.71580142)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.71580142)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.116666, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.183333, 0.183333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.116666, -0.183333, 0.183333)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.583333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.316666, 0.183333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.583333, 2.316666, 0.183333)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("Standardization with sparse input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.sparseData()), 3, ClassTag$.MODULE$.apply(Vector.class));
            StandardScaler standardizer1 = new StandardScaler(true, true);
            StandardScaler standardizer2 = new StandardScaler();
            StandardScaler standardizer3 = new StandardScaler(true, false);
            StandardScalerModel model1 = standardizer1.fit(dataRDD);
            StandardScalerModel model2 = standardizer2.fit(dataRDD);
            StandardScalerModel model3 = standardizer3.fit(dataRDD);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparseData())).map((Function1 & Serializable & scala.Serializable)vector -> model1.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparseData())).map((Function1 & Serializable & scala.Serializable)vector -> model2.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data3 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sparseData())).map((Function1 & Serializable & scala.Serializable)vector -> model3.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            RDD data1RDD = model1.transform(dataRDD);
            RDD data2RDD = model2.transform(dataRDD);
            RDD data3RDD = model3.transform(dataRDD);
            MultivariateStatisticalSummary summary1 = this.computeSummary((RDD<Vector>)data1RDD);
            MultivariateStatisticalSummary summary2 = this.computeSummary((RDD<Vector>)data2RDD);
            MultivariateStatisticalSummary summary3 = this.computeSummary((RDD<Vector>)data3RDD);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.sparseData(), (Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function3 & Serializable & scala.Serializable)(x0$8, x1$8, x2$8) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$75(x0$8, x1$8, x2$8))), "scala.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](StandardScalerSuite.this.sparseData, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$8: org.apache.spark.mllib.linalg.Vector, x1$8: org.apache.spark.mllib.linalg.Vector, x2$8: org.apache.spark.mllib.linalg.Vector) => scala.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$8, x1$8, x2$8) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after standardization.", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$78(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$81(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data3, data3RDD.collect())), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs))), (Function2 & Serializable & scala.Serializable)(v1, v2) -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$84(v1, v2))), "scala.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data3, data3RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary1.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary1.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.mean()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.mean).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary2.variance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary2.variance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.mean).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(summary3.variance()).$bang$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(summary3.variance).!~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 1.0, 1.0)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.56854, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.069068, 0.116377}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.56854, -0.069068, 0.116377)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.296998, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.872775, 0.116377}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.296998, 0.872775, 0.116377)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.865538862), new Tuple2.mcID.sp(1, -0.22604255)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, 0.865538862), scala.Tuple2.apply[Int, Double](1, -0.22604255)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.71580142)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, scala.collection.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.71580142)))).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.116666, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.183333, 0.183333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.116666, -0.183333, 0.183333)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data3[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.583333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.316666, 0.183333}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data3.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.583333, 2.316666, 0.183333)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        this.test("Standardization with constant input when means and stds are provided", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.constantData()), 2, ClassTag$.MODULE$.apply(Vector.class));
            StandardScaler standardizer1 = new StandardScaler(true, true);
            StandardScaler standardizer2 = new StandardScaler(true, false);
            StandardScaler standardizer3 = new StandardScaler(false, true);
            StandardScalerModel model1 = standardizer1.fit(dataRDD);
            StandardScalerModel model2 = standardizer2.fit(dataRDD);
            StandardScalerModel model3 = standardizer3.fit(dataRDD);
            StandardScalerModel equivalentModel1 = new StandardScalerModel(model1.std(), model1.mean());
            StandardScalerModel equivalentModel2 = new StandardScalerModel(model2.std(), model2.mean(), true, false);
            StandardScalerModel equivalentModel3 = new StandardScalerModel(model3.std(), model3.mean(), false, true);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.constantData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel1.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.constantData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel2.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data3 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.constantData())).map((Function1 & Serializable & scala.Serializable)vector -> equivalentModel3.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data1)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$89(x$1))), "scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data1).forall(((x$1: org.apache.spark.mllib.linalg.Vector) => scala.Predef.doubleArrayOps(x$1.toArray).forall(((x$2: Double) => x$2.==(0.0)))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The variance is zero, so the transformed result should be 0.0", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data2)).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$91(x$3))), "scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data2).forall(((x$3: org.apache.spark.mllib.linalg.Vector) => scala.Predef.doubleArrayOps(x$3.toArray).forall(((x$4: Double) => x$4.==(0.0)))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The variance is zero, so the transformed result should be 0.0", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data3)).forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$93(x$5))), "scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data3).forall(((x$5: org.apache.spark.mllib.linalg.Vector) => scala.Predef.doubleArrayOps(x$5.toArray).forall(((x$6: Double) => x$6.==(0.0)))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The variance is zero, so the transformed result should be 0.0", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("Standardization with constant input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.constantData()), 2, ClassTag$.MODULE$.apply(Vector.class));
            StandardScaler standardizer1 = new StandardScaler(true, true);
            StandardScaler standardizer2 = new StandardScaler(true, false);
            StandardScaler standardizer3 = new StandardScaler(false, true);
            StandardScalerModel model1 = standardizer1.fit(dataRDD);
            StandardScalerModel model2 = standardizer2.fit(dataRDD);
            StandardScalerModel model3 = standardizer3.fit(dataRDD);
            Vector[] data1 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.constantData())).map((Function1 & Serializable & scala.Serializable)vector -> model1.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.constantData())).map((Function1 & Serializable & scala.Serializable)vector -> model2.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Vector[] data3 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.constantData())).map((Function1 & Serializable & scala.Serializable)vector -> model3.transform(vector), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data1)).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$99(x$7))), "scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data1).forall(((x$7: org.apache.spark.mllib.linalg.Vector) => scala.Predef.doubleArrayOps(x$7.toArray).forall(((x$8: Double) => x$8.==(0.0)))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The variance is zero, so the transformed result should be 0.0", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data2)).forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$101(x$9))), "scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data2).forall(((x$9: org.apache.spark.mllib.linalg.Vector) => scala.Predef.doubleArrayOps(x$9.toArray).forall(((x$10: Double) => x$10.==(0.0)))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"The variance is zero, so the transformed result should be 0.0", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data3)).forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StandardScalerSuite.$anonfun$new$103(x$11))), "scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](data3).forall(((x$11: org.apache.spark.mllib.linalg.Vector) => scala.Predef.doubleArrayOps(x$11.toArray).forall(((x$12: Double) => x$12.==(0.0)))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"The variance is zero, so the transformed result should be 0.0", Prettifier$.MODULE$.default(), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("StandardScalerModel argument nulls are properly handled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.withClue("model needs at least one of std or mean vectors", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StandardScalerModel standardScalerModel = new StandardScalerModel(null, null);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351)));
            this.withClue("model needs std to set withStd to true", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                StandardScalerModel model = new StandardScalerModel(null, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                return model.setWithStd(true);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356)));
            this.withClue("model needs mean to set withMean to true", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                StandardScalerModel model = new StandardScalerModel(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), null);
                return model.setWithMean(true);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362)));
            return (IllegalArgumentException)this.withClue("model needs std and mean vectors to be equal size when both are provided", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StandardScalerModel standardScalerModel = new StandardScalerModel(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})));
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368)));
        }, new Position("StandardScalerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
    }
}

