/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.Serializable;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.mllib.random.GammaGenerator;
import org.apache.spark.mllib.random.PoissonGenerator;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.StandardNormalGenerator;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class GeneralizedLinearRegressionSuite$
implements scala.Serializable {
    public static GeneralizedLinearRegressionSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;

    static {
        new GeneralizedLinearRegressionSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public Seq<LabeledPoint> generateGeneralizedLinearRegressionInput(double intercept, double[] coefficients, double[] xMean, double[] xVariance, int nPoints, int seed, double noiseLevel, String family, String link) {
        Tuple2 tuple2;
        Random rnd = new Random(seed);
        String string = family;
        if ("gaussian".equals(string)) {
            tuple2 = new Tuple2((Object)new StandardNormalGenerator(), (Object)BoxesRunTime.boxToDouble((double)0.0));
        } else if ("poisson".equals(string)) {
            tuple2 = new Tuple2((Object)new PoissonGenerator(1.0), (Object)BoxesRunTime.boxToDouble((double)1.0));
        } else if ("gamma".equals(string)) {
            tuple2 = new Tuple2((Object)new GammaGenerator(1.0, 1.0), (Object)BoxesRunTime.boxToDouble((double)1.0));
        } else {
            throw new MatchError((Object)string);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        RandomDataGenerator generator = (RandomDataGenerator)tuple22._1();
        double mean = tuple22._2$mcD$sp();
        Tuple2 tuple23 = new Tuple2((Object)generator, (Object)BoxesRunTime.boxToDouble((double)mean));
        Tuple2 tuple24 = tuple23;
        RandomDataGenerator generator2 = (RandomDataGenerator)tuple24._1();
        double mean2 = tuple24._2$mcD$sp();
        generator2.setSeed((long)seed);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1 & Serializable & scala.Serializable)x$33 -> GeneralizedLinearRegressionSuite$.$anonfun$generateGeneralizedLinearRegressionInput$1(coefficients, intercept, link, noiseLevel, generator2, mean2, rnd, xVariance, xMean, BoxesRunTime.unboxToInt((Object)x$33)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final double rndElement$1(int i, Random rnd$1, double[] xVariance$1, double[] xMean$1) {
        return (rnd$1.nextDouble() - 0.5) * package$.MODULE$.sqrt(12.0 * xVariance$1[i]) + xMean$1[i];
    }

    public static final /* synthetic */ LabeledPoint $anonfun$generateGeneralizedLinearRegressionInput$1(double[] coefficients$1, double intercept$1, String link$6, double noiseLevel$1, RandomDataGenerator generator$1, double mean$1, Random rnd$1, double[] xVariance$1, double[] xMean$1, int x$33) {
        double d;
        Vector features = Vectors$.MODULE$.dense((double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefficients$1)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> GeneralizedLinearRegressionSuite$.rndElement$1(i, rnd$1, xVariance$1, xMean$1), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
        double eta = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(coefficients$1), features) + intercept$1;
        String string = link$6;
        if ("identity".equals(string)) {
            d = eta;
        } else if ("log".equals(string)) {
            d = package$.MODULE$.exp(eta);
        } else if ("sqrt".equals(string)) {
            d = package$.MODULE$.pow(eta, 2.0);
        } else if ("inverse".equals(string)) {
            d = 1.0 / eta;
        } else {
            throw new MatchError((Object)string);
        }
        double mu = d;
        double label = mu + noiseLevel$1 * (BoxesRunTime.unboxToDouble((Object)generator$1.nextValue()) - mean$1);
        return new LabeledPoint(label, features);
    }

    private GeneralizedLinearRegressionSuite$() {
        MODULE$ = this;
        this.allParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"family"), (Object)"poisson"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link"), (Object)"log"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fitIntercept"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)0.8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"predictionCol"), (Object)"myPrediction"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"variancePower"), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
    }
}

