/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class MLTestingUtils$
extends SparkFunSuite {
    public static MLTestingUtils$ MODULE$;

    static {
        new MLTestingUtils$();
    }

    public <T extends Estimator<?>> void checkCopyAndUids(T estimator, Model<?> model) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(estimator.uid());
        String $org_scalatest_assert_macro_right = model.uid();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Model uid does not match parent estimator", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        Model copied = model.copy(ParamMap$.MODULE$.empty());
        Estimator $org_scalatest_assert_macro_left2 = copied.parent();
        Estimator $org_scalatest_assert_macro_right2 = model.parent();
        Estimator estimator2 = $org_scalatest_assert_macro_left2;
        Estimator estimator3 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(estimator2 != null ? !estimator2.equals(estimator3) : estimator3 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        String $org_scalatest_assert_macro_left3 = copied.parent().uid();
        String $org_scalatest_assert_macro_right3 = model.parent().uid();
        String string = $org_scalatest_assert_macro_left3;
        String string2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public <M extends Model<M>, T extends Estimator<M>> void checkNumericTypes(T estimator, SparkSession spark, boolean isClassification, Function2<M, M, BoxedUnit> check) {
        Estimator t2;
        Map<NumericType, Dataset<Row>> dfs = isClassification ? this.genClassifDFWithNumericLabelCol(spark, this.genClassifDFWithNumericLabelCol$default$2(), this.genClassifDFWithNumericLabelCol$default$3(), this.genClassifDFWithNumericLabelCol$default$4()) : this.genRegressionDFWithNumericLabelCol(spark, this.genRegressionDFWithNumericLabelCol$default$2(), this.genRegressionDFWithNumericLabelCol$default$3(), this.genRegressionDFWithNumericLabelCol$default$4(), this.genRegressionDFWithNumericLabelCol$default$5());
        Estimator t3 = estimator;
        if (t3 instanceof HasWeightCol) {
            Estimator t4 = t3;
            t4.set(((HasWeightCol)t4).weightCol(), (Object)"weight");
            t2 = t4;
        } else {
            t2 = estimator;
        }
        Estimator finalEstimator = t2;
        Model expected = finalEstimator.fit((Dataset)dfs.apply((Object)DoubleType$.MODULE$));
        Iterable actuals = (Iterable)((TraversableLike)dfs.keys().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MLTestingUtils$.$anonfun$checkNumericTypes$1(x$1)))).map((Function1 & Serializable & scala.Serializable)t -> finalEstimator.fit((Dataset)dfs.apply(t)), Iterable$.MODULE$.canBuildFrom());
        actuals.foreach((Function1 & Serializable & scala.Serializable)actual -> {
            check.apply((Object)expected, (Object)actual);
            return BoxedUnit.UNIT;
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$1() {
            }
        }
        Dataset dfWithStringLabels = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"0", (Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "weight", "features", "censor"}));
        IllegalArgumentException thrown = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> estimator.fit(dfWithStringLabels), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        String $org_scalatest_assert_macro_left = thrown.getMessage();
        String $org_scalatest_assert_macro_right = "Column label must be of type numeric but was actually of type string";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        Estimator t5 = estimator;
        if (t5 instanceof HasWeightCol) {
            Estimator t6 = t5;
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
                }

                public Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$1() {
                }
            }
            Dataset dfWithStringWeights = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)0), (Object)"1", (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "weight", "features", "censor"}));
            t6.set(((HasWeightCol)t6).weightCol(), (Object)"weight");
            IllegalArgumentException thrown2 = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> t6.fit(dfWithStringWeights), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            String $org_scalatest_assert_macro_left2 = thrown2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Column weight must be of type numeric but was actually of type string";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <T extends Evaluator> void checkNumericTypes(T evaluator, SparkSession spark) {
        Map<NumericType, Dataset<Row>> dfs = this.genEvaluatorDFWithNumericLabelCol(spark, "label", "prediction");
        double expected = evaluator.evaluate((Dataset)dfs.apply((Object)DoubleType$.MODULE$));
        Iterable actuals = (Iterable)((TraversableLike)dfs.keys().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MLTestingUtils$.$anonfun$checkNumericTypes$6(x$2)))).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToDouble((double)evaluator.evaluate((Dataset)dfs.apply((Object)t))), Iterable$.MODULE$.canBuildFrom());
        actuals.foreach((Function1 & Serializable & scala.Serializable)actual -> MLTestingUtils$.$anonfun$checkNumericTypes$8(expected, BoxesRunTime.unboxToDouble((Object)actual)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$2() {
            }
        }
        Dataset dfWithStringLabels = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"0", (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$2())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "prediction"}));
        IllegalArgumentException thrown = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> evaluator.evaluate(dfWithStringLabels), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        String $org_scalatest_assert_macro_left = thrown.getMessage();
        String $org_scalatest_assert_macro_right = "Column label must be of type numeric but was actually of type string";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    public <M extends Model<M>, T extends Estimator<M>> boolean checkNumericTypes$default$3() {
        return true;
    }

    public Map<NumericType, Dataset<Row>> genClassifDFWithNumericLabelCol(SparkSession spark, String labelColName, String featuresColName, String weightColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$3() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 1.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 9.0}))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$3())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelColName, featuresColName}));
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> {
            Dataset castDF = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(labelColName).cast((DataType)t), functions$.MODULE$.col(featuresColName)}));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)TreeTests$.MODULE$.setMetadata((Dataset<Row>)castDF, 2, labelColName, featuresColName).withColumn(weightColName, functions$.MODULE$.round(functions$.MODULE$.rand(42L)).cast((DataType)t)));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String genClassifDFWithNumericLabelCol$default$2() {
        return "label";
    }

    public String genClassifDFWithNumericLabelCol$default$3() {
        return "features";
    }

    public String genClassifDFWithNumericLabelCol$default$4() {
        return "weight";
    }

    public Map<NumericType, Dataset<Row>> genRegressionDFWithNumericLabelCol(SparkSession spark, String labelColName, String weightColName, String featuresColName, String censorColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$4() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$4())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelColName, featuresColName}));
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> {
            Dataset castDF = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(labelColName).cast((DataType)t), functions$.MODULE$.col(featuresColName)}));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)TreeTests$.MODULE$.setMetadata((Dataset<Row>)castDF, 0, labelColName, featuresColName).withColumn(censorColName, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0))).withColumn(weightColName, functions$.MODULE$.round(functions$.MODULE$.rand(42L)).cast((DataType)t)));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String genRegressionDFWithNumericLabelCol$default$2() {
        return "label";
    }

    public String genRegressionDFWithNumericLabelCol$default$3() {
        return "weight";
    }

    public String genRegressionDFWithNumericLabelCol$default$4() {
        return "features";
    }

    public String genRegressionDFWithNumericLabelCol$default$5() {
        return "censor";
    }

    public Map<NumericType, Dataset<Row>> genEvaluatorDFWithNumericLabelCol(SparkSession spark, String labelColName, String predictionColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$5() {
            }
        }
        Dataset df = spark.createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0), new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(3, 3.0), new Tuple2.mcID.sp(4, 4.0)})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$5())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelColName, predictionColName}));
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ShortType$.MODULE$, LongType$.MODULE$, IntegerType$.MODULE$, FloatType$.MODULE$, ByteType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 0)}));
        return ((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(labelColName).cast((DataType)t), functions$.MODULE$.col(predictionColName)}))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String genEvaluatorDFWithNumericLabelCol$default$2() {
        return "label";
    }

    public String genEvaluatorDFWithNumericLabelCol$default$3() {
        return "prediction";
    }

    public Tuple2<Dataset<Instance>, Dataset<Instance>> genEquivalentOversampledAndWeightedInstances(Dataset<LabeledPoint> data, long seed) {
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.Instance").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator13$1() {
            }
        }
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.Instance").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$1() {
            }
        }
        Random rng = new Random(seed);
        JFunction0.mcI.sp & Serializable & scala.Serializable sample = (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rng.nextInt(10) + 1;
        UserDefinedFunction sampleUDF = functions$.MODULE$.udf((Function0)sample, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        Dataset rawData = data.select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"})).withColumn("samples", sampleUDF.apply((Seq)Nil$.MODULE$));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Dataset overSampledData = data.sparkSession().implicits().rddToDatasetHolder(rawData.rdd().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Vector vector;
            double d;
            Object n;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    n = ((SeqLike)some.get()).apply(2);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (!(features instanceof Vector)) break block2;
                    vector = (Vector)features;
                    if (n instanceof Integer) break block3;
                }
                throw new MatchError((Object)row);
            }
            int n2 = BoxesRunTime.unboxToInt((Object)n);
            Iterator iterator = scala.package$.MODULE$.Iterator().fill(n2, (Function0 & Serializable & scala.Serializable)() -> new Instance(d, 1.0, vector));
            return iterator;
        }, ClassTag$.MODULE$.apply(Instance.class)), data.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$1()))).toDS();
        rng.setSeed(seed);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Dataset weightedData = data.sparkSession().implicits().rddToDatasetHolder(rawData.rdd().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Vector vector;
            double d;
            Object n;
            block3: {
                Row row;
                block2: {
                    row = x0$2;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    n = ((SeqLike)some.get()).apply(2);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (!(features instanceof Vector)) break block2;
                    vector = (Vector)features;
                    if (n instanceof Integer) break block3;
                }
                throw new MatchError((Object)row);
            }
            int n2 = BoxesRunTime.unboxToInt((Object)n);
            Instance instance = new Instance(d, (double)n2, vector);
            return instance;
        }, ClassTag$.MODULE$.apply(Instance.class)), data.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator13$1()))).toDS();
        return new Tuple2((Object)overSampledData, (Object)weightedData);
    }

    public <M extends Model<M>, E extends Estimator<M>> void testOversamplingVsWeighting(Dataset<LabeledPoint> data, E estimator, Function2<M, M, BoxedUnit> modelEquals, long seed) {
        Tuple2<Dataset<Instance>, Dataset<Instance>> tuple2 = this.genEquivalentOversampledAndWeightedInstances(data, seed);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Dataset overSampledData = (Dataset)tuple2._1();
        Dataset weightedData = (Dataset)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)overSampledData, (Object)weightedData);
        Tuple2 tuple23 = tuple22;
        Dataset overSampledData2 = (Dataset)tuple23._1();
        Dataset weightedData2 = (Dataset)tuple23._2();
        Model overSampledModel = ((Estimator)estimator.set(((HasWeightCol)estimator).weightCol(), (Object)"")).fit(overSampledData2);
        Model weightedModel = ((Estimator)estimator.set(((HasWeightCol)estimator).weightCol(), (Object)"weight")).fit(weightedData2);
        modelEquals.apply((Object)weightedModel, (Object)overSampledModel);
    }

    public <M extends Model<M>, E extends Estimator<M>> void testOutliersWithSmallWeights(Dataset<LabeledPoint> data, E estimator, int numClasses, Function2<M, M, BoxedUnit> modelEquals, int outlierRatio) {
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.Instance").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$2() {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.feature.Instance").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$1() {
            }
        }
        Dataset outlierDS = data.withColumn("weight", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0))).as(data.sqlContext().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$1()))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Instance instance = x0$1;
            if (instance == null) {
                throw new MatchError((Object)instance);
            }
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double outlierLabel = numClasses == 0 ? -l : (double)numClasses - l - 1.0;
            List list = (List)((List)List$.MODULE$.fill(outlierRatio, (Function0 & Serializable & scala.Serializable)() -> new Instance(outlierLabel, 1.0E-4, f))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Instance(l, w, f), (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom());
            return list;
        }, data.sqlContext().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$2())));
        Model trueModel = ((Estimator)estimator.set(((HasWeightCol)estimator).weightCol(), (Object)"")).fit(data);
        Model outlierModel = ((Estimator)estimator.set(((HasWeightCol)estimator).weightCol(), (Object)"weight")).fit(outlierDS);
        modelEquals.apply((Object)trueModel, (Object)outlierModel);
    }

    public <M extends Model<M>, E extends Estimator<M>> void testArbitrarilyScaledWeights(Dataset<LabeledPoint> data, E estimator, Function2<M, M, BoxedUnit> modelEquals) {
        estimator.set(((HasWeightCol)estimator).weightCol(), (Object)"weight");
        Seq models = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.01, 1.0, 1000.0}))).map((Function1 & Serializable & scala.Serializable)w -> MLTestingUtils$.$anonfun$testArbitrarilyScaledWeights$1(data, estimator, BoxesRunTime.unboxToDouble((Object)w)), Seq$.MODULE$.canBuildFrom());
        models.sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MLTestingUtils$.$anonfun$testArbitrarilyScaledWeights$2(modelEquals, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple3<Dataset<Row>, Dataset<Row>, Dataset<Row>> generateArrayFeatureDataset(Dataset<Row> dataset, String featuresColName) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$6
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$6() {
            }
        }
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$2() {
            }
        }
        UserDefinedFunction toFloatVectorUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> (float)x$4, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator1$6()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator2$2()));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator3$1() {
            }
        }
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$2() {
            }
        }
        UserDefinedFunction toDoubleArrayUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> features.toArray(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator4$2()));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$3() {
            }
        }
        public final class Org_apache_spark_ml_util_MLTestingUtils$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_util_MLTestingUtils$$typecreator6$1() {
            }
        }
        UserDefinedFunction toFloatArrayUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(features.toArray())).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$5 -> (float)x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator5$3()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_apache_spark_ml_util_MLTestingUtils$$typecreator6$1()));
        Dataset newDataset = dataset.withColumn(featuresColName, toFloatVectorUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresColName)})));
        Dataset newDatasetD = newDataset.withColumn(featuresColName, toDoubleArrayUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresColName)})));
        Dataset newDatasetF = newDataset.withColumn(featuresColName, toFloatArrayUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresColName)})));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(newDataset.schema().apply(featuresColName).dataType().equals((Object)new VectorUDT()), "newDataset.schema.apply(featuresColName).dataType.equals(new org.apache.spark.ml.linalg.VectorUDT())", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(newDatasetD.schema().apply(featuresColName).dataType().equals((Object)new ArrayType((DataType)DoubleType$.MODULE$, false)), "newDatasetD.schema.apply(featuresColName).dataType.equals(new org.apache.spark.sql.types.ArrayType(org.apache.spark.sql.types.DoubleType, false))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(newDatasetF.schema().apply(featuresColName).dataType().equals((Object)new ArrayType((DataType)FloatType$.MODULE$, false)), "newDatasetF.schema.apply(featuresColName).dataType.equals(new org.apache.spark.sql.types.ArrayType(org.apache.spark.sql.types.FloatType, false))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        return new Tuple3((Object)newDataset, (Object)newDatasetD, (Object)newDatasetF);
    }

    public String generateArrayFeatureDataset$default$2() {
        return "features";
    }

    public <M extends PredictionModel<?, M>> void modelPredictionEquals(Dataset<Row> data, Function2<Object, Object, Object> compareFunc, double fractionInTol, M model1, M model2) {
        Row[] pred1 = (Row[])model1.transform(data).select(model1.getPredictionCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        Row[] pred2 = (Row[])model2.transform(data).select(model2.getPredictionCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
        int inTol = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pred1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])pred2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MLTestingUtils$.$anonfun$modelPredictionEquals$1(compareFunc, x0$1)));
        double $org_scalatest_assert_macro_left = (double)inTol / (double)pred1.length;
        double $org_scalatest_assert_macro_right = fractionInTol;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$checkNumericTypes$1(NumericType x$1) {
        NumericType numericType = x$1;
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        return numericType == null ? doubleType$ != null : !numericType.equals(doubleType$);
    }

    public static final /* synthetic */ boolean $anonfun$checkNumericTypes$6(NumericType x$2) {
        NumericType numericType = x$2;
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        return numericType == null ? doubleType$ != null : !numericType.equals(doubleType$);
    }

    public static final /* synthetic */ Assertion $anonfun$checkNumericTypes$8(double expected$2, double actual) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = MODULE$.convertToEqualizer(BoxesRunTime.boxToDouble((double)expected$2));
        double $org_scalatest_assert_macro_right = actual;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MLTestingUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }

    public static final /* synthetic */ Model $anonfun$testArbitrarilyScaledWeights$1(Dataset data$1, Estimator estimator$2, double w) {
        Dataset df = data$1.withColumn("weight", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)w)));
        return estimator$2.fit(df);
    }

    public static final /* synthetic */ void $anonfun$testArbitrarilyScaledWeights$2(Function2 modelEquals$1, Seq x0$1) {
        Seq seq = x0$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        Model m1 = (Model)((SeqLike)some.get()).apply(0);
        Model m2 = (Model)((SeqLike)some.get()).apply(1);
        BoxedUnit boxedUnit = (BoxedUnit)modelEquals$1.apply((Object)m1, (Object)m2);
    }

    public static final /* synthetic */ boolean $anonfun$modelPredictionEquals$1(Function2 compareFunc$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Row p1 = (Row)tuple2._1();
        Row p2 = (Row)tuple2._2();
        double x = p1.getDouble(0);
        double y = p2.getDouble(0);
        boolean bl = compareFunc$1.apply$mcZDD$sp(x, y);
        return bl;
    }

    private MLTestingUtils$() {
        MODULE$ = this;
    }
}

