/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!2A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0014\u0001A\u0003%\u0011E\u0001\fNk2$\u0018n\u00197bgNlU\r\u001e:jGN\u001cV/\u001b;f\u0015\t1q!\u0001\u0006fm\u0006dW/\u0019;j_:T!\u0001C\u0005\u0002\u000b5dG.\u001b2\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#U\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t1\u0012$D\u0001\u0018\u0015\tAr!\u0001\u0003vi&d\u0017B\u0001\u000e\u0018\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0003\u0002\u000b\u0011,G\u000e^1\u0016\u0003\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a\u0001R8vE2,\u0017A\u00023fYR\f\u0007\u0005")
public class MulticlassMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final double delta;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private double delta() {
        return this.delta;
    }

    private final void testImplicits$lzycompute$1() {
        MulticlassMetricsSuite multiclassMetricsSuite = this;
        synchronized (multiclassMetricsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public MulticlassMetricsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.delta = 1.0E-7;
        this.test("Multiclass evaluation metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix confusionMatrix = Matrices$.MODULE$.dense(3, 3, new double[]{2.0, 1.0, 0.0, 1.0, 3.0, 0.0, 1.0, 0.0, 1.0});
            double[] labels = new double[]{0.0, 1.0, 2.0};
            RDD predictionAndLabels = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(0.0, 1.0), new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(1.0, 0.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(2.0, 2.0), new Tuple2.mcDD.sp(2.0, 0.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels);
            double tpRate0 = 0.5;
            double tpRate1 = 0.75;
            double tpRate2 = 1.0;
            double fpRate0 = 0.2;
            double fpRate1 = 0.2;
            double fpRate2 = 0.125;
            double precision0 = 0.6666666666666666;
            double precision1 = 0.75;
            double precision2 = 0.5;
            double recall0 = 0.5;
            double recall1 = 0.75;
            double recall2 = 1.0;
            double f1measure0 = (double)2 * precision0 * recall0 / (precision0 + recall0);
            double f1measure1 = (double)2 * precision1 * recall1 / (precision1 + recall1);
            double f1measure2 = (double)2 * precision2 * recall2 / (precision2 + recall2);
            double f2measure0 = (double)5 * precision0 * recall0 / ((double)4 * precision0 + recall0);
            double f2measure1 = (double)5 * precision1 * recall1 / ((double)4 * precision1 + recall1);
            double f2measure2 = (double)5 * precision2 * recall2 / ((double)4 * precision2 + recall2);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(metrics.confusionMatrix().asML()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(confusionMatrix).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(metrics.confusionMatrix.asML).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(confusionMatrix).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.truePositiveRate(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tpRate0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.truePositiveRate(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(tpRate0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.truePositiveRate(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tpRate1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.truePositiveRate(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(tpRate1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.truePositiveRate(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.truePositiveRate(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(tpRate2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.falsePositiveRate(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(fpRate0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.falsePositiveRate(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(fpRate0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.falsePositiveRate(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(fpRate1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.falsePositiveRate(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(fpRate1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.falsePositiveRate(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(fpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.falsePositiveRate(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(fpRate2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(precision0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(precision1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(precision2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(recall0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(recall1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(recall2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f1measure0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f1measure1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f1measure2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(0.0, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f2measure0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(0.0, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f2measure0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(1.0, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f2measure1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(1.0, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f2measure1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(2.0, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f2measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(2.0, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f2measure2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.accuracy()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6666666666666666).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.accuracy).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.6666666666666666).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.accuracy()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedRecall()).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.accuracy).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedRecall).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            double weight0 = 0.4444444444444444;
            double weight1 = 0.4444444444444444;
            double weight2 = 0.1111111111111111;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedTruePositiveRate()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * tpRate0 + weight1 * tpRate1 + weight2 * tpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedTruePositiveRate).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(tpRate0).+(weight1.*(tpRate1)).+(weight2.*(tpRate2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedFalsePositiveRate()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * fpRate0 + weight1 * fpRate1 + weight2 * fpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedFalsePositiveRate).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(fpRate0).+(weight1.*(fpRate1)).+(weight2.*(fpRate2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedPrecision()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * precision0 + weight1 * precision1 + weight2 * precision2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedPrecision).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(precision0).+(weight1.*(precision1)).+(weight2.*(precision2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedRecall()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * recall0 + weight1 * recall1 + weight2 * recall2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedRecall).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(recall0).+(weight1.*(recall1)).+(weight2.*(recall2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedFMeasure()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * f1measure0 + weight1 * f1measure1 + weight2 * f1measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedFMeasure).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(f1measure0).+(weight1.*(f1measure1)).+(weight2.*(f1measure2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedFMeasure(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * f2measure0 + weight1 * f2measure1 + weight2 * f2measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedFMeasure(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(f2measure0).+(weight1.*(f2measure1)).+(weight2.*(f2measure2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metrics.labels());
            double[] $org_scalatest_assert_macro_right = labels;
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("Multiclass evaluation metrics with weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double w1 = 2.2;
            double w2 = 1.5;
            double tw = 2.0 * w1 + 1.0 * w2 + 1.0 * w1 + 1.0 * w2 + 2.0 * w1 + 1.0 * w2 + 1.0 * w2;
            Matrix confusionMatrix = Matrices$.MODULE$.dense(3, 3, new double[]{(double)2 * w1, 1.0 * w2, 0.0, 1.0 * w2, (double)2 * w1 + 1.0 * w2, 0.0, 1.0 * w1, 0.0, 1.0 * w2});
            double[] labels = new double[]{0.0, 1.0, 2.0};
            RDD predictionAndLabelsWithWeights = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w1)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w1)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w1)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w1)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w1))})), 2, ClassTag$.MODULE$.apply(Tuple3.class));
            MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabelsWithWeights);
            double tpRate0 = 2.0 * w1 / (2.0 * w1 + 1.0 * w2 + 1.0 * w1);
            double tpRate1 = (2.0 * w1 + 1.0 * w2) / (2.0 * w1 + 1.0 * w2 + 1.0 * w2);
            double tpRate2 = 1.0 * w2 / (1.0 * w2 + 0.0);
            double fpRate0 = 1.0 * w2 / (tw - (2.0 * w1 + 1.0 * w2 + 1.0 * w1));
            double fpRate1 = 1.0 * w2 / (tw - (1.0 * w2 + 2.0 * w1 + 1.0 * w2));
            double fpRate2 = 1.0 * w1 / (tw - 1.0 * w2);
            double precision0 = 2.0 * w1 / ((double)2 * w1 + 1.0 * w2);
            double precision1 = (2.0 * w1 + 1.0 * w2) / (2.0 * w1 + 1.0 * w2 + 1.0 * w2);
            double precision2 = 1.0 * w2 / (1.0 * w1 + 1.0 * w2);
            double recall0 = 2.0 * w1 / (2.0 * w1 + 1.0 * w2 + 1.0 * w1);
            double recall1 = (2.0 * w1 + 1.0 * w2) / (2.0 * w1 + 1.0 * w2 + 1.0 * w2);
            double recall2 = 1.0 * w2 / (1.0 * w2 + 0.0);
            double f1measure0 = (double)2 * precision0 * recall0 / (precision0 + recall0);
            double f1measure1 = (double)2 * precision1 * recall1 / (precision1 + recall1);
            double f1measure2 = (double)2 * precision2 * recall2 / (precision2 + recall2);
            double f2measure0 = (double)5 * precision0 * recall0 / ((double)4 * precision0 + recall0);
            double f2measure1 = (double)5 * precision1 * recall1 / ((double)4 * precision1 + recall1);
            double f2measure2 = (double)5 * precision2 * recall2 / ((double)4 * precision2 + recall2);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(metrics.confusionMatrix().asML()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(confusionMatrix).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(metrics.confusionMatrix.asML).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(confusionMatrix).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.truePositiveRate(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tpRate0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.truePositiveRate(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(tpRate0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.truePositiveRate(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tpRate1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.truePositiveRate(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(tpRate1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.truePositiveRate(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.truePositiveRate(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(tpRate2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.falsePositiveRate(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(fpRate0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.falsePositiveRate(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(fpRate0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.falsePositiveRate(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(fpRate1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.falsePositiveRate(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(fpRate1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.falsePositiveRate(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(fpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.falsePositiveRate(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(fpRate2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(precision0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(precision1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(precision2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(recall0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(recall1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(recall2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(0.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f1measure0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(1.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f1measure1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f1measure2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(0.0, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f2measure0).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(0.0, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f2measure0).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(1.0, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f2measure1).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(1.0, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f2measure1).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.fMeasure(2.0, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f2measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.fMeasure(2.0, 2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(f2measure2).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.accuracy()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals((2.0 * w1 + 2.0 * w1 + 1.0 * w2 + 1.0 * w2) / tw).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.accuracy).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(2.0.*(w1).+(2.0.*(w1)).+(1.0.*(w2)).+(1.0.*(w2))./(tw)).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.accuracy()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedRecall()).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.accuracy).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedRecall).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            double weight0 = ((double)2 * w1 + 1.0 * w2 + 1.0 * w1) / tw;
            double weight1 = (1.0 * w2 + (double)2 * w1 + 1.0 * w2) / tw;
            double weight2 = 1.0 * w2 / tw;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedTruePositiveRate()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * tpRate0 + weight1 * tpRate1 + weight2 * tpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedTruePositiveRate).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(tpRate0).+(weight1.*(tpRate1)).+(weight2.*(tpRate2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedFalsePositiveRate()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * fpRate0 + weight1 * fpRate1 + weight2 * fpRate2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedFalsePositiveRate).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(fpRate0).+(weight1.*(fpRate1)).+(weight2.*(fpRate2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedPrecision()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * precision0 + weight1 * precision1 + weight2 * precision2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedPrecision).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(precision0).+(weight1.*(precision1)).+(weight2.*(precision2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedRecall()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * recall0 + weight1 * recall1 + weight2 * recall2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedRecall).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(recall0).+(weight1.*(recall1)).+(weight2.*(recall2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedFMeasure()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * f1measure0 + weight1 * f1measure1 + weight2 * f1measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedFMeasure).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(f1measure0).+(weight1.*(f1measure1)).+(weight2.*(f1measure2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.weightedFMeasure(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weight0 * f2measure0 + weight1 * f2measure1 + weight2 * f2measure2).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.weightedFMeasure(2.0)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weight0.*(f2measure0).+(weight1.*(f2measure1)).+(weight2.*(f2measure2))).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(metrics.labels());
            double[] $org_scalatest_assert_macro_right = labels;
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("MulticlassMetrics supports binary class log-loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq labels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 1.0}));
            Seq probabilities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{{0.1, 0.9}, {0.9, 0.1}, {0.8, 0.2}, {0.35, 0.65}}));
            Seq weights = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.5, 2.0, 1.0, 0.5}));
            SparkContext qual$1 = this.sc();
            Seq x$1 = (Seq)((IterableLike)labels.zip((GenIterable)weights, Seq$.MODULE$.canBuildFrom())).zip((GenIterable)probabilities, Seq$.MODULE$.canBuildFrom());
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                double[] probability;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        probability = (double[])tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double label = tuple2._1$mcD$sp();
                double weight = tuple2._2$mcD$sp();
                double prediction = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probability)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probability)).max((Ordering)Ordering.Double$.MODULE$));
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)prediction), (Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)weight), (Object)probability);
                return tuple4;
            }, ClassTag$.MODULE$.apply(Tuple4.class));
            MulticlassMetrics metrics = new MulticlassMetrics(rdd);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.logLoss(metrics.logLoss$default$1())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.16145936283256573).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.logLoss(metrics.logLoss$default$1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.16145936283256573).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            RDD rdd2 = rdd.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                double d;
                double d2;
                double[] probability;
                block3: {
                    Tuple4 tuple4;
                    block2: {
                        tuple4 = x0$2;
                        if (tuple4 == null) break block2;
                        double prediction = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                        double label = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                        probability = (double[])tuple4._4();
                        d2 = prediction;
                        d = label;
                        if (true && probability != null) break block3;
                    }
                    throw new MatchError((Object)tuple4);
                }
                double[] dArray = probability;
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)dArray);
                return tuple4;
            }, ClassTag$.MODULE$.apply(Tuple4.class));
            MulticlassMetrics metrics2 = new MulticlassMetrics(rdd2);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics2.logLoss(metrics2.logLoss$default$1())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.21616187468057912).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics2.logLoss(metrics2.logLoss$default$1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.21616187468057912).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }, new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("MulticlassMetrics supports multi-class log-loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq labels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 0.0, 1.0}));
            Seq probabilities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{{0.1, 0.8, 0.1}, {0.9, 0.05, 0.05}, {0.8, 0.2, 0.0}, {0.3, 0.65, 0.05}}));
            Seq weights = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.5, 2.0, 1.0, 0.5}));
            SparkContext qual$2 = this.sc();
            Seq x$3 = (Seq)((IterableLike)labels.zip((GenIterable)weights, Seq$.MODULE$.canBuildFrom())).zip((GenIterable)probabilities, Seq$.MODULE$.canBuildFrom());
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                double[] probability;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$3;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        probability = (double[])tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double label = tuple2._1$mcD$sp();
                double weight = tuple2._2$mcD$sp();
                double prediction = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probability)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probability)).max((Ordering)Ordering.Double$.MODULE$));
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)prediction), (Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)weight), (Object)probability);
                return tuple4;
            }, ClassTag$.MODULE$.apply(Tuple4.class));
            MulticlassMetrics metrics = new MulticlassMetrics(rdd);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.logLoss(metrics.logLoss$default$1())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.3529429766879466).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.logLoss(metrics.logLoss$default$1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(1.3529429766879466).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            RDD rdd2 = rdd.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                double d;
                double d2;
                double[] probability;
                block3: {
                    Tuple4 tuple4;
                    block2: {
                        tuple4 = x0$4;
                        if (tuple4 == null) break block2;
                        double prediction = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                        double label = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                        probability = (double[])tuple4._4();
                        d2 = prediction;
                        d = label;
                        if (true && probability != null) break block3;
                    }
                    throw new MatchError((Object)tuple4);
                }
                double[] dArray = probability;
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)dArray);
                return tuple4;
            }, ClassTag$.MODULE$.apply(Tuple4.class));
            MulticlassMetrics metrics2 = new MulticlassMetrics(rdd2);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics2.logLoss(metrics2.logLoss$default$1())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.9682005730687164).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics2.logLoss(metrics2.logLoss$default$1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.9682005730687164).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        }, new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("MulticlassMetrics supports hammingLoss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq preds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Seq labels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0, 3.0, 4.0}));
            Seq weights = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.5, 2.0, 1.0, 0.5}));
            SparkContext qual$3 = this.sc();
            Seq x$5 = (Seq)preds.zip((GenIterable)labels, Seq$.MODULE$.canBuildFrom());
            int x$6 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
            MulticlassMetrics metrics = new MulticlassMetrics(rdd);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.hammingLoss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.25).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics.hammingLoss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.25).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            SparkContext qual$4 = this.sc();
            Seq x$7 = (Seq)((IterableLike)preds.zip((GenIterable)labels, Seq$.MODULE$.canBuildFrom())).zip((GenIterable)weights, Seq$.MODULE$.canBuildFrom());
            int x$8 = qual$4.parallelize$default$2();
            RDD rdd2 = qual$4.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                double weight;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$5;
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        weight = tuple22._2$mcD$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double pred = tuple2._1$mcD$sp();
                double label = tuple2._2$mcD$sp();
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)pred), (Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)weight));
                return tuple3;
            }, ClassTag$.MODULE$.apply(Tuple3.class));
            MulticlassMetrics metrics2 = new MulticlassMetrics(rdd2);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics2.hammingLoss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3).relTol(this.delta())), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(metrics2.hammingLoss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.3).relTol(MulticlassMetricsSuite.this.delta))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        }, new Position("MulticlassMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }
}

