/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.feature.ChiSqSelectorModel$;
import org.apache.spark.mllib.feature.ChiSqSelectorSuite$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0003\u0006\u0001+!)\u0001\u0005\u0001C\u0001C!AA\u0005\u0001EC\u0002\u0013\u0005QeB\u00033\u0015!\u00051GB\u0003\n\u0015!\u0005A\u0007C\u0003!\t\u0011\u0005Q\u0007C\u00037\t\u0011\u0005q\u0007C\u0003<\t\u0011\u0005A\bC\u0004H\t\u0005\u0005I\u0011\u0002%\u0003%\rC\u0017nU9TK2,7\r^8s'VLG/\u001a\u0006\u0003\u00171\tqAZ3biV\u0014XM\u0003\u0002\u000e\u001d\u0005)Q\u000e\u001c7jE*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011\"\u0004\u0005\u0002\u001815\ta\"\u0003\u0002\u001a\u001d\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003?q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\u0015\u0005\u0019B.\u00192fY\u0016$G)[:de\u0016$X\rR1uCV\ta\u0005E\u0002(U1j\u0011\u0001\u000b\u0006\u0003S9\t1A\u001d3e\u0013\tY\u0003FA\u0002S\t\u0012\u0003\"!\f\u0019\u000e\u00039R!a\f\u0007\u0002\u0015I,wM]3tg&|g.\u0003\u00022]\taA*\u00192fY\u0016$\u0007k\\5oi\u0006\u00112\t[5TcN+G.Z2u_J\u001cV/\u001b;f!\t\u0019Ca\u0005\u0002\u0005-Q\t1'A\u0006de\u0016\fG/Z'pI\u0016dG#\u0001\u001d\u0011\u0005\rJ\u0014B\u0001\u001e\u000b\u0005I\u0019\u0005.[*r'\u0016dWm\u0019;pe6{G-\u001a7\u0002\u0015\rDWmY6FcV\fG\u000eF\u0002>\u0007\u0016\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\")Ai\u0002a\u0001q\u0005\t\u0011\rC\u0003G\u000f\u0001\u0007\u0001(A\u0001c\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0004PE*,7\r\u001e")
public class ChiSqSelectorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<LabeledPoint> labeledDiscreteData;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    public static void checkEqual(ChiSqSelectorModel chiSqSelectorModel, ChiSqSelectorModel chiSqSelectorModel2) {
        ChiSqSelectorSuite$.MODULE$.checkEqual(chiSqSelectorModel, chiSqSelectorModel2);
    }

    public static ChiSqSelectorModel createModel() {
        return ChiSqSelectorSuite$.MODULE$.createModel();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private RDD<LabeledPoint> labeledDiscreteData$lzycompute() {
        ChiSqSelectorSuite chiSqSelectorSuite = this;
        synchronized (chiSqSelectorSuite) {
            if (!this.bitmap$0) {
                this.labeledDiscreteData = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(6, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 6.0), new Tuple2.mcID.sp(1, 7.0), new Tuple2.mcID.sp(3, 7.0), new Tuple2.mcID.sp(4, 6.0)}))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(6, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 9.0), new Tuple2.mcID.sp(2, 6.0), new Tuple2.mcID.sp(4, 5.0), new Tuple2.mcID.sp(5, 9.0)}))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(6, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 9.0), new Tuple2.mcID.sp(2, 3.0), new Tuple2.mcID.sp(4, 5.0), new Tuple2.mcID.sp(5, 5.0)}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 8.0, 5.0, 6.0, 4.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 6.0, 5.0, 4.0, 4.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 6.0, 4.0, 0.0, 0.0}))})), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.bitmap$0 = true;
            }
        }
        return this.labeledDiscreteData;
    }

    public RDD<LabeledPoint> labeledDiscreteData() {
        return !this.bitmap$0 ? this.labeledDiscreteData$lzycompute() : this.labeledDiscreteData;
    }

    private final void testImplicits$lzycompute$1() {
        ChiSqSelectorSuite chiSqSelectorSuite = this;
        synchronized (chiSqSelectorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public ChiSqSelectorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("ChiSqSelector transform by numTopFeatures test (sparse & dense vector)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set preFilteredData = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(new double[]{6.0, 7.0, 7.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 5.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 5.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 4.0}))}));
            ChiSqSelectorModel model = new ChiSqSelector(3).fit(this.labeledDiscreteData());
            Set filteredData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.labeledDiscreteData().map((Function1 & Serializable & scala.Serializable)lp -> new LabeledPoint(lp.label(), model.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class)).collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(filteredData);
            Set $org_scalatest_assert_macro_right = preFilteredData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("ChiSqSelector transform by Percentile test (sparse & dense vector)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set preFilteredData = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(new double[]{6.0, 7.0, 7.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 5.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 5.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 4.0}))}));
            ChiSqSelectorModel model = new ChiSqSelector().setSelectorType("percentile").setPercentile(0.5).fit(this.labeledDiscreteData());
            Set filteredData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.labeledDiscreteData().map((Function1 & Serializable & scala.Serializable)lp -> new LabeledPoint(lp.label(), model.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class)).collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(filteredData);
            Set $org_scalatest_assert_macro_right = preFilteredData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("ChiSqSelector transform by FPR test (sparse & dense vector)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set preFilteredData = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(new double[]{6.0, 7.0, 7.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 0.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0, 5.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 5.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0, 4.0}))}));
            ChiSqSelectorModel model = new ChiSqSelector().setSelectorType("fpr").setFpr(0.15).fit(this.labeledDiscreteData());
            Set filteredData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.labeledDiscreteData().map((Function1 & Serializable & scala.Serializable)lp -> new LabeledPoint(lp.label(), model.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class)).collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(filteredData);
            Set $org_scalatest_assert_macro_right = preFilteredData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        }, new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("ChiSqSelector transform by FDR test (sparse & dense vector)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set preFilteredData = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(new double[]{6.0, 7.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0}))}));
            ChiSqSelectorModel model = new ChiSqSelector().setSelectorType("fdr").setFdr(0.15).fit(this.labeledDiscreteData());
            Set filteredData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.labeledDiscreteData().map((Function1 & Serializable & scala.Serializable)lp -> new LabeledPoint(lp.label(), model.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class)).collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(filteredData);
            Set $org_scalatest_assert_macro_right = preFilteredData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("ChiSqSelector transform by FWE test (sparse & dense vector)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Set preFilteredData = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(new double[]{6.0, 7.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(new double[]{0.0, 9.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0})), new LabeledPoint(2.0, Vectors$.MODULE$.dense(new double[]{8.0, 9.0}))}));
            ChiSqSelectorModel model = new ChiSqSelector().setSelectorType("fwe").setFwe(0.3).fit(this.labeledDiscreteData());
            Set filteredData = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.labeledDiscreteData().map((Function1 & Serializable & scala.Serializable)lp -> new LabeledPoint(lp.label(), model.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class)).collect())).toSet();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(filteredData);
            Set $org_scalatest_assert_macro_right = preFilteredData;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        }, new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            ChiSqSelectorModel model = ChiSqSelectorSuite$.MODULE$.createModel();
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                ChiSqSelectorModel sameModel = ChiSqSelectorModel$.MODULE$.load(this.sc(), path);
                ChiSqSelectorSuite$.MODULE$.checkEqual(model, sameModel);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("ChiSqSelectorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
    }
}

