/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.PCA;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.feature.PCAUtil$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0002\u0004\u0001#!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0018\u0001A\u0003%!\u0005\u0003\u00050\u0001!\u0015\r\u0011\"\u00031\u0005!\u00016)Q*vSR,'BA\u0004\t\u0003\u001d1W-\u0019;ve\u0016T!!\u0003\u0006\u0002\u000b5dG.\u001b2\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\"$D\u0001\u0019\u0015\tI\u0002\"\u0001\u0003vi&d\u0017BA\u000e\u0019\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0004\u0002\t\u0011\fG/Y\u000b\u0002EA\u00191E\n\u0015\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012Q!\u0011:sCf\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0005\u0002\r1Lg.\u00197h\u0013\ti#F\u0001\u0004WK\u000e$xN]\u0001\u0006I\u0006$\u0018\rI\u0001\bI\u0006$\u0018M\u0015#E+\u0005\t\u0004c\u0001\u001a6Q5\t1G\u0003\u00025\u0015\u0005\u0019!\u000f\u001a3\n\u0005Y\u001a$a\u0001*E\t\u0002")
public class PCASuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<Vector> dataRDD;
    private final Vector[] data;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private Vector[] data() {
        return this.data;
    }

    private RDD<Vector> dataRDD$lzycompute() {
        PCASuite pCASuite = this;
        synchronized (pCASuite) {
            if (!this.bitmap$0) {
                this.dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.data()), 2, ClassTag$.MODULE$.apply(Vector.class));
                this.bitmap$0 = true;
            }
        }
        this.data = null;
        return this.dataRDD;
    }

    private RDD<Vector> dataRDD() {
        return !this.bitmap$0 ? this.dataRDD$lzycompute() : this.dataRDD;
    }

    private final void testImplicits$lzycompute$1() {
        PCASuite pCASuite = this;
        synchronized (pCASuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$9(double firstValue$1, double values) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(values).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(firstValue$1).relTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(values).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(firstValue).relTol(1.0E-12))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    public PCASuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.data = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(3, 7.0)}))), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 3.0, 4.0, 5.0})), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 7.0}))});
        this.test("Correct computing use a PCA wrapper", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int k = (int)this.dataRDD().count();
            PCAModel pca = new PCA(k).fit(this.dataRDD());
            RowMatrix mat = new RowMatrix(this.dataRDD());
            Tuple2 tuple2 = mat.computePrincipalComponentsAndExplainedVariance(k);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Matrix pc = (Matrix)tuple2._1();
            Vector explainedVariance = (Vector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)pc, (Object)explainedVariance);
            Tuple2 tuple23 = tuple22;
            Matrix pc2 = (Matrix)tuple23._1();
            Vector explainedVariance2 = (Vector)tuple23._2();
            Vector[] pca_transform = (Vector[])pca.transform(this.dataRDD()).collect();
            Vector[] mat_multiply = (Vector[])mat.multiply(pc2).rows().collect();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pca_transform)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])mat_multiply), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector calculated = (Vector)tuple2._1();
                Vector expected = (Vector)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(calculated).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(calculated).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(1.0E-8))", Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
                return assertion;
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)pca.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(explainedVariance2).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(pca.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(explainedVariance).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        }, new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("memory cost computation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long $org_scalatest_assert_macro_left = PCAUtil$.MODULE$.memoryCost(10, 100);
            int $org_scalatest_assert_macro_right = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            long $org_scalatest_assert_macro_left2 = PCAUtil$.MODULE$.memoryCost(40000, 60000);
            int $org_scalatest_assert_macro_right2 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("number of features more than 65535", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD data1 = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(100000, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 2.0, ClassTag$.MODULE$.Double())), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(100000, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()))})), 2, ClassTag$.MODULE$.apply(Vector.class));
            PCAModel pca = new PCA(2).fit(data1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(pca.explainedVariance().values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 >= 0.0), "scala.Predef.doubleArrayOps(pca.explainedVariance.values).forall(((x$2: Double) => x$2.>=(0)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Math.sqrt(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(pca.pc().values())).slice(0, 100000))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> Math.pow(x$3, 2.0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(java.lang.Math.sqrt(scala.Predef.doubleArrayOps(scala.Predef.doubleArrayOps(scala.Predef.doubleArrayOps(pca.pc.values).slice(0, 100000)).map[Double, Array[Double]](((x$3: Double) => java.lang.Math.pow(x$3, 2.0)))(scala.this.Array.canBuildFrom[Double]((ClassTag.Double: scala.reflect.ClassTag[Double])))).sum[Double](math.this.Numeric.DoubleIsFractional))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-8))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pca.explainedVariance().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pca.explainedVariance.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-12))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            double firstValue = pca.pc().values()[0];
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(pca.pc().values())).slice(0, 100000))).map((Function1 & Serializable & scala.Serializable)values -> PCASuite.$anonfun$new$9(firstValue, BoxesRunTime.unboxToDouble((Object)values)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Assertion.class)));
        }, new Position("PCASuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
    }
}

