/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import java.util.Arrays;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.RandomRDDs;
import org.apache.spark.mllib.random.StringGenerator;
import org.apache.spark.mllib.random.UniformGenerator;
import org.junit.Assert;
import org.junit.Test;

public class JavaRandomRDDsSuite
extends SharedSparkSession {
    @Test
    public void testUniformRDD() {
        long m = 1000L;
        int p = 2;
        long seed = 1L;
        JavaDoubleRDD rdd1 = RandomRDDs.uniformJavaRDD((JavaSparkContext)this.jsc, (long)m);
        JavaDoubleRDD rdd2 = RandomRDDs.uniformJavaRDD((JavaSparkContext)this.jsc, (long)m, (int)p);
        JavaDoubleRDD rdd3 = RandomRDDs.uniformJavaRDD((JavaSparkContext)this.jsc, (long)m, (int)p, (long)seed);
        for (JavaDoubleRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
        }
    }

    @Test
    public void testNormalRDD() {
        long m = 1000L;
        int p = 2;
        long seed = 1L;
        JavaDoubleRDD rdd1 = RandomRDDs.normalJavaRDD((JavaSparkContext)this.jsc, (long)m);
        JavaDoubleRDD rdd2 = RandomRDDs.normalJavaRDD((JavaSparkContext)this.jsc, (long)m, (int)p);
        JavaDoubleRDD rdd3 = RandomRDDs.normalJavaRDD((JavaSparkContext)this.jsc, (long)m, (int)p, (long)seed);
        for (JavaDoubleRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
        }
    }

    @Test
    public void testLNormalRDD() {
        double mean = 4.0;
        double std = 2.0;
        long m = 1000L;
        int p = 2;
        long seed = 1L;
        JavaDoubleRDD rdd1 = RandomRDDs.logNormalJavaRDD((JavaSparkContext)this.jsc, (double)mean, (double)std, (long)m);
        JavaDoubleRDD rdd2 = RandomRDDs.logNormalJavaRDD((JavaSparkContext)this.jsc, (double)mean, (double)std, (long)m, (int)p);
        JavaDoubleRDD rdd3 = RandomRDDs.logNormalJavaRDD((JavaSparkContext)this.jsc, (double)mean, (double)std, (long)m, (int)p, (long)seed);
        for (JavaDoubleRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
        }
    }

    @Test
    public void testPoissonRDD() {
        double mean = 2.0;
        long m = 1000L;
        int p = 2;
        long seed = 1L;
        JavaDoubleRDD rdd1 = RandomRDDs.poissonJavaRDD((JavaSparkContext)this.jsc, (double)mean, (long)m);
        JavaDoubleRDD rdd2 = RandomRDDs.poissonJavaRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)p);
        JavaDoubleRDD rdd3 = RandomRDDs.poissonJavaRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)p, (long)seed);
        for (JavaDoubleRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
        }
    }

    @Test
    public void testExponentialRDD() {
        double mean = 2.0;
        long m = 1000L;
        int p = 2;
        long seed = 1L;
        JavaDoubleRDD rdd1 = RandomRDDs.exponentialJavaRDD((JavaSparkContext)this.jsc, (double)mean, (long)m);
        JavaDoubleRDD rdd2 = RandomRDDs.exponentialJavaRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)p);
        JavaDoubleRDD rdd3 = RandomRDDs.exponentialJavaRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)p, (long)seed);
        for (JavaDoubleRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
        }
    }

    @Test
    public void testGammaRDD() {
        double shape = 1.0;
        double jscale = 2.0;
        long m = 1000L;
        int p = 2;
        long seed = 1L;
        JavaDoubleRDD rdd1 = RandomRDDs.gammaJavaRDD((JavaSparkContext)this.jsc, (double)shape, (double)jscale, (long)m);
        JavaDoubleRDD rdd2 = RandomRDDs.gammaJavaRDD((JavaSparkContext)this.jsc, (double)shape, (double)jscale, (long)m, (int)p);
        JavaDoubleRDD rdd3 = RandomRDDs.gammaJavaRDD((JavaSparkContext)this.jsc, (double)shape, (double)jscale, (long)m, (int)p, (long)seed);
        for (JavaDoubleRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
        }
    }

    @Test
    public void testUniformVectorRDD() {
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.uniformJavaVectorRDD((JavaSparkContext)this.jsc, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.uniformJavaVectorRDD((JavaSparkContext)this.jsc, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.uniformJavaVectorRDD((JavaSparkContext)this.jsc, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }

    @Test
    public void testNormalVectorRDD() {
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.normalJavaVectorRDD((JavaSparkContext)this.jsc, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.normalJavaVectorRDD((JavaSparkContext)this.jsc, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.normalJavaVectorRDD((JavaSparkContext)this.jsc, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }

    @Test
    public void testLogNormalVectorRDD() {
        double mean = 4.0;
        double std = 2.0;
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.logNormalJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (double)std, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.logNormalJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (double)std, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.logNormalJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (double)std, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }

    @Test
    public void testPoissonVectorRDD() {
        double mean = 2.0;
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.poissonJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.poissonJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.poissonJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }

    @Test
    public void testExponentialVectorRDD() {
        double mean = 2.0;
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.exponentialJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.exponentialJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.exponentialJavaVectorRDD((JavaSparkContext)this.jsc, (double)mean, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }

    @Test
    public void testGammaVectorRDD() {
        double shape = 1.0;
        double jscale = 2.0;
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.gammaJavaVectorRDD((JavaSparkContext)this.jsc, (double)shape, (double)jscale, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.gammaJavaVectorRDD((JavaSparkContext)this.jsc, (double)shape, (double)jscale, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.gammaJavaVectorRDD((JavaSparkContext)this.jsc, (double)shape, (double)jscale, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }

    @Test
    public void testArbitrary() {
        long size = 10L;
        long seed = 1L;
        int numPartitions = 0;
        StringGenerator gen = new StringGenerator();
        JavaRDD rdd1 = RandomRDDs.randomJavaRDD((JavaSparkContext)this.jsc, (RandomDataGenerator)gen, (long)size);
        JavaRDD rdd2 = RandomRDDs.randomJavaRDD((JavaSparkContext)this.jsc, (RandomDataGenerator)gen, (long)size, (int)numPartitions);
        JavaRDD rdd3 = RandomRDDs.randomJavaRDD((JavaSparkContext)this.jsc, (RandomDataGenerator)gen, (long)size, (int)numPartitions, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)size, (long)rdd.count());
            Assert.assertEquals((long)2L, (long)((String)rdd.first()).length());
        }
    }

    @Test
    public void testRandomVectorRDD() {
        UniformGenerator generator = new UniformGenerator();
        long m = 100L;
        int n = 10;
        int p = 2;
        long seed = 1L;
        JavaRDD rdd1 = RandomRDDs.randomJavaVectorRDD((JavaSparkContext)this.jsc, (RandomDataGenerator)generator, (long)m, (int)n);
        JavaRDD rdd2 = RandomRDDs.randomJavaVectorRDD((JavaSparkContext)this.jsc, (RandomDataGenerator)generator, (long)m, (int)n, (int)p);
        JavaRDD rdd3 = RandomRDDs.randomJavaVectorRDD((JavaSparkContext)this.jsc, (RandomDataGenerator)generator, (long)m, (int)n, (int)p, (long)seed);
        for (JavaRDD rdd : Arrays.asList(rdd1, rdd2, rdd3)) {
            Assert.assertEquals((long)m, (long)rdd.count());
            Assert.assertEquals((long)n, (long)((Vector)rdd.first()).size());
        }
    }
}

