/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.feature.Normalizer;
import org.apache.spark.ml.feature.VectorIndexerSuite;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.sql.Dataset;
import org.junit.Test;

public class JavaNormalizerSuite
extends SharedSparkSession {
    @Test
    public void normalizer() {
        JavaRDD points = this.jsc.parallelize(Arrays.asList(new VectorIndexerSuite.FeatureData(Vectors.dense((double)0.0, (double[])new double[]{-2.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{3.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{4.0}))));
        Dataset dataFrame = this.spark.createDataFrame(points, VectorIndexerSuite.FeatureData.class);
        Normalizer normalizer = (Normalizer)((Normalizer)new Normalizer().setInputCol("features")).setOutputCol("normFeatures");
        Dataset l2NormData = normalizer.transform(dataFrame, normalizer.p().w(2.0), new ParamPair[0]);
        l2NormData.count();
        Dataset lInfNormData = normalizer.transform(dataFrame, normalizer.p().w(Double.POSITIVE_INFINITY), new ParamPair[0]);
        lInfNormData.count();
    }
}

