/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.feature.VectorSlicer;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;

public class JavaVectorSlicerSuite
extends SharedSparkSession {
    @Test
    public void vectorSlice() {
        Attribute[] attrs = new Attribute[]{NumericAttribute.defaultAttr().withName("f1"), NumericAttribute.defaultAttr().withName("f2"), NumericAttribute.defaultAttr().withName("f3")};
        AttributeGroup group = new AttributeGroup("userFeatures", attrs);
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.sparse((int)3, (int[])new int[]{0, 1}, (double[])new double[]{-2.0, 2.3})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3, 0.0})}));
        Dataset dataset = this.spark.createDataFrame(data, new StructType().add(group.toStructField()));
        VectorSlicer vectorSlicer = new VectorSlicer().setInputCol("userFeatures").setOutputCol("features");
        vectorSlicer.setIndices(new int[]{1}).setNames(new String[]{"f3"});
        Dataset output = vectorSlicer.transform(dataset);
        for (Row r : output.select("userFeatures", new String[]{"features"}).takeAsList(2)) {
            Vector features = (Vector)r.getAs(1);
            Assert.assertEquals((long)2L, (long)features.size());
        }
    }
}

