/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.OffsetInstance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquares;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresModel;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresSuite$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a4A\u0001E\t\u00019!)\u0011\u0006\u0001C\u0001U!IQ\u0006\u0001a\u0001\u0002\u0004%IA\f\u0005\nw\u0001\u0001\r\u00111A\u0005\nqB\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0018\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u0013q\u0003\"C$\u0001\u0001\u0004\u0005\r\u0011\"\u0003I\u0011%Q\u0005\u00011A\u0001B\u0003&q\u0006C\u0003L\u0001\u0011\u0005CjB\u0003N#!\u0005aJB\u0003\u0011#!\u0005q\nC\u0003*\u0015\u0011\u0005a\u000bC\u0003X\u0015\u0011\u0005\u0001\fC\u0003g\u0015\u0011\u0005q\rC\u0003k\u0015\u0011\u00051\u000eC\u0004o\u0015\u0005\u0005I\u0011B8\u0003M%#XM]1uSZ,G.\u001f*fo\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:Tk&$XM\u0003\u0002\u0013'\u0005)q\u000e\u001d;j[*\u0011A#F\u0001\u0003[2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\r\u0001Q$\t\t\u0003=}i\u0011!F\u0005\u0003AU\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011)H/\u001b7\u000b\u0005\u0019*\u0012!B7mY&\u0014\u0017B\u0001\u0015$\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\u0016\u0011\u00051\u0002Q\"A\t\u0002\u0015%t7\u000f^1oG\u0016\u001c\u0018'F\u00010!\r\u00014'N\u0007\u0002c)\u0011!'F\u0001\u0004e\u0012$\u0017B\u0001\u001b2\u0005\r\u0011F\t\u0012\t\u0003mej\u0011a\u000e\u0006\u0003qM\tqAZ3biV\u0014X-\u0003\u0002;o\tqqJ\u001a4tKRLen\u001d;b]\u000e,\u0017AD5ogR\fgnY3tc}#S-\u001d\u000b\u0003{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"9AiAA\u0001\u0002\u0004y\u0013a\u0001=%c\u0005Y\u0011N\\:uC:\u001cWm]\u0019!\u0003)Ign\u001d;b]\u000e,7OM\u0001\u000fS:\u001cH/\u00198dKN\u0014t\fJ3r)\ti\u0014\nC\u0004E\r\u0005\u0005\t\u0019A\u0018\u0002\u0017%t7\u000f^1oG\u0016\u001c(\u0007I\u0001\nE\u00164wN]3BY2$\u0012!P\u0001'\u0013R,'/\u0019;jm\u0016d\u0017PU3xK&<\u0007\u000e^3e\u0019\u0016\f7\u000f^*rk\u0006\u0014Xm]*vSR,\u0007C\u0001\u0017\u000b'\rQ\u0001k\u0015\t\u0003}EK!AU \u0003\r\u0005s\u0017PU3g!\tqD+\u0003\u0002V\u007f\ta1+\u001a:jC2L'0\u00192mKR\ta*\u0001\u000bCS:|W.[1m%\u0016<X-[4ii\u001a+hn\u0019\u000b\u00043~\u000b\u0007\u0003\u0002 [9rK!aW \u0003\rQ+\b\u000f\\33!\tqT,\u0003\u0002_\u007f\t1Ai\\;cY\u0016DQ\u0001\u0019\u0007A\u0002U\n\u0001\"\u001b8ti\u0006t7-\u001a\u0005\u0006E2\u0001\raY\u0001\u0006[>$W\r\u001c\t\u0003Y\u0011L!!Z\t\u00033]+\u0017n\u001a5uK\u0012dU-Y:u'F,\u0018M]3t\u001b>$W\r\\\u0001\u0014!>L7o]8o%\u0016<X-[4ii\u001a+hn\u0019\u000b\u00043\"L\u0007\"\u00021\u000e\u0001\u0004)\u0004\"\u00022\u000e\u0001\u0004\u0019\u0017\u0001\u0007'2%\u0016<'/Z:tS>t'+Z<fS\u001eDGOR;oGR\u0019\u0011\f\\7\t\u000b\u0001t\u0001\u0019A\u001b\t\u000b\tt\u0001\u0019A2\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0005Y\u0006twMC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(AB(cU\u0016\u001cG\u000f")
public class IterativelyReweightedLeastSquaresSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<OffsetInstance> instances1;
    private RDD<OffsetInstance> instances2;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Tuple2<Object, Object> L1RegressionReweightFunc(OffsetInstance offsetInstance, WeightedLeastSquaresModel weightedLeastSquaresModel) {
        return IterativelyReweightedLeastSquaresSuite$.MODULE$.L1RegressionReweightFunc(offsetInstance, weightedLeastSquaresModel);
    }

    public static Tuple2<Object, Object> PoissonReweightFunc(OffsetInstance offsetInstance, WeightedLeastSquaresModel weightedLeastSquaresModel) {
        return IterativelyReweightedLeastSquaresSuite$.MODULE$.PoissonReweightFunc(offsetInstance, weightedLeastSquaresModel);
    }

    public static Tuple2<Object, Object> BinomialReweightFunc(OffsetInstance offsetInstance, WeightedLeastSquaresModel weightedLeastSquaresModel) {
        return IterativelyReweightedLeastSquaresSuite$.MODULE$.BinomialReweightFunc(offsetInstance, weightedLeastSquaresModel);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private RDD<OffsetInstance> instances1() {
        return this.instances1;
    }

    private void instances1_$eq(RDD<OffsetInstance> x$1) {
        this.instances1 = x$1;
    }

    private RDD<OffsetInstance> instances2() {
        return this.instances2;
    }

    private void instances2_$eq(RDD<OffsetInstance> x$1) {
        this.instances2 = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances1_$eq((RDD<OffsetInstance>)this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetInstance[]{new OffsetInstance(1.0, 1.0, 0.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new OffsetInstance(0.0, 2.0, 0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new OffsetInstance(1.0, 3.0, 0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new OffsetInstance(0.0, 4.0, 0.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0})))})), 2, ClassTag$.MODULE$.apply(OffsetInstance.class)));
        this.instances2_$eq((RDD<OffsetInstance>)this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetInstance[]{new OffsetInstance(2.0, 1.0, 0.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new OffsetInstance(8.0, 2.0, 0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), new OffsetInstance(3.0, 3.0, 0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), new OffsetInstance(9.0, 4.0, 0.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0})))})), 2, ClassTag$.MODULE$.apply(OffsetInstance.class)));
    }

    private final void testImplicits$lzycompute$1() {
        IterativelyReweightedLeastSquaresSuite iterativelyReweightedLeastSquaresSuite = this;
        synchronized (iterativelyReweightedLeastSquaresSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(IterativelyReweightedLeastSquaresSuite $this, Seq expected$1, IntRef idx$1, boolean fitIntercept) {
        RDD newInstances = $this.instances1().map((Function1 & Serializable & scala.Serializable)instance -> {
            double mu = (instance.label() + 0.5) / 2.0;
            double eta = package$.MODULE$.log(mu / (1.0 - mu));
            return new Instance(eta, instance.weight(), instance.features());
        }, ClassTag$.MODULE$.apply(Instance.class));
        WeightedLeastSquares qual$1 = new WeightedLeastSquares(fitIntercept, 0.0, 0.0, false, false, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
        RDD x$1 = newInstances;
        OptionalInstrumentation x$2 = qual$1.fit$default$2();
        int x$3 = qual$1.fit$default$3();
        WeightedLeastSquaresModel initial = qual$1.fit(x$1, x$2, x$3);
        IterativelyReweightedLeastSquares qual$2 = new IterativelyReweightedLeastSquares(initial, (Function2 & Serializable & scala.Serializable)(instance, model) -> IterativelyReweightedLeastSquaresSuite$.MODULE$.BinomialReweightFunc((OffsetInstance)instance, (WeightedLeastSquaresModel)model), fitIntercept, 0.0, 25, 1.0E-8);
        RDD<OffsetInstance> x$4 = $this.instances1();
        OptionalInstrumentation x$5 = qual$2.fit$default$2();
        int x$6 = qual$2.fit$default$3();
        IterativelyReweightedLeastSquaresModel irls = qual$2.fit(x$4, x$5, x$6);
        Vector actual = Vectors$.MODULE$.dense(irls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{irls.coefficients().apply(0), irls.coefficients().apply(1)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$1.apply(idx$1.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IterativelyReweightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        ++idx$1.elem;
    }

    public static final /* synthetic */ void $anonfun$new$6(IterativelyReweightedLeastSquaresSuite $this, Seq expected$2, IntRef idx$2, boolean fitIntercept) {
        double yMean = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions($this.instances2().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.label()), ClassTag$.MODULE$.Double())).mean();
        RDD newInstances = $this.instances2().map((Function1 & Serializable & scala.Serializable)instance -> {
            double mu = (instance.label() + yMean) / 2.0;
            double eta = package$.MODULE$.log(mu);
            return new Instance(eta, instance.weight(), instance.features());
        }, ClassTag$.MODULE$.apply(Instance.class));
        WeightedLeastSquares qual$3 = new WeightedLeastSquares(fitIntercept, 0.0, 0.0, false, false, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
        RDD x$7 = newInstances;
        OptionalInstrumentation x$8 = qual$3.fit$default$2();
        int x$9 = qual$3.fit$default$3();
        WeightedLeastSquaresModel initial = qual$3.fit(x$7, x$8, x$9);
        IterativelyReweightedLeastSquares qual$4 = new IterativelyReweightedLeastSquares(initial, (Function2 & Serializable & scala.Serializable)(instance, model) -> IterativelyReweightedLeastSquaresSuite$.MODULE$.PoissonReweightFunc((OffsetInstance)instance, (WeightedLeastSquaresModel)model), fitIntercept, 0.0, 25, 1.0E-8);
        RDD<OffsetInstance> x$10 = $this.instances2();
        OptionalInstrumentation x$11 = qual$4.fit$default$2();
        int x$12 = qual$4.fit$default$3();
        IterativelyReweightedLeastSquaresModel irls = qual$4.fit(x$10, x$11, x$12);
        Vector actual = Vectors$.MODULE$.dense(irls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{irls.coefficients().apply(0), irls.coefficients().apply(1)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$2.apply(idx$2.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IterativelyReweightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        ++idx$2.elem;
    }

    public static final /* synthetic */ void $anonfun$new$11(IterativelyReweightedLeastSquaresSuite $this, Seq expected$3, IntRef idx$3, boolean fitIntercept) {
        WeightedLeastSquares qual$5 = new WeightedLeastSquares(fitIntercept, 0.0, 0.0, false, false, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8());
        RDD x$13 = $this.instances2().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toInstance(), ClassTag$.MODULE$.apply(Instance.class));
        OptionalInstrumentation x$14 = qual$5.fit$default$2();
        int x$15 = qual$5.fit$default$3();
        WeightedLeastSquaresModel initial = qual$5.fit(x$13, x$14, x$15);
        IterativelyReweightedLeastSquares qual$6 = new IterativelyReweightedLeastSquares(initial, (Function2 & Serializable & scala.Serializable)(instance, model) -> IterativelyReweightedLeastSquaresSuite$.MODULE$.L1RegressionReweightFunc((OffsetInstance)instance, (WeightedLeastSquaresModel)model), fitIntercept, 0.0, 200, 1.0E-7);
        RDD<OffsetInstance> x$16 = $this.instances2();
        OptionalInstrumentation x$17 = qual$6.fit$default$2();
        int x$18 = qual$6.fit$default$3();
        IterativelyReweightedLeastSquaresModel irls = qual$6.fit(x$16, x$17, x$18);
        Vector actual = Vectors$.MODULE$.dense(irls.intercept(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{irls.coefficients().apply(0), irls.coefficients().apply(1)}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(actual).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)expected$3.apply(idx$3.elem)).absTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(actual).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected.apply(idx)).absTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IterativelyReweightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        ++idx$3.elem;
    }

    public IterativelyReweightedLeastSquaresSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("IRLS against GLM with Binomial errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.30216651, -0.04452045})), Vectors$.MODULE$.dense(3.5651651, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.2334085, -0.7348971}))}));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                IterativelyReweightedLeastSquaresSuite.$anonfun$new$2(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("IterativelyReweightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("IRLS against GLM with Poisson errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.09607792, 0.18375613})), Vectors$.MODULE$.dense(6.299947, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.324107, -1.081766}))}));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                IterativelyReweightedLeastSquaresSuite.$anonfun$new$6(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("IterativelyReweightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("IRLS against L1Regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.266667, 0.4})), Vectors$.MODULE$.dense(29.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{17.0, -5.5}))}));
            IntRef idx = IntRef.create((int)0);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)fitIntercept -> {
                IterativelyReweightedLeastSquaresSuite.$anonfun$new$11(this, expected, idx, BoxesRunTime.unboxToBoolean((Object)fitIntercept));
                return BoxedUnit.UNIT;
            });
        }, new Position("IterativelyReweightedLeastSquaresSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }
}

