/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BlockHingeAggregator;
import org.apache.spark.ml.optim.aggregator.HingeAggregator;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0005\n\u0001?!)A\u0006\u0001C\u0001[!I\u0001\u0007\u0001a\u0001\u0002\u0004%\t!\r\u0005\n}\u0001\u0001\r\u00111A\u0005\u0002}B\u0011\"\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001a\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0003\t\u0004\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u0011%q\u0005\u00011A\u0001B\u0003&!\u0007C\u0005Q\u0001\u0001\u0007\t\u0019!C\u0001c!I\u0011\u000b\u0001a\u0001\u0002\u0004%\tA\u0015\u0005\n)\u0002\u0001\r\u0011!Q!\nIB\u0011B\u0016\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0006\"\u0003.\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015q\u0006\u0001\"\u0003`\u0011\u0015\t\b\u0001\"\u0003s\u0005QA\u0015N\\4f\u0003\u001e<'/Z4bi>\u00148+^5uK*\u00111\u0003F\u0001\u000bC\u001e<'/Z4bi>\u0014(BA\u000b\u0017\u0003\u0015y\u0007\u000f^5n\u0015\t9\u0002$\u0001\u0002nY*\u0011\u0011DG\u0001\u0006gB\f'o\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001C\u0005\u0005\u0002\"E5\t\u0001$\u0003\u0002$1\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0003Sa\tQ!\u001c7mS\nL!a\u000b\u0014\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012A\f\t\u0003_\u0001i\u0011AE\u0001\nS:\u001cH/\u00198dKN,\u0012A\r\t\u0004gYBT\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0012a\u00024fCR,(/Z\u0005\u0003{i\u0012\u0001\"\u00138ti\u0006t7-Z\u0001\u000eS:\u001cH/\u00198dKN|F%Z9\u0015\u0005\u0001\u001b\u0005CA\u001aB\u0013\t\u0011EG\u0001\u0003V]&$\bb\u0002#\u0004\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0014AC5ogR\fgnY3tA!\u0012Aa\u0012\t\u0003g!K!!\u0013\u001b\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001G5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u0006a\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3`I\u0015\fHC\u0001!N\u0011\u001d!e!!AA\u0002I\n\u0011$\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:fA!\u0012qaR\u0001!S:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,g)\u001b7uKJ,G-\u0001\u0013j]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u00164\u0015\u000e\u001c;fe\u0016$w\fJ3r)\t\u00015\u000bC\u0004E\u0013\u0005\u0005\t\u0019\u0001\u001a\u0002C%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014XMR5mi\u0016\u0014X\r\u001a\u0011)\u0005)9\u0015!F:uC:$\u0017M\u001d3ju\u0016$\u0017J\\:uC:\u001cWm]\u0001\u001agR\fg\u000eZ1sI&TX\rZ%ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002A3\"9A\tDA\u0001\u0002\u0004\u0011\u0014AF:uC:$\u0017M\u001d3ju\u0016$\u0017J\\:uC:\u001cWm\u001d\u0011)\u000559\u0015!\u00032fM>\u0014X-\u00117m)\u0005\u0001\u0015\u0001E4fi:+w/Q4he\u0016<\u0017\r^8s)\u0011\u00017\r\u001a7\u0011\u0005=\n\u0017B\u00012\u0013\u0005=A\u0015N\\4f\u0003\u001e<'/Z4bi>\u0014\b\"\u0002\u0019\u0010\u0001\u0004\u0011\u0004\"B3\u0010\u0001\u00041\u0017\u0001D2pK\u001a4\u0017nY5f]R\u001c\bCA4k\u001b\u0005A'BA5\u0017\u0003\u0019a\u0017N\\1mO&\u00111\u000e\u001b\u0002\u0007-\u0016\u001cGo\u001c:\t\u000b5|\u0001\u0019\u00018\u0002\u0019\u0019LG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005Mz\u0017B\u000195\u0005\u001d\u0011un\u001c7fC:\fQcZ3u\u001d\u0016<(\t\\8dW\u0006;wM]3hCR|'\u000fF\u0002tm^\u0004\"a\f;\n\u0005U\u0014\"\u0001\u0006\"m_\u000e\\\u0007*\u001b8hK\u0006;wM]3hCR|'\u000fC\u0003f!\u0001\u0007a\rC\u0003n!\u0001\u0007a\u000e")
public class HingeAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] standardizedInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] standardizedInstances() {
        return this.standardizedInstances;
    }

    public void standardizedInstances_$eq(Instance[] x$1) {
        this.standardizedInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.standardizedInstances_$eq(this.standardize(this.instances()));
    }

    private HingeAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        MultiClassSummarizer ySummarizer = (MultiClassSummarizer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
        MultiClassSummarizer ySummarizer2 = (MultiClassSummarizer)tuple23._2();
        double[] featuresStd = featuresSummarizer2.std().toArray();
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new HingeAggregator(bcFeaturesStd, fitIntercept, bcCoefficients);
    }

    private BlockHingeAggregator getNewBlockAggregator(Vector coefficients, boolean fitIntercept) {
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new BlockHingeAggregator(fitIntercept, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        HingeAggregatorSuite hingeAggregatorSuite = this;
        synchronized (hingeAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$16(double[] stdCoef$1, double intercept$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        double w = instance.weight();
        Vector f = instance.features();
        double labelScaled = (double)2 * l - 1.0;
        double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$1), f) + intercept$1;
        double d = 1.0 > labelScaled * margin ? (1.0 - labelScaled * margin) * w : 0.0;
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$17(double[] coefArray$1, double intercept$1, double[] gradientCoef$1, double[] featuresStd$1, DoubleRef gradientIntercept$1, Instance x0$2) {
        BoxedUnit boxedUnit;
        Instance instance = x0$2;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double margin = BLAS$.MODULE$.dot(f, Vectors$.MODULE$.dense(coefArray$1)) + intercept$1;
            if (1.0 > ((double)2 * l - 1.0) * margin) {
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    gradientCoef$1[i] = gradientCoef$1[i] + f.apply(i) * -((double)2 * l - 1.0) * w / featuresStd$1[i];
                });
                gradientIntercept$1.elem += -((double)2 * l - 1.0) * w;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public HingeAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double[] interceptArray = new double[]{2.0};
            HingeAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true);
            return (IllegalArgumentException)this.withClue("HingeAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80)));
        }, new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double[] interceptArray = new double[]{2.0};
            HingeAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true);
            return (IllegalArgumentException)this.withClue("HingeAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92)));
        }, new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures + 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            HingeAggregator aggIntercept = this.getNewAggregator(this.instances(), coefWithIntercept, true);
            HingeAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefWithoutIntercept, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = numFeatures + 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("check correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SummarizerBuffer featuresSummarizer;
            int x$22;
            WrappedArray x$1;
            double[] coefArray = new double[]{1.0, 2.0};
            double intercept = 1.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$22 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizerBuffer = featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = summarizerBuffer;
            double[] featuresStd = featuresSummarizer2.std().toArray();
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            HingeAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd[i], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            double lossSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)HingeAggregatorSuite.$anonfun$new$16(stdCoef, intercept, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = lossSum / weightSum;
            double[] gradientCoef = new double[numFeatures];
            DoubleRef gradientIntercept = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HingeAggregatorSuite.$anonfun$new$17(coefArray, intercept, gradientCoef, featuresStd, gradientIntercept, x0$2);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{gradientIntercept.elem})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.standardizedInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceBlock[][]{blocks1, blocks2}))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BlockHingeAggregator blockAgg = this.getNewBlockAggregator(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> blockAgg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(blockAgg.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(blockAgg.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(blockAgg.gradient()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(blockAgg.gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                });
            });
        }, new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] binaryCoefArray = new double[]{1.0, 2.0};
            double intercept = 1.0;
            HingeAggregator aggConstantFeatureBinary = this.getNewAggregator(this.instancesConstantFeature(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(binaryCoefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeature())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureBinary.add(instance));
            HingeAggregator aggConstantFeatureBinaryFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(binaryCoefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureBinaryFiltered.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)aggConstantFeatureBinary.gradient().apply(0)));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            double $org_scalatest_assert_macro_left2 = aggConstantFeatureBinary.gradient().apply(1);
            double $org_scalatest_assert_macro_right2 = aggConstantFeatureBinaryFiltered.gradient().apply(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        }, new Position("HingeAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }
}

