/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.evaluation.MultilabelMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\t1R*\u001e7uS2\f'-\u001a7NKR\u0014\u0018nY:Tk&$XM\u0003\u0002\u0005\u000b\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00199\u0011!B7mY&\u0014'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aD\n\u0011\u0005A\tR\"A\u0004\n\u0005I9!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\u000b\u0005!Q\u000f^5m\u0013\tARCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0019\u0001")
public class MultilabelMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        MultilabelMetricsSuite multilabelMetricsSuite = this;
        synchronized (multilabelMetricsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public MultilabelMetricsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Multilabel evaluation metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int sumTp;
            RDD scoreAndLabels = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new double[]{0.0, 1.0}, (Object)new double[]{0.0, 2.0}), new Tuple2((Object)new double[]{0.0, 2.0}, (Object)new double[]{0.0, 1.0}), new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (Object)new double[]{0.0}), new Tuple2((Object)new double[]{2.0}, (Object)new double[]{2.0}), new Tuple2((Object)new double[]{2.0, 0.0}, (Object)new double[]{2.0, 0.0}), new Tuple2((Object)new double[]{0.0, 1.0, 2.0}, (Object)new double[]{0.0, 1.0}), new Tuple2((Object)new double[]{1.0}, (Object)new double[]{1.0, 2.0})})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            MultilabelMetrics metrics = new MultilabelMetrics(scoreAndLabels);
            double delta = 1.0E-5;
            double precision0 = 1.0;
            double precision1 = 0.6666666666666666;
            double precision2 = 0.5;
            double recall0 = 0.8;
            double recall1 = 0.6666666666666666;
            double recall2 = 0.5;
            double f1measure0 = (double)2 * precision0 * recall0 / (precision0 + recall0);
            double f1measure1 = (double)2 * precision1 * recall1 / (precision1 + recall1);
            double f1measure2 = (double)2 * precision2 * recall2 / (precision2 + recall2);
            int $org_scalatest_assert_macro_left = sumTp = 8;
            int $org_scalatest_assert_macro_right = 8;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            double microPrecisionClass = (double)sumTp / (double)11;
            double microRecallClass = (double)sumTp / (double)12;
            double microF1MeasureClass = 2.0 * (double)sumTp / ((double)2 * (double)sumTp + (double)4 + (double)3);
            double macroPrecisionDoc = 0.6666666666666665;
            double macroRecallDoc = 0.6428571428571428;
            double macroF1MeasureDoc = 0.638095238095238;
            double hammingLoss = 0.3333333333333333;
            double strictAccuracy = 0.2857142857142857;
            double accuracy = 0.5476190476190476;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision0).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(0.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(precision0).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision1).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(1.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(precision1).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(precision2).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision(2.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(precision2).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall0).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(0.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recall0).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall1).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(1.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recall1).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(recall2).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall(2.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recall2).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.f1Measure(0.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure0).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.f1Measure(0.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(f1measure0).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.f1Measure(1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure1).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.f1Measure(1.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(f1measure1).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.f1Measure(2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(f1measure2).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.f1Measure(2.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(f1measure2).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.microPrecision()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(microPrecisionClass).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.microPrecision).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(microPrecisionClass).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.microRecall()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(microRecallClass).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.microRecall).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(microRecallClass).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.microF1Measure()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(microF1MeasureClass).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.microF1Measure).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(microF1MeasureClass).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precision()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(macroPrecisionDoc).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precision).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(macroPrecisionDoc).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recall()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(macroRecallDoc).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recall).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(macroRecallDoc).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.f1Measure()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(macroF1MeasureDoc).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.f1Measure).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(macroF1MeasureDoc).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.hammingLoss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(hammingLoss).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.hammingLoss).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(hammingLoss).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.subsetAccuracy()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(strictAccuracy).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.subsetAccuracy).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(strictAccuracy).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.accuracy()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(accuracy).absTol(delta)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.accuracy).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(accuracy).absTol(delta))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(metrics.labels())).sameElements((GenIterable)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 2.0})), "scala.Predef.doubleArrayOps(metrics.labels).sameElements[Double](scala.Predef.wrapDoubleArray(scala.Array.apply(0.0, 1.0, 2.0)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        }, new Position("MultilabelMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
    }
}

