/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=3Aa\u0003\u0007\u0001/!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00039\u0003B\u0002\u0018\u0001A\u0003%\u0001\u0006C\u00050\u0001\u0001\u0007\t\u0019!C\u0001a!I\u0001\t\u0001a\u0001\u0002\u0004%\t!\u0011\u0005\n\u000f\u0002\u0001\r\u0011!Q!\nEB\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0003Q\u0005\"\u0003'\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011\u0015i\u0005\u0001\"\u0011O\u0005ui\u0015\r\u001e:jq\u001a\u000b7\r^8sSj\fG/[8o\u001b>$W\r\\*vSR,'BA\u0007\u000f\u00039\u0011XmY8n[\u0016tG-\u0019;j_:T!a\u0004\t\u0002\u000b5dG.\u001b2\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003AI!a\u0007\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ti\u0002%D\u0001\u001f\u0015\tyb\"\u0001\u0003vi&d\u0017BA\u0011\u001f\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0007\u0002\tI\fgn[\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t\u0019\u0011J\u001c;\u0002\u000bI\fgn\u001b\u0011\u0002\u0019U\u001cXM\u001d$fCR,(/Z:\u0016\u0003E\u00022AM\u001b8\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\r\u0011H\rZ\u0005\u0003mM\u00121A\u0015#E!\u0011I\u0003\b\u000b\u001e\n\u0005eR#A\u0002+va2,'\u0007E\u0002*wuJ!\u0001\u0010\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%r\u0014BA +\u0005\u0019!u.\u001e2mK\u0006\u0001Ro]3s\r\u0016\fG/\u001e:fg~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"!K\"\n\u0005\u0011S#\u0001B+oSRDqAR\u0003\u0002\u0002\u0003\u0007\u0011'A\u0002yIE\nQ\"^:fe\u001a+\u0017\r^;sKN\u0004\u0013\u0001\u00049s_\u00124U-\u0019;ve\u0016\u001c\u0018\u0001\u00059s_\u00124U-\u0019;ve\u0016\u001cx\fJ3r)\t\u00115\nC\u0004G\u0011\u0005\u0005\t\u0019A\u0019\u0002\u001bA\u0014x\u000e\u001a$fCR,(/Z:!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001C\u0001")
public class MatrixFactorizationModelSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int rank;
    private RDD<Tuple2<Object, double[]>> userFeatures;
    private RDD<Tuple2<Object, double[]>> prodFeatures;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public void userFeatures_$eq(RDD<Tuple2<Object, double[]>> x$1) {
        this.userFeatures = x$1;
    }

    public RDD<Tuple2<Object, double[]>> prodFeatures() {
        return this.prodFeatures;
    }

    public void prodFeatures_$eq(RDD<Tuple2<Object, double[]>> x$1) {
        this.prodFeatures = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        SparkContext qual$1 = this.sc();
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new double[]{1.0, 2.0}), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new double[]{3.0, 4.0})}));
        int x$2 = qual$1.parallelize$default$2();
        this.userFeatures_$eq((RDD<Tuple2<Object, double[]>>)qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)));
        SparkContext qual$2 = this.sc();
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new double[]{5.0, 6.0})}));
        int x$4 = qual$2.parallelize$default$2();
        this.prodFeatures_$eq((RDD<Tuple2<Object, double[]>>)qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    private final void testImplicits$lzycompute$1() {
        MatrixFactorizationModelSuite matrixFactorizationModelSuite = this;
        synchronized (matrixFactorizationModelSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    private static final Set collect$1(RDD features) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(features, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$1)).toSeq()).collect())).toSet();
    }

    public MatrixFactorizationModelSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.rank = 2;
        this.test("constructor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MatrixFactorizationModel model = new MatrixFactorizationModel(this.rank(), this.userFeatures(), this.prodFeatures());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(0, 2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(0, 2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.0).relTol(1.0E-14))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new MatrixFactorizationModel(1, this.userFeatures(), this.prodFeatures()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            SparkContext qual$1 = this.sc();
            Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new double[]{1.0}), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new double[]{3.0})}));
            int x$2 = qual$1.parallelize$default$2();
            RDD userFeatures1 = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new MatrixFactorizationModel(this.rank(), userFeatures1, this.prodFeatures()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            SparkContext qual$2 = this.sc();
            Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new double[]{5.0})}));
            int x$4 = qual$2.parallelize$default$2();
            RDD prodFeatures1 = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new MatrixFactorizationModel(this.rank(), this.userFeatures(), prodFeatures1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            MatrixFactorizationModel model = new MatrixFactorizationModel(this.rank(), this.userFeatures(), this.prodFeatures());
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                MatrixFactorizationModel newModel = MatrixFactorizationModel$.MODULE$.load(this.sc(), path);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.rank()));
                int $org_scalatest_assert_macro_right = this.rank();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(MatrixFactorizationModelSuite.collect$1(newModel.userFeatures()));
                Set $org_scalatest_assert_macro_right2 = MatrixFactorizationModelSuite.collect$1(this.userFeatures());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(MatrixFactorizationModelSuite.collect$1(newModel.productFeatures()));
                Set $org_scalatest_assert_macro_right3 = MatrixFactorizationModelSuite.collect$1(this.prodFeatures());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("invalid user and product", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MatrixFactorizationModel model = new MatrixFactorizationModel(this.rank(), this.userFeatures(), this.prodFeatures());
            this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> model.predict(5, 2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> model.predict(0, 5), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> model.recommendProducts(5, 2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> model.recommendUsers(5, 2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("batch predict API recommendProductsForUsers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MatrixFactorizationModel model = new MatrixFactorizationModel(this.rank(), this.userFeatures(), this.prodFeatures());
            int topK = 10;
            Map recommendations = RDD$.MODULE$.rddToPairRDDFunctions(model.recommendProductsForUsers(topK), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Rating.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)0)))[0].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(0).apply(0).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.0).relTol(1.0E-14))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)1)))[0].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(39.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(1).apply(0).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(39.0).relTol(1.0E-14))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("batch predict API recommendUsersForProducts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MatrixFactorizationModel model = new MatrixFactorizationModel(this.rank(), this.userFeatures(), this.prodFeatures());
            int topK = 10;
            Map recommendations = RDD$.MODULE$.rddToPairRDDFunctions(model.recommendUsersForProducts(topK), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Rating.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            int $org_scalatest_assert_macro_left = ((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[0].user();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[0].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(39.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(2).apply(0).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(39.0).relTol(1.0E-14))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            int $org_scalatest_assert_macro_left2 = ((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[1].user();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Rating[])recommendations.apply((Object)BoxesRunTime.boxToInteger((int)2)))[1].rating()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.0).relTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(recommendations.apply(2).apply(1).rating).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.0).relTol(1.0E-14))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("MatrixFactorizationModelSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }
}

