/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.Predict;
import org.apache.spark.mllib.tree.model.Split;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DecisionTreeSuite$
extends SparkFunSuite {
    public static DecisionTreeSuite$ MODULE$;
    private final int[] org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds;

    static {
        new DecisionTreeSuite$();
    }

    public void validateClassifier(DecisionTreeModel model, Seq<LabeledPoint> input, double requiredAccuracy) {
        double accuracy;
        Seq predictions = (Seq)input.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)model.predict(x.features())), Seq$.MODULE$.canBuildFrom());
        int numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DecisionTreeSuite$.$anonfun$validateClassifier$2(x0$1)));
        double $org_scalatest_assert_macro_left = accuracy = (double)(input.length() - numOffPredictions) / (double)input.length();
        double $org_scalatest_assert_macro_right = requiredAccuracy;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(54).append("validateClassifier calculated accuracy ").append(accuracy).append(" but required ").append(requiredAccuracy).append(".").toString(), Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
    }

    public void validateRegressor(DecisionTreeModel model, Seq<LabeledPoint> input, double requiredMSE) {
        double mse;
        Seq predictions = (Seq)input.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)model.predict(x.features())), Seq$.MODULE$.canBuildFrom());
        double squaredError = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)DecisionTreeSuite$.$anonfun$validateRegressor$2(x0$1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double $org_scalatest_assert_macro_left = mse = squaredError / (double)input.length();
        double $org_scalatest_assert_macro_right = requiredMSE;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(48).append("validateRegressor calculated MSE ").append(mse).append(" but required ").append(requiredMSE).append(".").toString(), Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPointsWithLabel0() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            LabeledPoint lp;
            arr$1[i] = lp = new LabeledPoint(0.0, Vectors$.MODULE$.dense((double)i, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1000.0 - (double)i})));
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPointsWithLabel1() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            LabeledPoint lp;
            arr$2[i] = lp = new LabeledPoint(1.0, Vectors$.MODULE$.dense((double)i, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{999.0 - (double)i})));
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPoints() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double label = i < 100 ? 0.0 : (i < 500 ? 1.0 : (i < 900 ? 0.0 : 1.0));
            arr$3[i] = new LabeledPoint(label, Vectors$.MODULE$.dense((double)i, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1000.0 - (double)i})));
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateCategoricalDataPoints() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            arr$4[i] = i < 600 ? new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))) : new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})));
        });
        return var1_1;
    }

    public List<LabeledPoint> generateCategoricalDataPointsAsJavaList() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.generateCategoricalDataPoints())).toList()).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateCategoricalDataPointsForMulticlass() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[3000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            arr$5[i] = i < 1000 ? new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : (i < 2000 ? new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))));
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateContinuousDataPointsForMulticlass() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[3000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            arr$6[i] = i < 2000 ? new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{i}))) : new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{i})));
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateCategoricalDataPointsForMulticlassForOrderedFeatures() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[3000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            arr$7[i] = i < 1001 ? new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : (i < 2000 ? new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))));
        });
        return var1_1;
    }

    private Node createLeafNode(int id) {
        return Node$.MODULE$.apply(id, new Predict(0.0, 1.0), 0.5, true);
    }

    private Node createInternalNode(int id, Enumeration.Value featureType, Node left, Node right) {
        Split split;
        Node node = Node$.MODULE$.apply(id, new Predict(0.0, 1.0), 0.5, false);
        Enumeration.Value value = featureType;
        Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            split = new Split(0, 0.5, featureType, List$.MODULE$.empty());
        } else {
            Enumeration.Value value4 = FeatureType$.MODULE$.Categorical();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                split = new Split(1, 0.0, featureType, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})));
            } else {
                throw new MatchError((Object)value);
            }
        }
        node.split_$eq((Option)new Some((Object)split));
        node.stats_$eq((Option)new Some((Object)new InformationGainStats(0.1, node.impurity(), left.impurity(), right.impurity(), left.predict(), right.predict())));
        node.leftNode_$eq((Option)new Some((Object)left));
        node.rightNode_$eq((Option)new Some((Object)right));
        return node;
    }

    public DecisionTreeModel createModel(Enumeration.Value algo) {
        Tuple2 tuple2 = new Tuple2((Object)this.createLeafNode(6), (Object)this.createLeafNode(7));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node node6 = (Node)tuple2._1();
        Node node7 = (Node)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)node6, (Object)node7);
        Tuple2 tuple23 = tuple22;
        Node node62 = (Node)tuple23._1();
        Node node72 = (Node)tuple23._2();
        Node node3 = this.createInternalNode(3, FeatureType$.MODULE$.Categorical(), node62, node72);
        Node node2 = this.createLeafNode(2);
        Node topNode = this.createInternalNode(1, FeatureType$.MODULE$.Continuous(), node2, node3);
        return new DecisionTreeModel(topNode, algo);
    }

    public int[] org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds() {
        return this.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds;
    }

    public void checkEqual(DecisionTreeModel a, DecisionTreeModel b) {
        try {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(a.algo());
            Enumeration.Value $org_scalatest_assert_macro_right = b.algo();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
            this.checkEqual(a.topNode(), b.topNode());
        }
        catch (Exception ex) {
            throw this.fail(new StringBuilder(76).append("checkEqual failed since the two trees were not identical.\nTREE A:\n").append(a.toDebugString()).append("\n").append("TREE B:\n").append(b.toDebugString()).append("\n").toString(), ex, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkEqual(Node a, Node b) {
        block13: {
            block12: {
                while (true) {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)a.id()));
                                    $org_scalatest_assert_macro_right = b.id();
                                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
                                    $org_scalatest_assert_macro_left = this.convertToEqualizer(a.predict());
                                    $org_scalatest_assert_macro_right = b.predict();
                                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
                                    $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)a.impurity()));
                                    $org_scalatest_assert_macro_right = b.impurity();
                                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
                                    $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)a.isLeaf()));
                                    $org_scalatest_assert_macro_right = b.isLeaf();
                                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
                                    $org_scalatest_assert_macro_left = this.convertToEqualizer(a.split());
                                    $org_scalatest_assert_macro_right = b.split();
                                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
                                    var23_20 = new Tuple2((Object)a.stats(), (Object)b.stats());
                                    if (var23_20 == null) break block8;
                                    var24_21 = (Option)var23_20._1();
                                    var25_22 = (Option)var23_20._2();
                                    if (!(var24_21 instanceof Some)) break block8;
                                    var26_23 = (Some)var24_21;
                                    aStats = (InformationGainStats)var26_23.value();
                                    if (!(var25_22 instanceof Some)) break block8;
                                    var28_25 = (Some)var25_22;
                                    bStats = (InformationGainStats)var28_25.value();
                                    $org_scalatest_assert_macro_left = this.convertToEqualizer(aStats);
                                    $org_scalatest_assert_macro_right = bStats;
                                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    var6_4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
                                    break block9;
                                }
                                if (var23_20 == null) ** GOTO lbl-1000
                                var33_30 = (Option)var23_20._1();
                                var34_31 = (Option)var23_20._2();
                                if (None$.MODULE$.equals(var33_30) && None$.MODULE$.equals(var34_31)) {
                                    var6_4 = BoxedUnit.UNIT;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    throw this.fail(new StringBuilder(59).append("Only one instance has stats defined. (a.stats: ").append(a.stats()).append(", ").append("b.stats: ").append(b.stats()).append(")").toString(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
                                }
                            }
                            var35_32 = new Tuple2((Object)a.leftNode(), (Object)b.leftNode());
                            if (var35_32 == null) break block10;
                            var36_33 = (Option)var35_32._1();
                            var37_34 = (Option)var35_32._2();
                            if (!(var36_33 instanceof Some)) break block10;
                            var38_35 = (Some)var36_33;
                            aNode = (Node)var38_35.value();
                            if (!(var37_34 instanceof Some)) break block10;
                            var40_37 = (Some)var37_34;
                            bNode = (Node)var40_37.value();
                            this.checkEqual(aNode, bNode);
                            var5_3 = BoxedUnit.UNIT;
                            break block11;
                        }
                        if (var35_32 == null) ** GOTO lbl-1000
                        var42_39 = (Option)var35_32._1();
                        var43_40 = (Option)var35_32._2();
                        if (None$.MODULE$.equals(var42_39) && None$.MODULE$.equals(var43_40)) {
                            var5_3 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            throw this.fail("Only one instance has leftNode defined. (a.leftNode: ${a.leftNode}, b.leftNode: ${b.leftNode})", new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
                        }
                    }
                    var44_41 = new Tuple2((Object)a.rightNode(), (Object)b.rightNode());
                    if (var44_41 == null) break;
                    var45_42 = (Option)var44_41._1();
                    var46_43 = (Option)var44_41._2();
                    if (!(var45_42 instanceof Some) || (aNode = (Node)(var47_44 = (Some)var45_42).value()) == null) break;
                    var49_46 = aNode;
                    if (!(var46_43 instanceof Some) || (bNode = (Node)(var50_47 = (Some)var46_43).value()) == null) break;
                    b = var52_49 = bNode;
                    a = var49_46;
                }
                if (var44_41 == null) break block12;
                var53_50 = (Option)var44_41._1();
                var54_51 = (Option)var44_41._2();
                if (None$.MODULE$.equals(var53_50) && None$.MODULE$.equals(var54_51)) break block13;
            }
            throw this.fail("Only one instance has rightNode defined. (a.rightNode: ${a.rightNode}, b.rightNode: ${b.rightNode})", new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        }
        var4_52 = BoxedUnit.UNIT;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateClassifier$2(Tuple2 x0$1) {
        LabeledPoint expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
        return bl;
    }

    public static final /* synthetic */ double $anonfun$validateRegressor$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        LabeledPoint expected = (LabeledPoint)tuple2._2();
        double err = prediction - expected.label();
        double d = err * err;
        return d;
    }

    private DecisionTreeSuite$() {
        MODULE$ = this;
        this.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds = new int[]{1, 2, 3, 6, 7};
    }
}

