/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.TestShuffleDataContext;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.Test;

public class NonShuffleFilesCleanupSuite {
    private Executor sameThreadExecutor = MoreExecutors.sameThreadExecutor();
    private TransportConf conf = new TransportConf("shuffle", (ConfigProvider)MapConfigProvider.EMPTY);
    private static final String SORT_MANAGER = "org.apache.spark.shuffle.sort.SortShuffleManager";
    private static FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(".index") && !name.endsWith(".data");
        }
    };

    @Test
    public void cleanupOnRemovedExecutorWithShuffleFiles() throws IOException {
        this.cleanupOnRemovedExecutor(true);
    }

    @Test
    public void cleanupOnRemovedExecutorWithoutShuffleFiles() throws IOException {
        this.cleanupOnRemovedExecutor(false);
    }

    private void cleanupOnRemovedExecutor(boolean withShuffleFiles) throws IOException {
        TestShuffleDataContext dataContext = NonShuffleFilesCleanupSuite.initDataContext(withShuffleFiles);
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext.createExecutorInfo(SORT_MANAGER));
        resolver.executorRemoved("exec0", "app");
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext);
    }

    @Test
    public void cleanupUsesExecutorWithShuffleFiles() throws IOException {
        this.cleanupUsesExecutor(true);
    }

    @Test
    public void cleanupUsesExecutorWithoutShuffleFiles() throws IOException {
        this.cleanupUsesExecutor(false);
    }

    private void cleanupUsesExecutor(boolean withShuffleFiles) throws IOException {
        TestShuffleDataContext dataContext = NonShuffleFilesCleanupSuite.initDataContext(withShuffleFiles);
        AtomicBoolean cleanupCalled = new AtomicBoolean(false);
        Executor noThreadExecutor = runnable -> cleanupCalled.set(true);
        ExternalShuffleBlockResolver manager = new ExternalShuffleBlockResolver(this.conf, null, noThreadExecutor);
        manager.registerExecutor("app", "exec0", dataContext.createExecutorInfo(SORT_MANAGER));
        manager.executorRemoved("exec0", "app");
        Assert.assertTrue((boolean)cleanupCalled.get());
        NonShuffleFilesCleanupSuite.assertStillThere(dataContext);
    }

    @Test
    public void cleanupOnlyRemovedExecutorWithShuffleFiles() throws IOException {
        this.cleanupOnlyRemovedExecutor(true);
    }

    @Test
    public void cleanupOnlyRemovedExecutorWithoutShuffleFiles() throws IOException {
        this.cleanupOnlyRemovedExecutor(false);
    }

    private void cleanupOnlyRemovedExecutor(boolean withShuffleFiles) throws IOException {
        TestShuffleDataContext dataContext0 = NonShuffleFilesCleanupSuite.initDataContext(withShuffleFiles);
        TestShuffleDataContext dataContext1 = NonShuffleFilesCleanupSuite.initDataContext(withShuffleFiles);
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext0.createExecutorInfo(SORT_MANAGER));
        resolver.registerExecutor("app", "exec1", dataContext1.createExecutorInfo(SORT_MANAGER));
        resolver.executorRemoved("exec-nonexistent", "app");
        NonShuffleFilesCleanupSuite.assertStillThere(dataContext0);
        NonShuffleFilesCleanupSuite.assertStillThere(dataContext1);
        resolver.executorRemoved("exec0", "app");
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext0);
        NonShuffleFilesCleanupSuite.assertStillThere(dataContext1);
        resolver.executorRemoved("exec1", "app");
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext0);
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext1);
        resolver.executorRemoved("exec1", "app");
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext0);
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext1);
    }

    @Test
    public void cleanupOnlyRegisteredExecutorWithShuffleFiles() throws IOException {
        this.cleanupOnlyRegisteredExecutor(true);
    }

    @Test
    public void cleanupOnlyRegisteredExecutorWithoutShuffleFiles() throws IOException {
        this.cleanupOnlyRegisteredExecutor(false);
    }

    private void cleanupOnlyRegisteredExecutor(boolean withShuffleFiles) throws IOException {
        TestShuffleDataContext dataContext = NonShuffleFilesCleanupSuite.initDataContext(withShuffleFiles);
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext.createExecutorInfo(SORT_MANAGER));
        resolver.executorRemoved("exec1", "app");
        NonShuffleFilesCleanupSuite.assertStillThere(dataContext);
        resolver.executorRemoved("exec0", "app");
        NonShuffleFilesCleanupSuite.assertCleanedUp(dataContext);
    }

    private static void assertStillThere(TestShuffleDataContext dataContext) {
        for (String localDir : dataContext.localDirs) {
            Assert.assertTrue((String)(localDir + " was cleaned up prematurely"), (boolean)new File(localDir).exists());
        }
    }

    private static boolean assertOnlyShuffleDataInDir(File[] dirs) {
        for (File dir : dirs) {
            Assert.assertTrue((String)(dir.getName() + " wasn't cleaned up"), (!dir.exists() || dir.listFiles(filter).length == 0 || NonShuffleFilesCleanupSuite.assertOnlyShuffleDataInDir(dir.listFiles()) ? 1 : 0) != 0);
        }
        return true;
    }

    private static void assertCleanedUp(TestShuffleDataContext dataContext) {
        for (String localDir : dataContext.localDirs) {
            File[] dirs = new File[]{new File(localDir)};
            NonShuffleFilesCleanupSuite.assertOnlyShuffleDataInDir(dirs);
        }
    }

    private static TestShuffleDataContext initDataContext(boolean withShuffleFiles) throws IOException {
        if (withShuffleFiles) {
            return NonShuffleFilesCleanupSuite.initDataContextWithShuffleFiles();
        }
        return NonShuffleFilesCleanupSuite.initDataContextWithoutShuffleFiles();
    }

    private static TestShuffleDataContext initDataContextWithShuffleFiles() throws IOException {
        TestShuffleDataContext dataContext = NonShuffleFilesCleanupSuite.createDataContext();
        NonShuffleFilesCleanupSuite.createShuffleFiles(dataContext);
        NonShuffleFilesCleanupSuite.createNonShuffleFiles(dataContext);
        return dataContext;
    }

    private static TestShuffleDataContext initDataContextWithoutShuffleFiles() throws IOException {
        TestShuffleDataContext dataContext = NonShuffleFilesCleanupSuite.createDataContext();
        NonShuffleFilesCleanupSuite.createNonShuffleFiles(dataContext);
        return dataContext;
    }

    private static TestShuffleDataContext createDataContext() {
        TestShuffleDataContext dataContext = new TestShuffleDataContext(10, 5);
        dataContext.create();
        return dataContext;
    }

    private static void createShuffleFiles(TestShuffleDataContext dataContext) throws IOException {
        Random rand = new Random(123L);
        dataContext.insertSortShuffleData(rand.nextInt(1000), rand.nextInt(1000), new byte[][]{"ABC".getBytes(StandardCharsets.UTF_8), "DEF".getBytes(StandardCharsets.UTF_8)});
    }

    private static void createNonShuffleFiles(TestShuffleDataContext dataContext) throws IOException {
        dataContext.insertSpillData();
    }
}

