/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.LockUpgradeException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.RootINodeCache;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.sparkproject.guava.base.Predicate;
import org.sparkproject.guava.collect.Lists;
import org.sparkproject.guava.primitives.Longs;

public class INodeContext
extends BaseEntityContext<Long, INode> {
    protected static final Log LOG = LogFactory.getLog(INodeContext.class);
    private final INodeDataAccess<INode> dataAccess;
    private final Map<String, INode> inodesNameParentIndex = new HashMap<String, INode>();
    private final Map<Long, List<INode>> inodesParentIndex = new HashMap<Long, List<INode>>();
    private final List<INode> renamedInodes = new ArrayList<INode>();

    public INodeContext(INodeDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.inodesNameParentIndex.clear();
        this.inodesParentIndex.clear();
        this.renamedInodes.clear();
    }

    public INode find(FinderType<INode> finder, Object ... params) throws TransactionContextException, StorageException {
        INode.Finder iFinder = (INode.Finder)finder;
        switch (iFinder) {
            case ByINodeIdFTIS: {
                return this.findByInodeIdFTIS(iFinder, params);
            }
            case ByNameParentIdAndPartitionId: {
                return this.findByNameParentIdAndPartitionIdPK(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<INode> findList(FinderType<INode> finder, Object ... params) throws TransactionContextException, StorageException {
        INode.Finder iFinder = (INode.Finder)finder;
        switch (iFinder) {
            case ByParentIdFTIS: {
                return this.findByParentIdFTIS(iFinder, params);
            }
            case ByParentIdAndPartitionId: {
                return this.findByParentIdAndPartitionIdPPIS(iFinder, params);
            }
            case ByNamesParentIdsAndPartitionIds: {
                return this.findBatch(iFinder, params);
            }
            case ByNamesParentIdsAndPartitionIdsCheckLocal: {
                return this.findBatchWithLocalCacheCheck(iFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public void remove(INode iNode) throws TransactionContextException {
        super.remove((Object)iNode);
        this.inodesNameParentIndex.remove(iNode.nameParentKey());
        if (this.isLogTraceEnabled()) {
            this.log("removed-inode", new Object[]{"id", iNode.getId(), "name", iNode.getLocalName(), "parent_id", iNode.getParentId(), "partition_id", iNode.getPartitionId()});
        }
    }

    public void update(INode iNode) throws TransactionContextException {
        super.update((Object)iNode);
        this.inodesNameParentIndex.put(iNode.nameParentKey(), iNode);
        if (this.isLogTraceEnabled()) {
            this.log("updated-inode", new Object[]{"id", iNode.getId(), "name", iNode.getLocalName(), "parent_id", iNode.getParentId(), "partition_id", iNode.getPartitionId()});
        }
    }

    public void prepare(TransactionLocks lks) throws TransactionContextException, StorageException {
        boolean refreshRootCache;
        Collection removed = this.getRemoved();
        ArrayList<INode> added = new ArrayList<INode>(this.getAdded());
        added.addAll(this.renamedInodes);
        Collection modified = this.getModified();
        if (lks.containsLock(Lock.Type.INode)) {
            TransactionLockTypes.INodeLockType lock;
            BaseINodeLock hlk = (BaseINodeLock)lks.getLock(Lock.Type.INode);
            if (!removed.isEmpty()) {
                for (INode inode2 : removed) {
                    lock = hlk.getLockedINodeLockType(inode2);
                    if (lock == null || lock == TransactionLockTypes.INodeLockType.WRITE || lock == TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT) continue;
                    throw new LockUpgradeException("Trying to remove inode id=" + inode2.getId() + " acquired lock was " + lock);
                }
            }
            if (!modified.isEmpty()) {
                for (INode inode2 : modified) {
                    lock = hlk.getLockedINodeLockType(inode2);
                    if (lock == null || lock == TransactionLockTypes.INodeLockType.WRITE || lock == TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT) continue;
                    throw new LockUpgradeException("Trying to update inode id=" + inode2.getId() + " acquired lock was " + lock);
                }
            }
        }
        boolean bl = refreshRootCache = RootINodeCache.isRootInCache() && (modified.stream().filter(inode -> inode.isRoot()).count() > 0L || added.stream().filter(inode -> inode.isRoot()).count() > 0L);
        if (refreshRootCache) {
            LOG.trace((Object)"Root Inode has been updated, force RootINodeCache to refresh");
            RootINodeCache.forceRefresh();
        }
        this.dataAccess.prepare(removed, added, modified);
    }

    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        HdfsTransactionContextMaintenanceCmds hopCmds = (HdfsTransactionContextMaintenanceCmds)cmds;
        switch (hopCmds) {
            case INodePKChanged: {
                INode inodeBeforeChange = (INode)params[0];
                INode inodeAfterChange = (INode)params[1];
                super.remove((Object)inodeBeforeChange);
                try {
                    inodeAfterChange.setPartitionIdNoPersistance(INode.calculatePartitionId(inodeAfterChange.getParentId(), inodeAfterChange.getLocalName(), inodeAfterChange.myDepth()));
                }
                catch (StorageException e) {
                    throw new TransactionContextException((Throwable)e);
                }
                this.renamedInodes.add(inodeAfterChange);
                if (!this.isLogTraceEnabled()) break;
                this.log("removed-inode-snapshot-maintenance", new Object[]{"id", inodeBeforeChange.getId(), "name", inodeBeforeChange.getLocalName(), "parent_id", inodeBeforeChange.getParentId(), "partition_id", inodeBeforeChange.getPartitionId()});
                this.log("added-inode-snapshot-maintenance", new Object[]{"id", inodeAfterChange.getId(), "name", inodeAfterChange.getLocalName(), "parent_id", inodeAfterChange.getParentId(), "partition_id", inodeAfterChange.getPartitionId()});
                break;
            }
        }
    }

    Long getKey(INode iNode) {
        return iNode.getId();
    }

    private INode findByInodeIdFTIS(INode.Finder inodeFinder, Object[] params) throws TransactionContextException, StorageException {
        INode result = null;
        Long inodeId = (Long)params[0];
        if (this.contains(inodeId)) {
            result = (INode)this.get(inodeId);
            if (result != null) {
                this.hit(inodeFinder, result, new Object[]{"id", inodeId, "name", result.getLocalName(), "parent_id", result.getParentId(), "partition_id", result.getPartitionId()});
            } else {
                this.hit(inodeFinder, result, new Object[]{"id", inodeId});
            }
        } else {
            this.aboutToAccessStorage(inodeFinder, params);
            result = (INode)this.dataAccess.findInodeByIdFTIS(inodeId.longValue());
            this.gotFromDB(inodeId, result);
            if (result != null) {
                this.inodesNameParentIndex.put(result.nameParentKey(), result);
                this.miss(inodeFinder, result, new Object[]{"id", inodeId, "name", result.getLocalName(), "parent_id", result.getParentId(), "partition_id", result.getPartitionId()});
            } else {
                this.miss(inodeFinder, result, new Object[]{"id"});
            }
        }
        return result;
    }

    private INode findByNameParentIdAndPartitionIdPK(INode.Finder inodeFinder, Object[] params) throws TransactionContextException, StorageException {
        String nameParentKey;
        INode result = null;
        String name = (String)params[0];
        Long parentId = (Long)params[1];
        Long partitionId = (Long)params[2];
        Long possibleInodeId = null;
        if (params.length == 4) {
            possibleInodeId = (Long)params[3];
        }
        if (this.inodesNameParentIndex.containsKey(nameParentKey = INode.nameParentKey(parentId, name))) {
            result = this.inodesNameParentIndex.get(nameParentKey);
            if (!this.preventStorageCalls() && currentLockMode.get() == EntityContext.LockMode.WRITE_LOCK) {
                this.aboutToAccessStorage(inodeFinder, params);
                result = (INode)this.dataAccess.findInodeByNameParentIdAndPartitionIdPK(name, parentId.longValue(), partitionId.longValue());
                this.gotFromDBWithPossibleInodeId(result, possibleInodeId);
                this.inodesNameParentIndex.put(nameParentKey, result);
                this.missUpgrade(inodeFinder, result, new Object[]{"name", name, "parent_id", parentId, "partition_id", partitionId});
            } else {
                this.hit(inodeFinder, result, new Object[]{"name", name, "parent_id", parentId, "partition_id", partitionId});
            }
        } else if (!this.isNewlyAdded(parentId) && !this.containsRemoved(parentId, name)) {
            if (this.canReadCachedRootINode(name, parentId)) {
                result = RootINodeCache.getRootINode();
                LOG.trace((Object)("Reading root inode from the cache. " + result));
            } else {
                this.aboutToAccessStorage(inodeFinder, params);
                result = (INode)this.dataAccess.findInodeByNameParentIdAndPartitionIdPK(name, parentId.longValue(), partitionId.longValue());
            }
            this.gotFromDBWithPossibleInodeId(result, possibleInodeId);
            this.inodesNameParentIndex.put(nameParentKey, result);
            this.miss(inodeFinder, result, new Object[]{"name", name, "parent_id", parentId, "partition_id", partitionId, "possible_inode_id", possibleInodeId});
        }
        return result;
    }

    private List<INode> findByParentIdFTIS(INode.Finder inodeFinder, Object[] params) throws TransactionContextException, StorageException {
        Long parentId = (Long)params[0];
        List<INode> result = null;
        if (this.inodesParentIndex.containsKey(parentId)) {
            result = this.inodesParentIndex.get(parentId);
            this.hit(inodeFinder, result, new Object[]{"parent_id", parentId});
        } else {
            this.aboutToAccessStorage(inodeFinder, params);
            result = this.syncInodeInstances(this.dataAccess.findInodesByParentIdFTIS(parentId.longValue()));
            this.inodesParentIndex.put(parentId, result);
            this.miss(inodeFinder, result, new Object[]{"parent_id", parentId});
        }
        return result;
    }

    private List<INode> findByParentIdAndPartitionIdPPIS(INode.Finder inodeFinder, Object[] params) throws TransactionContextException, StorageException {
        Long parentId = (Long)params[0];
        Long partitionId = (Long)params[1];
        List<INode> result = null;
        if (this.inodesParentIndex.containsKey(parentId)) {
            result = this.inodesParentIndex.get(parentId);
            this.hit(inodeFinder, result, new Object[]{"parent_id", parentId, "partition_id", partitionId});
        } else {
            this.aboutToAccessStorage(inodeFinder, params);
            result = this.syncInodeInstances(this.dataAccess.findInodesByParentIdAndPartitionIdPPIS(parentId.longValue(), partitionId.longValue()));
            this.inodesParentIndex.put(parentId, result);
            this.miss(inodeFinder, result, new Object[]{"parent_id", parentId, "partition_id", partitionId});
        }
        return result;
    }

    private List<INode> findBatch(INode.Finder inodeFinder, Object[] params) throws TransactionContextException, StorageException {
        String[] names = (String[])params[0];
        long[] parentIds = (long[])params[1];
        long[] partitionIds = (long[])params[2];
        return this.findBatch(inodeFinder, names, parentIds, partitionIds);
    }

    private List<INode> findBatchWithLocalCacheCheck(INode.Finder inodeFinder, Object[] params) throws TransactionContextException, StorageException {
        String[] names = (String[])params[0];
        long[] parentIds = (long[])params[1];
        long[] partitionIds = (long[])params[2];
        ArrayList namesRest = Lists.newArrayList();
        ArrayList parentIdsRest = Lists.newArrayList();
        ArrayList partitionIdsRest = Lists.newArrayList();
        ArrayList unpopulatedIndeces = Lists.newArrayList();
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(names.length, null));
        for (int i = 0; i < names.length; ++i) {
            String nameParentKey = INode.nameParentKey(parentIds[i], names[i]);
            INode node = this.inodesNameParentIndex.get(nameParentKey);
            if (node != null) {
                result.set(i, node);
                this.hit(inodeFinder, node, new Object[]{"name", names[i], "parent_id", parentIds[i], "partition_id", partitionIds[i]});
                continue;
            }
            namesRest.add(names[i]);
            parentIdsRest.add(parentIds[i]);
            partitionIdsRest.add(partitionIds[i]);
            unpopulatedIndeces.add(i);
        }
        if (unpopulatedIndeces.isEmpty()) {
            return result;
        }
        if (unpopulatedIndeces.size() == names.length) {
            return this.findBatch(inodeFinder, names, parentIds, partitionIds);
        }
        List<INode> batch = this.findBatch(inodeFinder, namesRest.toArray(new String[namesRest.size()]), Longs.toArray((Collection)parentIdsRest), Longs.toArray((Collection)partitionIdsRest));
        ListIterator<INode> batchIterator = batch.listIterator();
        for (Integer i : unpopulatedIndeces) {
            if (!batchIterator.hasNext()) continue;
            result.set(i, batchIterator.next());
        }
        return result;
    }

    private List<INode> findBatch(INode.Finder inodeFinder, String[] names, long[] parentIds, long[] partitionIds) throws StorageException {
        INode rootINode = null;
        boolean addCachedRootInode = false;
        if (this.canReadCachedRootINode(names[0], parentIds[0]) && (rootINode = RootINodeCache.getRootINode()) != null && names[0].equals("") && parentIds[0] == 0L) {
            LOG.trace((Object)("Reading root inode from the cache " + rootINode));
            names = Arrays.copyOfRange(names, 1, names.length);
            parentIds = Arrays.copyOfRange(parentIds, 1, parentIds.length);
            partitionIds = Arrays.copyOfRange(partitionIds, 1, partitionIds.length);
            addCachedRootInode = true;
        }
        List batch = this.dataAccess.getINodesPkBatched(names, parentIds, partitionIds);
        this.miss(inodeFinder, batch, new Object[]{"names", Arrays.toString(names), "parent_ids", Arrays.toString(parentIds), "partition_ids", Arrays.toString(partitionIds)});
        if (rootINode != null && addCachedRootInode) {
            batch.add(0, rootINode);
        }
        return this.syncInodeInstances(batch);
    }

    private List<INode> syncInodeInstances(List<INode> newInodes) {
        ArrayList<INode> finalList = new ArrayList<INode>(newInodes.size());
        for (INode inode : newInodes) {
            if (this.isRemoved(inode.getId())) continue;
            this.gotFromDB(inode);
            finalList.add(inode);
            String key = inode.nameParentKey();
            if (this.inodesNameParentIndex.containsKey(key)) {
                if (this.inodesNameParentIndex.get(key) != null) continue;
                this.inodesNameParentIndex.put(key, inode);
                continue;
            }
            this.inodesNameParentIndex.put(key, inode);
        }
        Collections.sort(finalList, INode.Order.ByName);
        return finalList;
    }

    private boolean containsRemoved(final Long parentId, final String name) {
        return this.contains((Predicate)new Predicate<BaseEntityContext.ContextEntity>(){

            public boolean apply(BaseEntityContext.ContextEntity input) {
                INode iNode = (INode)input.getEntity();
                return input.getState() == BaseEntityContext.State.REMOVED && iNode.getParentId() == parentId.longValue() && iNode.getLocalName().equals(name);
            }
        });
    }

    private void gotFromDBWithPossibleInodeId(INode result, Long possibleInodeId) {
        if (result != null) {
            this.gotFromDB(result);
        }
        if (result == null && possibleInodeId != null || result != null && possibleInodeId != null && result.getId() != possibleInodeId.longValue()) {
            this.gotFromDB(possibleInodeId, null);
        }
    }

    private boolean canReadCachedRootINode(String name, long parentId) {
        if (name.equals("") && parentId == 0L) {
            return RootINodeCache.isRootInCache() && currentLockMode.get() == EntityContext.LockMode.READ_COMMITTED;
        }
        return false;
    }
}

