/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.collect.LinkedListMultimap;

class SocketCache {
    private static final Log LOG = LogFactory.getLog(SocketCache.class);
    private Daemon daemon;
    private static LinkedListMultimap<SocketAddress, SocketAndStreams> multimap = LinkedListMultimap.create();
    private static int capacity;
    private static long expiryPeriod;
    private static SocketCache scInstance;
    private static boolean isInitedOnce;

    SocketCache() {
    }

    public static synchronized SocketCache getInstance(int c, long e) {
        if (!isInitedOnce) {
            capacity = c;
            expiryPeriod = e;
            if (capacity == 0) {
                LOG.info((Object)"SocketCache disabled.");
            } else if (expiryPeriod == 0L) {
                throw new IllegalStateException("Cannot initialize expiryPeriod to " + expiryPeriod + "when cache is enabled.");
            }
            isInitedOnce = true;
        } else if (capacity != c || expiryPeriod != e) {
            LOG.info((Object)("capacity and expiry periods already set to " + capacity + " and " + expiryPeriod + " respectively. Cannot set it to " + c + " and " + e));
        }
        return scInstance;
    }

    private boolean isDaemonStarted() {
        return this.daemon != null;
    }

    private synchronized void startExpiryDaemon() {
        if (this.isDaemonStarted()) {
            return;
        }
        this.daemon = new Daemon(new Runnable(){

            @Override
            public void run() {
                try {
                    SocketCache.this.run();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    SocketCache.this.clear();
                }
            }

            public String toString() {
                return String.valueOf(SocketCache.this);
            }
        });
        this.daemon.start();
    }

    public synchronized SocketAndStreams get(SocketAddress remote) {
        if (capacity <= 0) {
            return null;
        }
        List sockStreamList = multimap.get((Object)remote);
        if (sockStreamList == null) {
            return null;
        }
        Iterator iter = sockStreamList.iterator();
        while (iter.hasNext()) {
            SocketAndStreams candidate = (SocketAndStreams)iter.next();
            iter.remove();
            if (candidate.sock.isClosed()) continue;
            return candidate;
        }
        return null;
    }

    public synchronized void put(Socket sock, IOStreamPair ioStreams) {
        Preconditions.checkNotNull((Object)sock);
        SocketAndStreams s = new SocketAndStreams(sock, ioStreams);
        if (capacity <= 0) {
            s.close();
            return;
        }
        this.startExpiryDaemon();
        SocketAddress remoteAddr = sock.getRemoteSocketAddress();
        if (remoteAddr == null) {
            LOG.warn((Object)("Cannot cache (unconnected) socket with no remote address: " + sock));
            IOUtils.closeSocket((Socket)sock);
            return;
        }
        if (capacity == multimap.size()) {
            this.evictOldest();
        }
        multimap.put((Object)remoteAddr, (Object)s);
    }

    public synchronized int size() {
        return multimap.size();
    }

    private synchronized void evictExpired(long expiryPeriod) {
        Iterator iter;
        Map.Entry entry;
        while (multimap.size() != 0 && (entry = (Map.Entry)(iter = multimap.entries().iterator()).next()) != null && Time.monotonicNow() - ((SocketAndStreams)entry.getValue()).getCreateTime() >= expiryPeriod) {
            iter.remove();
            SocketAndStreams s = (SocketAndStreams)entry.getValue();
            s.close();
        }
    }

    private synchronized void evictOldest() {
        Iterator iter = multimap.entries().iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Cannot evict from empty cache! capacity: " + capacity);
        }
        Map.Entry entry = (Map.Entry)iter.next();
        iter.remove();
        SocketAndStreams s = (SocketAndStreams)entry.getValue();
        s.close();
    }

    private void run() throws InterruptedException {
        long lastExpiryTime = Time.monotonicNow();
        while (!Thread.interrupted()) {
            long elapsed = Time.monotonicNow() - lastExpiryTime;
            if (elapsed >= expiryPeriod) {
                this.evictExpired(expiryPeriod);
                lastExpiryTime = Time.monotonicNow();
            }
            Thread.sleep(expiryPeriod);
        }
        this.clear();
        throw new InterruptedException("Daemon Interrupted");
    }

    @VisibleForTesting
    protected synchronized void clear() {
        for (SocketAndStreams sockAndStream : multimap.values()) {
            sockAndStream.close();
        }
        multimap.clear();
    }

    static {
        scInstance = new SocketCache();
        isInitedOnce = false;
    }

    @InterfaceAudience.Private
    static class SocketAndStreams
    implements Closeable {
        public final Socket sock;
        public final IOStreamPair ioStreams;
        long createTime;

        public SocketAndStreams(Socket s, IOStreamPair ioStreams) {
            this.sock = s;
            this.ioStreams = ioStreams;
            this.createTime = Time.monotonicNow();
        }

        @Override
        public void close() {
            if (this.ioStreams != null) {
                IOUtils.closeStream((Closeable)this.ioStreams.in);
                IOUtils.closeStream((Closeable)this.ioStreams.out);
            }
            IOUtils.closeSocket((Socket)this.sock);
        }

        public long getCreateTime() {
            return this.createTime;
        }
    }
}

