/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.hash.Hashing;

public class HashBuckets {
    static final Log LOG = LogFactory.getLog(HashBuckets.class);
    private static HashBuckets instance;
    private static int numBuckets;
    public static final int HASH_LENGTH = 20;
    static Random rand;

    public static void initialize(int numBuckets) {
        if (instance != null) {
            LOG.warn((Object)"initialize called again after already initialized.");
        } else {
            instance = new HashBuckets(numBuckets);
        }
    }

    private HashBuckets(int numBuckets) {
        HashBuckets.numBuckets = numBuckets;
    }

    public static HashBuckets getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new RuntimeException("HashBuckets have not been initialized");
    }

    public int getBucketForBlock(Block block) {
        return (int)(block.getBlockId() % (long)numBuckets);
    }

    public List<HashBucket> getBucketsForStorage(final DatanodeStorageInfo storage) throws IOException {
        LightWeightRequestHandler findHashesHandler = new LightWeightRequestHandler(HDFSOperationType.GET_STORAGE_HASHES){

            public Object performTask() throws IOException {
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                return da.findBucketsByStorageId(storage.getSid());
            }
        };
        return (List)findHashesHandler.handle();
    }

    @VisibleForTesting
    public void corruptHashBuckets(final DatanodeStorageInfo storage) throws IOException {
        Random rand = new Random(System.currentTimeMillis());
        LightWeightRequestHandler corruptedHashes = new LightWeightRequestHandler(HDFSOperationType.RESET_STORAGE_HASHES){

            public Object performTask() throws IOException {
                ArrayList<HashBucket> newBuckets = new ArrayList<HashBucket>();
                for (int i = 0; i < numBuckets; ++i) {
                    newBuckets.add(new HashBucket(storage.getSid(), i, HashBuckets.getRandomHash()));
                }
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                da.prepare((Collection)Collections.EMPTY_LIST, newBuckets);
                return null;
            }
        };
        corruptedHashes.handle();
    }

    @VisibleForTesting
    public void deleteHashBuckets(final DatanodeStorageInfo storage) throws IOException {
        LightWeightRequestHandler deleteHashes = new LightWeightRequestHandler(HDFSOperationType.RESET_STORAGE_HASHES){

            public Object performTask() throws IOException {
                ArrayList<HashBucket> deleted = new ArrayList<HashBucket>();
                for (int i = 0; i < numBuckets; ++i) {
                    deleted.add(new HashBucket(storage.getSid(), i, HashBuckets.initalizeHash()));
                }
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                da.prepare(deleted, (Collection)Collections.EMPTY_LIST);
                return null;
            }
        };
        deleteHashes.handle();
    }

    public void createBucketsForStorage(final DatanodeStorageInfo storage) throws IOException {
        List<HashBucket> existing = this.getBucketsForStorage(storage);
        final HashMap<Integer, HashBucket> existingMap = new HashMap<Integer, HashBucket>();
        for (HashBucket bucket : existing) {
            existingMap.put(bucket.getBucketId(), bucket);
        }
        final ArrayList<HashBucket> newBuckets = new ArrayList<HashBucket>();
        for (int i = 0; i < numBuckets; ++i) {
            if (existingMap.containsKey(i)) continue;
            newBuckets.add(new HashBucket(storage.getSid(), i, HashBuckets.initalizeHash()));
        }
        LightWeightRequestHandler findHashesHandler = new LightWeightRequestHandler(HDFSOperationType.CREATE_ALL_STORAGE_HASHES){

            public Object performTask() throws IOException {
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                da.prepare((Collection)Collections.EMPTY_LIST, (Collection)newBuckets);
                LOG.debug((Object)("Created " + newBuckets.size() + " buckets for the storage " + storage + " Existing Buckets: " + existingMap.size()));
                return null;
            }
        };
        findHashesHandler.handle();
    }

    HashBucket getBucket(int storageId, int bucketId) throws TransactionContextException, StorageException {
        HashBucket result = (HashBucket)EntityManager.find((FinderType)HashBucket.Finder.ByStorageIdAndBucketId, (Object[])new Object[]{storageId, bucketId});
        if (result == null) {
            result = new HashBucket(storageId, bucketId, HashBuckets.initalizeHash());
        }
        return result;
    }

    Collection<HashBucket> getBuckets(int storageId) throws TransactionContextException, StorageException {
        Collection result = EntityManager.findList((FinderType)HashBucket.Finder.ByStorageId, (Object[])new Object[]{storageId});
        return result;
    }

    private static String blockToString(Block block) {
        return "(id: " + block.getBlockId() + ",#bytes: " + block.getNumBytes() + ",GS: " + block.getGenerationStamp() + ")";
    }

    public void applyHash(int storageId, HdfsServerConstants.ReplicaState state, Block block) throws TransactionContextException, StorageException {
        this.applyHash(storageId, state, block, "Apply");
    }

    private void applyHash(int storageId, HdfsServerConstants.ReplicaState state, Block block, String msg) throws TransactionContextException, StorageException {
        String dbgMessage = msg + " block:" + HashBuckets.blockToString(block) + "sid=" + storageId + " state=" + state.name() + ", hash (";
        int bucketId = this.getBucketForBlock(block);
        HashBucket bucket = this.getBucket(storageId, bucketId);
        byte[] bucketHash = bucket.getHash();
        byte[] blockHash = BlockReport.hash(block, state);
        dbgMessage = dbgMessage + HashBuckets.hashToString(bucketHash);
        dbgMessage = dbgMessage + " XOR " + HashBuckets.hashToString(blockHash) + " = ";
        HashBuckets.XORHashes(bucketHash, blockHash);
        dbgMessage = dbgMessage + HashBuckets.hashToString(bucketHash) + ")";
        LOG.debug((Object)dbgMessage);
        bucket.setHash(bucketHash);
    }

    public void undoHash(int storageId, HdfsServerConstants.ReplicaState state, Block block) throws TransactionContextException, StorageException {
        this.applyHash(storageId, state, block, "Undo");
    }

    public void resetBuckets(final int storageId) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.RESET_STORAGE_HASHES){

            public void acquireLock(TransactionLocks tl) {
                LockFactory lf = LockFactory.getInstance();
                tl.add(lf.getHashBucketLock(storageId));
            }

            public Object performTask() throws IOException {
                Collection<HashBucket> buckets = HashBuckets.this.getBuckets(storageId);
                for (HashBucket bucket : buckets) {
                    bucket.setHash(HashBuckets.initalizeHash());
                }
                return null;
            }
        }.handle();
    }

    public static byte[] hash(long blockId, long generationStamp, long numBytes, int replicaState) {
        return Hashing.sha1().newHasher().putLong(blockId).putLong(generationStamp).putLong(numBytes).putInt(replicaState).hash().asBytes();
    }

    public static byte[] getRandomHash() {
        byte[] hash = new byte[20];
        rand.nextBytes(hash);
        return hash;
    }

    public static byte[] initalizeHash() {
        byte[] hash = new byte[20];
        return hash;
    }

    public static boolean hashEquals(byte[] a, byte[] b) {
        assert (a.length == b.length);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] XORHashes(byte[] a, byte[] b) {
        assert (a.length == b.length);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (byte)(a[i] ^ b[i]);
        }
        return a;
    }

    public static String hashToString(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    static {
        rand = new Random(System.currentTimeMillis());
    }
}

