/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.Ace;
import io.hops.transaction.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.sparkproject.guava.collect.Lists;

public class INodeAclHelper {
    static AclFeature getAclFeature(INode inode) throws TransactionContextException, StorageException, AclException {
        Collection<Ace> result = INodeAclHelper.getAces(inode);
        if (result == null) {
            return null;
        }
        ArrayList asList = Lists.newArrayList(result);
        Collections.sort(asList, Ace.Order.ByIndexAscending);
        return new AclFeature(INodeAclHelper.convert(asList));
    }

    static void addAclFeature(INode inode, AclFeature aclFeature) throws TransactionContextException, StorageException, AclException {
        List<AclEntry> entries = aclFeature.getEntries();
        entries = INodeAclHelper.filterUnnamedNonGroupEntries(entries);
        long inodeId = inode.getId();
        for (int i = 0; i < entries.size(); ++i) {
            EntityManager.update((Object)INodeAclHelper.convert(entries.get(i), inodeId, i));
        }
        inode.setNumAces(entries.size());
    }

    public static void removeAclFeature(INode inode) throws TransactionContextException, StorageException {
        assert (inode.getNumAces() > 0);
        Collection<Ace> aces = INodeAclHelper.getOwnAces(inode);
        if (aces == null) {
            return;
        }
        for (Ace ace : aces) {
            EntityManager.remove((Object)ace);
        }
        inode.setNumAces(0);
    }

    private static List<AclEntry> filterUnnamedNonGroupEntries(List<AclEntry> entries) {
        ArrayList unnamedRemoved = Lists.newArrayList();
        for (AclEntry entry : entries) {
            if (entry.getScope().equals((Object)AclEntryScope.DEFAULT) && !entry.getType().equals((Object)AclEntryType.GROUP) && (entry.getName() == null || entry.getName().isEmpty())) continue;
            unnamedRemoved.add(entry);
        }
        return unnamedRemoved;
    }

    private static void checkNoUnnamedDefaults(List<AclEntry> entries) throws AclException {
        for (AclEntry entry : entries) {
            if (!entry.getScope().equals((Object)AclEntryScope.DEFAULT) || entry.getName() != null && !entry.getName().isEmpty()) continue;
            throw new AclException("HOPS does not allow unnamed DEFAULT entries.");
        }
    }

    private static Collection<Ace> getAces(INode inode) throws TransactionContextException, StorageException {
        Collection<Ace> aces = inode.getNumAces() > 0 ? INodeAclHelper.getOwnAces(inode) : INodeAclHelper.getInheritedDefaultAcesAsAccess(inode.getParent());
        return aces;
    }

    private static Collection<Ace> getOwnAces(INode inode) throws TransactionContextException, StorageException {
        assert (inode.getNumAces() > 0);
        int[] indices = new int[inode.getNumAces()];
        for (int i = 0; i < inode.getNumAces(); ++i) {
            indices[i] = i;
        }
        return EntityManager.findList((FinderType)Ace.Finder.ByInodeIdAndIndices, (Object[])new Object[]{inode.getId(), indices});
    }

    private static Collection<Ace> getInheritedDefaultAcesAsAccess(INode inode) throws TransactionContextException, StorageException {
        if (inode == null) {
            return null;
        }
        if (inode.getNumAces() > 0) {
            Collection<Ace> ownAces = INodeAclHelper.getOwnAces(inode);
            ArrayList<Ace> defaultAces = new ArrayList<Ace>();
            for (Ace ownAce : ownAces) {
                if (!ownAce.isDefault()) continue;
                defaultAces.add(ownAce);
            }
            if (!defaultAces.isEmpty()) {
                ArrayList<Ace> convertedToAccess = new ArrayList<Ace>();
                for (Ace defaultAce : defaultAces) {
                    Ace access = defaultAce.copy();
                    access.setIsDefault(false);
                    convertedToAccess.add(access);
                }
                return convertedToAccess;
            }
        }
        return INodeAclHelper.getInheritedDefaultAcesAsAccess(inode.getParent());
    }

    private static Ace convert(AclEntry entry, long inodeId, int index) throws AclException {
        return new Ace(inodeId, index, entry.getName(), INodeAclHelper.convert(entry.getType()), entry.getScope().equals((Object)AclEntryScope.DEFAULT), entry.getPermission().ordinal());
    }

    private static Ace.AceType convert(AclEntryType type) throws AclException {
        switch (type) {
            case USER: {
                return Ace.AceType.USER;
            }
            case GROUP: {
                return Ace.AceType.GROUP;
            }
            case MASK: {
                return Ace.AceType.MASK;
            }
            case OTHER: {
                return Ace.AceType.OTHER;
            }
        }
        throw new AclException("Unexpected acl entry type " + type.toString() + ", should be USER, GROUP, MASK or OTHER");
    }

    private static AclEntryType convert(Ace.AceType type) throws AclException {
        switch (type) {
            case USER: {
                return AclEntryType.USER;
            }
            case GROUP: {
                return AclEntryType.GROUP;
            }
            case MASK: {
                return AclEntryType.MASK;
            }
            case OTHER: {
                return AclEntryType.OTHER;
            }
        }
        throw new AclException("Unexpected ace type " + type.toString() + ", should be USER, GROUP, MASK or OTHER");
    }

    public static List<AclEntry> convert(List<Ace> aces) throws AclException {
        ArrayList<AclEntry> result = new ArrayList<AclEntry>();
        for (Ace ace : aces) {
            result.add(new AclEntry.Builder().setScope(ace.isDefault() ? AclEntryScope.DEFAULT : AclEntryScope.ACCESS).setName(ace.getSubject()).setPermission(FsAction.values()[ace.getPermission()]).setType(INodeAclHelper.convert(ace.getType())).build());
        }
        return result;
    }
}

