/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.collect.ImmutableList;

public class INodesInPath {
    public static final Log LOG = LogFactory.getLog(INodesInPath.class);
    private final byte[][] path;
    private final INode[] inodes;

    static INodesInPath fromINode(INode inode) throws StorageException, TransactionContextException {
        INode tmp;
        int depth = 0;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            ++depth;
        }
        byte[][] path = new byte[depth][];
        INode[] inodes = new INode[depth];
        int index = depth;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            path[--index] = tmp.getLocalNameBytes();
            inodes[index] = tmp;
        }
        return new INodesInPath(inodes, path);
    }

    private static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        Preconditions.checkArgument((startingDir.compareTo(components[0]) == 0 ? 1 : 0) != 0);
        INode curNode = startingDir;
        int inodeNum = 0;
        INode[] inodes = new INode[components.length];
        for (int count = 0; count < components.length && curNode != null; ++count) {
            INodeDirectory dir;
            boolean lastComp = count == components.length - 1;
            inodes[inodeNum++] = curNode;
            boolean isDir = curNode.isDirectory();
            INodeDirectory iNodeDirectory = dir = isDir ? curNode.asDirectory() : null;
            if (curNode.isSymlink() && (!lastComp || resolveLink)) {
                String path = INodesInPath.constructPath(components, 0, components.length);
                String preceding = INodesInPath.constructPath(components, 0, count);
                String remainder = INodesInPath.constructPath(components, count + 1, components.length);
                String link = DFSUtil.bytes2String(components[count]);
                String target = curNode.asSymlink().getSymlinkString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("UnresolvedPathException  path: " + path + " preceding: " + preceding + " count: " + count + " link: " + link + " target: " + target + " remainder: " + remainder));
                }
                throw new UnresolvedPathException(path, preceding, remainder, target);
            }
            if (lastComp || !isDir) break;
            byte[] childName = components[count + 1];
            curNode = dir.getChildINode(childName);
        }
        return new INodesInPath(inodes, components);
    }

    public static INodesInPath replace(INodesInPath iip, int pos, INode inode) {
        Preconditions.checkArgument((iip.length() > 0 && pos > 0 && pos < iip.length() ? 1 : 0) != 0);
        if (iip.getINode(pos) == null) {
            Preconditions.checkState((iip.getINode(pos - 1) != null ? 1 : 0) != 0);
        }
        INode[] inodes = new INode[iip.inodes.length];
        System.arraycopy(iip.inodes, 0, inodes, 0, inodes.length);
        inodes[pos] = inode;
        return new INodesInPath(inodes, iip.path);
    }

    public static INodesInPath append(INodesInPath iip, INode child, byte[] childName) {
        Preconditions.checkArgument((iip.length() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((iip.getLastINode() != null && iip.getLastINode().isDirectory() ? 1 : 0) != 0);
        INode[] inodes = new INode[iip.length() + 1];
        System.arraycopy(iip.inodes, 0, inodes, 0, inodes.length - 1);
        inodes[inodes.length - 1] = child;
        byte[][] path = new byte[iip.path.length + 1][];
        System.arraycopy(iip.path, 0, path, 0, path.length - 1);
        path[path.length - 1] = childName;
        return new INodesInPath(inodes, path);
    }

    private INodesInPath(INode[] inodes, byte[][] path) {
        Preconditions.checkArgument((inodes != null && path != null ? 1 : 0) != 0);
        this.inodes = inodes;
        this.path = path;
    }

    public INode getINode(int i) {
        int index;
        if (this.inodes == null || this.inodes.length == 0) {
            throw new NoSuchElementException("inodes is null or empty");
        }
        int n = index = i >= 0 ? i : this.inodes.length + i;
        if (index < this.inodes.length && index >= 0) {
            return this.inodes[index];
        }
        throw new NoSuchElementException("inodes.length == " + this.inodes.length);
    }

    public INode getLastINode() {
        return this.getINode(-1);
    }

    byte[] getLastLocalName() {
        return this.path[this.path.length - 1];
    }

    public byte[][] getPathComponents() {
        return this.path;
    }

    public String getPath() {
        return DFSUtil.byteArray2PathString(this.path);
    }

    public String getParentPath() {
        return this.getPath(this.path.length - 1);
    }

    public String getPath(int pos) {
        return DFSUtil.byteArray2PathString(this.path, 0, pos);
    }

    public List<String> getPath(int offset, int length) {
        Preconditions.checkArgument((offset >= 0 && length >= 0 && offset + length <= this.path.length ? 1 : 0) != 0);
        ImmutableList.Builder components = ImmutableList.builder();
        for (int i = offset; i < offset + length; ++i) {
            components.add((Object)DFSUtil.bytes2String(this.path[i]));
        }
        return components.build();
    }

    public int length() {
        return this.inodes.length;
    }

    public List<INode> getReadOnlyINodes() {
        return Collections.unmodifiableList(Arrays.asList(this.inodes));
    }

    private INodesInPath getAncestorINodesInPath(int length) {
        Preconditions.checkArgument((length >= 0 && length < this.inodes.length ? 1 : 0) != 0);
        INode[] anodes = new INode[length];
        byte[][] apath = new byte[length][];
        System.arraycopy(this.inodes, 0, anodes, 0, length);
        System.arraycopy(this.path, 0, apath, 0, length);
        return new INodesInPath(anodes, apath);
    }

    public INodesInPath getParentINodesInPath() {
        return this.inodes.length > 1 ? this.getAncestorINodesInPath(this.inodes.length - 1) : null;
    }

    public INodesInPath getExistingINodes() {
        int i;
        for (i = 0; i < this.inodes.length && this.inodes[i] != null; ++i) {
        }
        INode[] existing = new INode[i];
        byte[][] existingPath = new byte[i][];
        System.arraycopy(this.inodes, 0, existing, 0, i);
        System.arraycopy(this.path, 0, existingPath, 0, i);
        return new INodesInPath(existing, existingPath);
    }

    private static String toString(INode inode) {
        return inode == null ? null : inode.getLocalName();
    }

    public String toString() {
        try {
            return this.toString(true);
        }
        catch (StorageException | TransactionContextException ex) {
            LOG.error((Object)ex, ex);
            return null;
        }
    }

    private String toString(boolean vaildateObject) throws StorageException, TransactionContextException {
        if (vaildateObject) {
            this.validate();
        }
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append(": path = ").append(DFSUtil.byteArray2PathString(this.path)).append("\n  inodes = ");
        if (this.inodes == null) {
            b.append("null");
        } else if (this.inodes.length == 0) {
            b.append("[]");
        } else {
            b.append("[").append(INodesInPath.toString(this.inodes[0]));
            for (int i = 1; i < this.inodes.length; ++i) {
                b.append(", ").append(INodesInPath.toString(this.inodes[i]));
            }
            b.append("], length=").append(this.inodes.length);
        }
        return b.toString();
    }

    void validate() throws StorageException, TransactionContextException {
        int i = 0;
        if (this.inodes[i] != null) {
            ++i;
            while (i < this.inodes.length && this.inodes[i] != null) {
                INodeDirectory parent_i = this.inodes[i].getParent();
                INodeDirectory parent_i_1 = this.inodes[i - 1].getParent();
                if (parent_i != this.inodes[i - 1] && (parent_i_1 == null || parent_i != parent_i_1)) {
                    throw new AssertionError((Object)("inodes[" + i + "].getParent() != inodes[" + (i - 1) + "]\n  inodes[" + i + "]=" + this.inodes[i].toDetailString() + "\n  inodes[" + (i - 1) + "]=" + this.inodes[i - 1].toDetailString() + "\n this=" + this.toString(false)));
                }
                ++i;
            }
        }
        if (i != this.inodes.length) {
            throw new AssertionError((Object)("i = " + i + " != " + this.inodes.length + ", this=" + this.toString(false)));
        }
    }
}

