/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.DirectoryWithQuotaFeatureDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;

public class DirectoryWithQuotaFeatureContext
extends BaseEntityContext<Long, DirectoryWithQuotaFeature> {
    private final DirectoryWithQuotaFeatureDataAccess<DirectoryWithQuotaFeature> dataAccess;

    public DirectoryWithQuotaFeatureContext(DirectoryWithQuotaFeatureDataAccess<DirectoryWithQuotaFeature> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(DirectoryWithQuotaFeature directoryWithQuotaFeature) throws TransactionContextException {
        if (directoryWithQuotaFeature.getInodeId() != null) {
            super.update((Object)directoryWithQuotaFeature);
            if (this.isLogTraceEnabled()) {
                this.log("updated-attributes", new Object[]{"id", directoryWithQuotaFeature.getInodeId(), "quota", directoryWithQuotaFeature.getQuota(), " usage", directoryWithQuotaFeature.getSpaceConsumed()});
            }
        } else if (this.isLogTraceEnabled()) {
            this.log("updated-attributes -- IGNORED as id is not set", new Object[0]);
        }
    }

    public void remove(DirectoryWithQuotaFeature directoryWithQuotaFeature) throws TransactionContextException {
        super.remove((Object)directoryWithQuotaFeature);
        if (this.isLogTraceEnabled()) {
            this.log("removed-attributes", new Object[]{"id", directoryWithQuotaFeature.getInodeId()});
            for (int i = 0; i < Thread.currentThread().getStackTrace().length; ++i) {
                System.out.println(Thread.currentThread().getStackTrace()[i]);
            }
        }
    }

    public DirectoryWithQuotaFeature find(FinderType<DirectoryWithQuotaFeature> finder, Object ... params) throws TransactionContextException, StorageException {
        DirectoryWithQuotaFeature.Finder qfinder = (DirectoryWithQuotaFeature.Finder)finder;
        switch (qfinder) {
            case ByINodeId: {
                return this.findByPrimaryKey(qfinder, params);
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FINDER);
    }

    public Collection<DirectoryWithQuotaFeature> findList(FinderType<DirectoryWithQuotaFeature> finder, Object ... params) throws TransactionContextException, StorageException {
        DirectoryWithQuotaFeature.Finder qfinder = (DirectoryWithQuotaFeature.Finder)finder;
        switch (qfinder) {
            case ByINodeIds: {
                return this.findByPrimaryKeys(qfinder, params);
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FINDER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        ArrayList modified = new ArrayList(this.getModified());
        modified.addAll(this.getAdded());
        this.dataAccess.prepare(modified, this.getRemoved());
    }

    Long getKey(DirectoryWithQuotaFeature directoryWithQuotaFeature) {
        return directoryWithQuotaFeature.getInodeId();
    }

    public void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        HdfsTransactionContextMaintenanceCmds hopCmds = (HdfsTransactionContextMaintenanceCmds)cmds;
        switch (hopCmds) {
            case INodePKChanged: {
                INode inodeBeforeChange = (INode)params[0];
                INode inodeAfterChange = (INode)params[1];
                break;
            }
            case Concat: {
                INodeCandidatePrimaryKey trg_param = (INodeCandidatePrimaryKey)params[0];
                List srcs_param = (List)params[1];
                List oldBlks = (List)params[2];
                this.updateAttributes(trg_param, srcs_param);
            }
        }
    }

    private DirectoryWithQuotaFeature findByPrimaryKey(DirectoryWithQuotaFeature.Finder qfinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long inodeId = (Long)params[0];
        DirectoryWithQuotaFeature result = null;
        if (this.contains(inodeId)) {
            result = (DirectoryWithQuotaFeature)this.get(inodeId);
            this.hit(qfinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage(qfinder, params);
            result = (DirectoryWithQuotaFeature)this.dataAccess.findAttributesByPk(Long.valueOf(inodeId));
            this.gotFromDB(inodeId, result);
            this.miss(qfinder, result, new Object[]{"inodeid", inodeId, "size", this.size()});
        }
        return result;
    }

    private Collection<DirectoryWithQuotaFeature> findByPrimaryKeys(DirectoryWithQuotaFeature.Finder qfinder, Object[] params) throws StorageCallPreventedException, StorageException {
        List inodePks = (List)params[0];
        Collection result = null;
        if (this.contains(inodePks)) {
            result = this.get(inodePks);
            this.hit(qfinder, result, new Object[]{"inodeids", inodePks});
        } else {
            this.aboutToAccessStorage(qfinder, new Object[]{inodePks});
            result = this.dataAccess.findAttributesByPkList(inodePks);
            this.gotFromDB(result);
            this.miss(qfinder, result, new Object[]{"inodeids", inodePks});
            if (result != null) {
                for (DirectoryWithQuotaFeature directoryWithQuotaFeature : result) {
                    this.log("attributes", new Object[]{"id", directoryWithQuotaFeature.getInodeId(), "quota", directoryWithQuotaFeature.getQuota(), " usage", directoryWithQuotaFeature.getSpaceConsumed()});
                }
            }
        }
        return result;
    }

    private boolean contains(List<INodeCandidatePrimaryKey> iNodeCandidatePKs) {
        for (INodeCandidatePrimaryKey pk : iNodeCandidatePKs) {
            if (this.contains(pk.getInodeId())) continue;
            return false;
        }
        return true;
    }

    private Collection<DirectoryWithQuotaFeature> get(List<INodeCandidatePrimaryKey> iNodeCandidatePKs) {
        ArrayList<DirectoryWithQuotaFeature> directoryWithQuotaFeatures = new ArrayList<DirectoryWithQuotaFeature>(iNodeCandidatePKs.size());
        for (INodeCandidatePrimaryKey pk : iNodeCandidatePKs) {
            directoryWithQuotaFeatures.add((DirectoryWithQuotaFeature)this.get(pk.getInodeId()));
        }
        return directoryWithQuotaFeatures;
    }

    private void updateAttributes(INodeCandidatePrimaryKey trg_param, List<INodeCandidatePrimaryKey> toBeDeletedSrcs) throws TransactionContextException {
        toBeDeletedSrcs.remove(trg_param);
        for (INodeCandidatePrimaryKey src : toBeDeletedSrcs) {
            if (!this.contains(src.getInodeId())) continue;
            DirectoryWithQuotaFeature toBeDeleted = (DirectoryWithQuotaFeature)this.get(src.getInodeId());
            DirectoryWithQuotaFeature toBeAdded = this.clone(toBeDeleted, trg_param.getInodeId());
            this.remove(toBeDeleted);
            if (this.isLogTraceEnabled()) {
                this.log("snapshot-maintenance-removed-inode-attribute", new Object[]{"inodeId", toBeDeleted.getInodeId()});
            }
            this.add(toBeAdded);
            if (!this.isLogTraceEnabled()) continue;
            this.log("snapshot-maintenance-added-inode-attribute", new Object[]{"inodeId", toBeAdded.getInodeId()});
        }
    }

    private DirectoryWithQuotaFeature clone(DirectoryWithQuotaFeature src, long inodeId) {
        return new DirectoryWithQuotaFeature.Builder(inodeId).nameSpaceQuota(src.getQuota().getNameSpace()).nameSpaceUsage(src.getSpaceConsumed().getNameSpace()).storageSpaceQuota(src.getQuota().getStorageSpace()).spaceUsage(src.getSpaceConsumed().getStorageSpace()).typeQuotas(src.getQuota().getTypeSpaces()).typeUsages(src.getSpaceConsumed().getTypeSpaces()).build();
    }
}

