/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;

public class BlockReaderDB
implements BlockReader {
    public static final Log LOG = LogFactory.getLog(BlockReaderDB.class);
    private final ByteArrayInputStream bis;

    public BlockReaderDB(byte[] data, int startOffset) {
        this.bis = new ByteArrayInputStream(data);
        if (startOffset > 0) {
            long skipped = this.bis.skip(startOffset);
            assert (skipped == (long)startOffset);
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.bis.read(buf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.bis.close();
    }

    @Override
    public void readFully(byte[] buf, int readOffset, int amtToRead) throws IOException {
        int amountRead = this.bis.read(buf, readOffset, amtToRead);
        if (amountRead < amtToRead) {
            throw new IOException("Premature EOF from inputStream");
        }
    }

    @Override
    public int readAll(byte[] buf, int offset, int len) throws IOException {
        return this.bis.read(buf, offset, len);
    }

    public int read(ByteBuffer buf) throws IOException {
        int amountToRead = buf.remaining();
        int initialPosition = buf.position();
        byte[] buffer = new byte[amountToRead];
        int actuallyRead = this.bis.read(buffer);
        if (actuallyRead > 0) {
            buf.put(buffer);
            buf.position(initialPosition + actuallyRead);
        }
        return actuallyRead;
    }

    @Override
    public int available() throws IOException {
        return 131072;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isShortCircuit() {
        return false;
    }

    @Override
    public ClientMmap getClientMmap(EnumSet<ReadOption> opts) {
        return null;
    }
}

