/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import java.util.Date;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.sparkproject.guava.base.Preconditions;

@InterfaceAudience.Private
public final class CacheDirective {
    private final long id;
    private final String path;
    private final short replication;
    private String poolName;
    private final long expiryTime;
    private long bytesNeeded;
    private long bytesCached;
    private long filesNeeded;
    private long filesCached;

    public CacheDirective(CacheDirectiveInfo info) {
        this(info.getId(), info.getPath().toUri().getPath(), info.getReplication(), info.getExpiration().getAbsoluteMillis());
    }

    public CacheDirective(long id, String path, short replication, long expiryTime) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        this.id = id;
        this.path = (String)Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0);
        this.replication = replication;
        this.expiryTime = expiryTime;
    }

    public CacheDirective(long id, String path, short replication, long expiryTime, long bytesNeeded, long bytesCached, long filesNeeded, long filesCached, String pool) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        this.id = id;
        this.path = (String)Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0);
        this.replication = replication;
        this.expiryTime = expiryTime;
        this.bytesNeeded = bytesNeeded;
        this.bytesCached = bytesCached;
        this.filesNeeded = filesNeeded;
        this.filesCached = filesCached;
        this.poolName = pool;
    }

    public long getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public short getReplication() {
        return this.replication;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public CachePool getPool() throws TransactionContextException, StorageException {
        return (CachePool)EntityManager.find((FinderType)CachePool.Finder.ByName, (Object[])new Object[]{this.poolName});
    }

    public void setPoolName(String pool) {
        this.poolName = pool;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public String getExpiryTimeString() {
        return DFSUtil.dateToIso8601String(new Date(this.expiryTime));
    }

    public CacheDirectiveInfo toInfo() {
        return new CacheDirectiveInfo.Builder().setId(this.id).setPath(new Path(this.path)).setReplication(this.replication).setPool(this.poolName).setExpiration(CacheDirectiveInfo.Expiration.newAbsolute(this.expiryTime)).build();
    }

    public CacheDirectiveStats toStats() {
        return new CacheDirectiveStats.Builder().setBytesNeeded(this.bytesNeeded).setBytesCached(this.bytesCached).setFilesNeeded(this.filesNeeded).setFilesCached(this.filesCached).setHasExpired(new Date().getTime() > this.expiryTime).build();
    }

    public CacheDirectiveEntry toEntry() {
        return new CacheDirectiveEntry(this.toInfo(), this.toStats());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ id:").append(this.id).append(", path:").append(this.path).append(", replication:").append(this.replication).append(", pool:").append(this.poolName).append(", expiryTime: ").append(this.getExpiryTimeString()).append(", bytesNeeded:").append(this.bytesNeeded).append(", bytesCached:").append(this.bytesCached).append(", filesNeeded:").append(this.filesNeeded).append(", filesCached:").append(this.filesCached).append(" }");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CacheDirective other = (CacheDirective)o;
        return this.id == other.id;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    public void resetStatistics() throws TransactionContextException, StorageException {
        this.bytesNeeded = 0L;
        this.bytesCached = 0L;
        this.filesNeeded = 0L;
        this.filesCached = 0L;
        this.save();
    }

    public long getBytesNeeded() {
        return this.bytesNeeded;
    }

    public void addBytesNeeded(long bytes) throws TransactionContextException, StorageException {
        this.bytesNeeded += bytes;
        CachePool pool = this.getPool();
        pool.addBytesNeeded(bytes);
        pool.save();
        this.save();
    }

    public long getBytesCached() {
        return this.bytesCached;
    }

    public void addBytesCached(long bytes) throws TransactionContextException, StorageException {
        this.bytesCached += bytes;
        CachePool pool = this.getPool();
        pool.addBytesCached(bytes);
        pool.save();
        this.save();
    }

    public long getFilesNeeded() {
        return this.filesNeeded;
    }

    public void addFilesNeeded(long files) throws TransactionContextException, StorageException {
        this.filesNeeded += files;
        CachePool pool = this.getPool();
        pool.addFilesNeeded(files);
        pool.save();
        this.save();
    }

    public long getFilesCached() {
        return this.filesCached;
    }

    public void addFilesCached(long files) throws TransactionContextException, StorageException {
        this.filesCached += files;
        CachePool pool = this.getPool();
        pool.addFilesCached(files);
        pool.save();
        this.save();
    }

    private void save() throws TransactionContextException, StorageException {
        EntityManager.update((Object)this);
    }

    public static enum Finder implements FinderType<CacheDirective>
    {
        ById,
        ByPoolName,
        ByIdPoolAndPath,
        All;


        public Class getType() {
            return CacheDirective.class;
        }

        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ById: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByPoolName: {
                    return FinderType.Annotation.IndexScan;
                }
                case ByIdPoolAndPath: {
                    return FinderType.Annotation.IndexScan;
                }
                case All: {
                    return FinderType.Annotation.FullTable;
                }
            }
            throw new IllegalStateException();
        }
    }
}

