/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.hops.security.HopsFileBasedKeyStoresFactory;
import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.web.URLDispatcher;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.SSLFactory;

public class DatanodeHttpServer
implements Closeable {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerSocketChannel externalHttpChannel;
    private final ServerBootstrap httpServer;
    private final SSLFactory sslFactory;
    private final ServerBootstrap httpsServer;
    private final Configuration conf;
    private final Configuration confForCreate;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    static final Log LOG = LogFactory.getLog(DatanodeHttpServer.class);

    public DatanodeHttpServer(final Configuration conf, final InetSocketAddress jettyAddr, final ServerSocketChannel externalHttpChannel) throws IOException {
        this.conf = conf;
        this.confForCreate = new Configuration(conf);
        this.confForCreate.set("fs.permissions.umask-mode", "000");
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.externalHttpChannel = externalHttpChannel;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        if (policy.isHttpEnabled()) {
            this.httpServer = new ServerBootstrap().group(this.bossGroup, this.workerGroup).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new HttpRequestDecoder(), new HttpResponseEncoder(), new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate));
                }
            });
            if (externalHttpChannel == null) {
                this.httpServer.channel(NioServerSocketChannel.class);
            } else {
                this.httpServer.channelFactory(new ChannelFactory<NioServerSocketChannel>(){

                    @Override
                    public NioServerSocketChannel newChannel() {
                        return new NioServerSocketChannel(externalHttpChannel){

                            @Override
                            protected void doBind(SocketAddress localAddress) throws Exception {
                            }
                        };
                    }
                });
            }
        } else {
            this.httpServer = null;
        }
        if (policy.isHttpsEnabled()) {
            if (conf.getBoolean("ipc.server.ssl.enabled", false)) {
                conf.set("hadoop.ssl.keystores.factory.class", HopsFileBasedKeyStoresFactory.class.getCanonicalName());
            }
            this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
            try {
                this.sslFactory.init();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.httpsServer = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new SslHandler(DatanodeHttpServer.this.sslFactory.createSSLEngine()), new HttpRequestDecoder(), new HttpResponseEncoder(), new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate));
                }
            });
        } else {
            this.httpsServer = null;
            this.sslFactory = null;
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    public void start() {
        if (this.httpServer != null) {
            ChannelFuture f = this.httpServer.bind(DataNode.getInfoAddr(this.conf));
            f.syncUninterruptibly();
            this.httpAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info((Object)("Listening HTTP traffic on " + this.httpAddress));
        }
        if (this.httpsServer != null) {
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)this.conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:50475"));
            ChannelFuture f = this.httpsServer.bind(secInfoSocAddr);
            f.syncUninterruptibly();
            this.httpsAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info((Object)("Listening HTTPS traffic on " + this.httpsAddress));
        }
    }

    @Override
    public void close() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
        if (this.externalHttpChannel != null) {
            this.externalHttpChannel.close();
        }
    }
}

